/*====================================+=====================================+
! File siren.cpp                      ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include <wx/event.h>
#include "siren.h"
#include "CApp.h"
/*-------------------------------------------------------------------------*/



/*--------------------------------------------------------------------------+
! Very few texts present in "wxstd.mo" too.                                 !
! "wxstd.mo" is only really useful for the help window.                     !
! Therefore avoiding "wxstd.mo" distribution is possible, only the help     !
! window will be an iussue.                                                 !
+--------------------------------------------------------------------------*/
#define DUMMY_TRANSLATIONS \
        wxTRANSLATE( "&OK" ) \
        wxTRANSLATE( "OK" ) \
        wxTRANSLATE( "&Apply" ) \
        wxTRANSLATE( "Apply" ) \
        wxTRANSLATE( "&Cancel" ) \
        wxTRANSLATE( "Cancel" )
#undef DUMMY_TRANSLATIONS

/*--------------------------------------------------------------------------+
! Not very useful but shows the language name in its own language ...       !
! In all languages "French" should stay "Francais",                         !
! "German" should stay "Deutsch" ...                                        !
+--------------------------------------------------------------------------*/
#define DUMMY_TRANSLATED_LANGUAGE_NAMES \
        wxTRANSLATE( "French" ) \
        wxTRANSLATE( "German" )
#undef DUMMY_TRANSLATED_LANGUAGE_NAMES
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
void g_disp_info( const wxString &s )
{
   /*----------------------------------------------------------------------*/
   wxGetApp().m_frame->SetStatusText( s ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
bool g_is_edit_info_event( wxKeyEvent &event )
{
   /*----------------------------------------------------------------------*/
   return(     event.GetKeyCode() == 'E'
            &&     ( event.GetModifiers() & ~wxMOD_ALT )
                == ( wxMOD_CMD | wxMOD_SHIFT )
         ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void g_disp_edit_info( const wxTextCtrl *win_text )
{
   /*----------------------------------------------------------------------*/
   long l_length   ;
   long l_pos_from ;
   long l_pos_to   ;

   /*----------------------------------------------------------------------*/
   win_text->GetSelection( &l_pos_from, &l_pos_to ) ;

   /*-----------------------------------------------------------------------+
   ! For multi-line text controls the information is displayed only if      !
   ! the selection is only on one line.                                     !
   +-----------------------------------------------------------------------*/
   if( win_text->IsSingleLine() )
   {  l_length = win_text->GetLastPosition() ; }
   else
   {
      /*-------------------------------------------------------------------*/
      long l_line_from ;
      long l_line_to ;
      long l_col ;
      /*--( Selection on one line ? )--------------------------------------*/
      if(    !win_text->PositionToXY( l_pos_from, &l_col, &l_line_from )
          || !win_text->PositionToXY( l_pos_to  , &l_col, &l_line_to   )
          || l_line_from != l_line_to
        )
      {  /*----------------------------------------------------------------*/
         g_disp_info( _( "Edit information : invalid selection" ) ) ;
         return ;
         /*----------------------------------------------------------------*/
      }
      /*-------------------------------------------------------------------*/
      l_length = win_text->GetLineLength( l_line_from ) ;
      /*--( Positions relative to this line )------------------------------*/
      l_col = win_text->XYToPosition( 0, l_line_from ) ;
      l_pos_from -= l_col ;
      l_pos_to   -= l_col ;
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
   g_disp_info( wxString::Format( _( "Selection : left : %ld/%ld, "
                                     "right : %ld/%ld, length : %ld"
                                   ),
                                  l_pos_from + 1, l_pos_from - l_length,
                                  l_pos_to + 1, l_pos_to - l_length,
                                  l_pos_to - l_pos_from
                                 )
              ) ;
   /*----------------------------------------------------------------------*/
}

/*--------------------------------------------------------------------------+
! Normally it should only be "called" from within a block where exists a    !
! CRunInfoMessage instance                                                  !
+--------------------------------------------------------------------------*/
void g_disp_info_yield( const wxString &s )
{
   /*----------------------------------------------------------------------*/
   CFrame *frame = wxGetApp().m_frame ;
   /*----------------------------------------------------------------------*/
   frame->allow_user_input( false ) ;
   frame->SetStatusText( s ) ;
   wxGetApp().Yield() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void g_trace( const wxString &s_format, ... )
{
   /*----------------------------------------------------------------------*/
   FILE *fp = fopen( wxFileName( wxGetApp().get_exe_path(), "siren_debug.txt"
                               ).GetFullPath(),
                     "a+"
                   ) ;
   va_list arg_list ;
   /*----------------------------------------------------------------------*/
   va_start( arg_list, s_format ) ;
   vfprintf( fp, s_format, arg_list ) ;
   fclose( fp ) ;
   /*----------------------------------------------------------------------*/
}

/*--( Here is the real entry point )---------------------------------------*/
IMPLEMENT_APP( CApp ) ;

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                         End of file siren.cpp                             !
+==========================================================================*/
