/*====================================+=====================================+
! File CPanPrefs.cpp                  ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include <algorithm>
#include <algorithm>
#include <limits>
#include <wx/imaglist.h>
#include <wx/stdpaths.h>
#include "CApp.h"
#include "CDirTree.h"
#include "prefs/CDlgPrefs.h"
#include "CCombo.h"
#include "common/sr_lib.h"
#include "siren_info.h"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
BEGIN_EVENT_TABLE( CCheckListCtrl, wxListCtrl )
   /*----------------------------------------------------------------------*/
   EVT_KEY_DOWN( CCheckListCtrl::OnKeyDown )
   EVT_LEFT_DOWN( CCheckListCtrl::OnMouseLeftDown )
   /*----------------------------------------------------------------------*/
END_EVENT_TABLE()
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
CPanPrefs::~CPanPrefs()
{  ; }

/*-------------------------------------------------------------------------*/
wxWindow *CPanPrefs::check_mandatory( wxTextCtrl *p_win )
{
   /*----------------------------------------------------------------------*/
   if( p_win->GetValue().empty() )
   {  /*-------------------------------------------------------------------*/
      sr::error_message( _( "This information is mandatory" ) ) ;
      return( p_win ) ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   return( NULL ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CPanPrefsGen::CPanPrefsGen( wxWindow *parent )
            : CPanPrefsGenBase( parent )
{
   /*----------------------------------------------------------------------*/
   init_cho_lang() ;
   /*----------------------------------------------------------------------*/
   m_boo_chkver_auto->SetValue( wxGetApp().M_boo_chkver_auto.get() ) ;
   m_boo_copy_file_tms->SetValue( wxGetApp().M_boo_copy_file_tms.get() ) ;
   /*----------------------------------------------------------------------*/
   m_boo_extr_meta->SetValue( wxGetApp().M_boo_extr_meta.get() ) ;
   m_boo_file_type_detect->SetValue( wxGetApp().M_boo_file_type_detect.get()
                                   ) ;
   m_boo_file_type_detect->Enable( wxGetApp().M_boo_extr_meta.get() ) ;
   m_boo_loose_mp3_check->SetValue( wxGetApp().M_boo_loose_mp3_check.get() );
   m_boo_loose_mp3_check->Enable( wxGetApp().M_boo_extr_meta.get() ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CPanPrefsGen::~CPanPrefsGen()
{  ; }

/*-------------------------------------------------------------------------*/
void CPanPrefsGen::init_cho_lang( void )
{
   /*----------------------------------------------------------------------*/
   wxArrayString         as_avail_translations ;
   sr::t_map_str_str     map_desc_canon        ;
   sr::t_map_str_str_cit cit_desc_canon        ;
   const wxLanguageInfo  *p_langinfo           ;
   size_t                sz_lang_sel           ;
   size_t                sz_num                ;

   /*----------------------------------------------------------------------*/
     as_avail_translations
   = wxTranslations::Get()->GetAvailableTranslations( SIREN_NAME ) ;

   /*--( Load the couples into a map to get it sorted on description )-----*/
   for( sz_num = 0 ; sz_num < as_avail_translations.GetCount() ; ++sz_num )
   {
      /*-------------------------------------------------------------------*/
        p_langinfo
      = wxLocale::FindLanguageInfo( as_avail_translations[ sz_num ] ) ;
      if( p_langinfo != NULL )
      {
         /*----------------------------------------------------------------*/
           map_desc_canon[ wxGetTranslation( p_langinfo->Description ) ]
         = as_avail_translations[ sz_num ] ;
         /*----------------------------------------------------------------*/
      }
      /*-------------------------------------------------------------------*/
   }

   /*--( The default will be displayed first )-----------------------------*/
   sz_lang_sel = m_cho_lang->GetCount() ;
   m_cho_lang->append_stringdata( "System (if translation exists)" ) ;

   /*--( Then the couples sorted on description (sort done by "map") )-----*/
   for( cit_desc_canon = map_desc_canon.begin() ;
        cit_desc_canon != map_desc_canon.end() ;
        ++cit_desc_canon
      )
   {
      /*--( Language chosen by the user ? (non default one) )--------------*/
      if(    !wxGetApp().M_s_lang.empty()
          && wxGetApp().M_s_lang.get() == cit_desc_canon->second
        )
      {  sz_lang_sel = m_cho_lang->GetCount() ; }
      /*-------------------------------------------------------------------*/
      m_cho_lang->append_stringdata( cit_desc_canon->first,
                                     cit_desc_canon->second
                                   ) ;
      /*-------------------------------------------------------------------*/
   }

   /*-----------------------------------------------------------------------+
   ! Finally the "no translation". It is mainly defined for test purpose.   !
   ! The idea is to use a code that is not defined and so use the           !
   ! "internal" text.                                                       !
   +-----------------------------------------------------------------------*/
   const wxString s_lang_none( _( "No translation (English)" ) ) ;
   const wxString s_lang_none_code( "**none**" ) ;
   /*----------------------------------------------------------------------*/
   if(    !wxGetApp().M_s_lang.empty()
       && wxGetApp().M_s_lang.get() == s_lang_none_code
     )
   {  sz_lang_sel = m_cho_lang->GetCount() ; }
   /*----------------------------------------------------------------------*/
   m_cho_lang->append_stringdata( s_lang_none, s_lang_none_code ) ;

   /*----------------------------------------------------------------------*/
   m_cho_lang->SetSelection( sz_lang_sel ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CPanPrefsGen::init_default()
{
   /*--( "System" language is the first one )------------------------------*/
   m_cho_lang->SetSelection( 0 ) ;
   /*----------------------------------------------------------------------*/
   m_boo_chkver_auto->SetValue( wxGetApp().M_boo_chkver_auto.get_def() ) ;
   m_boo_copy_file_tms->SetValue( wxGetApp().M_boo_copy_file_tms.get_def() );
   /*----------------------------------------------------------------------*/
   m_boo_extr_meta->SetValue( wxGetApp().M_boo_extr_meta.get_def() ) ;
   m_boo_file_type_detect->SetValue(
                                  wxGetApp().M_boo_file_type_detect.get_def()
                                   ) ;
   m_boo_file_type_detect->Enable( wxGetApp().M_boo_extr_meta.get_def() ) ;
   m_boo_loose_mp3_check->SetValue(
                                   wxGetApp().M_boo_loose_mp3_check.get_def()
                                  ) ;
   m_boo_loose_mp3_check->Enable( wxGetApp().M_boo_extr_meta.get_def() ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
wxWindow *CPanPrefsGen::validate_changes()
{  return( NULL ) ; }

/*-------------------------------------------------------------------------*/
void CPanPrefsGen::apply_changes( wxUint32 &dw_poa )
{
   /*----------------------------------------------------------------------*/
   wxString s_lang               = m_cho_lang->get_stringdata()       ;
   bool     boo_chkver_auto      = m_boo_chkver_auto->GetValue()      ;
   bool     boo_copy_file_tms    = m_boo_copy_file_tms->GetValue()    ;
   bool     boo_extr_meta        = m_boo_extr_meta->GetValue()        ;
   bool     boo_file_type_detect = m_boo_file_type_detect->GetValue() ;
   bool     boo_loose_mp3_check  = m_boo_loose_mp3_check->GetValue()  ;

   /*----------------------------------------------------------------------*/
   if( wxGetApp().M_s_lang.get() != s_lang )
   {  wxGetApp().M_s_lang.set( s_lang ) ; }
   /*----------------------------------------------------------------------*/
   if( wxGetApp().M_boo_chkver_auto.get() != boo_chkver_auto )
   {  wxGetApp().M_boo_chkver_auto.set( boo_chkver_auto ) ; }
   /*----------------------------------------------------------------------*/
   if( wxGetApp().M_boo_copy_file_tms.get() != boo_copy_file_tms )
   {  wxGetApp().M_boo_copy_file_tms.set( boo_copy_file_tms ) ; }
   /*----------------------------------------------------------------------*/
   if( wxGetApp().M_boo_extr_meta.get() != boo_extr_meta )
   {  /*-------------------------------------------------------------------*/
      wxGetApp().M_boo_extr_meta.set( boo_extr_meta ) ;
      dw_poa |= SR_PPA_RELOAD ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   if( wxGetApp().M_boo_file_type_detect.get() != boo_file_type_detect )
   {  /*-------------------------------------------------------------------*/
      wxGetApp().M_boo_file_type_detect.set( boo_file_type_detect ) ;
      dw_poa |= SR_PPA_RELOAD ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   if( wxGetApp().M_boo_loose_mp3_check.get() != boo_loose_mp3_check )
   {  /*-------------------------------------------------------------------*/
      wxGetApp().M_boo_loose_mp3_check.set( boo_loose_mp3_check ) ;
      dw_poa |= SR_PPA_RELOAD ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CPanPrefsGen::OnChkExtract( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   bool boo_enable = m_boo_extr_meta->GetValue() ;
   /*----------------------------------------------------------------------*/
   m_boo_file_type_detect->Enable( boo_enable ) ;
   m_boo_loose_mp3_check->Enable( boo_enable ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CPanPrefsDisp::CPanPrefsDisp( wxWindow *parent )
             : CPanPrefsDispBase( parent )
{
   /*----------------------------------------------------------------------*/
   m_boo_list_alt_attr->SetValue( wxGetApp().M_boo_list_alt_attr.get() ) ;
   m_boo_grid_fl->SetValue( wxGetApp().M_boo_grid_fl.get() ) ;
   m_boo_list_hidden->SetValue( wxGetApp().M_boo_list_hidden.get() ) ;
   m_boo_natural_sort->SetValue( wxGetApp().M_boo_natural_sort.get() ) ;
   m_boo_fsizeb_fl->SetValue( wxGetApp().M_boo_fsizeb_fl.get() ) ;
   m_boo_list_dir->SetValue( wxGetApp().M_boo_list_dir.get() ) ;
   m_boo_list_dir_top->SetValue( wxGetApp().M_boo_list_dir_top.get() ) ;
   m_boo_filter_dir->SetValue( wxGetApp().M_boo_filter_dir.get() ) ;
   m_boo_dir_size_fl->SetValue( wxGetApp().M_boo_dir_size_fl.get() ) ;
   m_boo_img_rotation->SetValue( wxGetApp().M_boo_img_rotation.get() ) ;
   m_boo_img_hq_manip->SetValue( wxGetApp().M_boo_img_hq_manip.get() ) ;
   m_boo_img_stretch->SetValue( wxGetApp().M_boo_img_stretch.get() ) ;
   m_boo_exp_fix->SetValue( wxGetApp().M_boo_exp_fix.get() ) ;
   m_boo_fil_fix->SetValue( wxGetApp().M_boo_fil_fix.get() ) ;
   m_s_fmt_date_fl->SetValue( wxGetApp().M_s_fmt_date_fl.get() ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CPanPrefsDisp::~CPanPrefsDisp()
{  ; }

/*-------------------------------------------------------------------------*/
void CPanPrefsDisp::OnFmtDateFlKeyDown( wxKeyEvent &event )
{
   /*----------------------------------------------------------------------*/
   if( event.GetKeyCode() == WXK_F1 )
   {  wxGetApp().m_frame->show_help( HELP_DATE ) ; }
   else
   {  event.Skip() ; }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CPanPrefsDisp::init_default()
{
   /*----------------------------------------------------------------------*/
   m_boo_list_alt_attr->SetValue( wxGetApp().M_boo_list_alt_attr.get_def() );
   m_boo_grid_fl->SetValue( wxGetApp().M_boo_grid_fl.get_def() ) ;
   m_boo_list_hidden->SetValue( wxGetApp().M_boo_list_hidden.get_def() ) ;
   m_boo_natural_sort->SetValue( wxGetApp().M_boo_natural_sort.get_def() ) ;
   m_boo_fsizeb_fl->SetValue( wxGetApp().M_boo_fsizeb_fl.get_def() ) ;
   m_boo_list_dir->SetValue( wxGetApp().M_boo_list_dir.get_def() ) ;
   m_boo_list_dir_top->SetValue(wxGetApp().M_boo_list_dir_top.get_def() ) ;
   m_boo_filter_dir->SetValue( wxGetApp().M_boo_filter_dir.get_def() ) ;
   m_boo_dir_size_fl->SetValue( wxGetApp().M_boo_dir_size_fl.get_def() ) ;
   m_boo_img_rotation->SetValue(wxGetApp().M_boo_img_rotation.get_def() ) ;
   m_boo_img_hq_manip->SetValue(wxGetApp().M_boo_img_hq_manip.get_def() ) ;
   m_boo_img_stretch->SetValue( wxGetApp().M_boo_img_stretch.get_def() ) ;
   m_boo_exp_fix->SetValue( wxGetApp().M_boo_exp_fix.get_def() ) ;
   m_boo_fil_fix->SetValue( wxGetApp().M_boo_fil_fix.get_def() ) ;
   m_s_fmt_date_fl->SetValue( wxGetApp().M_s_fmt_date_fl.get_def() ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
wxWindow *CPanPrefsDisp::validate_changes()
{  return( NULL ) ; }

/*-------------------------------------------------------------------------*/
void CPanPrefsDisp::apply_changes( wxUint32 &dw_poa )
{
   /*----------------------------------------------------------------------*/
   bool     boo_list_hidden   = m_boo_list_hidden->GetValue()   ;
   bool     boo_natural_sort  = m_boo_natural_sort->GetValue()  ;
   bool     boo_list_alt_attr = m_boo_list_alt_attr->GetValue() ;
   bool     boo_fsizeb_fl     = m_boo_fsizeb_fl->GetValue()     ;
   bool     boo_grid_fl       = m_boo_grid_fl->GetValue()       ;
   bool     boo_list_dir      = m_boo_list_dir->GetValue()      ;
   bool     boo_list_dir_top  = m_boo_list_dir_top->GetValue()  ;
   bool     boo_filter_dir    = m_boo_filter_dir->GetValue()    ;
   bool     boo_dir_size_fl   = m_boo_dir_size_fl->GetValue()   ;
   bool     boo_img_rotation  = m_boo_img_rotation->GetValue()  ;
   bool     boo_img_hq_manip  = m_boo_img_hq_manip->GetValue()  ;
   bool     boo_img_stretch   = m_boo_img_stretch->GetValue()   ;
   bool     boo_exp_fix       = m_boo_exp_fix->GetValue()       ;
   bool     boo_fil_fix       = m_boo_fil_fix->GetValue()       ;
   wxString s_fmt_date_fl     = m_s_fmt_date_fl->GetValue()     ;

   /*----------------------------------------------------------------------*/
   if( wxGetApp().M_boo_list_alt_attr.get() != boo_list_alt_attr )
   {  /*-------------------------------------------------------------------*/
      wxGetApp().M_boo_list_alt_attr.set( boo_list_alt_attr ) ;
      dw_poa |= SR_PPA_REFRESH_FL ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   if( wxGetApp().M_boo_grid_fl.get() != boo_grid_fl )
   {  /*-------------------------------------------------------------------*/
      wxGetApp().M_boo_grid_fl.set( boo_grid_fl ) ;
      wxGetApp().get_fl()->show_grid( boo_grid_fl ) ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   if( wxGetApp().M_boo_list_hidden.get() != boo_list_hidden )
   {  /*-------------------------------------------------------------------*/
      wxGetApp().M_boo_list_hidden.set( boo_list_hidden ) ;
      wxGetApp().m_frame->m_dt->apply_hidden() ;
      dw_poa |= SR_PPA_REFRESH_DT ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   if( wxGetApp().M_boo_natural_sort.get() != boo_natural_sort )
   {  /*-------------------------------------------------------------------*/
      wxGetApp().M_boo_natural_sort.set( boo_natural_sort ) ;
      dw_poa |= SR_PPA_SORT ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   if( wxGetApp().M_boo_fsizeb_fl.get() != boo_fsizeb_fl )
   {  /*-------------------------------------------------------------------*/
      wxGetApp().M_boo_fsizeb_fl.set( boo_fsizeb_fl ) ;
      dw_poa |= SR_PPA_RELOAD ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   if( wxGetApp().M_boo_list_dir.get() != boo_list_dir )
   {  /*-------------------------------------------------------------------*/
      wxGetApp().M_boo_list_dir.set( boo_list_dir ) ;
      dw_poa |= SR_PPA_RELOAD ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   if( wxGetApp().M_boo_list_dir_top.get() != boo_list_dir_top )
   {  /*-------------------------------------------------------------------*/
      wxGetApp().M_boo_list_dir_top.set( boo_list_dir_top ) ;
      dw_poa |= SR_PPA_RELOAD ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   if( wxGetApp().M_boo_filter_dir.get() != boo_filter_dir )
   {  /*-------------------------------------------------------------------*/
      wxGetApp().M_boo_filter_dir.set( boo_filter_dir ) ;
      dw_poa |= SR_PPA_RELOAD ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   if( wxGetApp().M_boo_dir_size_fl.get() != boo_dir_size_fl )
   {  /*-------------------------------------------------------------------*/
      wxGetApp().M_boo_dir_size_fl.set( boo_dir_size_fl ) ;
      dw_poa |= SR_PPA_RELOAD ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   if( wxGetApp().M_boo_img_rotation.get() != boo_img_rotation )
   {  /*-------------------------------------------------------------------*/
      wxGetApp().M_boo_img_rotation.set( boo_img_rotation ) ;
      dw_poa |= SR_PPA_DISP_IMG ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   if( wxGetApp().M_boo_img_hq_manip.get() != boo_img_hq_manip )
   {  /*-------------------------------------------------------------------*/
      wxGetApp().M_boo_img_hq_manip.set( boo_img_hq_manip ) ;
      dw_poa |= SR_PPA_DISP_IMG ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   if( wxGetApp().M_boo_img_stretch.get() != boo_img_stretch )
   {  /*-------------------------------------------------------------------*/
      wxGetApp().M_boo_img_stretch.set( boo_img_stretch ) ;
      dw_poa |= SR_PPA_DISP_IMG ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   if( wxGetApp().M_boo_exp_fix.get() != boo_exp_fix )
   {  /*-------------------------------------------------------------------*/
      wxGetApp().M_boo_exp_fix.set( boo_exp_fix ) ;
      sr::set_font_fix( wxGetApp().m_frame->m_cb_exp, boo_exp_fix ) ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   if( wxGetApp().M_boo_fil_fix.get() != boo_fil_fix )
   {  /*-------------------------------------------------------------------*/
      wxGetApp().M_boo_fil_fix.set( boo_fil_fix ) ;
      sr::set_font_fix( wxGetApp().m_frame->m_cb_fil, boo_fil_fix ) ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   if( wxGetApp().M_s_fmt_date_fl.get() != s_fmt_date_fl )
   {  /*-------------------------------------------------------------------*/
      wxGetApp().M_s_fmt_date_fl.set( s_fmt_date_fl ) ;
      dw_poa |= SR_PPA_RELOAD ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CPanPrefsCbc::CPanPrefsCbc( wxWindow *parent )
            : CPanPrefsCbcBase( parent )
{
   /*----------------------------------------------------------------------*/
   m_boo_cbc_sep_tab->SetValue( wxGetApp().M_boo_cbc_sep_tab.get() ) ;
   m_boo_cbc_sep_char->SetValue( !wxGetApp().M_boo_cbc_sep_tab.get() ) ;
   /*----------------------------------------------------------------------*/
   m_s_cbc_sep_char->SetValue( wxGetApp().M_s_cbc_sep_char.get() ) ;
   m_s_cbc_sep_char->Enable( !wxGetApp().M_boo_cbc_sep_tab.get() ) ;
   /*----------------------------------------------------------------------*/
   m_s_cbc_repl_sep_char->SetValue( wxGetApp().M_s_cbc_repl_sep_char.get() );
   /*----------------------------------------------------------------------*/
   sr::set_font_fix( m_s_cbc_repl_sep_char, true ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CPanPrefsCbc::~CPanPrefsCbc()
{  ; }

/*-------------------------------------------------------------------------*/
void CPanPrefsCbc::init_default()
{
   /*----------------------------------------------------------------------*/
   m_boo_cbc_sep_tab->SetValue( wxGetApp().M_boo_cbc_sep_tab.get_def() ) ;
   m_boo_cbc_sep_char->SetValue(!wxGetApp().M_boo_cbc_sep_tab.get_def() ) ;
   /*----------------------------------------------------------------------*/
   m_s_cbc_sep_char->SetValue( wxGetApp().M_s_cbc_sep_char.get_def() ) ;
   m_s_cbc_sep_char->Enable( !wxGetApp().M_boo_cbc_sep_tab.get_def() ) ;
   /*----------------------------------------------------------------------*/
   m_s_cbc_repl_sep_char->SetValue(wxGetApp().M_s_cbc_repl_sep_char.get_def()
                                  ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
wxWindow *CPanPrefsCbc::validate_changes()
{
   /*----------------------------------------------------------------------*/
   bool     boo_cbc_sep_tab = m_boo_cbc_sep_tab->GetValue() ;
   wxString s_cbc_sep_char( m_s_cbc_sep_char->GetValue() ) ;
   wxString s_cbc_repl_sep_char( m_s_cbc_repl_sep_char->GetValue() ) ;

   /*----------------------------------------------------------------------*/
   if( !boo_cbc_sep_tab && s_cbc_sep_char.empty() )
   {
      /*-------------------------------------------------------------------*/
      sr::error_message( _( "The columns separator character is mandatory" )
                       ) ;
      return( m_s_cbc_sep_char ) ;
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
   if( s_cbc_repl_sep_char.empty() )
   {
      /*-------------------------------------------------------------------*/
      sr::error_message( _( "The replacement character of the columns "
                            "separator is mandatory"
                          )
                       ) ;
      return( m_s_cbc_repl_sep_char ) ;
      /*-------------------------------------------------------------------*/
   }

   /*--( Normally, it shouldn't be possible to enter a tabulation char )---*/
   if( !boo_cbc_sep_tab && s_cbc_sep_char == s_cbc_repl_sep_char )
   {
      /*-------------------------------------------------------------------*/
      sr::error_message( _( "The columns separator and its "
                            "replacement character must be different"
                          )
                       ) ;
      return( m_s_cbc_repl_sep_char ) ;
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
   return( NULL ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CPanPrefsCbc::apply_changes( wxUint32 & WXUNUSED( dw_poa ) )
{
   /*----------------------------------------------------------------------*/
   wxGetApp().M_boo_cbc_sep_tab.set( m_boo_cbc_sep_tab->GetValue() ) ;
   wxGetApp().M_s_cbc_sep_char.set( m_s_cbc_sep_char->GetValue() ) ;
   wxGetApp().M_s_cbc_repl_sep_char.set( m_s_cbc_repl_sep_char->GetValue() );
   /*--( No specific work has to be done after this modification )---------*/
}

/*-------------------------------------------------------------------------*/
void CPanPrefsCbc::OnRadTab( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   m_s_cbc_sep_char->Enable( !m_boo_cbc_sep_tab->GetValue() ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CPanPrefsCbc::OnRadChar( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   m_s_cbc_sep_char->Enable( m_boo_cbc_sep_char->GetValue() ) ;
   /*----------------------------------------------------------------------*/
}

/*--------------------------------------------------------------------------+
! Why using a "virtual" list ?                                              !
! - much faster to "initialize"                                             !
! - easier to deal with mainly during init and apply                        !
+--------------------------------------------------------------------------*/
CCheckListCtrl::CCheckListCtrl( wxWindow *parent, wxWindowID id,
                                const wxPoint &pos, const wxSize &size,
                                long style, const wxValidator &validator,
                                const wxString &name
                              ) : CListCtrlBase( parent, id, pos, size,
                                                 style | wxLC_VIRTUAL,
                                                 validator, name
                                               )
{
   /*----------------------------------------------------------------------*/
   wxGetApp().get_fl()->save_all_col_width() ;
   /*----------------------------------------------------------------------*/
   SetImageList( wxGetApp().get_fl()->GetImageList( wxIMAGE_LIST_SMALL ),
                 wxIMAGE_LIST_SMALL
               ) ;
   /*--( The work is done on a local copy )--------------------------------*/
   std::copy( &wxGetApp().get_fl()->m_tb_col[ st_co_i_col_min_disp ],
              &wxGetApp().get_fl()->m_tb_col[   st_co_i_col_min_disp
                                              + st_co_i_col_nb_disp
                                            ],
              &m_tb_col[ 0 ]
            ) ;

   /*--( Columns creation )------------------------------------------------*/
   int i_width     ;
   int i_width_max ;
   int i_num       ;
   /*----------------------------------------------------------------------*/
   for( i_num = 0, i_width_max = 0 ; i_num < st_co_i_col_nb_disp ; ++i_num )
   {  i_width = col_width_for_text( m_tb_col[ i_num ].m_s_name ) ;
      i_width_max = wxMax( i_width_max, i_width ) ;
   }
   /*--( The first column contains the checkbox too )----------------------*/
   InsertColumn( 0, _( "Column" ), wxLIST_FORMAT_LEFT,
                 6 + g_co_size_tool.GetWidth() + i_width_max
               ) ;
   /*----------------------------------------------------------------------*/
   for( i_num = 0, i_width_max = 0 ; i_num < GRP_NB ; ++i_num )
   {  i_width = col_width_for_text( wxGetApp().m_colgroup.get_name( i_num ));
      i_width_max = wxMax( i_width_max, i_width ) ;
   }
   /*----------------------------------------------------------------------*/
   InsertColumn( 1, _( "Group" ) , wxLIST_FORMAT_LEFT, i_width_max ) ;

   /*----------------------------------------------------------------------*/
   SetItemCount( st_co_i_col_nb_disp ) ;
   /*----------------------------------------------------------------------*/
   set_item_hil( 0, true ) ;
   set_item_focus( 0 ) ;

   /*--( No horizontal scrollbar ... )-------------------------------------*/
   wxRect rect ;
   GetItemRect( 0, rect ) ;
   SetMinClientSize( wxSize( rect.GetWidth(), wxDefaultSize.GetHeight() ) ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
wxListItemAttr *CCheckListCtrl::OnGetItemAttr( long item ) const
{
   /*----------------------------------------------------------------------*/
   if( item % 2 == 1 && wxGetApp().M_boo_list_alt_attr.get() )
   {  /*-------------------------------------------------------------------*/
      static wxListItemAttr st_attr( wxNullColour, get_alternate_attr(),
                                     wxNullFont
                                   ) ;
      /*-------------------------------------------------------------------*/
      return( &st_attr ) ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   return( NULL ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CCheckListCtrl::OnGetItemImage( long l_item ) const
{
   /*----------------------------------------------------------------------*/
   return( m_tb_col[ l_item ].m_boo_on
           ? wxGetApp().get_fl()->get_image_list()->get_check()
           : wxGetApp().get_fl()->get_image_list()->get_uncheck()
         ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
wxString CCheckListCtrl::OnGetItemText( long l_item, long l_column ) const
{
   /*----------------------------------------------------------------------*/
   return( l_column == 1
           ? wxGetApp().m_colgroup.get_name( m_tb_col[ l_item ].m_grp )
           : m_tb_col[ l_item ].m_s_name
         ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CCheckListCtrl::OnMouseLeftDown( wxMouseEvent &event )
{
   /*----------------------------------------------------------------------*/
   int  flags ;
   long l_item = HitTest( event.GetPosition(), flags ) ;
   /*--( Click in the checkbox ? )-----------------------------------------*/
   if( l_item > -1 && ( flags & wxLIST_HITTEST_ONITEMICON ) != 0 )
   {
      /*-------------------------------------------------------------------*/
      m_tb_col[ l_item ].m_boo_on = !m_tb_col[ l_item ].m_boo_on ;
      RefreshItem( l_item ) ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   event.Skip() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CCheckListCtrl::OnKeyDown( wxKeyEvent &event )
{
   /*----------------------------------------------------------------------*/
   if( event.GetModifiers() != wxMOD_ALT )
   {  event.Skip() ; return ; }
   /*----------------------------------------------------------------------*/
   switch( event.GetKeyCode() )
   {  /*-------------------------------------------------------------------*/
      case WXK_UP   : move_hil( true  ) ; break ;
      case WXK_DOWN : move_hil( false ) ; break ;
      default : event.Skip() ; break ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CCheckListCtrl::sel_all( bool boo_on )
{
   /*----------------------------------------------------------------------*/
   int i_item ;
   /*----------------------------------------------------------------------*/
   for( i_item = 0 ; i_item < st_co_i_col_nb_disp ; ++i_item )
   {  m_tb_col[ i_item ].m_boo_on = boo_on ; }
   /*----------------------------------------------------------------------*/
   RefreshItems( 0, st_co_i_col_nb_disp - 1 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CCheckListCtrl::set_order_def()
{
   /*----------------------------------------------------------------------*/
   std::sort( m_tb_col, m_tb_col + st_co_i_col_nb_disp,
              CColumnSubItemComp()
            ) ;
   /*----------------------------------------------------------------------*/
   Refresh() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CCheckListCtrl::set_sel_def()
{
   /*----------------------------------------------------------------------*/
   int i_item ;
   /*----------------------------------------------------------------------*/
   for( i_item = 0 ; i_item < st_co_i_col_nb_disp ; ++i_item )
   {  m_tb_col[ i_item ].m_boo_on = m_tb_col[ i_item ].get_on_default() ; }
   /*----------------------------------------------------------------------*/
   Refresh() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CCheckListCtrl::set_width_def()
{
   /*----------------------------------------------------------------------*/
   int i_item ;
   /*----------------------------------------------------------------------*/
   for( i_item = 0 ; i_item < st_co_i_col_nb_disp ; ++i_item )
   {  m_tb_col[ i_item ].m_i_width = m_tb_col[ i_item ].m_i_width_def ; }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CCheckListCtrl::sel_hil( bool boo_on )
{
   /*----------------------------------------------------------------------*/
   long l_item = -1 ;
   /*----------------------------------------------------------------------*/
   while( ( l_item = get_next_hil_item( l_item ) ) != -1 )
   {  m_tb_col[ l_item ].m_boo_on = boo_on ;
      RefreshItem( l_item ) ;
   }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CCheckListCtrl::hil_group( int i_grp, bool boo_on )
{
   /*----------------------------------------------------------------------*/
   int i_item ;
   int i_min_item = st_co_i_col_nb_disp - 1 ;
   int i_max_item = 0 ;
   /*----------------------------------------------------------------------*/
   for( i_item = 0 ; i_item < st_co_i_col_nb_disp ; ++i_item )
   {
      /*-------------------------------------------------------------------*/
      if( m_tb_col[ i_item ].m_grp == i_grp )
      {
         /*----------------------------------------------------------------*/
         set_item_hil( i_item, boo_on ) ;
         /*----------------------------------------------------------------*/
         if( i_item > i_max_item ) { i_max_item = i_item ; }
         if( i_item < i_min_item ) { i_min_item = i_item ; }
         /*----------------------------------------------------------------*/
      }
      /*-------------------------------------------------------------------*/
   }
   /*--( Try to have as much visible as possible )-------------------------*/
   set_item_visible( i_max_item ) ;
   set_item_visible( i_min_item ) ;
   /*--( Better to come back in the list )---------------------------------*/
   SetFocus() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CCheckListCtrl::move_hil( bool boo_up )
{
   /*----------------------------------------------------------------------*/
   sr::t_vec_int vi_hil       ;
   long          l_item = -1  ;
   long          l_item_focus ;
   int           i_item_hil   ;

   /*--( First, extract the list of highlighted items )--------------------*/
   while( ( l_item = get_next_hil_item( l_item ) ) != -1 )
   {  vi_hil.push_back( l_item ) ; }

   /*--( Something to do ? )-----------------------------------------------*/
   if( vi_hil.empty() ) { return ; }
   /*--( Don't move after the edges )--------------------------------------*/
   if(   (  boo_up && vi_hil[ 0 ] == 0 )
      || ( !boo_up && vi_hil.back() == st_co_i_col_nb_disp - 1 )
     )
   {  return ; }

   /*--( The focus will be set on the same item )--------------------------*/
   l_item_focus = get_item_focus() ;

   /*--( Move )------------------------------------------------------------*/
   if( boo_up )
   {  /*-------------------------------------------------------------------*/
      for( l_item = 0 ; l_item < ( long )vi_hil.size() ; ++l_item )
      {  /*----------------------------------------------------------------*/
         i_item_hil = vi_hil[ l_item ] ;
         /*----------------------------------------------------------------*/
         set_item_hil( i_item_hil, false ) ;
         std::swap( m_tb_col[ i_item_hil ], m_tb_col[ i_item_hil - 1 ] ) ;
         set_item_hil( i_item_hil - 1, true ) ;
         /*----------------------------------------------------------------*/
         if( i_item_hil == l_item_focus )
         {  set_item_focus( i_item_hil - 1 ) ; }
         /*----------------------------------------------------------------*/
      }
      /*-------------------------------------------------------------------*/
      set_item_visible( vi_hil[ 0 ] - 1 ) ;
      /*-------------------------------------------------------------------*/
   }
   else
   {  /*-------------------------------------------------------------------*/
      for( l_item = vi_hil.size() - 1 ; l_item >= 0 ; --l_item )
      {  /*----------------------------------------------------------------*/
         i_item_hil = vi_hil[ l_item ] ;
         /*----------------------------------------------------------------*/
         set_item_hil( i_item_hil, false ) ;
         std::swap( m_tb_col[ i_item_hil ], m_tb_col[ i_item_hil + 1 ] ) ;
         set_item_hil( i_item_hil + 1, true ) ;
         /*----------------------------------------------------------------*/
         if( i_item_hil == l_item_focus )
         {  set_item_focus( i_item_hil + 1 ) ; }
         /*----------------------------------------------------------------*/
      }
      /*-------------------------------------------------------------------*/
      set_item_visible( vi_hil.back() + 1 ) ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CPanPrefsCol::CPanPrefsCol( wxWindow *parent )
            : CPanPrefsColBase( parent )
{
   /*----------------------------------------------------------------------*/
   int i_grp ;
   /*----------------------------------------------------------------------*/
   m_boo_grp_auto->SetValue( wxGetApp().M_boo_grp_auto.get() ) ;
   m_boo_col_used->SetValue( wxGetApp().M_boo_col_used.get() ) ;

   /*--( An explanatory text that unhighlight everything if chosen )-------*/
   m_cb_hil_grp->Append( _( "Group" ) ) ;
   m_cb_hil_grp->SetSelection( 0 ) ;
   /*-----------------------------------------------------------------------+
   ! Add groups to the combo                                                !
   +-----------------------------------------------------------------------*/
   for( i_grp = st_co_i_col_min_disp_group ; i_grp < GRP_NB ; ++i_grp )
   {  m_cb_hil_grp->Append( wxGetApp().m_colgroup.get_name( i_grp ) ) ; }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CPanPrefsCol::~CPanPrefsCol()
{  ; }

/*-------------------------------------------------------------------------*/
void CPanPrefsCol::init_default()
{
   /*----------------------------------------------------------------------*/
   m_boo_grp_auto->SetValue( wxGetApp().M_boo_grp_auto.get_def() ) ;
   m_boo_col_used->SetValue( wxGetApp().M_boo_col_used.get_def() ) ;
   /*----------------------------------------------------------------------*/
   m_lv_col->set_order_def() ;
   m_lv_col->set_sel_def()   ;
   m_lv_col->set_width_def() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
wxWindow *CPanPrefsCol::validate_changes()
{
   /*----------------------------------------------------------------------*/
   return( NULL ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CPanPrefsCol::apply_changes( wxUint32 &dw_poa )
{
   /*----------------------------------------------------------------------*/
   bool boo_grp_auto = m_boo_grp_auto->GetValue() ;
   bool boo_col_used = m_boo_col_used->GetValue() ;
   int  i_col ;

   /*--( Check if some change has been made to the columns )---------------*/
   for( i_col = 0 ;
              m_lv_col->m_tb_col[ i_col ]
           == wxGetApp().get_fl()->m_tb_col[ i_col + st_co_i_col_min_disp ]
        && i_col < st_co_i_col_nb_disp ;
        ++i_col
      )
   {  ; }
   /*--( Something done ? )------------------------------------------------*/
   if( i_col < st_co_i_col_nb_disp )
   {
      /*--( Copy back to "global" )----------------------------------------*/
      std::copy( &m_lv_col->m_tb_col[ 0 ],
                 &m_lv_col->m_tb_col[ st_co_i_col_nb_disp ],
                 &wxGetApp().get_fl()->m_tb_col[ st_co_i_col_min_disp ]
               ) ;
      wxGetApp().get_fl()->init_tb_subitem_col() ;
      /*-------------------------------------------------------------------*/
      dw_poa |= SR_PPA_COLUMN ;
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
   if(    wxGetApp().M_boo_grp_auto.get() != boo_grp_auto
       || wxGetApp().M_boo_col_used.get() != boo_col_used
     )
   {  /*-------------------------------------------------------------------*/
      wxGetApp().M_boo_grp_auto.set( boo_grp_auto ) ;
      wxGetApp().M_boo_col_used.set( boo_col_used ) ;
      /*-------------------------------------------------------------------*/
      dw_poa |= SR_PPA_COLUMN ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CPanPrefsCol::OnBtUp( wxCommandEvent & WXUNUSED( event ) )
{  m_lv_col->move_hil( true ) ; }

/*-------------------------------------------------------------------------*/
void CPanPrefsCol::OnBtDown( wxCommandEvent & WXUNUSED( event ) )
{  m_lv_col->move_hil( false ) ; }

/*-------------------------------------------------------------------------*/
void CPanPrefsCol::OnBtAll( wxCommandEvent & WXUNUSED( event ) )
{  m_lv_col->sel_all( true ) ; }

/*-------------------------------------------------------------------------*/
void CPanPrefsCol::OnBtNone( wxCommandEvent & WXUNUSED( event ) )
{  m_lv_col->sel_all( false ) ; }

/*-------------------------------------------------------------------------*/
void CPanPrefsCol::OnBtSelect( wxCommandEvent & WXUNUSED( event ) )
{  m_lv_col->sel_hil( true ) ; }

/*-------------------------------------------------------------------------*/
void CPanPrefsCol::OnBtUnselect( wxCommandEvent & WXUNUSED( event ) )
{  m_lv_col->sel_hil( false ) ; }

/*-------------------------------------------------------------------------*/
void CPanPrefsCol::OnCbHilGrp( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   int i_sel = m_cb_hil_grp->GetSelection() ;

   /*----------------------------------------------------------------------*/
   m_lv_col->set_item_hil( -1, false ) ;
   /*----------------------------------------------------------------------*/
   if( i_sel > 0 )
   {  m_lv_col->hil_group( i_sel - 1 + st_co_i_col_min_disp_group, true ) ; }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CPanPrefsCol::OnBtDefOrder( wxCommandEvent & WXUNUSED( event ) )
{  m_lv_col->set_order_def() ; }

/*-------------------------------------------------------------------------*/
void CPanPrefsCol::OnBtDefSel( wxCommandEvent & WXUNUSED( event ) )
{  m_lv_col->set_sel_def() ; }

/*-------------------------------------------------------------------------*/
void CPanPrefsCol::OnBtDefWidth( wxCommandEvent & WXUNUSED( event ) )
{  m_lv_col->set_width_def() ; }

/*-------------------------------------------------------------------------*/
#ifdef __WXMSW__
/*-------------------------------------------------------------------------*/
CPanPrefsScut::CPanPrefsScut( wxWindow *parent )
             : CPanPrefsScutBase( parent )
{
   /*----------------------------------------------------------------------*/
   m_s_exe_fullpath = wxStandardPaths::Get().GetExecutablePath() ;
   m_s_lnk_basename = SIREN_DISPLAY_NAME ".lnk" ;

   /*--( Which shortcut is associated to which check box ? )---------------*/
   m_tb_scut_chk[ CShortcut::SCUT_SENDTO   ] = m_chk_sendto   ;
   m_tb_scut_chk[ CShortcut::SCUT_QUICK    ] = m_chk_quick    ;
   m_tb_scut_chk[ CShortcut::SCUT_DESKTOP  ] = m_chk_desktop  ;
   m_tb_scut_chk[ CShortcut::SCUT_START    ] = m_chk_start    ;
   m_tb_scut_chk[ CShortcut::SCUT_PROGRAMS ] = m_chk_programs ;

   /*----------------------------------------------------------------------*/
   init_checkboxes() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CPanPrefsScut::~CPanPrefsScut()
{  ; }

/*-------------------------------------------------------------------------*/
void CPanPrefsScut::init_checkboxes()
{
   /*----------------------------------------------------------------------*/
   CShortcut scut   ;
   int       i_scut ;
   /*----------------------------------------------------------------------*/
   for( i_scut = 0 ; i_scut < CShortcut::SCUT_NB ; ++i_scut )
   {
      /*-------------------------------------------------------------------*/
      if( scut.init_name( ( CShortcut::e_shortcut )i_scut, m_s_lnk_basename
                        ) != 0
        )
      {  return ; }
      /*--( It doesn't exists => checkbox empty )--------------------------*/
      if( scut.load() != 0 )
      {  m_tb_scut_chk[ i_scut ]->Set3StateValue( wxCHK_UNCHECKED ) ; }
      else /*--( It exists but the taget is not the expected one )---------*/
      if( scut.get_target() != m_s_exe_fullpath )
      {  m_tb_scut_chk[ i_scut ]->Set3StateValue( wxCHK_UNDETERMINED ) ; }
      else /*--( The shortcut is ok )--------------------------------------*/
      {  m_tb_scut_chk[ i_scut ]->Set3StateValue( wxCHK_CHECKED ) ; }
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
}

/*--( No "default" for the shortcuts )-------------------------------------*/
void CPanPrefsScut::init_default()
{
   /*----------------------------------------------------------------------*/
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
wxWindow *CPanPrefsScut::validate_changes()
{
   /*----------------------------------------------------------------------*/
   return( NULL ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CPanPrefsScut::apply_changes( wxUint32 & WXUNUSED( dw_poa ) )
{
   /*----------------------------------------------------------------------*/
   CShortcut       scut      ;
   int             i_scut    ;
   wxCheckBoxState chk_state ;

   /*----------------------------------------------------------------------*/
   for( i_scut = 0 ; i_scut < CShortcut::SCUT_NB ; ++i_scut )
   {
      /*-------------------------------------------------------------------*/
      if( scut.init_name( ( CShortcut::e_shortcut )i_scut, m_s_lnk_basename
                        ) != 0
        )
      {  return ; }

      /*--( Try to load the shortcut )-------------------------------------*/
      scut.load() ;

      /*-------------------------------------------------------------------*/
      chk_state = m_tb_scut_chk[ i_scut ]->Get3StateValue() ;

      /*--( Creation/Update of the shorcut ? )-----------------------------*/
      if(    chk_state == wxCHK_CHECKED
          && scut.get_target() != m_s_exe_fullpath
        )
      {  /*----------------------------------------------------------------*/
         scut.set_target( m_s_exe_fullpath ) ;
         scut.set_desc( SIREN_DESCRIPTION ) ;
         scut.create_update() ;
         /*----------------------------------------------------------------*/
      }
      else /*--( Don't touch "undetermined" )------------------------------*/
      if( chk_state == wxCHK_UNCHECKED && !scut.get_target().empty() )
      {  scut.remove() ; }
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
}
/*-------------------------------------------------------------------------*/
#endif // __WXMSW__
/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                       End of file CPanPrefs.cpp                           !
+==========================================================================*/
