/*====================================+=====================================+
! File CFrame_Base.cpp                ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include <wx/menu.h>
#include <wx/msgdlg.h>
#include <wx/statline.h>
#include <wx/splitter.h>
#include <wx/toolbar.h>
#include <wx/html/helpctrl.h>
#include "siren_info.h"
#include "siren.h"
#include "CApp.h"
#include "CFileList.h"
#include "CCombo.h"
#include "CDirTree.h"
#include "CImageVisu.h"
#include "CTagVisu.h"
#include "CLoadDir.h"
#include "CTestbed.h"
#include "CFSWatcher.h"
#include "sr_fcontact.h"
/*-------------------------------------------------------------------------*/



/*--------------------------------------------------------------------------+
! Change the frame toolbar layout ...                                       !
! In the 3 toolbars layout, the expression is on its own line before        !
! the directory sizer.                                                      !
! In the 2 toolbars layout, the expression is the last element of the       !
! action sizer.                                                             !
+--------------------------------------------------------------------------*/
void CFrame::adapt_toolbars_layout()
{
   /*----------------------------------------------------------------------*/
   bool boo_three = wxGetApp().M_boo_three_toolbars.get() ;

   /*--( If not the first call, the previous layout has to be cleaned )----*/
   if( m_bsz_exp_glob != NULL )
   {
      /*--( The static line is suppressed )--------------------------------*/
      m_bsz_exp_glob->Detach( m_sep_exp ) ;
      m_sep_exp->Destroy() ;
      m_bsz_exp_glob->Detach( m_bsz_exp ) ;
      /*--------------------------------------------------------------------+
      ! Based on current layout the sizer is "removed" from the action or   !
      ! the general sizer. Note that for a sizer, "Remove" destroys it too  !
      +--------------------------------------------------------------------*/
      if( m_bsz_act->GetItem( m_bsz_exp_glob ) != NULL )
      {  m_bsz_act->Remove( m_bsz_exp_glob ) ; }
      else /*--( Three toolbars layout ! )---------------------------------*/
      {  m_bsz_gen->Remove( m_bsz_exp_glob ) ; }
      /*-------------------------------------------------------------------*/
   }

   /*--( Add the separator line )------------------------------------------*/
     m_sep_exp
   = new wxStaticLine( m_panel, wxID_ANY, wxDefaultPosition, wxDefaultSize,
                       boo_three ? wxLI_HORIZONTAL : wxLI_VERTICAL
                     ) ;
   /*--( Create the sizer with the expression elements )-------------------*/
   m_bsz_exp_glob = new wxBoxSizer( boo_three ? wxVERTICAL : wxHORIZONTAL ) ;
   m_bsz_exp_glob->Add( m_sep_exp, 0, wxEXPAND ) ;
   m_bsz_exp_glob->Add( m_bsz_exp, 1, wxEXPAND ) ;
   /*--( Add this sizer at the right place )-------------------------------*/
   if( boo_three )
   {  m_bsz_gen->Insert( 1, m_bsz_exp_glob, 0, wxEXPAND ) ; }
   else
   {  m_bsz_act->Add( m_bsz_exp_glob, 1, wxEXPAND ) ; }
   /*----------------------------------------------------------------------*/
}

/*--------------------------------------------------------------------------+
! Change the frame splitter layout ...                                      !
+--------------------------------------------------------------------------*/
void CFrame::adapt_splitter_layout()
{
   /*----------------------------------------------------------------------*/
   int i_ver_pos ;
   int i_hor_pos ;

   /*--( We have to keep the value to maybe restore it )-------------------*/
   if( m_spl_hor->IsSplit() )
   {  wxGetApp().M_i_spl_hor_pos.set( m_spl_hor->GetSashPosition() ) ; }

   /*----------------------------------------------------------------------*/
   i_ver_pos = m_spl_ver->GetSashPosition() ;
   i_hor_pos = wxGetApp().M_i_spl_hor_pos.get() ;
   /*----------------------------------------------------------------------*/
   m_spl_ver->Unsplit() ;
   m_spl_hor->Unsplit() ;
   /*----------------------------------------------------------------------*/
   if( wxGetApp().M_i_layout.get() == LAYOUT_VISU_LEFT )
   {
      /*-------------------------------------------------------------------*/
      m_dt->Reparent( m_spl_hor ) ;
      m_fl->Reparent( m_spl_ver ) ;
      /*-------------------------------------------------------------------*/
      m_spl_hor->SplitHorizontally( m_dt, m_nb, i_hor_pos ) ;
      m_spl_ver->SplitVertically( m_spl_hor, m_fl, i_ver_pos ) ;
      /*-------------------------------------------------------------------*/
   }
   else
   {
      /*-------------------------------------------------------------------*/
      m_dt->Reparent( m_spl_ver ) ;
      m_fl->Reparent( m_spl_hor ) ;
      /*-------------------------------------------------------------------*/
      m_spl_hor->SplitHorizontally( m_fl, m_nb, i_hor_pos ) ;
      m_spl_ver->SplitVertically( m_dt, m_spl_hor, i_ver_pos ) ;
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
   if( wxGetApp().M_i_layout.get() == LAYOUT_VISU_OFF )
   {  m_spl_hor->Unsplit() ; }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::set_global_layout( e_layout layout )
{
   /*----------------------------------------------------------------------*/
   int i_lay_prev = wxGetApp().M_i_layout.get() ;
   /*----------------------------------------------------------------------*/
   wxGetApp().M_i_layout.set( layout ) ;
   adapt_splitter_layout() ;
   /*----------------------------------------------------------------------*/
   if( i_lay_prev == LAYOUT_VISU_OFF )
   {  visu_file() ; }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
bool CFrame::get_fswatcher_active() const
{  return( m_fswatcher != NULL && m_fswatcher->get_active() ) ; }

/*-------------------------------------------------------------------------*/
void CFrame::gui_enable_search()
{
   /*----------------------------------------------------------------------*/
   wxMenuBar *menu_bar( GetMenuBar() ) ;
   /*----------------------------------------------------------------------*/
   if( menu_bar == NULL ) { wxFAIL ; return ; }
   /*----------------------------------------------------------------------*/
   menu_bar->FindItem( IDM_FIND_FIRST )->Enable( true ) ;
   menu_bar->FindItem( IDM_FIND_NEXT  )->Enable( true ) ;
   menu_bar->FindItem( IDM_FIND_PREV  )->Enable( true ) ;
   menu_bar->FindItem( IDM_FIND_LAST  )->Enable( true ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::gui_enable_stop_loading( bool boo_on )
{
   /*----------------------------------------------------------------------*/
   wxMenuBar *menu_bar( GetMenuBar() ) ;
   /*----------------------------------------------------------------------*/
   if( menu_bar == NULL ) { wxFAIL ; return ; }
   /*----------------------------------------------------------------------*/
   m_to_dir->EnableTool( ID_TB_DIR_STOP_LOADING, boo_on ) ;
   menu_bar->FindItem( ID_TB_DIR_STOP_LOADING )->Enable( boo_on ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::gui_update_oper()
{
   /*----------------------------------------------------------------------*/
   wxMenuBar *menu_bar( GetMenuBar() ) ;
   wxMenu    *menu_edit( menu_bar->GetMenu( 1 ) ) ;
   bool      boo_on ;

   /*----------------------------------------------------------------------*/
   if( menu_bar == NULL || menu_edit == NULL )
   {  wxFAIL ; return ; }

   /*----------------------------------------------------------------------*/
   boo_on = ( m_fl->m_dir.get_nb_sel() > 0 && get_fswatcher_active() ) ;
   /*----------------------------------------------------------------------*/
   m_to_act->EnableTool( ID_ACT_RENAME, boo_on ) ;
   menu_bar->FindItem( ID_ACT_RENAME )->Enable( boo_on ) ;
   m_to_act->EnableTool( ID_ACT_COMPUTE, boo_on ) ;
   menu_bar->FindItem( ID_ACT_COMPUTE )->Enable( boo_on ) ;
   m_to_act->EnableTool( ID_ACT_COPY, boo_on ) ;
   menu_bar->FindItem( ID_ACT_COPY )->Enable( boo_on ) ;

   /*--( Edit/Copy to clipboard )------------------------------------------*/
   menu_edit->FindItemByPosition( 0 )->Enable( boo_on ) ;
   /*--( Find selected file )----------------------------------------------*/
   menu_edit->FindItemByPosition( 2 )->Enable( boo_on ) ;
   /*----------------------------------------------------------------------*/
   boo_on = ( m_fl->get_num_otfile() > 0 ) ;
   m_to_act->EnableTool( ID_ACT_UNDO, boo_on ) ;
   menu_bar->FindItem( ID_ACT_UNDO )->Enable( boo_on ) ;

   /*----------------------------------------------------------------------*/
   boo_on = ( m_fl->get_num_otfile() < m_fl->get_nb_otfile() ) ;
   m_to_act->EnableTool( ID_ACT_REDO, boo_on ) ;
   menu_bar->FindItem( ID_ACT_REDO )->Enable( boo_on ) ;

   /*----------------------------------------------------------------------*/
   SetStatusText( wxString::Format( _( "Oper : %d/%d" ),
                                    m_fl->get_num_otfile(),
                                    m_fl->get_nb_otfile()
                                  ),
                  SB_OPER
                ) ;
   /*----------------------------------------------------------------------*/
   SetStatusText( wxString::Format( _( "Sel : %d/%d" ),
                                    m_fl->m_dir.get_nb_sel(),
                                    ( int )m_fl->m_dir.size()
                                  ),
                  SB_SEL_NB
                ) ;
   /*----------------------------------------------------------------------*/
   SetStatusText( wxString::Format(
                     _( "Sel duration : %s" ),
                     sr::duration_to_string( m_fl->m_dir.get_sel_duration() )
                                  ),
                  SB_SEL_DURATION
                ) ;
   /*----------------------------------------------------------------------*/
   SetStatusText( wxString::Format(
              _( "Sel size : %s" ),
              sr::size_in_most_appropriate_unit( m_fl->m_dir.get_sel_size() )
                                  ),
                  SB_SEL_SIZE
                ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::gui_update_recurse()
{
   /*----------------------------------------------------------------------*/
   wxMenuBar *menu_bar( GetMenuBar() ) ;
   bool      boo_on = get_recurse() ;
   /*----------------------------------------------------------------------*/
   if( menu_bar == NULL ) { wxFAIL ; return ; }
   /*----------------------------------------------------------------------*/
   m_to_dir->ToggleTool( ID_TB_DIR_RECURSE, boo_on ) ;
   menu_bar->FindItem( ID_TB_DIR_RECURSE )->Check( boo_on ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::gui_update_dir()
{
   /*----------------------------------------------------------------------*/
   wxMenuBar *menu_bar( GetMenuBar() ) ;
   bool      boo_on ;
   /*----------------------------------------------------------------------*/
   if( menu_bar == NULL ) { wxFAIL ; return ; }
   /*----------------------------------------------------------------------*/
   m_to_dir->EnableTool( ID_TB_DIR_BACK,
                         m_dir_history.get_back_possible()
                       ) ;
   m_to_dir->EnableTool( ID_TB_DIR_FORWARD,
                         m_dir_history.get_forward_possible()
                       ) ;
   /*----------------------------------------------------------------------*/
   boo_on = (    wxGetApp().M_s_dir.get().Last()
              != wxFileName::GetPathSeparator()
            ) ;
   /*----------------------------------------------------------------------*/
   m_to_dir->EnableTool( ID_TB_DIR_UP, boo_on ) ;
   menu_bar->FindItem( ID_TB_DIR_UP )->Enable( boo_on ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::status_disp_text( long l_item )
{
   /*--( Loading information is more important than current file name )----*/
   if( m_loaddir.can_display_run_info() ) { return ; }
   /*----------------------------------------------------------------------*/
   if( l_item == -1 ) { l_item = m_fl->get_item_focus() ; }
   /*----------------------------------------------------------------------*/
   const CFile *p_file = m_fl->m_dir.get_p_file( l_item ) ;
   /*----------------------------------------------------------------------*/
   if( p_file == NULL )
   {  g_disp_info( wxEmptyString ) ; }
   else
   if( p_file->is_oper_err() )
   {  g_disp_info( p_file->get_oper_err() ) ; }
   else
   {  g_disp_info( p_file->get_full_path() ) ; }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::stop_current_load_directory( e_send_end_event seevt )
{
   /*----------------------------------------------------------------------*/
   {  wxCriticalSectionLocker enter_csec( m_loaddir.m_csec_p_thread ) ;
      /*-------------------------------------------------------------------*/
      if( m_loaddir.m_p_thread == NULL ) { return ; }
      /*-------------------------------------------------------------------*/
      m_loaddir.m_p_thread->set_send_end_event( seevt ) ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   m_loaddir.thread_stop() ;
   /*----------------------------------------------------------------------*/
}

/*--( Empty path parameter means reload current directory )----------------*/
int CFrame::load_directory( const wxString &s_path,
                            e_loading_mode loading_mode
                          )
{
   /*--( Stop monitoring current directory )-------------------------------*/
   if( m_fswatcher != NULL ) { m_fswatcher->stop() ; }

   /*-----------------------------------------------------------------------+
   ! First task is stopping a potential loading ...                         !
   ! Based on tests an heavy use of start/stop can cause a crash.           !
   +-----------------------------------------------------------------------*/
   stop_current_load_directory( SEEVT_DONT_SEND_END_EVENT ) ;
   /*----------------------------------------------------------------------*/
   bool boo_same_dir = s_path.empty() ;

   /*-----------------------------------------------------------------------+
   ! The "recurse" loading mode is automatically disabled if the directory  !
   ! has changed. This because it is very annoying to unintentionally load  !
   ! a complete directory tree.                                             !
   ! This won't be true during the application start to take the "recurse"  !
   ! command line parameter into account.                                   !
   +-----------------------------------------------------------------------*/
   if( !boo_same_dir && get_recurse() && wxGetApp().get_init_done() )
   {  set_recurse( false ) ;
      gui_update_recurse() ;
   }

   /*--( Transfer "modifiable" parameters and reinit the global ones )-----*/
   m_loaddir.m_param = m_loaddir_param ;
   m_loaddir_param.init() ;
   /*----------------------------------------------------------------------*/
   m_loaddir.set_path( boo_same_dir ? wxGetApp().M_s_dir.get() : s_path ) ;
   m_loaddir.set_filter( m_cb_fil->GetValue() ) ;
   m_loaddir.set_same_dir( boo_same_dir ) ;
   m_loaddir.set_list_dir( wxGetApp().M_boo_list_dir.get() ) ;
   m_loaddir.set_filter_dir( wxGetApp().M_boo_filter_dir.get() ) ;
   m_loaddir.set_list_hidden( wxGetApp().M_boo_list_hidden.get() ) ;
   m_loaddir.m_dir.set_recurse( get_recurse() ) ;

   /*-----------------------------------------------------------------------+
   ! It is more user friendly to show the loaded directory before starting  !
   +-----------------------------------------------------------------------*/
   if( !boo_same_dir && m_dt->set_path( s_path ) != 0 )
   {  return( -1 ) ; }
   /*----------------------------------------------------------------------*/
   if( loading_mode == LM_THREADED )
   {  m_loaddir.thread_start() ; }
   else
   {  m_loaddir.non_threaded_exec() ; }
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*--------------------------------------------------------------------------+
! The directory tree won't be refreshed in case of an UNC path because      !
! "wxGenericDirCtrl" control doesn't support it.                            !
+--------------------------------------------------------------------------*/
int CFrame::change_directory( const wxString &s_dir,
                              e_loading_mode loading_mode
                            )
{
   /*----------------------------------------------------------------------*/
   wxFileName fn_abs( s_dir, wxEmptyString ) ;
   wxString   s_path_abs ;

   /*-----------------------------------------------------------------------+
   ! First, standardize the path.                                           !
   ! It has to be absolute & long for "CDir::set_path" to work              !
   +-----------------------------------------------------------------------*/
   if( !fn_abs.Normalize( wxPATH_NORM_ABSOLUTE | wxPATH_NORM_LONG ) )
   {  return( -1 ) ; }
   /*----------------------------------------------------------------------*/
   s_path_abs = fn_abs.GetPath() ;

   /*----------------------------------------------------------------------*/
   if( sr::is_unc_path( s_path_abs ) )
   {
      /*-------------------------------------------------------------------*/
      if( !wxGetApp().is_path_ok_to_read( s_path_abs ) )
      {  sr::access_error_message( fn_abs.GetPath() ) ;
         return( -2 ) ;
      }
      /*-------------------------------------------------------------------*/
   }
   else
   if( m_dt->set_path( s_path_abs ) != 0 )
   {  return( -3 ) ; }

   /*----------------------------------------------------------------------*/
   return( load_directory( s_path_abs, loading_mode ) == 0 ? 0 : -4 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::setup_immediate_recompute()
{
   /*--( Change behaviour of the expression combo )------------------------*/
   if( wxGetApp().M_boo_imm_recompute.get() )
   {  m_cb_exp->Bind( wxEVT_COMMAND_TEXT_UPDATED,
                      &CFrame::OnExpChange, this
                    ) ;
   }
   else
   {  m_cb_exp->Unbind( wxEVT_COMMAND_TEXT_UPDATED,
                        &CFrame::OnExpChange, this
                      ) ;
   }

   /*--( Change behaviour of the testbed window, if any )------------------*/
   if( m_testbed != NULL ) { m_testbed->setup_immediate_recompute() ; }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::first_contact_dialog()
{
   /*----------------------------------------------------------------------*/
   CFContact dlg( this ) ;
   /*--( Use of application common images )--------------------------------*/
   dlg.m_bmp_dir->SetIcon( m_fl->get_image_list()->get_dir_icon() ) ;
   dlg.m_bmp_sel->SetIcon( m_fl->get_image_list()->get_check_icon() ) ;
   dlg.m_bmp_exp->SetBitmap(
                      m_to_act->FindById( ID_ACT_COMPUTE )->GetNormalBitmap()
                           ) ;
   dlg.m_bmp_ren->SetBitmap(
                       m_to_act->FindById( ID_ACT_RENAME )->GetNormalBitmap()
                           ) ;
   /*----------------------------------------------------------------------*/
   dlg.m_bt_ok->SetFocus() ;
   /*----------------------------------------------------------------------*/
   dlg.Layout() ;
   dlg.SetSize( dlg.GetEffectiveMinSize() ) ;
   dlg.CentreOnParent() ;
   /*----------------------------------------------------------------------*/
   dlg.ShowModal() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::allow_user_input( bool boo_on )
{
   /*----------------------------------------------------------------------*/
   if( boo_on )
   {  /*--( Delete the disabler if present )-------------------------------*/
      if( m_p_win_disabler != NULL )
      {  delete m_p_win_disabler ;
         m_p_win_disabler = NULL ;
         wxEndBusyCursor() ;
      }
      /*-------------------------------------------------------------------*/
   }
   else /*--( Disable user input if not already done => create disabler )--*/
   if( m_p_win_disabler == NULL )
   {  m_p_win_disabler = new wxWindowDisabler() ;
      wxBeginBusyCursor() ;
   }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::visu_file( long l_item )
{
   /*----------------------------------------------------------------------*/
   if( wxGetApp().M_i_layout.get() != LAYOUT_VISU_OFF )
   {
      /*-------------------------------------------------------------------*/
      CFile *p_file = ( l_item < 0 ? NULL : &m_fl->m_dir[ l_item ] ) ;
      /*-------------------------------------------------------------------*/
      switch( m_nb->GetSelection() )
      {  /*----------------------------------------------------------------*/
         case 0 : m_iv->visu( p_file ) ; break ;
         case 1 : m_tv->visu( p_file ) ; break ;
         /*----------------------------------------------------------------*/
      }
      /*-------------------------------------------------------------------*/
   }

   /*-----------------------------------------------------------------------+
   ! In all cases, the info is displayed on the status bar.                 !
   ! This behaviour is expected by the calling functions.                   !
   +-----------------------------------------------------------------------*/
   status_disp_text( l_item ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::visu_file()
{  visu_file( m_fl->get_item_focus() ) ; }

/*-------------------------------------------------------------------------*/
int CFrame::show_help( const wxString &s_page )
{
   /*--( First time call ? )-----------------------------------------------*/
   bool boo_first_call = ( m_help == NULL ) ;
   /*----------------------------------------------------------------------*/
   if( boo_first_call )
   {
      /*--------------------------------------------------------------------+
      ! Depending on the "help size" the initialization can take a while    !
      +--------------------------------------------------------------------*/
      wxString s_help_path(
                         wxGetApp().translated_file_path( SIREN_NAME ".htb" )
                          ) ;
      if( s_help_path.empty() )
      {  sr::error_message( _( "Help file not found" ) ) ;
         return( -1 ) ;
      }
      /*--( No index pane )------------------------------------------------*/
      m_help = new wxHtmlHelpController( wxHF_DEFAULT_STYLE & ~wxHF_INDEX ) ;
      m_help->SetTitleFormat( SIREN_DISPLAY_NAME " : %s" ) ;
      m_help->UseConfig( wxConfig::Get() ) ;
      m_help->AddBook( s_help_path ) ;
      /*-------------------------------------------------------------------*/
   }

   /*--( Default help )----------------------------------------------------*/
   if( s_page.empty() )
   {  m_help->DisplayContents() ; }
   else
   {  /*--------------------------------------------------------------------+
      ! Under GTK wx 2.9.3-2.9.4 if an anchor is present in the page name,  !
      ! the correct page is displayed but the "scroll to anchor" is not     !
      ! done. A second call will make the scroll to be achieved.            !
      +--------------------------------------------------------------------*/
#ifdef __WXGTK__
      if(    s_page.find( '#' ) != wxString::npos
          && !m_help->Display( s_page )
        )
      {  return( -3 ) ; }
#endif // __WXGTK__
      /*-------------------------------------------------------------------*/
      if( !m_help->Display( s_page ) )
      {  return( -4 ) ; }
      /*-------------------------------------------------------------------*/
   }

   /*--( Index expanded is nicer for the user )----------------------------*/
   if( boo_first_call )
   {  m_help->GetHelpWindow()->GetTreeCtrl()->ExpandAll() ; }
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*--( Transfer main combo expression to configuration variable )-----------*/
void CFrame::trsf_exp_combo_var()
{
   /*----------------------------------------------------------------------*/
   wxGetApp().M_s_exp.set( m_cb_exp->GetValue().Trim( false ).Trim() ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                      End of file CFrame_Base.cpp                          !
+==========================================================================*/
