/*====================================+=====================================+
! File CFileInit_off.cpp              ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+---------------------------------------------------------------------------+
!                                                                           !
!                  "Office" file: doc, xls, pps ...                         !
!                                                                           !
!                      ONLY FOR MSW PLATFORM !!                             !
!                                                                           !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#ifdef __WXMSW__
/*-------------------------------------------------------------------------*/
#include <wx/variant.h>
#include <wx/msw/ole/oleutils.h>
#include "common/sr_lib.h"
#include "CFileInit.h"
#include "CFile.h"
/*-------------------------------------------------------------------------*/



/*--------------------------------------------------------------------------+
! Data/Treatment used during the loading                                    !
+--------------------------------------------------------------------------*/
class CFileInit_off : public CFileInit_type_base
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CFileInit_off( CFileInit &parent ) : CFileInit_type_base( parent )
      {  ; }
      /*-------------------------------------------------------------------*/
      int read_tag( int i_num, const PROPVARIANT &PropVar ) ;
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
static const GUID SR_FMTID_SummaryInformation
             = {  0xF29F85E0, 0x4FF9, 0x1068,
                  { 0xAB, 0x91, 0x08, 0x00, 0x2B, 0x27, 0xB3, 0xD9 }
               } ;

/*--( Variable identifiers )-----------------------------------------------*/
struct str_tag_off
{  int i_col   ;
   int i_pidsi ;
} ;

/*-------------------------------------------------------------------------*/
static const str_tag_off st_tb_tag_off[]
= {
    /*---------------------------------------------------------------------*/
    { COL_DOC_TITLE       , PIDSI_TITLE        } , // VT_LPSTR
    { COL_DOC_SUBJECT     , PIDSI_SUBJECT      } , // VT_LPSTR
    { COL_DOC_AUTHOR      , PIDSI_AUTHOR       } , // VT_LPSTR
    { COL_DOC_KEYWORDS    , PIDSI_KEYWORDS     } , // VT_LPSTR
    { COL_DOC_COMMENT     , PIDSI_COMMENTS     } , // VT_LPSTR
    //{ COL_DOC_TEMPLATE    , PIDSI_TEMPLATE     } , // VT_LPSTR
    //{ COL_DOC_LASTAUTHOR  , PIDSI_LASTAUTHOR   } , // VT_LPSTR
    { COL_DOC_VERSION     , PIDSI_REVNUMBER    } , // VT_LPSTR
    //{ COL_DOC_EDITTIME    , PIDSI_EDITTIME     } , // VT_FILETIME
    //{ COL_DOC_LASTPRINTED , PIDSI_LASTPRINTED  } , // VT_FILETIME
    { COL_DOC_CRE_DATE    , PIDSI_CREATE_DTM   } , // VT_FILETIME
    { COL_DOC_MOD_DATE    , PIDSI_LASTSAVE_DTM } , // VT_FILETIME
    { COL_DOC_PAGECOUNT   , PIDSI_PAGECOUNT    } , // VT_I4
    { COL_DOC_WORDCOUNT   , PIDSI_WORDCOUNT    } , // VT_I4
    { COL_DOC_CHARCOUNT   , PIDSI_CHARCOUNT    } , // VT_I4
    { COL_DOC_APPLICATION , PIDSI_APPNAME      } , // VT_LPSTR
    //{ COL_DOC_DOC_SECURITY, PIDSI_DOC_SECURITY }   // VT_I4
    /*---------------------------------------------------------------------*/
  } ;
/*-------------------------------------------------------------------------*/
static const int st_ci_nb_tag_off = WXSIZEOF( st_tb_tag_off ) ;


/*-------------------------------------------------------------------------*/
int CFileInit_off::read_tag( int i_num, const PROPVARIANT &PropVar )
{
   /*----------------------------------------------------------------------*/
   wxString s_val ;
   int      i_col ;

   /*----------------------------------------------------------------------*/
   if( i_num >= st_ci_nb_tag_off ) { wxFAIL ; return( -1 ) ; }

   /*----------------------------------------------------------------------*/
   i_col = st_tb_tag_off[ i_num ].i_col ;

   /*--( "Fetch" only the elementary types )-------------------------------*/
   switch( PropVar.vt & VT_TYPEMASK )
   {
      /*-------------------------------------------------------------------*/
      case VT_EMPTY : case VT_NULL : case VT_BLOB :
      case VT_CF : // Clipboard format.
         break ;
      /*-------------------------------------------------------------------*/
      case VT_BOOL :
         m_f.val_s( i_col ) = ( PropVar.boolVal ? "True" : "False" ) ;
         break ;
      /*-------------------------------------------------------------------*/
      case VT_I1 :
         m_f.val_ll( i_col ) = PropVar.cVal ;
         m_f.val_s( i_col ) << PropVar.cVal ;
         break ;
      /*-------------------------------------------------------------------*/
      case VT_I2 :
         m_f.val_ll( i_col ) = PropVar.iVal ;
         m_f.val_s( i_col ) << PropVar.iVal ;
         break ;
      /*-------------------------------------------------------------------*/
      case VT_I4 :
         m_f.val_ll( i_col ) = PropVar.lVal ;
         m_f.val_s( i_col ) << PropVar.lVal ;
         break ;
      /*-------------------------------------------------------------------*/
      case VT_I8 :
      {  wxLongLong ll( PropVar.hVal.HighPart, PropVar.hVal.LowPart ) ;
         m_f.val_ll( i_col ) = ll ;
         m_f.val_s( i_col ) = ll.ToString() ;
         break ;
      }
      /*-------------------------------------------------------------------*/
#ifdef SR_NOT_USED_YET
      case VT_INT :
         m_f.val_ll( i_col ) = PropVar.intVal ;
         m_f.val_s( i_col ) << PropVar.intVal ;
         break ;
#endif
      /*-------------------------------------------------------------------*/
      case VT_UI1 :
         m_f.val_ll( i_col ) = PropVar.bVal ;
         m_f.val_s( i_col ) << PropVar.bVal ;
         break ;
      /*-------------------------------------------------------------------*/
      case VT_UI2 :
         m_f.val_ll( i_col ) = PropVar.uiVal ;
         m_f.val_s( i_col ) << PropVar.uiVal ;
         break ;
      /*-------------------------------------------------------------------*/
      case VT_UI4 :
         m_f.val_ll( i_col ) = PropVar.ulVal ;
         m_f.val_s( i_col ) << PropVar.ulVal ;
         break ;
      /*-------------------------------------------------------------------*/
      case VT_UI8 :
      {  wxULongLong ull( PropVar.uhVal.HighPart, PropVar.uhVal.LowPart ) ;
         m_f.val_ll( i_col ) = ull ;
         m_f.val_s( i_col ) = ull.ToString() ;
         break ;
      }
      /*-------------------------------------------------------------------*/
#ifdef SR_NOT_USED_YET
      case VT_UINT :
         m_f.val_ll( i_col ) = PropVar.uintVal ;
         m_f.val_s( i_col ) << PropVar.uintVal ;
         break ;
#endif
      /*-------------------------------------------------------------------*/
      case VT_R4 :
         m_f.val_do( i_col ) = PropVar.fltVal ;
         m_f.val_s( i_col ) << PropVar.fltVal ;
         break ;
      /*-------------------------------------------------------------------*/
      case VT_R8 :
         m_f.val_do( i_col ) = PropVar.dblVal ;
         m_f.val_s( i_col ) << PropVar.dblVal ;
         break ;
      /*-------------------------------------------------------------------*/
      case VT_LPSTR : // Null-terminated string.
         /*----------------------------------------------------------------*/
         if( PropVar.pszVal == NULL ) { break ; }
         /*----------------------------------------------------------------*/
         if( sr::prepare_string( ( char * )PropVar.pszVal, 1024, s_val,
                                 sr::CONV_FROM_UTF8
                               ) > 0
           )
         {  m_f.val_s( i_col ) = s_val ; }
         /*----------------------------------------------------------------*/
         break ;
      /*-------------------------------------------------------------------*/
      case VT_LPWSTR : // Wide character Null-terminated string.
         /*----------------------------------------------------------------*/
         if( PropVar.pwszVal == NULL ) { break ; }
         /*----------------------------------------------------------------*/
         if( sr::prepare_string( ( char * )PropVar.pwszVal, 1024, s_val,
                                 sr::CONV_FROM_UTF16LEBE
                               ) > 0
           )
         {  m_f.val_s( i_col ) = s_val ; }
         /*----------------------------------------------------------------*/
         break ;
      /*-------------------------------------------------------------------*/
      case VT_BSTR : // OLE Automation string.
         /*----------------------------------------------------------------*/
         if( PropVar.bstrVal == NULL ) { break ; }
         /*----------------------------------------------------------------*/
         if( sr::prepare_string( ( char * )PropVar.bstrVal, 1024, s_val,
                                 sr::CONV_FROM_UTF16LE
                               ) > 0
           )
         {  m_f.val_s( i_col ) = s_val ; }
         /*----------------------------------------------------------------*/
         break ;
      /*-------------------------------------------------------------------*/
      case VT_FILETIME :
      {
         /*----------------------------------------------------------------*/
         wxDateTime dt ;
         /*----------------------------------------------------------------*/
         if( sr::init_datetime( PropVar.filetime, dt ) == 0 )
         {  m_fi.init_date( i_col, dt ) ; }
         /*----------------------------------------------------------------*/
         break ;
         /*----------------------------------------------------------------*/
      }
      /*-------------------------------------------------------------------*/
      default : // Unhandled type, consult wtypes.h's VARENUM structure.
         break ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit::init_off()
{
   /*----------------------------------------------------------------------*/
   CFileInit_off       off( *this )        ;
   IStorage            *pStorage    = NULL ;
   IPropertySetStorage *pPropSetStg = NULL ;
   IPropertyStorage    *pPropStg    = NULL ;
   PROPSPEC            tb_PropSpec[ st_ci_nb_tag_off ] ;
   PROPVARIANT         tb_PropVar [ st_ci_nb_tag_off ] ;
   HRESULT             hres            ;
   bool                boo_reopen_file ;
   int                 i_num           ;

   /*--( With the parameters chosen StgOpenStorage is "exclusive" ... )----*/
   if( ( boo_reopen_file = m_fa.IsOpened() ) )
   {  m_fa.close() ; }

   /*--( It can crash if the file is used )--------------------------------*/
   hres = StgOpenStorage( m_f.get_full_path().wx_str(), NULL,
                          STGM_READ | STGM_SHARE_EXCLUSIVE, NULL, 0,
                          &pStorage
                        ) ;
   if( FAILED( hres ) ) { goto func_end ; }

   /*--( Get the interface )-----------------------------------------------*/
   hres = pStorage->QueryInterface( IID_IPropertySetStorage,
                                    ( void ** )&pPropSetStg
                                  ) ;
   if( FAILED( hres ) ) { wxFAIL ; goto func_end ; }

   /*--( Open the information summary: error if the file is not "office" )-*/
   hres = pPropSetStg->Open( SR_FMTID_SummaryInformation,
                             STGM_READ | STGM_SHARE_EXCLUSIVE, &pPropStg
                           ) ;
   if( FAILED( hres ) ) { goto func_end ; }

   /*--( Initialization of the array of request structures )---------------*/
   ZeroMemory( tb_PropSpec, sizeof( tb_PropSpec ) ) ;
   for( i_num = 0 ; i_num < st_ci_nb_tag_off ; ++i_num )
   {  /*-------------------------------------------------------------------*/
      tb_PropSpec[ i_num ].ulKind = PRSPEC_PROPID ;
      tb_PropSpec[ i_num ].propid = st_tb_tag_off[ i_num ].i_pidsi ;
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
     hres
   = pPropStg->ReadMultiple( st_ci_nb_tag_off, tb_PropSpec, tb_PropVar ) ;
   if( FAILED( hres ) ) { wxFAIL ; goto func_end ; }

   /*--( Then do the assignments )-----------------------------------------*/
   for( i_num = 0 ; i_num < st_ci_nb_tag_off ; ++i_num )
   {  /*-------------------------------------------------------------------*/
      off.read_tag( i_num, tb_PropVar[ i_num ] ) ;
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
   m_f.val_s( COL_BASE_TYPE_DET ) = "office" ;
   /*----------------------------------------------------------------------*/
func_end :
   /*----------------------------------------------------------------------*/
   if( pPropStg    != NULL ) { pPropStg->Release()    ; }
   if( pPropSetStg != NULL ) { pPropSetStg->Release() ; }
   if( pStorage    != NULL ) { pStorage->Release()    ; }
   /*----------------------------------------------------------------------*/
   if( boo_reopen_file )
   {  m_fa.open_to_read( m_f.get_full_path() ) ; }
   /*----------------------------------------------------------------------*/
   return( FAILED( hres ) ? -1 : 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
#endif // __WXMSW__
/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                      End of file CFileInit_off.cpp                        !
+==========================================================================*/
