/*====================================+=====================================+
! File CFileInit_lnk.cpp              ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+---------------------------------------------------------------------------+
!                                                                           !
!                      "Shortcut" file: lnk                                 !
!                                                                           !
!                     ONLY FOR MSW PLATFORM !!                              !
!                                                                           !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#ifdef __WXMSW__
/*-------------------------------------------------------------------------*/
#include <wx/variant.h>
#include <wx/msw/ole/oleutils.h>
#include "common/sr_lib.h"
#include "CFileInit.h"
#include "CFile.h"
#include "common/msw/CShortcut.h"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
int CFileInit::init_lnk()
{
   /*----------------------------------------------------------------------*/
   CShortcut scut  ;
   wxString  s_val ;
   int       i_ret ;

   /*----------------------------------------------------------------------*/
   wxOleInitialize() ;
   /*----------------------------------------------------------------------*/
   scut.init_name( m_f.get_full_path() ) ;
   if( ( i_ret = scut.load() ) != 0 ) { goto func_end ; }

   /*----------------------------------------------------------------------*/
   s_val = scut.get_desc() ;
   if( prepare_string( s_val ) > 0 )
   {  m_f.val_s( COL_DOC_COMMENT ) = s_val ; }
   /*----------------------------------------------------------------------*/
   s_val = scut.get_target() ;
   if( prepare_string( s_val ) > 0 )
   {  m_f.val_s( COL_DOC_APPLICATION ) = s_val ; }

   /*----------------------------------------------------------------------*/
   m_f.val_s( COL_BASE_TYPE_DET ) = "lnk" ;
   /*----------------------------------------------------------------------*/
func_end :
   /*----------------------------------------------------------------------*/
   wxOleUninitialize() ;
   /*----------------------------------------------------------------------*/
   return( i_ret ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
#endif // __WXMSW__
/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                      End of file CFileInit_lnk.cpp                        !
+==========================================================================*/
