/*====================================+=====================================+
! File CFileInit_exe.cpp              ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+---------------------------------------------------------------------------+
!                                                                           !
!           "Executable" MSW file: ".exe", ".dll", ".ocx" ...               !
!        even "fon" font files which contain a "Version" resource           !
!                                                                           !
!                       ONLY FOR MSW PLATFORM !!                            !
!                                                                           !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#ifdef __WXMSW__
/*-------------------------------------------------------------------------*/
#include <wx/wx.h>
#include <windef.h>
#include <winver.h>
#include "common/sr_lib.h"
#include "CFileInit.h"
#include "CFile.h"
/*-------------------------------------------------------------------------*/



/*--------------------------------------------------------------------------+
! Data/Treatment used during the loading                                    !
+--------------------------------------------------------------------------*/
class CFileInit_exe : public CFileInit_type_base
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CFileInit_exe( CFileInit &parent ) : CFileInit_type_base( parent )
      {  ; }
      /*-------------------------------------------------------------------*/
      int read_val( void *p_version, WORD w_lang, WORD w_charset,
                    int i_num_tag_exe
                  ) ;
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
struct str_tag_exe
{
   /*----------------------------------------------------------------------*/
   const char *p_c_name ;
   int         i_col    ;
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
struct str_lang_charset
{
   /*----------------------------------------------------------------------*/
   WORD w_lang    ;
   WORD w_charset ;
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
bool operator == ( const str_lang_charset &lc1, const str_lang_charset &lc2 )
{  return( lc1.w_lang == lc2.w_lang && lc1.w_charset == lc2.w_charset ) ; }

/*--( The values of language/charset that will be checked )----------------*/
static const str_lang_charset st_tb_lang_charset[]
= {
    /*---------------------------------------------------------------------*/
    { 0x0409, 0x04b0 } ,
    { 0x0409, 0x04E4 } ,
    { 0x0409, 0x0000 } ,
    { 0x0009, 0x0000 }
    /*---------------------------------------------------------------------*/
  } ;

/*-------------------------------------------------------------------------*/
static const int st_ci_nb_lang_charset = WXSIZEOF( st_tb_lang_charset ) ;

/*-------------------------------------------------------------------------*/
static const str_tag_exe st_tb_tag_exe[]
= {
    /*---------------------------------------------------------------------*/
    { "FileVersion"      , COL_DOC_VERSION    } ,
    { "FileDescription"  , COL_DOC_SUBJECT    } ,
    { "LegalCopyright"   , COL_DOC_COPYRIGHT  } ,
    { "Comments"         , COL_DOC_COMMENT    } ,
    { "CompanyName"      , COL_DOC_COMPANY    } ,
    { "LegalTrademarks"  , COL_DOC_TRADEMARKS } ,
    { "ProductName"      , COL_DOC_TITLE      } ,
    //{ "ProductVersion"   , COL_DOC_VERSION    } ,
    //{ "InternalName"     , COL_EXE_INTERNALNAME      } ,
    //{ "OriginalFilename" , COL_EXE_ORIGINALFILENAME  } ,
    //{ "PrivateBuild"     , COL_EXE_PRIVATEBUILD      } ,
    //{ "SpecialBuild"     , COL_EXE_SPECIALBUILD      }
    /*---------------------------------------------------------------------*/
  } ;

/*-------------------------------------------------------------------------*/
static const int st_ci_nb_tag_exe = WXSIZEOF( st_tb_tag_exe ) ;

/*-------------------------------------------------------------------------*/
int CFileInit_exe::read_val( void *p_version, WORD w_lang, WORD w_charset,
                             int i_num_tag_exe
                           )
{
   /*----------------------------------------------------------------------*/
   wxString s_var     ;
   wxString s_val     ;
   void     *p_val    ;
   UINT     ui_lg_val ;

   /*----------------------------------------------------------------------*/
   s_var.Printf( "\\StringFileInfo\\%04X%04X\\%s",
                 w_lang, w_charset, st_tb_tag_exe[ i_num_tag_exe ].p_c_name
               ) ;

   /*--( The "variable" may not exist )------------------------------------*/
   if( VerQueryValue( p_version, ( WCHAR * )s_var.wc_str(),
                      &p_val, &ui_lg_val
                    ) == 0
     )
   {  return( -1 ) ; }

   /*--( The length is for UTF16 char ... so it has to be multiplied by 2 )*/
   if(    m_fi.reserve_col( st_tb_tag_exe[ i_num_tag_exe ].i_col )
       && m_fi.prepare_string( ( char * )p_val, ui_lg_val * 2, s_val ) > 0
     )
   {
      /*-------------------------------------------------------------------*/
        m_f.val_s( st_tb_tag_exe[ i_num_tag_exe ].i_col )
      = s_val.Remove( g_co_i_string_sz_max ) ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit::init_exe()
{
   /*----------------------------------------------------------------------*/
   CFileInit_exe    exe( *this )      ;
   DWORD            dw_version_size   ;
   wxMemoryBuffer   mb_buffer_version ;
   str_lang_charset *p_str_lgcs       ;
   str_lang_charset str_lgcs          ;
   UINT             ui_lg_val         ;
   int              i_num_tag         ;
   DWORD            dw_dummy          ;

   /*----------------------------------------------------------------------*/
   set_conv_from_utf16le() ;

   /*--( Info block size: if no info is present then an error occurs )-----*/
     dw_version_size
   = GetFileVersionInfoSize( m_f.get_full_path().wc_str(), &dw_dummy ) ;
   if( dw_version_size == 0 ) { return( -1 ) ; }

   /*--( Read the info block )---------------------------------------------*/
   if( GetFileVersionInfo( m_f.get_full_path().wx_str(), 0,
                           dw_version_size,
                           mb_buffer_version.GetWriteBuf( dw_version_size )
                         ) == 0
     )
   {  wxFAIL ; return( -2 ) ; }
   /*----------------------------------------------------------------------*/
   mb_buffer_version.UngetWriteBuf( dw_version_size ) ;

   /*-----------------------------------------------------------------------+
   ! Extraction of language and country codes. Only the first language      !
   ! block information will be taken into account.                          !
   +------------------------------------------------------------------------+
   ! Based on tests, 2 possibilities:                                       !
   ! - No "Translation"                                                     !
   ! - The "Translation" does not correspond to the language really used    !
   ! The case "no version" is detected at the opening (cf upper)            !
   !                                                                        !
   ! A predefined list of "standard" codes lang/charset enables to          !
   ! determine the "right couple". These tests are done on the first        !
   ! element of the tag array (FileVersion).                                !
   ! Window's explorer "Properties/Version" seems to return nearly the same !
   ! results.                                                               !
   +-----------------------------------------------------------------------*/
   if( VerQueryValue( mb_buffer_version.GetData(),
                      ( WCHAR * )_T( "\\VarFileInfo\\Translation" ),
                      ( LPVOID * )&p_str_lgcs, &ui_lg_val
                    ) != 0
     )
   {  /*--( At least 4 bytes have to be read )-----------------------------*/
      if( ui_lg_val < sizeof( str_lgcs ) ) { wxFAIL ; return( -3 ) ; }
      /*-------------------------------------------------------------------*/
      str_lgcs = *p_str_lgcs ;
      /*-------------------------------------------------------------------*/
   }
   else
   {  /*--( If a problem occurred a default value is used )----------------*/
      str_lgcs = st_tb_lang_charset[ 0 ] ;
      /*-------------------------------------------------------------------*/
   }

   /*--( Test the existence to determine the right couple )----------------*/
   if( exe.read_val( mb_buffer_version.GetData(),
                     str_lgcs.w_lang, str_lgcs.w_charset, 0
                   ) != 0
     )
   {  /*-------------------------------------------------------------------*/
      int i_num_lgcs ;
      /*--( Scan the "planned" couples )-----------------------------------*/
      for( i_num_lgcs = 0 ;
           i_num_lgcs < st_ci_nb_lang_charset
           && (    st_tb_lang_charset[ i_num_lgcs ] == str_lgcs
                || exe.read_val( mb_buffer_version.GetData(),
                                 st_tb_lang_charset[ i_num_lgcs ].w_lang,
                                 st_tb_lang_charset[ i_num_lgcs ].w_charset,
                                 0
                               ) != 0
              ) ;
           ++i_num_lgcs
         )
      {  ; }
      /*-------------------------------------------------------------------*/
      if( i_num_lgcs >= st_ci_nb_lang_charset ) { return( -4 ) ; }
      /*--( Found the one ! )----------------------------------------------*/
      str_lgcs = st_tb_lang_charset[ i_num_lgcs ] ;
      /*-------------------------------------------------------------------*/
   }

   /*--( Extraction of the rest of the values )----------------------------*/
   for( i_num_tag = 1 ; i_num_tag < st_ci_nb_tag_exe ; ++i_num_tag )
   {
      /*-------------------------------------------------------------------*/
      exe.read_val( mb_buffer_version.GetData(),
                    str_lgcs.w_lang, str_lgcs.w_charset, i_num_tag
                 ) ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   m_f.val_s( COL_BASE_TYPE_DET ) = "exe" ;
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
#endif // __WXMSW__
/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                       End of file CFileInit_exe.cpp                       !
+==========================================================================*/
