/*====================================+=====================================+
! File CFileInit_xpi.cpp              ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+---------------------------------------------------------------------------+
!                                                                           !
!                Mozilla extension installation file: ".xpi"                !
!                                                                           !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include <memory>
#include <wx/wfstream.h>
#include <wx/zipstrm.h>
#include <wx/xml/xml.h>
#include "common/sr_lib.h"
#include "CFileInit.h"
#include "CFile.h"
/*-------------------------------------------------------------------------*/



/*--------------------------------------------------------------------------+
! Data/Treatment used during the loading                                    !
+--------------------------------------------------------------------------*/
class CFileInit_xpi : public CFileInit_type_base
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CFileInit_xpi( CFileInit &parent ) : CFileInit_type_base( parent )
      {  ; }
      /*-------------------------------------------------------------------*/
      int xpi_read() ;

   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
static int st_xpi_conv_tag_col( const wxXmlNode *p_node )
{
   /*----------------------------------------------------------------------*/
   wxString s_name( p_node->GetName() ) ;
   /*----------------------------------------------------------------------*/
   if( s_name.CmpNoCase( "em:id" ) == 0 )
   {  return( COL_DOC_ID ) ; }
   if( s_name.CmpNoCase( "em:version" ) == 0 )
   {  return( COL_DOC_VERSION ) ; }
   if(    s_name.CmpNoCase( "em:creator" ) == 0
       || s_name.CmpNoCase( "em:author" ) == 0
     )
   {  return( COL_DOC_AUTHOR ) ; }
   if( s_name.CmpNoCase( "em:name" ) == 0 )
   {  return( COL_DOC_TITLE ) ; }
   if( s_name.CmpNoCase( "em:description" ) == 0 )
   {  return( COL_DOC_INFO ) ; }
   if( s_name.CmpNoCase( "em:homepageURL" ) == 0 )
   {  return( COL_DOC_URL ) ; }
   /*----------------------------------------------------------------------*/
   return( COL_NB ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit_xpi::xpi_read()
{
   /*----------------------------------------------------------------------*/
   wxFileInputStream           finput( m_fa )      ;
   wxZipInputStream            zip_input( finput ) ;
   std::auto_ptr< wxZipEntry > ptr_zip_entry       ;
   wxString                    s_info              ;

   /*----------------------------------------------------------------------*/
   if( !zip_input.IsOk() ) { return( -1 ) ; }
   /*----------------------------------------------------------------------*/
   m_fi.init_doc_zip_info( zip_input ) ;

   /*--( Looking for the file containing the metadata )--------------------*/
   do
   {  ptr_zip_entry.reset( zip_input.GetNextEntry() ) ;
   } while(    ptr_zip_entry.get() != NULL
            && ptr_zip_entry->GetInternalName().CmpNoCase( "install.rdf"
                                                         ) != 0
          ) ;
   /*----------------------------------------------------------------------*/
   if( ptr_zip_entry.get() == NULL ) { return( -2 ) ; }
   /*----------------------------------------------------------------------*/
   m_fi.init_doc_nb_files( zip_input.GetTotalEntries() ) ;

   /*----------------------------------------------------------------------*/
   wxXmlDocument xml_desc( zip_input ) ;
   /*----------------------------------------------------------------------*/
   if( !xml_desc.IsOk() ) { return( -3 ) ; }

   /*----------------------------------------------------------------------*/
   wxXmlNode *xml_node( xml_desc.GetRoot() ) ;

   /*----------------------------------------------------------------------*/
   if(    xml_node->GetName().CmpNoCase( "rdf" ) != 0
       && xml_node->GetName().CmpNoCase( "rdf:rdf" ) != 0
     )
   {  return( -4 ) ; }

   /*--( Looking for the description block )-------------------------------*/
   for( xml_node = xml_node->GetChildren() ;
           xml_node != NULL
        && xml_node->GetName().CmpNoCase( "description" ) != 0
        && xml_node->GetName().CmpNoCase( "rdf:description" ) != 0 ;
        xml_node = xml_node->GetNext()
      )
   {  ; }
   /*----------------------------------------------------------------------*/
   if( xml_node == NULL ) { return( -5 ) ; }

   /*--( Now, the tags )---------------------------------------------------*/
   for( xml_node = xml_node->GetChildren() ;
        xml_node != NULL ;
        xml_node = xml_node->GetNext()
      )
   {
      /*--( Compatibility with host program )------------------------------*/
      if( xml_node->GetName().CmpNoCase( "em:targetApplication" ) == 0 )
      {
         /*----------------------------------------------------------------*/
         wxXmlNode *xml_comp ;
         /*----------------------------------------------------------------*/
         for( xml_comp = xml_node->GetChildren() ;
                 xml_comp != NULL
              && xml_comp->GetName().CmpNoCase( "description" ) != 0 ;
              xml_comp = xml_comp->GetNext()
            )
         {  ; }
         /*----------------------------------------------------------------*/
         if( xml_comp != NULL )
         {
            /*-------------------------------------------------------------*/
            wxString s_app_id ;
            wxString s_app    ;
            wxString s_min    ;
            wxString s_max    ;
            /*-------------------------------------------------------------*/
            for( xml_comp = xml_comp->GetChildren() ;
                 xml_comp != NULL ;
                 xml_comp = xml_comp->GetNext()
               )
            {  /*----------------------------------------------------------*/
               if( xml_comp->GetName().CmpNoCase( "em:id" ) == 0 )
               {  s_app_id = xml_comp->GetNodeContent().Lower() ; }
               else
               if( xml_comp->GetName().CmpNoCase( "em:minVersion" ) == 0 )
               {  s_min = xml_comp->GetNodeContent() ;
                  m_fi.prepare_string( s_min ) ;
               }
               else
               if( xml_comp->GetName().CmpNoCase( "em:maxVersion" ) == 0 )
               {  s_max = xml_comp->GetNodeContent() ;
                  m_fi.prepare_string( s_max ) ;
               }
               /*----------------------------------------------------------*/
            }
            /*--( "id" has been set lower-case )---------------------------*/
            if( s_app_id == "{ec8030f7-c20a-464f-9b0e-13a3a9e97384}" )
            {  s_app = "Firefox" ; }
            else
            if( s_app_id == "{86c18b42-e466-45a9-ae7a-9b95ba6f5640}" )
            {  s_app = "Mozilla" ; }
            else
            if( s_app_id == "{3550f703-e582-4d05-9a08-453d09bdfdc6}" )
            {  s_app = "Thunderbird" ; }
            else
            if( s_app_id == "{92650c4d-4b8e-4d2a-b7eb-24ecf4f6b63a}" )
            {  s_app = "Seamonkey" ; }
            else
            if( s_app_id == "{a79fe89b-6662-4ff4-8e88-09950ad4dfde}" )
            {  s_app = "Conqueror" ; }
            else
            if( s_app_id == "{a23983c0-fd0e-11dc-95ff-0800200c9a66}" )
            {  s_app = "Fennec" ; }
            else
            if( s_app_id == "{a463f10c-3994-11da-9945-000d60ca027b}" )
            {  s_app = "Flock" ; }
            else
            if( s_app_id == "{aa5ca914-c309-495d-91cf-3141bbb04115}" )
            {  s_app = "MidBrowser" ; }
            else
            {  s_app = s_app_id ; }
            /*-------------------------------------------------------------*/
            if( !s_info.empty() )
            {  s_info += ", " ; }
            /*-------------------------------------------------------------*/
            s_info += s_app + ": " + s_min + " to " + s_max ;
            /*-------------------------------------------------------------*/
         }
         /*----------------------------------------------------------------*/
      }
      else
      {
         /*----------------------------------------------------------------*/
         int i_col = st_xpi_conv_tag_col( xml_node ) ;
         /*----------------------------------------------------------------*/
         if( m_fi.reserve_col( i_col ) )
         {  /*-------------------------------------------------------------*/
            wxString s_val( xml_node->GetNodeContent() ) ;
            /*-------------------------------------------------------------*/
            if( m_fi.prepare_string( s_val ) > 0 )
            {  m_f.val_s( i_col ) = s_val ; }
            /*-------------------------------------------------------------*/
         }
         /*----------------------------------------------------------------*/
      }
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   if( !s_info.empty() )
   {  m_f.val_s( COL_DOC_APPLICATION ) = s_info ; }

   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit::init_xpi()
{
   /*----------------------------------------------------------------------*/
   m_s_type_det = "xpi" ;
   /*----------------------------------------------------------------------*/
   return( CFileInit_xpi( *this ).xpi_read() ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                      End of file CFileInit_xpi.cpp                        !
+==========================================================================*/
