/*====================================+=====================================+
! File CFileInit_webp.cpp             ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+---------------------------------------------------------------------------+
!                                                                           !
!                       Image file: ".webp"                                 !
!                                                                           !
+-------+-------------------------------------------------------------------+
! Notes !                                                                   !
+-------+                                                                   !
! Even if they are not really EXIF, the metadata are stored in this group   !
!                                                                           !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include "common/sr_lib.h"
#include "CFileInit.h"
#include "CFile.h"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
struct str_webp_header_vp8 ;

/*--------------------------------------------------------------------------+
! Data/Treatment used during the loading                                    !
+--------------------------------------------------------------------------*/
class CFileInit_webp : public CFileInit_type_base
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CFileInit_webp( CFileInit &parent ) : CFileInit_type_base( parent )
      {  ; }
      /*-------------------------------------------------------------------*/
      int read_le_data( str_webp_header_vp8 &vp8 ) ;
      int read_vp8_info( const str_chunk &chunk ) ;
      int read_one_info( const str_chunk &chunk ) ;
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
#pragma pack( push, 1 )

/*-------------------------------------------------------------------------*/
struct str_webp_header_vp8
{
   /*----------------------------------------------------------------------*/
   wxUint8  tb_b_frame_tag [ 3 ] ;
   wxUint8  tb_b_start_code[ 3 ] ;
   wxUint16 w_width              ;
   wxUint16 w_height             ;
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
#pragma pack( pop )

/*-------------------------------------------------------------------------*/
int CFileInit_webp::read_le_data( str_webp_header_vp8 &vp8 )
{
   /*----------------------------------------------------------------------*/
   if( m_fa.read_buffer( sizeof( vp8 ), &vp8 ) != 0 )
   {  return( -1 ) ; }
   /*----------------------------------------------------------------------*/
#if wxBYTE_ORDER == wxBIG_ENDIAN
   vp8.w_width  = wxUINT32_SWAP_ALWAYS( vp8.w_width  ) ;
   vp8.w_height = wxUINT32_SWAP_ALWAYS( vp8.w_height ) ;
#endif
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
static int st_webp_conv_tag_col( wxUint32 dw_tag )
{
   /*----------------------------------------------------------------------*/
   switch( dw_tag )
   {
      /*-------------------------------------------------------------------*/
      case SR_FOURCC( 'I','C','M','T' ): return( COL_EXIF_USERCOMMENT ) ;
      case SR_FOURCC( 'I','C','O','P' ): return( COL_EXIF_COPYRIGHT ) ;
      case SR_FOURCC( 'I','A','R','T' ): return( COL_EXIF_ARTIST ) ;
      case SR_FOURCC( 'I','N','A','M' ): return( COL_EXIF_IMAGEDESCRIPTION );
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   return( COL_NB ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit_webp::read_vp8_info( const str_chunk &chunk )
{
   /*----------------------------------------------------------------------*/
   str_webp_header_vp8 header ;

   /*--( Minimal size needed )---------------------------------------------*/
   if( chunk.dw_size < sizeof( header ) )
   {  return( -1 ) ; }
   /*----------------------------------------------------------------------*/
   if( read_le_data( header ) != 0 )
   {  return( -2 ) ; }

   /*--( Start code constant )---------------------------------------------*/
   if(    header.tb_b_start_code[ 0 ] != 0x9D
       || header.tb_b_start_code[ 1 ] != 0x01
       || header.tb_b_start_code[ 2 ] != 0x2A
     )
   {  return( -3 ) ; }

   /*----------------------------------------------------------------------*/
   m_fi.init_img_x_y( header.w_width, header.w_height ) ;

   /*--( Skip the image data to maybe read text data (tag) )---------------*/
   if( m_fa.skip_nb_byte( chunk.dw_size - sizeof( header ) ) != 0 )
   {  return( -4 ) ; }

   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit_webp::read_one_info( const str_chunk &chunk )
{
   /*----------------------------------------------------------------------*/
   int i_col ;
   /*----------------------------------------------------------------------*/
   i_col = st_webp_conv_tag_col( chunk.dw_id ) ;

   /*--( Unknown or already extracted ? Skip it ! )------------------------*/
   if( m_fi.reserve_col( i_col ) )
   {  /*-------------------------------------------------------------------*/
      wxString s_val ;
      /*-------------------------------------------------------------------*/
      if( m_fi.file_read_tb_c( chunk.dw_size, s_val ) == 0 && !s_val.empty())
      {  m_f.val_s( i_col ) = s_val ; }
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*--------------------------------------------------------------------------+
! Not all parameters are used to have a "coherent" prototype for all image  !
! extract information functions.                                            !
! Maybe one day to call them through a function pointer.                    !
+--------------------------------------------------------------------------*/
int CFileInit::webp_read( wxFileOffset WXUNUSED( fo_image_offset ),
                          wxULongLong WXUNUSED( ull_image_size )
                        )
{
   /*----------------------------------------------------------------------*/
   CFileInit_webp  webp( *this ) ;
   str_riff_header header        ;
   str_chunk       chunk         ;

   /*--( First, the header )-----------------------------------------------*/
   if( m_fa.read_le_data( header ) != 0 )
   {  return( -1 ) ; }

   /*--( It has to begin with ... )----------------------------------------*/
   if( header.dw_id != SR_FOURCC( 'W','E','B','P' ) )
   {  return( -2 ) ; }

   /*--( Then must come the VP8 chunk )------------------------------------*/
   if(    m_fa.read_le_data( chunk ) != 0
       || chunk.dw_id != SR_FOURCC( 'V','P','8',' ' )
     )
   {  return( -3 ) ; }
   /*----------------------------------------------------------------------*/
   if( webp.read_vp8_info( chunk ) != 0 )
   {  return( -4 ) ; }

   /*--( Then maybe some text infos chunks )-------------------------------*/
   while( m_fa.read_le_data( chunk ) == 0 )
   {
      /*-------------------------------------------------------------------*/
      if( webp.read_one_info( chunk ) != 0 )
      {  return( -5 ) ; }
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit::init_webp()
{
   /*----------------------------------------------------------------------*/
   int i_ret ;
   /*----------------------------------------------------------------------*/
   m_s_type_det = "webp" ;
   /*----------------------------------------------------------------------*/
   if( ( i_ret = webp_read( 0, m_f.get_size() ) ) == 0 )
   {  m_f.set_image_offset( 0 ) ; }
   /*----------------------------------------------------------------------*/
   return( i_ret ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                      End of file CFileInit_webp.cpp                       !
+==========================================================================*/
