/*====================================+=====================================+
! File CFileInit_url.cpp              ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+---------------------------------------------------------------------------+
!                                                                           !
!         "URL" files: Associated to IE Favourites under Windows            !
!                                                                           !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include <wx/fileconf.h>
#include "common/sr_lib.h"
#include "CFileInit.h"
#include "CFile.h"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
int CFileInit::init_url()
{
   /*----------------------------------------------------------------------*/
   m_s_type_det = "url" ;

   /*-----------------------------------------------------------------------+
   ! These files have to be not to big.                                     !
   ! Note: Windows seems to analyse a file if it is renamed to ".url"       !
   +-----------------------------------------------------------------------*/
   if( m_f.get_size() > 50 * 1024 )
   {  return( -1 ) ; }

   /*--( URL file syntax is like the ".ini" ones (config file) )-----------*/
   wxFileConfig url_conf( wxEmptyString, wxEmptyString, m_f.get_full_path(),
                          wxEmptyString,
                            wxCONFIG_USE_LOCAL_FILE
                          | wxCONFIG_USE_RELATIVE_PATH
                          | wxCONFIG_USE_NO_ESCAPE_CHARACTERS
                        ) ;

   /*----------------------------------------------------------------------*/
   wxString s_val ;
   if( !url_conf.Read( "/InternetShortcut/URL", &s_val ) )
   {  return( -2 ) ; }

   /*----------------------------------------------------------------------*/
   if( prepare_string( s_val ) > 0 )
   {  m_f.val_s( COL_DOC_URL ) = s_val ; }
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                      End of file CFileInit_url.cpp                        !
+==========================================================================*/
