/*====================================+=====================================+
! File CFileInit_svg.cpp              ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+---------------------------------------------------------------------------+
!                                                                           !
!                  Scalable Vector Graphics: ".svg"                         !
!                                                                           !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include <memory>
#include <wx/wfstream.h>
#include <wx/zstream.h>
#include <wx/xml/xml.h>
#include <wx/numformatter.h>
#include "common/sr_lib.h"
#include "CFileInit.h"
#include "CFile.h"
/*-------------------------------------------------------------------------*/



/*--------------------------------------------------------------------------+
! Data/Treatment used during the loading                                    !
+--------------------------------------------------------------------------*/
class CFileInit_svg : public CFileInit_type_base
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CFileInit_svg( CFileInit &parent ) : CFileInit_type_base( parent )
      {  ; }
      /*-------------------------------------------------------------------*/
      bool svg_str_to_pixel( const wxString &s, double &do_val ) ;
      int  svg_read( wxXmlDocument &xml_cont ) ;

   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
bool CFileInit_svg::svg_str_to_pixel( const wxString &s, double &do_val )
{
   /*--( "Pure" number: no unit )------------------------------------------*/
   if( s.ToCDouble( &do_val ) ) { return( true ) ; }

   /*----------------------------------------------------------------------*/
   wxString s_val( s ) ;
   /*----------------------------------------------------------------------*/
   s_val.Trim() ;

   /*--( A unit can be specified at the end. It is two characters long )---*/
   if( s_val.size() <= 2 ) { return( false ) ; }

   /*--( Absolute value extraction. The decimal separator is always a "." )*/
   if( !s_val.Left( s_val.size() - 2 ).ToCDouble( &do_val ) )
   {  return( false ) ; }

   /*--( Extract the unit )------------------------------------------------*/
   s_val.Remove( 0, s_val.size() - 2 ) ;

   /*-----------------------------------------------------------------------+
   ! Convert absolute value to pixels based on unit and that current        !
   ! DPI is 90.                                                             !
   ! http://www.w3.org/TR/SVG/coords.html#Units                             !
   +-----------------------------------------------------------------------*/
   if( s_val == "px" ) { ; }
   else if( s_val == "pt" ) { do_val *= 1.25 ; }
   else if( s_val == "pc" ) { do_val *= 15 ; }
   else if( s_val == "mm" ) { do_val *= 3.543307 ; }
   else if( s_val == "cm" ) { do_val *= 35.43307 ; }
   else if( s_val == "in" ) { do_val *= 90 ; }
   else /*--( Unknown unit ... )-------------------------------------------*/
   {  return( false ) ; }

   /*--( Value ok ! )------------------------------------------------------*/
   return( true ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit_svg::svg_read( wxXmlDocument &xml_cont )
{
   /*----------------------------------------------------------------------*/
   wxString s_val     ;
   double   do_width  ;
   double   do_height ;

   /*----------------------------------------------------------------------*/
   if( !xml_cont.IsOk() ) { return( -1 ) ; }

   /*----------------------------------------------------------------------*/
   wxXmlNode *xml_node( xml_cont.GetRoot() ) ;
   /*----------------------------------------------------------------------*/
   if( xml_node->GetName().CmpNoCase( "svg" ) != 0 )
   {  return( -2 ) ; }

   /*--( Try to get width and height )-------------------------------------*/
   if(    !xml_node->GetAttribute( "width", &s_val )
       || !svg_str_to_pixel( s_val, do_width )
     )
   {  do_width = -1 ; }
   /*----------------------------------------------------------------------*/
   if(    !xml_node->GetAttribute( "height", &s_val )
       || !svg_str_to_pixel( s_val, do_height )
     )
   {  do_height = -1 ; }

   /*----------------------------------------------------------------------*/
   if( do_width > 0 && do_height > 0 )
   {  m_fi.init_img_x_y( sr::round_0( do_width ),
                         sr::round_0( do_height )
                       ) ;
   }

   /*----------------------------------------------------------------------*/
   for( xml_node = xml_node->GetChildren() ;
        xml_node != NULL ;
        xml_node = xml_node->GetNext()
      )
   {
      /*-------------------------------------------------------------------*/
      if( xml_node->GetName().CmpNoCase( "title" ) == 0 )
      {
         /*----------------------------------------------------------------*/
         if(    m_fi.reserve_col( COL_EXIF_IMAGEDESCRIPTION )
             && !( s_val = xml_node->GetNodeContent() ).empty()
             && m_fi.prepare_string( s_val ) > 0
           )
         {  m_f.val_s( COL_EXIF_IMAGEDESCRIPTION ) = s_val ; }
         /*----------------------------------------------------------------*/
      }
      else
      if( xml_node->GetName().CmpNoCase( "desc" ) == 0 )
      {
         /*----------------------------------------------------------------*/
         if(    m_fi.reserve_col( COL_EXIF_USERCOMMENT )
             && !( s_val = xml_node->GetNodeContent() ).empty()
             && m_fi.prepare_string( s_val ) > 0
           )
         {  m_f.val_s( COL_EXIF_USERCOMMENT ) = s_val ; }
         /*----------------------------------------------------------------*/
      }
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*--( Plain text file )----------------------------------------------------*/
int CFileInit::init_svg()
{
   /*----------------------------------------------------------------------*/
   wxFileInputStream finput( m_fa )     ;
   wxXmlDocument     xml_cont( finput ) ;
   /*----------------------------------------------------------------------*/
   m_s_type_det = "svg" ;
   /*----------------------------------------------------------------------*/
   return( CFileInit_svg( *this ).svg_read( xml_cont ) ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                      End of file CFileInit_svg.cpp                        !
+==========================================================================*/
