/*====================================+=====================================+
! File CFileInit_rpm.cpp              ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+---------------------------------------------------------------------------+
!                                                                           !
!                      RPM packages: ".rpm"                                 !
!                                                                           !
+-------+-------------------------------------------------------------------+
! Notes !                                                                   !
+-------+                                                                   !
! Only a very limited data extraction is done here ...                      !
!                                                                           !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include "common/sr_lib.h"
#include "CFileInit.h"
#include "CFile.h"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
struct str_rpm_lead ;

/*--------------------------------------------------------------------------+
! Data/Treatment used during the loading                                    !
+--------------------------------------------------------------------------*/
class CFileInit_rpm : public CFileInit_type_base
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CFileInit_rpm( CFileInit &parent ) : CFileInit_type_base( parent )
      {  ; }

      /*-------------------------------------------------------------------*/
      int read_be_data( str_rpm_lead &rpm ) ;
      int rpm_read() ;

   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
#pragma pack( push, 1 )
/*-------------------------------------------------------------------------*/
struct str_rpm_lead
{
   /*----------------------------------------------------------------------*/
   wxUint32 dw_magic               ;
   wxUint8  ___b_major             ;
   wxUint8  ___b_minor             ;
   wxUint16 w_type                 ;
   wxUint16 ___w_archnum           ;
   char     tb_c_name[ 66 ]        ;
   wxUint16 ___w_osnum             ;
   wxUint16 ___w_signature_type    ;
   // cppcheck-suppress unusedStructMember
   char     ___tb_c_reserved[ 16 ] ;
   /*----------------------------------------------------------------------*/
} ;
/*-------------------------------------------------------------------------*/
#pragma pack( pop )

/*-------------------------------------------------------------------------*/
int CFileInit_rpm::read_be_data( str_rpm_lead &rpm )
{
   /*----------------------------------------------------------------------*/
   if( m_fa.read_buffer( sizeof( rpm ), &rpm ) != 0 )
   {  return( -1 ) ; }
   /*----------------------------------------------------------------------*/
#if wxBYTE_ORDER == wxLITTLE_ENDIAN
   rpm.w_type = wxUINT16_SWAP_ALWAYS( rpm.w_type ) ;
#endif
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit_rpm::rpm_read()
{
   /*----------------------------------------------------------------------*/
   str_rpm_lead header ;
   wxString     s_name ;

   /*----------------------------------------------------------------------*/
   if( read_be_data( header ) != 0 ) { return( -1 ) ; }

   /*----------------------------------------------------------------------*/
   if( header.dw_magic != SR_FOURCC( 0xed,0xab,0xee,0xdb ) )
   {  return( -2 ) ; }

   /*----------------------------------------------------------------------*/
   if( header.w_type <= 1 )
   {    m_f.val_s( COL_DOC_SUBJECT )
      = ( header.w_type == 0 ) ? "binary" : "source" ;
   }

   /*----------------------------------------------------------------------*/
   SR_SET_LAST_0( header.tb_c_name ) ;
   if(    header.tb_c_name[ 0 ] != '\0'
       && m_fi.prepare_string( &header.tb_c_name[ 0 ],
                               sizeof( header.tb_c_name ) - 1, s_name
                             ) > 0
     )
   {  m_f.val_s( COL_DOC_APPLICATION ) = s_name ; }

   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit::init_rpm()
{
   /*----------------------------------------------------------------------*/
   m_s_type_det = "rpm" ;
   /*----------------------------------------------------------------------*/
   return( CFileInit_rpm( *this ).rpm_read() ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                      End of file CFileInit_rpm.cpp                        !
+==========================================================================*/
