/*====================================+=====================================+
! File CFileInit_raf.cpp              ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+---------------------------------------------------------------------------+
!                                                                           !
!                     Image files ".raf": Fuji RAW                          !
!                                                                           !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include "common/sr_lib.h"
#include "CFileInit.h"
#include "CFile.h"
/*-------------------------------------------------------------------------*/



/*--------------------------------------------------------------------------+
! Data/Treatment used during the loading                                    !
+--------------------------------------------------------------------------*/
class CFileInit_raf : public CFileInit_type_base
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CFileInit_raf( CFileInit &parent ) : CFileInit_type_base( parent )
      {  ; }
      /*-------------------------------------------------------------------*/
      int raf_read() ;
   /*----------------------------------------------------------------------*/
} ;



/*-------------------------------------------------------------------------*/
typedef char t_raf_signature[ 8 ] ;
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
int CFileInit_raf::raf_read()
{
   /*----------------------------------------------------------------------*/
   t_raf_signature header    ;
   wxUint32        dw_offset ;

   /*----------------------------------------------------------------------*/
   if( m_fa.read_buffer( sizeof( header ), header ) != 0 )
   {  return( -1 ) ; }

   /*----------------------------------------------------------------------*/
   if( memcmp( header, "FUJIFILM", sizeof( header ) ) != 0 )
   {  return( -2 ) ; }

   /*--( The "tif" start is at an indirect address )-----------------------*/
   if(    m_fa.set_offset( 84 ) != 0
       || m_fa.read_be_data( dw_offset ) != 0
     )
   {  return( -3 ) ; }

   /*----------------------------------------------------------------------*/
   dw_offset += 12 ;

   /*----------------------------------------------------------------------*/
   return( m_fi.tiff_read_tiff( dw_offset, m_f.get_size() - dw_offset ) ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit::init_raf()
{
   /*----------------------------------------------------------------------*/
   m_s_type_det = "raf" ;
   /*----------------------------------------------------------------------*/
   return( CFileInit_raf( *this ).raf_read() ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                      End of file CFileInit_raf.cpp                        !
+==========================================================================*/
