/*====================================+=====================================+
! File CFileInit_png.cpp              ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+---------------------------------------------------------------------------+
!                                                                           !
!                         Image files ".png"                                !
!                                                                           !
+-------+-------------------------------------------------------------------+
! Notes !                                                                   !
+-------+                                                                   !
! Even if they are not really EXIF, the metadata are stored in this group   !
!                                                                           !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include "common/sr_lib.h"
#include "CFileInit.h"
#include "CFile.h"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
struct str_png_ihdr ;

/*--------------------------------------------------------------------------+
! Data/Treatment used during the loading                                    !
+--------------------------------------------------------------------------*/
class CFileInit_png : public CFileInit_type_base
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CFileInit_png( CFileInit &parent ) : CFileInit_type_base( parent )
      {  ; }
      /*-------------------------------------------------------------------*/
      int read_be_data( str_png_ihdr &pih ) ;
      int png_read( wxFileOffset WXUNUSED( fo_image_offset ),
                    wxULongLong WXUNUSED( ull_image_size )
                  ) ;

   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
#pragma pack( push, 1 )

/*-------------------------------------------------------------------------*/
struct str_png_ihdr
{
   /*----------------------------------------------------------------------*/
   wxUint32 dw_width                ;
   wxUint32 dw_height               ;
   wxUint8  b_bit_depth             ;
   wxUint8  b_color_type            ;
   wxUint8  ___b_compression_method ;
   wxUint8  ___b_filter_method      ;
   wxUint8  ___b_interlace_method   ;
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
#pragma pack( pop )

/*-------------------------------------------------------------------------*/
int CFileInit_png::read_be_data( str_png_ihdr &pih )
{
   /*----------------------------------------------------------------------*/
   if( m_fa.read_buffer( sizeof( pih ), &pih ) != 0 )
   {  return( -1 ) ; }
   /*----------------------------------------------------------------------*/
#if wxBYTE_ORDER == wxLITTLE_ENDIAN
   pih.dw_width  = wxUINT32_SWAP_ALWAYS( pih.dw_width  ) ;
   pih.dw_height = wxUINT32_SWAP_ALWAYS( pih.dw_height ) ;
#endif
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
static int st_png_conv_tag_col( const wxString &s_var )
{
   /*----------------------------------------------------------------------*/
   if( s_var.CmpNoCase( "Title" ) == 0 )
   {  return( COL_EXIF_IMAGEDESCRIPTION ) ; }
   /*----------------------------------------------------------------------*/
   if( s_var.CmpNoCase( "Software" ) == 0 )
   {  return( COL_EXIF_SOFTWARE ) ; }
   /*----------------------------------------------------------------------*/
   if( s_var.CmpNoCase( "Source" ) == 0 )
   {  return( COL_EXIF_FILESOURCE ) ; }
   /*----------------------------------------------------------------------*/
   if( s_var.CmpNoCase( "Author" ) == 0 )
   {  return( COL_EXIF_ARTIST ) ; }
   /*----------------------------------------------------------------------*/
   if( s_var.CmpNoCase( "Copyright" ) == 0 )
   {  return( COL_EXIF_COPYRIGHT ) ; }
   /*----------------------------------------------------------------------*/
   if( s_var.CmpNoCase( "Comment" ) == 0 )
   {  return( COL_EXIF_USERCOMMENT ) ; }
   /*----------------------------------------------------------------------*/
   return( COL_NB ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
typedef wxUint8 t_png_signature[ 8 ] ;
/*-------------------------------------------------------------------------*/
static const t_png_signature st_png_signature
  = { 0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a } ;
/*--( Declare it in an array to have the number of chars )-----------------*/
static const wxUint8 st_tb_b_tag_software[] = "Software" ;
/*-------------------------------------------------------------------------*/



/*--------------------------------------------------------------------------+
! Not all parameters are used to have a "coherent" prototype for all image  !
! extract information functions.                                            !
! Maybe one day to call them through a function pointer.                    !
+--------------------------------------------------------------------------*/
int CFileInit_png::png_read( wxFileOffset WXUNUSED( fo_image_offset ),
                             wxULongLong WXUNUSED( ull_image_size )
                           )
{
   /*----------------------------------------------------------------------*/
   t_png_signature header          ;
   str_atom        atom            ;
   str_png_ihdr    ihdr            ;
   int             i_bpp           ;
   bool            boo_end         ;
   size_t          sz_size_to_read ;
   size_t          sz_size_to_skip ;

   /*----------------------------------------------------------------------*/
   if( m_fa.read_buffer( sizeof( header ), header ) != 0 )
   {  return( -1 ) ; }

   /*----------------------------------------------------------------------*/
   if( memcmp( header, st_png_signature, sizeof( header ) ) != 0 )
   {  return( -2 ) ; }

   /*----------------------------------------------------------------------*/
   if( m_fa.read_be_data( atom ) != 0 )
   {  return( -3 ) ; }

   /*----------------------------------------------------------------------*/
   if(    atom.dw_id != SR_FOURCC( 'I', 'H', 'D', 'R' )
       || atom.dw_size < sizeof( ihdr )
     )
   {  return( -4 ) ; }

   /*----------------------------------------------------------------------*/
   if( read_be_data( ihdr ) != 0 )
   {  return( -5 ) ; }

   /*--( Image size )------------------------------------------------------*/
   m_fi.init_img_x_y( ihdr.dw_width, ihdr.dw_height ) ;

   /*--( Bits per pixel )--------------------------------------------------*/
   i_bpp = ihdr.b_bit_depth ;

   /*--( RGB )-------------------------------------------------------------*/
   switch( ihdr.b_color_type )
   {  /*-------------------------------------------------------------------*/
      case 2 : i_bpp *= 3 ; break ;
      case 6 : i_bpp *= 4 ; break ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   m_fi.init_img_bpp( i_bpp ) ;

   /*----------------------------------------------------------------------*/
   boo_end = false ;
   /*----------------------------------------------------------------------*/
   do
   {
      /*--( Jump over the CRC )--------------------------------------------*/
      if(    m_fa.skip_nb_byte( sizeof( wxUint32 ) ) != 0
          || m_fa.read_be_data( atom ) != 0
        )
      {  return( -6 ) ; }
      /*-------------------------------------------------------------------*/
      sz_size_to_skip = atom.dw_size ;
      /*-------------------------------------------------------------------*/
      switch( atom.dw_id )
      {
         /*--( Last one ? )------------------------------------------------*/
         case SR_FOURCC( 'I', 'E', 'N', 'D' ) :
            boo_end = true ;
            break ;
         /*--( Is it a tag ? )---------------------------------------------*/
         case SR_FOURCC( 't', 'E', 'X', 't' ) :
         {
            /*-------------------------------------------------------------*/
            char     tb_c_val[ 80 + 1 + g_co_i_string_sz_max ] ;
            wxString s_var       ;
            wxString s_val       ;
            int      i_col       ;
            char     *p_c_val    ;
            size_t   sz_size_val ;

            /*--------------------------------------------------------------+
            ! The string must contain the final '\0', like the array does   !
            +--------------------------------------------------------------*/
            if(    sz_size_to_skip != 0
                && sz_size_to_skip >= sizeof( tb_c_val )
              )
            {  break ; }
            /*-------------------------------------------------------------*/
            sz_size_to_read = wxMin( sz_size_to_skip, sizeof( tb_c_val ) ) ;
            /*-------------------------------------------------------------*/
            if( m_fa.read_buffer( sz_size_to_read, tb_c_val ) != 0 )
            {  return( -7 ) ; }
            /*-------------------------------------------------------------*/
            sz_size_to_skip -= sz_size_to_read ;
            SR_SET_LAST_0( tb_c_val ) ;

            /*--( Tag name )-----------------------------------------------*/
            s_var.assign( &tb_c_val[ 0 ] ) ;
            i_col = st_png_conv_tag_col( s_var ) ;
            /*-------------------------------------------------------------*/
            if( !m_fi.reserve_col( i_col ) )
            {  break ; }

            /*--( Value )--------------------------------------------------*/
            p_c_val     = tb_c_val + s_var.size() + 1 ;
            sz_size_val = sz_size_to_read - s_var.size() - 1 ;
            /*-------------------------------------------------------------*/
            if( m_fi.prepare_string( p_c_val, sz_size_val, s_val ) > 0 )
            {  m_f.val_s( i_col ) = s_val ; }
            /*-------------------------------------------------------------*/
            boo_end = true ;
            /*-------------------------------------------------------------*/
            break ;
            /*-------------------------------------------------------------*/
         }
         /*----------------------------------------------------------------*/
      }
      /*-------------------------------------------------------------------*/
      if( sz_size_to_skip != 0 && m_fa.skip_nb_byte( sz_size_to_skip ) != 0 )
      {  return( -8 ) ; }
      /*-------------------------------------------------------------------*/
   } while( !boo_end ) ;

   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit::init_png()
{
   /*----------------------------------------------------------------------*/
   int i_ret ;
   /*----------------------------------------------------------------------*/
   m_s_type_det = "png" ;
   /*----------------------------------------------------------------------*/
   if( ( i_ret = png_read( 0, m_f.get_size() ) ) == 0 )
   {  m_f.set_image_offset( 0 ) ; }
   /*----------------------------------------------------------------------*/
   return( i_ret ) ;
   /*----------------------------------------------------------------------*/
}

/*--------------------------------------------------------------------------+
!                                                                           !
! This function is directly used by other init modules ...                  !
!                                                                           !
+--------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------*/
int CFileInit::png_read( wxFileOffset fo_offset, wxULongLong ull_size )
{  return( CFileInit_png( *this ).png_read( fo_offset, ull_size ) ) ; }

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                        End of file CFileInit_png.cpp                      !
+==========================================================================*/
