/*====================================+=====================================+
! File CFileInit_odf.cpp              ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+---------------------------------------------------------------------------+
!                                                                           !
!          Open Document Format: ".odt", ".ods", ".odp", ".ott"             !
!                                                                           !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include <memory>
#include <wx/wfstream.h>
#include <wx/zipstrm.h>
#include <wx/xml/xml.h>
#include "common/sr_lib.h"
#include "CFileInit.h"
#include "CFile.h"
/*-------------------------------------------------------------------------*/



/*--------------------------------------------------------------------------+
! Data/Treatment used during the loading                                    !
+--------------------------------------------------------------------------*/
class CFileInit_odf : public CFileInit_type_base
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CFileInit_odf( CFileInit &parent ) : CFileInit_type_base( parent )
      {  ; }

      /*-------------------------------------------------------------------*/
      void read_doc_stats( const wxXmlNode *p_node ) ;
      int  odf_read() ;
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
static int st_odf_conv_tag_col( const wxXmlNode *p_node )
{
   /*----------------------------------------------------------------------*/
   wxString s_name( p_node->GetName() ) ;
   /*----------------------------------------------------------------------*/
   if( s_name.CmpNoCase( "dc:title" ) == 0 )
   {  return( COL_DOC_TITLE ) ; }
   if( s_name.CmpNoCase( "dc:subject" ) == 0 )
   {  return( COL_DOC_SUBJECT ) ; }
   if( s_name.CmpNoCase( "dc:description" ) == 0 )
   {  return( COL_DOC_COMMENT ) ; }
   if( s_name.CmpNoCase( "dc:creator" ) == 0 )
   {  return( COL_DOC_AUTHOR ) ; }
   if( s_name.CmpNoCase( "meta:generator" ) == 0 )
   {  return( COL_DOC_APPLICATION ) ; }
   if( s_name.CmpNoCase( "meta:creation-date" ) == 0 )
   {  return( COL_DOC_CRE_DATE ) ; }
   if( s_name.CmpNoCase( "dc:date" ) == 0 )
   {  return( COL_DOC_MOD_DATE ) ; }
   if( s_name.CmpNoCase( "dc:language" ) == 0 )
   {  return( COL_DOC_VERSION ) ; }
   if( s_name.CmpNoCase( "meta:keyword" ) == 0 )
   {  return( COL_DOC_KEYWORDS ) ; }
   /*----------------------------------------------------------------------*/
   if( s_name.CmpNoCase( "meta:user-defined" ) == 0 )
   {
      /*-------------------------------------------------------------------*/
      if( p_node->GetAttribute( "meta:name" ).CmpNoCase( "Version" ) == 0 )
      {  return( COL_DOC_VERSION ) ; }
      /*-------------------------------------------------------------------*/
      if( p_node->GetAttribute( "meta:name" ).CmpNoCase( "Department" ) == 0)
      {  return( COL_DOC_COMPANY ) ; }
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   return( COL_NB ) ;
   /*----------------------------------------------------------------------*/
}

/*--------------------------------------------------------------------------+
! Document statistics are stored as attributes. So they have to be treated  !
! separately                                                                !
+--------------------------------------------------------------------------*/
void CFileInit_odf::read_doc_stats( const wxXmlNode *p_node )
{
   /*--( Couples Attribute Name / Column )---------------------------------*/
   static const char *st_tb_co_p_c_name[]
   = { "meta:page-count", "meta:word-count", "meta:character-count" } ;
   static int  st_tb_i_col[]
   = { COL_DOC_PAGECOUNT, COL_DOC_WORDCOUNT, COL_DOC_CHARCOUNT } ;
   /*----------------------------------------------------------------------*/
   wxString s_val  ;
   long     l_val  ;
   size_t   sz_num ;

   /*----------------------------------------------------------------------*/
   for( sz_num = 0 ; sz_num < WXSIZEOF( st_tb_co_p_c_name ) ; ++sz_num )
   {
      /*-------------------------------------------------------------------*/
      if(    p_node->GetAttribute( st_tb_co_p_c_name[ sz_num ], &s_val )
          && m_fi.reserve_col( st_tb_i_col[ sz_num ] )
          && m_fi.prepare_string( s_val ) > 0
        )
      {  /*----------------------------------------------------------------*/
         m_f.val_s( st_tb_i_col[ sz_num ] ) = s_val ;
         if( s_val.ToLong( &l_val ) )
         {  m_f.val_ll( st_tb_i_col[ sz_num ] ) = l_val ; }
         /*----------------------------------------------------------------*/
      }
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit_odf::odf_read()
{
   /*----------------------------------------------------------------------*/
   wxFileInputStream           finput( m_fa )      ;
   wxZipInputStream            zip_input( finput ) ;
   std::auto_ptr< wxZipEntry > ptr_zip_entry       ;

   /*----------------------------------------------------------------------*/
   if( !zip_input.IsOk() ) { return( -1 ) ; }
   /*----------------------------------------------------------------------*/
   m_fi.init_doc_zip_info( zip_input ) ;

   /*--( Looking for the file containing the metadata )--------------------*/
   do
   {  ptr_zip_entry.reset( zip_input.GetNextEntry() ) ;
   } while(    ptr_zip_entry.get() != NULL
            && ptr_zip_entry->GetInternalName().CmpNoCase( "meta.xml" ) != 0
          ) ;
   /*----------------------------------------------------------------------*/
   if( ptr_zip_entry.get() == NULL ) { return( -2 ) ; }

   /*----------------------------------------------------------------------*/
   wxXmlDocument xml_meta( zip_input ) ;
   /*----------------------------------------------------------------------*/
   if( !xml_meta.IsOk() ) { return( -3 ) ; }

   /*----------------------------------------------------------------------*/
   wxXmlNode *xml_node( xml_meta.GetRoot() ) ;
   /*----------------------------------------------------------------------*/
   if( xml_node->GetName().CmpNoCase( "office:document-meta" ) != 0 )
   {  return( -4 ) ; }
   /*----------------------------------------------------------------------*/
   for( xml_node = xml_node->GetChildren() ;
           xml_node != NULL
        && xml_node->GetName().CmpNoCase( "office:meta" ) != 0 ;
        xml_node = xml_node->GetNext()
      )
   {  ; }
   /*----------------------------------------------------------------------*/
   if( xml_node == NULL ) { return( -5 ) ; }

   /*--( Now should come the tags )----------------------------------------*/
   for( xml_node = xml_node->GetChildren() ;
        xml_node != NULL ;
        xml_node = xml_node->GetNext()
      )
   {
      /*-------------------------------------------------------------------*/
      int i_col = st_odf_conv_tag_col( xml_node ) ;
      /*-------------------------------------------------------------------*/
      if(    i_col == COL_NB
          && xml_node->GetName().CmpNoCase( "meta:document-statistic" ) == 0
        )
      {  read_doc_stats( xml_node ) ; }
      else
      if(    m_fi.reserve_col( i_col )
          || ( i_col == COL_DOC_KEYWORDS && m_fi.is_col_reserved( i_col ) )
        )
      {
         /*----------------------------------------------------------------*/
         wxString s_val( xml_node->GetNodeContent() ) ;
         /*----------------------------------------------------------------*/
         if( m_fi.prepare_string( s_val ) == 0 )
         {  ; }
         else /*--( Keyword entry may appear many times )------------------*/
         if( i_col == COL_DOC_KEYWORDS )
         {
            /*-------------------------------------------------------------*/
            sr::append_with_sep( s_val, ", ", m_f.val_s( COL_DOC_KEYWORDS ));
            /*-------------------------------------------------------------*/
         }
         else
         if( i_col == COL_DOC_CRE_DATE || i_col == COL_DOC_MOD_DATE )
         {
            /*-------------------------------------------------------------*/
            wxDateTime dt ;
            /*--( Time can end with a "Z" or number of ms )----------------*/
            if( sr::init_datetime_wxiso( s_val, dt ) )
            {  m_fi.init_date( i_col, dt ) ; }
            else /*--( If not ISO format, it is kept as it is )------------*/
            {  m_f.val_s( i_col ) = s_val ; }
            /*-------------------------------------------------------------*/
         }
         else
         {  m_f.val_s( i_col ) = s_val ; }
         /*----------------------------------------------------------------*/
      }
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit::init_odf()
{
   /*----------------------------------------------------------------------*/
   m_s_type_det = "odf" ;
   /*----------------------------------------------------------------------*/
   return( CFileInit_odf( *this ).odf_read() ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                     End of file CFileInit_odf.cpp                         !
+==========================================================================*/
