/*====================================+=====================================+
! File CFileInit_kar.cpp              ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+---------------------------------------------------------------------------+
!                                                                           !
!                      Audio file: ".kar", ".mid"                           !
!                                                                           !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include "common/sr_lib.h"
#include "CFileInit.h"
#include "CFile.h"
/*-------------------------------------------------------------------------*/



/*--------------------------------------------------------------------------+
! Data/Treatment used during the loading                                    !
+--------------------------------------------------------------------------*/
class CFileInit_kar : public CFileInit_type_base
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CFileInit_kar( CFileInit &parent ) : CFileInit_type_base( parent )
      {  ; }
      /*-------------------------------------------------------------------*/
      int search_next_var( char &c_var, wxString &s_val ) ;
      int kar_read() ;
   /*----------------------------------------------------------------------*/
} ;

/*--( The search starts from current position )----------------------------*/
int CFileInit_kar::search_next_var( char &c_var, wxString &s_val )
{
   /*----------------------------------------------------------------------*/
   char   tb_c_buffer[ 512 ]               ;
   size_t sz_read                          ;
   bool   boo_first_buffer = true          ;
   char   tb_c_start[ 6 ]                  ; // Rotating buffer
   bool   boo_found                        ;
   int    i_num                            ;
   int    i_pos                            ;
   char   tb_c_val[ g_co_i_string_sz_max ] ;
   size_t sz_size                          ;

   /*----------------------------------------------------------------------*/
   do
   {
      /*-------------------------------------------------------------------*/
      sz_read = sizeof( tb_c_buffer ) ;
      if( m_fa.read_buffer_max( sz_read, tb_c_buffer ) != 0 )
      {  return( -2 ) ; }
      /*--------------------------------------------------------------------+
      ! Looking for a 6 characters sequence                                 !
      ! "tb_c_start" will contain the "rotating" data                       !
      +--------------------------------------------------------------------*/
      if( !boo_first_buffer )
      {  i_num = 0 ; }
      else
      {  /*----------------------------------------------------------------*/
         boo_first_buffer = false  ;
         for( i_num = 0 ;
              i_num < ( int )sizeof( tb_c_start ) && i_num < ( int )sz_read ;
              ++i_num
            )
         {  tb_c_start[ i_num ] = tb_c_buffer[ i_num ] ; }
         /*----------------------------------------------------------------*/
      }
      /*--------------------------------------------------------------------+
      ! 00 FF 01 nn @ [KVLT]                                                !
      ! nn: size of the value                                               !
      +--------------------------------------------------------------------*/
      for( ;  i_num < ( int )sz_read
           && !(    SR_FOURCC( tb_c_start[ 0 ], tb_c_start[ 1 ],
                               tb_c_start[ 2 ], tb_c_start[ 4 ]
                             ) == SR_FOURCC( 0x00, 0xFF, 0x01, '@' )
                 && (    tb_c_start[ 5 ] == 'K'
                      || tb_c_start[ 5 ] == 'V'
                      || tb_c_start[ 5 ] == 'L'
                      || tb_c_start[ 5 ] == 'T'
                    )
               ) ;
           ++i_num
         )
      {  /*--( Make turn ... )---------------------------------------------*/
         for( i_pos = 0 ; i_pos < ( int )sizeof( tb_c_start ) - 1 ; ++i_pos )
         {  tb_c_start[ i_pos ] = tb_c_start[ i_pos + 1 ] ; }
         tb_c_start[ i_pos ] = tb_c_buffer[ i_num ] ;
         /*----------------------------------------------------------------*/
      }
      /*-------------------------------------------------------------------*/
      boo_found = ( i_num < ( int )sz_read ) ;
      /*-------------------------------------------------------------------*/
      if( boo_found )
      {
         /*----------------------------------------------------------------*/
         size_t sz_size_to_skip ;
         /*----------------------------------------------------------------*/
         sz_size = wxMin( sizeof( tb_c_val ), tb_c_start[ 3 ] - 2 ) ;
         sz_size_to_skip = wxMin( tb_c_start[ 3 ] - 2 - sz_size, 0 ) ;
         /*-----------------------------------------------------------------+
         ! Set the pos at the start of the value and jump over the rest     !
         +-----------------------------------------------------------------*/
         if(    m_fa.skip_nb_byte( - ( int )sz_read + i_num ) != 0
             || m_fa.read_buffer( sz_size, tb_c_val ) != 0
             || m_fa.skip_nb_byte( sz_size_to_skip ) != 0
           )
         {  return( -3 ) ; }
         /*----------------------------------------------------------------*/
         c_var = tb_c_start[ 5 ] ;
         m_fi.prepare_string( tb_c_val, sz_size, s_val ) ;
         /*----------------------------------------------------------------*/
      }
      /*-------------------------------------------------------------------*/
   } while( !boo_found && sz_read == sizeof( tb_c_buffer ) ) ;

   /*----------------------------------------------------------------------*/
   if( !boo_found ) { return( -4 ) ; }

   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit_kar::kar_read()
{
   /*----------------------------------------------------------------------*/
   wxUint32 dw_id                       ;
   char     c_var                       ;
   wxString s_val                       ;
   int      i_col                       ;
   int      i_num_T = 0                 ;
   wxString s_info                      ;
   bool     boo_type_treated    = false ;
   bool     boo_version_treated = false ;

   /*----------------------------------------------------------------------*/
   if(    m_fa.read_data( dw_id ) != 0
       || dw_id != SR_FOURCC( 'M','T','h','d' )
     )
   {  return( -1 ) ; }

   /*--( Look into the "tracks" )------------------------------------------*/
   while( search_next_var( c_var, s_val ) == 0 )
   {
      /*-------------------------------------------------------------------*/
      switch( c_var )
      {
         /*----------------------------------------------------------------*/
         case 'K' : // Type
            /*-------------------------------------------------------------*/
            if( boo_type_treated ) { break ; }
            /*-------------------------------------------------------------*/
            boo_type_treated = true ;
            sr::prepend_with_sep( s_val, " - ", s_info ) ;
            /*-------------------------------------------------------------*/
            break ;

         /*----------------------------------------------------------------*/
         case 'V' : // Version
            /*-------------------------------------------------------------*/
            if( boo_version_treated ) { break ; }
            /*-------------------------------------------------------------*/
            boo_version_treated = true ;
            sr::append_with_sep( s_val, " - ", s_info ) ;
            /*-------------------------------------------------------------*/
            break ;

         /*----------------------------------------------------------------*/
         default :
            /*-------------------------------------------------------------*/
            i_col = COL_NB ;
            /*-------------------------------------------------------------*/
            switch( c_var )
            {
               /*----------------------------------------------------------*/
               case 'L' : i_col = COL_AUDTAG_GENRE ; break ; // Language
               /*----------------------------------------------------------*/
               case 'T' :
                  /*--( The occurrence of the 'T' gives its signification )*/
                  switch( ++i_num_T )
                  {  case 1 : i_col = COL_AUDTAG_TITLE     ; break ;
                     case 2 : i_col = COL_AUDTAG_ARTIST    ; break ;
                     case 3 : i_col = COL_AUDTAG_COPYRIGHT ; break ;
                  }
                  /*-------------------------------------------------------*/
                  break ;
               /*----------------------------------------------------------*/
            }
            /*--( Reserve the column even if the value is empty )----------*/
            if(    i_col != COL_NB
                && m_fi.reserve_col( i_col )
                && !s_val.empty()
              )
            {  m_f.val_s( i_col ) = s_val ; }
            /*-------------------------------------------------------------*/
            break ;
         /*----------------------------------------------------------------*/
      }
      /*-------------------------------------------------------------------*/
   }

   /*--( Finally the comment is stored )-----------------------------------*/
   if( !s_info.empty() )
   {  m_f.val_s( COL_AUDIO_INFO ) = s_info ; }
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit::init_kar()
{
   /*----------------------------------------------------------------------*/
   m_s_type_det = "kar" ;
   /*----------------------------------------------------------------------*/
   return( CFileInit_kar( *this ).kar_read() ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                       End of file CFileInit_kar.cpp                       !
+==========================================================================*/
