/*====================================+=====================================+
! File CFileInit_epub.cpp             ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+---------------------------------------------------------------------------+
!                                                                           !
!     Electronic publication (free and open e-book standard): ".epub"       !
!                                                                           !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include <memory>
#include <wx/wfstream.h>
#include <wx/zipstrm.h>
#include <wx/xml/xml.h>
#include "common/sr_lib.h"
#include "CFileInit.h"
#include "CFile.h"
/*-------------------------------------------------------------------------*/



/*--------------------------------------------------------------------------+
! Data/Treatment used during the loading                                    !
+--------------------------------------------------------------------------*/
class CFileInit_epub : public CFileInit_type_base
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CFileInit_epub( CFileInit &parent ) : CFileInit_type_base( parent )
      {  ; }
      /*-------------------------------------------------------------------*/
      int epub_read() ;

   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
static int st_epub_conv_tag_col( const wxXmlNode *p_node )
{
   /*----------------------------------------------------------------------*/
   wxString s_name( p_node->GetName() ) ;
   /*----------------------------------------------------------------------*/
   if( s_name.CmpNoCase( "dc:title" ) == 0 )
   {  return( COL_DOC_TITLE ) ; }
   if( s_name.CmpNoCase( "dc:creator" ) == 0 )
   {  return( COL_DOC_AUTHOR ) ; }
   if( s_name.CmpNoCase( "dc:publisher" ) == 0 )
   {  return( COL_DOC_COMPANY ) ; }
   if( s_name.CmpNoCase( "dc:comments" ) == 0 )
   {  return( COL_DOC_COMMENT ) ; }
   if( s_name.CmpNoCase( "dc:subject" ) == 0 )
   {  return( COL_DOC_SUBJECT ) ; }
   if( s_name.CmpNoCase( "dc:description" ) == 0 )
   {  return( COL_DOC_INFO ) ; }
   if( s_name.CmpNoCase( "dc:identifier" ) == 0 )
   {  return( p_node->GetAttribute( "opf:scheme" ) == "URI"
              ? COL_DOC_URL : COL_DOC_APPLICATION
            ) ;
   }
   if( s_name.CmpNoCase( "dc:date" ) == 0 )
   {  return( p_node->GetAttribute( "opf:event" ) == "ops-publication"
              ? COL_DOC_MOD_DATE : COL_DOC_CRE_DATE
            ) ;
   }
   if( s_name.CmpNoCase( "dc:language" ) == 0 )
   {  return( COL_DOC_VERSION ) ; }
   if( s_name.CmpNoCase( "dc:keywords" ) == 0 )
   {  return( COL_DOC_KEYWORDS ) ; }
   if( s_name.CmpNoCase( "dc:rights" ) == 0 )
   {  return( COL_DOC_COPYRIGHT ) ; }
   /*
   COL_DOC_TRADEMARKS
   */
   /*----------------------------------------------------------------------*/
   return( COL_NB ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit_epub::epub_read()
{
   /*----------------------------------------------------------------------*/
   wxFileInputStream           finput( m_fa )      ;
   wxZipInputStream            zip_input( finput ) ;
   std::auto_ptr< wxZipEntry > ptr_zip_entry       ;
   wxString                    s_opf_path          ;

   /*----------------------------------------------------------------------*/
   if( !zip_input.IsOk() ) { return( -1 ) ; }
   /*----------------------------------------------------------------------*/
   m_fi.init_doc_zip_info( zip_input ) ;

   /*--( Looking for the file specifying the file containing the metadata )*/
   do
   {  ptr_zip_entry.reset( zip_input.GetNextEntry() ) ;
   } while(    ptr_zip_entry.get() != NULL
            && ptr_zip_entry->GetInternalName().CmpNoCase(
                                                     "META-INF/container.xml"
                                                         ) != 0
          ) ;
   /*----------------------------------------------------------------------*/
   if( ptr_zip_entry.get() == NULL ) { return( -2 ) ; }

   /*--( This "xml" contains the "opf" file name )-------------------------*/
   {
      /*-------------------------------------------------------------------*/
      wxXmlDocument xml_cont( zip_input ) ;
      /*-------------------------------------------------------------------*/
      if( !xml_cont.IsOk() ) { return( -3 ) ; }

      /*-------------------------------------------------------------------*/
      wxXmlNode *xml_node( xml_cont.GetRoot() ) ;
      /*-------------------------------------------------------------------*/
      if( xml_node->GetName().CmpNoCase( "container" ) != 0 )
      {  return( -4 ) ; }
      /*-------------------------------------------------------------------*/
      for( xml_node = xml_node->GetChildren() ;
              xml_node != NULL
           && xml_node->GetName().CmpNoCase( "rootfiles" ) != 0 ;
           xml_node = xml_node->GetNext()
         )
      {  ; }
      /*-------------------------------------------------------------------*/
      if( xml_node == NULL ) { return( -5 ) ; }
      /*--( "rootfiles" contains "rootfile" )------------------------------*/
      for( xml_node = xml_node->GetChildren() ;
              xml_node != NULL
           && xml_node->GetName().CmpNoCase( "rootfile" ) != 0 ;
           xml_node = xml_node->GetNext()
         )
      {  ; }
      /*-------------------------------------------------------------------*/
      if( xml_node == NULL ) { return( -6 ) ; }
      /*--( Here it is ... )-----------------------------------------------*/
      s_opf_path = xml_node->GetAttribute( "full-path" ) ;
      /*-------------------------------------------------------------------*/
      if( s_opf_path.empty() ) { return( -7 ) ; }
      /*-------------------------------------------------------------------*/
   }

   /*-----------------------------------------------------------------------+
   ! Searching for the "opf" file entry in the archive                      !
   ! First rewind the "zip" and then search for the right entry             !
   +-----------------------------------------------------------------------*/
   finput.SeekI( 0 ) ;
   /*----------------------------------------------------------------------*/
   do
   {  ptr_zip_entry.reset( zip_input.GetNextEntry() ) ;
   } while(    ptr_zip_entry.get() != NULL
            && ptr_zip_entry->GetInternalName().CmpNoCase( s_opf_path ) != 0
          ) ;
   /*----------------------------------------------------------------------*/
   if( ptr_zip_entry.get() == NULL ) { return( -8 ) ; }

   /*--( Extract the opf file content )------------------------------------*/
   {
      /*-------------------------------------------------------------------*/
      wxXmlDocument xml_opf( zip_input ) ;
      /*-------------------------------------------------------------------*/
      if( !xml_opf.IsOk() ) { return( -9 ) ; }

      /*-------------------------------------------------------------------*/
      wxXmlNode *xml_node( xml_opf.GetRoot() ) ;
      /*-------------------------------------------------------------------*/
      if(    xml_node->GetName().CmpNoCase( "package" ) != 0
          && xml_node->GetName().CmpNoCase( "opf:package" ) != 0
        )
      {  return( -10 ) ; }
      /*-------------------------------------------------------------------*/
      for( xml_node = xml_node->GetChildren() ;
              xml_node != NULL
           && xml_node->GetName().CmpNoCase( "metadata" ) != 0
           && xml_node->GetName().CmpNoCase( "opf:metadata" ) != 0 ;
           xml_node = xml_node->GetNext()
         )
      {  ; }
      /*-------------------------------------------------------------------*/
      if( xml_node == NULL ) { return( -11 ) ; }
      /*--( Now should come the tags )-------------------------------------*/
      for( xml_node = xml_node->GetChildren() ;
           xml_node != NULL ;
           xml_node = xml_node->GetNext()
         )
      {  /*----------------------------------------------------------------*/
         int i_col = st_epub_conv_tag_col( xml_node ) ;
         /*----------------------------------------------------------------*/
         if( m_fi.reserve_col( i_col ) )
         {  /*-------------------------------------------------------------*/
            wxString s_val( xml_node->GetNodeContent() ) ;
            /*-------------------------------------------------------------*/
            if( m_fi.prepare_string( s_val ) == 0 )
            {  ; }
            else
            if( i_col == COL_DOC_CRE_DATE || i_col == COL_DOC_MOD_DATE )
            {
               /*----------------------------------------------------------*/
               wxDateTime dt ;
               /*--( Time can be ended with a "Z" or a number of ms )------*/
               if( sr::init_datetime_wxiso( s_val, dt ) )
               {  m_fi.init_date( i_col, dt ) ; }
               else /*--( By default it is kept as it is )-----------------*/
               {  m_f.val_s( i_col ) = s_val ; }
               /*----------------------------------------------------------*/
            }
            else
            {  m_f.val_s( i_col ) = s_val ; }
            /*-------------------------------------------------------------*/
         }
         /*----------------------------------------------------------------*/
      }
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit::init_epub()
{
   /*----------------------------------------------------------------------*/
   m_s_type_det = "epub" ;
   /*----------------------------------------------------------------------*/
   return( CFileInit_epub( *this ).epub_read() ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                     End of file CFileInit_epub.cpp                        !
+==========================================================================*/
