/*====================================+=====================================+
! File CFileInit_eml.cpp              ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+---------------------------------------------------------------------------+
!                                                                           !
!                         Email files ".eml"                                !
!                                                                           !
+-------+-------------------------------------------------------------------+
! Notes !                                                                   !
+-------+                                                                   !
! Storage column names may not correspond to data information names         !
!                                                                           !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include <wx/txtstrm.h>
#include <wx/wfstream.h>
#include <wx/base64.h>
#include "common/sr_lib.h"
#include "CFileInit.h"
#include "CFile.h"
/*-------------------------------------------------------------------------*/



/*--------------------------------------------------------------------------+
! Data/Treatment used during the loading                                    !
+--------------------------------------------------------------------------*/
class CFileInit_eml : public CFileInit_type_base
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CFileInit_eml( CFileInit &parent ) : CFileInit_type_base( parent )
      {  ; }
      /*-------------------------------------------------------------------*/
      int eml_read() ;

   /*----------------------------------------------------------------------*/
} ;

/*--------------------------------------------------------------------------+
! This function is supposed to implement the decoding part for:             !
! RFC 2047: MIME (Multipurpose Internet Mail Extensions)                    !
!           Part Three: Message Header Extensions for Non-ASCII Text        !
+--------------------------------------------------------------------------*/
static int st_decode_rfc2047_string( const wxString &s_in, wxString &s_out )
{
   /*----------------------------------------------------------------------*/
   sr::wxString_cit it     ;
   sr::wxString_cit it_end ;

   /*----------------------------------------------------------------------*/
   s_out.clear() ;
   s_out.reserve( s_in.length() ) ;
   /*----------------------------------------------------------------------*/
   for( it = s_in.begin() ; it != s_in.end() ; ++it )
   {
      /*--( Not the "=?" starting sequence ? Then it's "pure" text )-------*/
      if( *it != '=' || it == s_in.end() - 1 || *( it + 1 ) != '?' )
      {
         /*----------------------------------------------------------------*/
         s_out += *it ;
         continue ;
         /*----------------------------------------------------------------*/
      }

      /*--------------------------------------------------------------------+
      ! Inside a sequence: =?charset?x?text?=                               !
      +--------------------------------------------------------------------*/
      wxMemoryBuffer mb_out    ;
      wxString       s_charset ;
      wxUniChar      c_format  ;
      wxString       s_val     ;

      /*--( Charset to be used )-------------------------------------------*/
      for( it += 2 ; it != s_in.end() && *it != '?' ; ++it )
      {  s_charset += *it ; }
      if( it == s_in.end() ) { return( -1 ) ; }
      if( s_charset.empty() ) { s_charset = "ISO-8859-1" ; }

      /*--( Format: B/b for base64 or Q/q Quoted-Printable )---------------*/
      if( ++it == s_in.end() ) { return( -2 ) ; }
      c_format = wxToupper( *it ) ;
      if( ++it == s_in.end() ) { return( -3 ) ; }
      if( *it != '?' ) { return( -4 ) ; }

      /*--( The value to convert )-----------------------------------------*/
      for( ++it ; it != s_in.end() && *it != '?' ; ++it )
      {  s_val += *it ; }
      if( it == s_in.end() ) {  return( -3 ) ; }

      /*-( The ending sequence should be here )----------------------------*/
      if( *++it != '=' ) { return( -4 ) ; }

      /*--( Now, the "translation" can be done )---------------------------*/
      if( c_format == 'B' )
      {
         /*----------------------------------------------------------------*/
         mb_out = wxBase64Decode( s_val ) ;
         /*----------------------------------------------------------------*/
      }
      else
      if( c_format == 'Q' )
      {
         /*----------------------------------------------------------------*/
         sr::wxString_cit it_val    ;
         wxUint8          b_out = 0 ;
         /*----------------------------------------------------------------*/
         for( it_val = s_val.begin() ; it_val != s_val.end() ; ++it_val )
         {
            /*-------------------------------------------------------------*/
            switch( ( *it_val ).GetValue() )
            {  /*----------------------------------------------------------*/
               case '_' : b_out = ' ' ; break ;
               /*--( Hexadecimal value ? Supposed to be on 2 positions )---*/
               case '=' :
                  ++it_val ;
                  if(    it_val <= s_val.end() - 2
                      && isxdigit( *it_val ) && isxdigit( *( it_val + 1 ) )
                    )
                  {  b_out =    ( sr::xchar_value( *it_val ) << 4 )
                              | sr::xchar_value( *( it_val + 1 ) ) ;
                     ++it_val ;
                  }
                  break ;
               /*----------------------------------------------------------*/
               default : b_out = *it_val ; break ;
               /*----------------------------------------------------------*/
            }
            /*-------------------------------------------------------------*/
            mb_out.AppendByte( b_out ) ;
            /*-------------------------------------------------------------*/
         }
         /*----------------------------------------------------------------*/
      }
      /*--( Now the conversion according the right charset )---------------*/
         s_out
      += wxString( ( char * )mb_out.GetData(), wxCSConv( s_charset ),
                   mb_out.GetDataLen()
                 ) ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
static int st_eml_conv_tag_col( const wxString &s_var )
{
   /*--( CC and BCC useful ... ? and where put them ? )--------------------*/
   if( s_var.CmpNoCase( "From" ) == 0 ) { return( COL_DOC_AUTHOR ) ; }
   if( s_var.CmpNoCase( "To" ) == 0 )   { return( COL_DOC_DESTINATION ) ; }
   //if( s_var.CmpNoCase( "Cc" ) == 0 ) { return( COL_DOC_COPYRIGHT ) ; }
   //if( s_var.CmpNoCase( "Bcc" ) == 0 ) { return( COL_DOC_COMPANY ) ; }
   if( s_var.CmpNoCase( "Subject" ) == 0 ) { return( COL_DOC_SUBJECT ) ; }
   if( s_var.CmpNoCase( "Date" ) == 0 )    { return( COL_DOC_CRE_DATE ) ; }
   if( s_var.CmpNoCase( "Message-ID" ) == 0 ) { return( COL_DOC_ID ) ; }
   if( s_var.CmpNoCase( "Keywords" ) == 0 ) { return( COL_DOC_KEYWORDS ) ; }
   if( s_var.CmpNoCase( "Comments" ) == 0 ) { return( COL_DOC_COMMENT ) ; }
   if(    s_var.CmpNoCase( "User-Agent" ) == 0
       || s_var.CmpNoCase( "X-Mailer" ) == 0
     )
   {  return( COL_DOC_APPLICATION ) ; }

   /*----------------------------------------------------------------------*/
   return( COL_NB ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit_eml::eml_read()
{
   /*----------------------------------------------------------------------*/
   wxFileInputStream input( m_fa )  ;
   wxTextInputStream text( input )  ;
   wxString          s_line         ;
   wxString          s_val          ;
   wxString          s_prepare      ;
   int               i_col = COL_NB ;

   /*--( Read the "var" line )---------------------------------------------*/
   s_line = text.ReadLine() ;
   /*--( An empty line indicates the end of the header )-------------------*/
   do
   {
      /*--------------------------------------------------------------------+
      ! Name ends with a ':' and is separated from value with a space       !
      ! Then comes the first value starting with a space                    !
      +--------------------------------------------------------------------*/
      i_col = st_eml_conv_tag_col( s_line.BeforeFirst( ':', &s_val ) ) ;
      s_val.Trim( false ) ;

      /*--------------------------------------------------------------------+
      ! The useless values have to be skipped.                              !
      ! It is kept only if it is needed (!= COL_NB)                         !
      +--------------------------------------------------------------------*/
      while(    !input.Eof()
             && !( s_line = text.ReadLine() ).empty()
             && sr::bool_isspace( s_line[ 0 ] )
           )
      {  if( i_col != COL_NB ) { s_val += s_line.substr( 1 ) ; } }

      /*--------------------------------------------------------------------+
      ! The column/value pair is known. It has to be checked and prepared.  !
      +--------------------------------------------------------------------*/
      if(    i_col != COL_NB
          && st_decode_rfc2047_string( s_val, s_prepare ) == 0
          && m_fi.reserve_col( i_col )
          && m_fi.prepare_string( s_prepare ) > 0
        )
      {
         /*----------------------------------------------------------------*/
         if( i_col == COL_DOC_CRE_DATE )
         {
            /*-------------------------------------------------------------*/
            wxDateTime dt ;
            /*--( Date format is "fixed" )---------------------------------*/
            if( dt.ParseRfc822Date( s_prepare ) )
            {  m_fi.init_date( i_col,  dt ) ; }
            else /*--( Date "ko" )-----------------------------------------*/
            {  m_f.val_s( i_col ) = s_prepare ; }
            /*-------------------------------------------------------------*/
         }
         else
         {  m_f.val_s( i_col ) = s_prepare ; }
         /*----------------------------------------------------------------*/
      }

      /*-------------------------------------------------------------------*/
   } while( !input.Eof() && !s_line.empty() ) ;

   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit::init_eml()
{
   /*----------------------------------------------------------------------*/
   m_s_type_det = "eml" ;
   /*----------------------------------------------------------------------*/
   return( CFileInit_eml( *this ).eml_read() ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                       End of file CFileInit_eml.cpp                       !
+==========================================================================*/
