/*====================================+=====================================+
! File CFile_ExpMod1.cpp              ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+---------------------------------------------------------------------------+
!                                                                           !
!         Expression : evaluation of the specific modifiers "{}"            !
!                                                                           !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include "CFile.h"
#include "CApp.h"
/*-------------------------------------------------------------------------*/



/*--------------------------------------------------------------------------+
! Conversion of an integer value (i_num) to a string based on the           !
! expression to which point "it" and "cit_end"                              !
!                                                                           !
! The associated expression looks like:                                     !
!   - '{ <pad>, <start>, <inc> }'                                           !
!   by default the values of the "config file" variables are used           !
!                                                                           !
! "eci.it_exp" must point to the last character of the variable "name"      !
+--------------------------------------------------------------------------*/
int CFile::exp_sel_num( t_exp_comp_info &eci,
                        int             i_num,
                        wxString        &s_val
                      ) const
{
   /*----------------------------------------------------------------------*/
   int i_pad = wxGetApp().M_i_sel_num_pad.get() ;
   int i_beg = wxGetApp().M_i_sel_num_beg.get() ;
   int i_inc = wxGetApp().M_i_sel_num_inc.get() ;

   /*--( End of expression or no padding/recompute definition ? )----------*/
   if( eci.it_exp + 1 < eci.it_exp_end && *( eci.it_exp + 1 ) == '{' )
   {
      /*-------------------------------------------------------------------*/
      int i_val = 0 ;
      /*--( Jump just after the brace )------------------------------------*/
      eci.it_exp += 2 ;
      /*--( Value of the pad ? )-------------------------------------------*/
      extr_integer( eci, i_val ) ;
      if( eci.it_exp == eci.it_exp_end ) { return( -1 ) ; }
      /*--( Minimal control )----------------------------------------------*/
      if( i_val >= g_co_i_min_num_pad && i_val <= g_co_i_max_num_pad )
      {  i_pad = i_val ; }
      /*--( Then a begin (start) value ? )---------------------------------*/
      if( *eci.it_exp == ',' )
      {  /*----------------------------------------------------------------*/
         ++eci.it_exp ;
         extr_integer( eci, i_beg ) ;
         if( eci.it_exp == eci.it_exp_end ) { return( -2 ) ; }
         /*--( Then an increment value ? )---------------------------------*/
         if( *eci.it_exp == ',' )
         {  /*-------------------------------------------------------------*/
            ++eci.it_exp ;
            extr_integer( eci, i_inc ) ;
            if( eci.it_exp == eci.it_exp_end ) { return( -3 ) ; }
            /*-------------------------------------------------------------*/
         }
         /*----------------------------------------------------------------*/
      }
      /*--( Here should be the closing brace )-----------------------------*/
      if( *eci.it_exp != '}' ) { return( -4 ) ; }
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
   s_val.Printf( "%0*d", i_pad, i_beg + i_num * i_inc ) ;
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*--------------------------------------------------------------------------+
! Extraction of the "i_num" th non numeric part in a string based on the    !
! expression string to which point "it" and "cit_end"                       !
!                                                                           !
! The associated expression can be:                                         !
!   - '{ <num> }'                                                           !
!                                                                           !
! num is the number (place) of the string to extract. By default the value  !
! given as parameter will be used (not the digit which is the last          !
! character of the variable name). It can be negative, in this case the     !
! numbering starts from the end of the string.                              !
!                                                                           !
! "eci.it_exp" must point to the last character of the variable name        !
+--------------------------------------------------------------------------*/
int CFile::exp_non_num_in_string( t_exp_comp_info &eci,
                                  const wxString  &s_source,
                                  int             i_num,
                                  wxString        &s_val
                                ) const
{
   /*----------------------------------------------------------------------*/
   sr::wxString_cit it_beg ;
   sr::wxString_cit it_end ;

   /*--( Extract parameters )----------------------------------------------*/
   if( eci.it_exp + 1 < eci.it_exp_end && *( eci.it_exp + 1 ) == '{' )
   {
      /*--( Jump just after the opening brace )----------------------------*/
      eci.it_exp += 2 ;
      /*--( Index of the substring to extract )----------------------------*/
      extr_integer( eci, i_num ) ;
      if( eci.it_exp == eci.it_exp_end ) { return( -1 ) ; }
      /*--( Here must be a closing brace )---------------------------------*/
      if( *eci.it_exp != '}' ) { return( -2 ) ; }
      /*-------------------------------------------------------------------*/
   }

   /*-----------------------------------------------------------------------+
   ! Search for nth "non number". It can negative => search from end        !
   +-----------------------------------------------------------------------*/
   if( i_num < 0 )
   {
      /*-------------------------------------------------------------------*/
      sr::wxString_crit rit_beg( s_source.rbegin() ) ;
      sr::wxString_crit rit_end( s_source.rbegin() ) ;
      /*-------------------------------------------------------------------*/
      for( ; i_num < 0 && rit_beg != s_source.rend() ; ++i_num )
      {  /*--( Looking for the end of a number )---------------------------*/
         for( rit_beg = rit_end ;
              rit_beg != s_source.rend() && sr::bool_isdigit( *rit_beg ) ;
              ++rit_beg
            )
         {  ; }
         /*--( and now for its start )-------------------------------------*/
         for( rit_end = rit_beg ;
              rit_end != s_source.rend() && !sr::bool_isdigit( *rit_end ) ;
              ++rit_end
            )
         {  ; }
         /*----------------------------------------------------------------*/
      }
      /*--( The string was reversely treated )-----------------------------*/
      it_beg = rit_end.base() ;
      it_end = rit_beg.base() ;
      /*-------------------------------------------------------------------*/
   }
   else /*--( If 0 then start equals end and the result will be empty )----*/
   {
      /*-------------------------------------------------------------------*/
      for( it_end = it_beg = s_source.begin() ;
           i_num > 0 && it_beg != s_source.end() ;
           --i_num
         )
      {  /*--( Looking for the start of a non-number )---------------------*/
         for( it_beg = it_end ;
              it_beg != s_source.end() && sr::bool_isdigit( *it_beg ) ;
              ++it_beg
            )
         {  ; }
         /*--( and then for its start )------------------------------------*/
         for( it_end = it_beg ;
              it_end != s_source.end() && !sr::bool_isdigit( *it_end ) ;
              ++it_end
            )
         {  ; }
         /*----------------------------------------------------------------*/
      }
      /*-------------------------------------------------------------------*/
   }

   /*--( Got something ? )-------------------------------------------------*/
   if( it_beg < it_end )
   {  s_val.assign( it_beg, it_end ) ; }

   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*--------------------------------------------------------------------------+
! Extraction "i_num_num" nth numeric part of a string and convert it based  !
! on the expression between "it" and "cit_end"                              !
!                                                                           !
! The associated expression can be:                                         !
!   - '{ <pad>, <inc>, <num> }'                                             !
!   by default the values of the "config file" variables are used           !
!                                                                           !
! num is the number (place) of the number to extract. By default the value  !
! given as parameter will be used (not the digit which is the last          !
! character of the variable name). It can be negative, in this case the     !
! numbering starts from the end of the string.                              !
!                                                                           !
! "eci.it_exp" must point to the last character of the variable name        !
+--------------------------------------------------------------------------*/
int CFile::exp_num_in_string( t_exp_comp_info &eci,
                              const wxString  &s_source,
                              int             i_num_num,
                              wxString        &s_val
                            ) const
{
   /*----------------------------------------------------------------------*/
   sr::wxString_cit it_beg ;
   sr::wxString_cit it_end ;
   int              i_val = 0 ;
   int              i_pad = wxGetApp().M_i_num_in_name_pad.get() ;
   int              i_add = wxGetApp().M_i_num_in_name_add.get() ;

   /*--( Extract parameters )----------------------------------------------*/
   if( eci.it_exp + 1 < eci.it_exp_end && *( eci.it_exp + 1 ) == '{' )
   {
      /*-------------------------------------------------------------------*/
      int i_val = 0 ;
      /*--( Jump on the character after the brace )------------------------*/
      eci.it_exp += 2 ;
      /*--( Padding value )------------------------------------------------*/
      extr_integer( eci, i_val ) ;
      if( eci.it_exp == eci.it_exp_end ) { return( -1 ) ; }
      /*--( Minimal controls )---------------------------------------------*/
      if( i_val >= g_co_i_min_num_pad && i_val <= g_co_i_max_num_pad )
      {  i_pad = i_val ; }
      /*--( Then a value to add ? )----------------------------------------*/
      if( *eci.it_exp == ',' )
      {  /*----------------------------------------------------------------*/
         ++eci.it_exp ;
         extr_integer( eci, i_add ) ;
         if( eci.it_exp == eci.it_exp_end ) { return( -2 ) ; }
         /*--( Then the position of the number in string, even negative )--*/
         if( *eci.it_exp == ',' )
         {  /*-------------------------------------------------------------*/
            ++eci.it_exp ;
            extr_integer( eci, i_num_num ) ;
            if( eci.it_exp == eci.it_exp_end ) { return( -3 ) ; }
            /*-------------------------------------------------------------*/
         }
         /*----------------------------------------------------------------*/
      }
      /*--( Here must be the closing brace )-------------------------------*/
      if( *eci.it_exp != '}' ) { return( -4 ) ; }
      /*-------------------------------------------------------------------*/
   }

   /*-----------------------------------------------------------------------+
   ! Search for the nth number, it can be negative => search backwards      !
   +-----------------------------------------------------------------------*/
   if( i_num_num < 0 )
   {
      /*-------------------------------------------------------------------*/
      sr::wxString_crit rit_beg( s_source.rbegin() ) ;
      sr::wxString_crit rit_end( s_source.rbegin() ) ;
      /*-------------------------------------------------------------------*/
      for( ; i_num_num < 0 && rit_beg != s_source.rend() ; ++i_num_num )
      {  /*--( Looking for the end of the number )-------------------------*/
         for( rit_beg = rit_end ;
              rit_beg != s_source.rend() && !sr::bool_isdigit( *rit_beg ) ;
              ++rit_beg
            )
         {  ; }
         /*--( and then its start )----------------------------------------*/
         for( rit_end = rit_beg ;
              rit_end != s_source.rend() &&  sr::bool_isdigit( *rit_end ) ;
              ++rit_end
            )
         {  ; }
         /*----------------------------------------------------------------*/
      }
      /*-------------------------------------------------------------------*/
      it_beg = rit_end.base() ;
      it_end = rit_beg.base() ;
      /*-------------------------------------------------------------------*/
   }
   else /*--( if 0 the pointer are equal, so res empty )-------------------*/
   {
      /*-------------------------------------------------------------------*/
      for( it_end = it_beg = s_source.begin() ;
           i_num_num > 0 && it_beg != s_source.end() ;
           --i_num_num
         )
      {  /*--( Looking for the start of the number )-----------------------*/
         for( it_beg = it_end ;
              it_beg != s_source.end() && !sr::bool_isdigit( *it_beg ) ;
              ++it_beg
            )
         {  ; }
         /*--( and then its end )------------------------------------------*/
         for( it_end = it_beg ;
              it_end != s_source.end() &&  sr::bool_isdigit( *it_end ) ;
              ++it_end
            )
         {  ; }
         /*----------------------------------------------------------------*/
      }
      /*-------------------------------------------------------------------*/
   }

   /*-----------------------------------------------------------------------+
   ! The "computation" of the value is done only if it has been found ...   !
   +-----------------------------------------------------------------------*/
   if( it_beg < it_end )
   {
      /*-------------------------------------------------------------------*/
      for( i_val = 0 ; it_beg < it_end ; ++it_beg )
      {  i_val = i_val * 10 + sr::char_value( *it_beg ) ; }
      /*-------------------------------------------------------------------*/
      s_val.Printf( "%0*d", i_pad, i_val + i_add ) ;
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*--------------------------------------------------------------------------+
! Extraction of a line from the clipboard based on the expression string to !
! which point "it" and "cit_end"                                            !
!                                                                           !
! The associated expression can be:                                         !
!   - '{ <num> }'                                                           !
!                                                                           !
! num is the line number to extract (1..). By default the value given as    !
! parameter will be used.                                                   !
!                                                                           !
! "eci.it_exp" must point to the last character of the variable name        !
+--------------------------------------------------------------------------*/
int CFile::exp_clipboard_line( t_exp_comp_info &eci,
                               int             i_num,
                               wxString        &s_val
                             ) const
{
   /*--( Extract parameters )----------------------------------------------*/
   if( eci.it_exp + 1 < eci.it_exp_end && *( eci.it_exp + 1 ) == '{' )
   {
      /*--( Jump just after the opening brace )----------------------------*/
      eci.it_exp += 2 ;
      /*--( Index of the line number to extract )--------------------------*/
      extr_integer( eci, i_num ) ;
      if( eci.it_exp == eci.it_exp_end ) { return( -1 ) ; }
      /*--( Here must be a closing brace )---------------------------------*/
      if( *eci.it_exp != '}' ) { return( -2 ) ; }
      /*-------------------------------------------------------------------*/
   }

   /*--( Internally the number starts at 0 )-------------------------------*/
   s_val = st_m_ed_cp.get_line( i_num - 1 ) ;

   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*--------------------------------------------------------------------------+
! Extraction of a line from a file based on the expression string to which  !
! point "it" and "cit_end"                                                  !
!                                                                           !
! The associated expression can be:                                         !
!   - '{ "filename",<num> }'                                                !
!                                                                           !
! filename is the name of the file to extract the line from. It is          !
! optional.                                                                 !
!                                                                           !
! num is the line number to extract (1..). By default the value given as    !
! parameter will be used. It is optional.                                   !
!                                                                           !
! "eci.it_exp" must point to the last character of the variable name        !
+--------------------------------------------------------------------------*/
int CFile::exp_file_line( t_exp_comp_info &eci,
                          int             i_num,
                          wxString        &s_val
                        ) const
{
   /*----------------------------------------------------------------------*/
   bool boo_num_follows = true ;

   /*--( Extract parameters )----------------------------------------------*/
   if( eci.it_exp + 1 < eci.it_exp_end && *( eci.it_exp + 1 ) == '{' )
   {
      /*--( Jump just after the opening brace )----------------------------*/
      eci.it_exp += 2 ;
      /*-------------------------------------------------------------------*/
      sr::next_non_space( eci.it_exp_end, eci.it_exp ) ;
      if( eci.it_exp == eci.it_exp_end ) { return( -1 ) ; }

      /*--( File name ? )--------------------------------------------------*/
      if( *eci.it_exp == '%' || sr::is_string_delimiter( *eci.it_exp ) )
      {
          /*---------------------------------------------------------------*/
          wxString s_name ;
          /*---------------------------------------------------------------*/
          extr_quoted_string( eci, s_name ) ;
          if( eci.it_exp == eci.it_exp_end ) { return( -2 ) ; }
          /*--( It becomes the "active" file )-----------------------------*/
          if( !s_name.empty() )
          {  st_m_ed_fi.set_active_file( m_p_cdir->get_dir(), s_name ) ; }
          /*---------------------------------------------------------------*/
          if( ( boo_num_follows = ( *eci.it_exp == ',' ) ) )
          {  ++eci.it_exp ; }
          /*---------------------------------------------------------------*/
      }

      /*--( Line number follows ? )----------------------------------------*/
      if( boo_num_follows )
      {  /*----------------------------------------------------------------*/
         extr_integer( eci, i_num ) ;
         if( eci.it_exp == eci.it_exp_end ) { return( -3 ) ; }
         /*----------------------------------------------------------------*/
      }

      /*--( Here must be a closing brace )---------------------------------*/
      if( *eci.it_exp != '}' ) { return( -4 ) ; }
      /*-------------------------------------------------------------------*/
   }

   /*--( Internally the number starts at 0 )-------------------------------*/
   s_val = st_m_ed_fi.get_line( i_num - 1 ) ;

   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*--------------------------------------------------------------------------+
! Conversion of the integer value "i_num" to a string based on the          !
! expression string to which point "it" and "cit_end"                       !
!                                                                           !
! The associated expression can be:                                         !
!   - '{ <pad> }'                                                           !
!   by default the value of the "i_pad" parameter is used                   !
!                                                                           !
! "eci.it_exp" must point to the last character of the variable name        !
+--------------------------------------------------------------------------*/
int CFile::exp_num_pad( t_exp_comp_info &eci,
                        int             i_num,
                        int             i_pad,
                        wxString        &s_val
                      ) const
{
   /*--( End of expression or no padding definition ? )--------------------*/
   if( eci.it_exp + 1 < eci.it_exp_end && *( eci.it_exp + 1 ) == '{' )
   {
      /*-------------------------------------------------------------------*/
      int i_val = 0 ;
      /*--( Jump after the opening brace )---------------------------------*/
      eci.it_exp += 2 ;
      /*-------------------------------------------------------------------*/
      extr_integer( eci, i_val ) ;
      if( eci.it_exp == eci.it_exp_end ) { return( -1 ) ; }
      /*--( There must be a closing brace )--------------------------------*/
      if( *eci.it_exp != '}' ) { return( -2 ) ; }
      /*--( Minimal controls )---------------------------------------------*/
      if( i_val >= g_co_i_min_num_pad && i_val <= g_co_i_max_num_pad )
      {  i_pad = i_val ; }
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   s_val.Printf( "%0*d", i_pad, i_num ) ;
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*--------------------------------------------------------------------------+
! Conversion of the integral value associated to columns "1" or "2" (if the !
! equivalence has been asked) to a string.                                  !
! The "variable" can be completed in the expression by a "format"           !
! (cf exp_num_pad)                                                          !
+--------------------------------------------------------------------------*/
int CFile::exp_track_pad( t_exp_comp_info &eci,
                          int             i_col_1,
                          int             i_col_2,
                          wxString        &s_val
                        ) const
{
   /*----------------------------------------------------------------------*/
   t_ll_val_cit it_ll_val ;

   /*--( Fetch the integral value, if "possible" )-------------------------*/
   if(    ( it_ll_val = m_ll_val.find( i_col_1 ) ) == m_ll_val.end()
       && (    !wxGetApp().M_boo_id3v1aud_nvl.get()
            || ( it_ll_val = m_ll_val.find( i_col_2 ) ) == m_ll_val.end()
          )
     )
   {  /*--( If no numeric information is available a string is returned )--*/
      s_val = id3v1aud_equiv( i_col_1, i_col_2 ) ;
      return( 0 ) ;
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
   exp_num_pad( eci,
                it_ll_val->second.ToLong(), wxGetApp().M_i_track_pad.get(),
                s_val
              ) ;
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*--------------------------------------------------------------------------+
! Conversion of the wxDateTime value to a string based on the               !
! expression string to which point "it" and "cit_end"                       !
!                                                                           !
! The variable name can be followed by:                                     !
!   - 'd' to have only the "date" part                                      !
!   - 't' to have only the "time" part                                      !
!                                                                           !
! It can possibly be followed by:                                           !
!   - '{"format",add_hms}'                                                  !
!     format: strftime format, optional (empty string or undefined param)   !
!             By default, the default formats (config vars) will be applied !
!     add_hms: cf function extr_time                                        !
!                                                                           !
! "dt" is a parameter passed by value because it can be modified            !
! "eci.it_exp" must point to the last character of the variable name        !
+--------------------------------------------------------------------------*/
int CFile::exp_date( t_exp_comp_info &eci,
                     wxDateTime      dt,
                     wxString        &s_val
                   ) const
{
   /*----------------------------------------------------------------------*/
   wxString  s_format       ;
   wxUniChar c_format = ' ' ;

   /*--( Add the default value even if it will be subtracted later )-------*/
   if( dt.IsValid() )
   {  dt.Add( wxTimeSpan( 0, 0, wxGetApp().M_i_fmt_date_add.get() ) ) ; }

   /*--( End of expression ? )---------------------------------------------*/
   if( eci.it_exp + 1 == eci.it_exp_end )
   {  /*-------------------------------------------------------------------*/
      if( dt.IsValid() )
      {  s_val = dt.Format( wxGetApp().M_s_fmt_date_time.get() ) ; }
      /*-------------------------------------------------------------------*/
      return( 0 ) ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   ++eci.it_exp ;
   /*--( A date or a time ? )----------------------------------------------*/
   if( *eci.it_exp == 'd' || *eci.it_exp == 't' )
   {
      /*--( No following format ? )----------------------------------------*/
      if( eci.it_exp + 1 == eci.it_exp_end || *( eci.it_exp + 1 ) != '{' )
      {
         /*----------------------------------------------------------------*/
         if( dt.IsValid() )
         {  s_val = dt.Format( *eci.it_exp == 'd'
                               ? wxGetApp().M_s_fmt_date.get()
                               : wxGetApp().M_s_fmt_time.get()
                             ) ;
         }
         /*----------------------------------------------------------------*/
         return( 0 ) ;
         /*----------------------------------------------------------------*/
      }
      /*--( Jump over the 'd' or 't'. It is kept for default format )------*/
      c_format = *eci.it_exp ;
      ++eci.it_exp ;
      /*-------------------------------------------------------------------*/
   }
   else /*--( No format ... )----------------------------------------------*/
   if( *eci.it_exp != '{' )
   {
      /*-------------------------------------------------------------------*/
      --eci.it_exp ;
      if( dt.IsValid() )
      {  s_val = dt.Format( wxGetApp().M_s_fmt_date_time.get() ) ; }
      return( 0 ) ;
      /*-------------------------------------------------------------------*/
   }

   /*--( Extraction of the format )----------------------------------------*/
   ++eci.it_exp ;
   extr_quoted_string( eci, s_format ) ;
   if( eci.it_exp == eci.it_exp_end ) { return( -1 ) ; }

   /*--( Finally use the default format ? )--------------------------------*/
   if( s_format.empty() )
   {
      /*-------------------------------------------------------------------*/
      switch( c_format.GetValue() )
      {
         /*----------------------------------------------------------------*/
         case 'd': s_format = wxGetApp().M_s_fmt_date.get()      ; break ;
         case 't': s_format = wxGetApp().M_s_fmt_time.get()      ; break ;
         default : s_format = wxGetApp().M_s_fmt_date_time.get() ; break ;
         /*----------------------------------------------------------------*/
      }
      /*-------------------------------------------------------------------*/
   }

   /*--( Is there a time to add ? )----------------------------------------*/
   if( *eci.it_exp == ',' )
   {
      /*-------------------------------------------------------------------*/
      int i_nb_sec = wxGetApp().M_i_fmt_date_add.get() ;
      /*-------------------------------------------------------------------*/
      ++eci.it_exp ;
      extr_time( eci, i_nb_sec ) ;
      if( eci.it_exp == eci.it_exp_end ) { return( -2 ) ; }
      /*--------------------------------------------------------------------+
      ! Add the difference ...                                              !
      ! So if no "value" is specified (or 0), no change is done.            !
      ! If a "value" is specified (or 0), the original default value is     !
      ! suppressed and the value added.                                     !
      +--------------------------------------------------------------------*/
      if( dt.IsValid() )
      {  dt.Add( wxTimeSpan( 0, 0,
                             - wxGetApp().M_i_fmt_date_add.get() + i_nb_sec
                           )
               ) ;
      }
      /*-------------------------------------------------------------------*/
   }

   /*--( There must be a closing brace )-----------------------------------*/
   if( *eci.it_exp != '}' ) { return( -3 ) ; }
   /*----------------------------------------------------------------------*/
   if( dt.IsValid() )
   {  s_val = dt.Format( s_format ) ; }
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFile::exp_date( t_exp_comp_info &eci,
                     int             i_col,
                     wxString        &s_val
                   ) const
{
   /*----------------------------------------------------------------------*/
   wxDateTime dt = get_dt_val( i_col ) ;
   /*-----------------------------------------------------------------------+
   ! Even if the date is undefined the potential associated expression is   !
   ! skipped.                                                               !
   +-----------------------------------------------------------------------*/
   exp_date( eci, dt, s_val ) ;
   /*-----------------------------------------------------------------------+
   ! If the original date format was invalid there is no "dt_val" so        !
   ! the original string is returned                                        !
   +-----------------------------------------------------------------------*/
   if( !dt.IsValid() ) { s_val = get_s_val( i_col ) ; }
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*--------------------------------------------------------------------------+
! Generation of a random string. The string can contain: 0-9 A-Z a-z        !
!                                                                           !
! If only numeric characters are wanted the associated expression can be:   !
!   - '{ <num>, <min>, <max> }'                                             !
!     num : the length of the string to generate                            !
!     min : the maximal expected value                                      !
!     max : the minimal expected value                                      !
!                                                                           !
! Else the associated expression can be:                                    !
!   - '{ <num> }'                                                           !
!     num : the length of the string to generate                            !
!                                                                           !
! "srg_rand" is a bit field to specify the characters set used              !
!    SRG_RAND_DIGIT : 0-9                                                   !
!    SRG_RAND_ALPHA : A-Za-z                                                !
!                                                                           !
! "eci.it_exp" must point to the last character of the variable name        !
+--------------------------------------------------------------------------*/
int CFile::exp_rand( t_exp_comp_info &eci,
                     int             i_srg_rand,
                     wxString        &s_val
                   ) const
{
   /*----------------------------------------------------------------------*/
   int i_length = wxGetApp().M_i_rand_len.get() ;
   int i_val ;

   /*--( Fully analyse the format to at least skip it ... )----------------*/
   if( eci.it_exp + 1 < eci.it_exp_end && *( eci.it_exp + 1 ) == '{' )
   {
      /*-------------------------------------------------------------------*/
      i_val = 0 ;
      /*--( Jump on the character after the brace )------------------------*/
      eci.it_exp += 2 ;
      /*--( Length value )-------------------------------------------------*/
      extr_integer( eci, i_val ) ;
      if( eci.it_exp == eci.it_exp_end ) { return( -1 ) ; }
      /*--( Minimal controls )---------------------------------------------*/
      if( i_val >= g_co_i_min_rand_len && i_val <= g_co_i_max_rand_len )
      {  i_length = i_val ; }

      /*--( Numbers can have a specific format : min, max )----------------*/
      if( i_srg_rand == SRG_RAND_DIGIT && *eci.it_exp == ',' )
      {
         /*----------------------------------------------------------------*/
         long l_res ;
         int  i_min = 0 ;
         int  i_max = 0 ;

         /*----------------------------------------------------------------*/
         ++eci.it_exp ;
         extr_integer( eci, i_min ) ;
         if( eci.it_exp == eci.it_exp_end ) { return( -3 ) ; }

         /*--( Maximum value specified ? )---------------------------------*/
         if( *eci.it_exp == ',' )
         {  /*-------------------------------------------------------------*/
            ++eci.it_exp ;
            extr_integer( eci, i_max ) ;
            if( eci.it_exp == eci.it_exp_end ) { return( -4 ) ; }
            /*-------------------------------------------------------------*/
         }
         /*--( There must be the closing brace )---------------------------*/
         if( *eci.it_exp != '}' ) { return( -5 ) ; }

         /*--( Minimal control )-------------------------------------------*/
         if( i_min > i_max ) { return( -6 ) ; }
         /*----------------------------------------------------------------*/
         if( i_min == i_max )
         {  l_res = i_min ; }
         else
         {  l_res = i_min + rand() % ( i_max - i_min + 1 ) ; }
         /*----------------------------------------------------------------*/
         s_val.Printf( "%0*ld", i_length, l_res ) ;
         /*--( The job is done for this kind )-----------------------------*/
         return( 0 ) ;
         /*----------------------------------------------------------------*/
      }
      /*--( Then must be the closing brace )-------------------------------*/
      if( *eci.it_exp != '}' ) { return( -7 ) ; }
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
   int i_nb_possible = 0 ;
   if( ( i_srg_rand & SRG_RAND_DIGIT ) != 0 )
   {  i_nb_possible += 10 ; }
   if( ( i_srg_rand & SRG_RAND_ALPHA ) != 0 )
   {  i_nb_possible += 52 ; }
   /*----------------------------------------------------------------------*/
   if( i_nb_possible == 0 ) { return( -6 ) ; }

   /*----------------------------------------------------------------------*/
   s_val.clear() ;
   s_val.reserve( i_length ) ;

   /*----------------------------------------------------------------------*/
   do
   {  /*-------------------------------------------------------------------*/
      i_val = rand() % i_nb_possible ;
      /*-------------------------------------------------------------------*/
      if( ( i_srg_rand & SRG_RAND_DIGIT ) != 0 )
      {
         /*----------------------------------------------------------------*/
         if( i_val < 10 ) { s_val += '0' + i_val ; continue ; }
         /*----------------------------------------------------------------*/
         i_val -= 10 ;
         /*----------------------------------------------------------------*/
      }
      /*-------------------------------------------------------------------*/
      if( ( i_srg_rand & SRG_RAND_ALPHA ) != 0 )
      {
         /*----------------------------------------------------------------*/
         if( i_val < 26 ) { s_val += 'A' + i_val ; continue ; }
         /*----------------------------------------------------------------*/
         i_val -= 26 ;
         /*----------------------------------------------------------------*/
         if( i_val < 26 ) { s_val += 'a' + i_val ; continue ; }
         /*----------------------------------------------------------------*/
      }
      /*-------------------------------------------------------------------*/
   } while( --i_length > 0 ) ;

   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                       End of File CFile_ExpMod1.cpp                       !
+==========================================================================*/
