/*====================================+=====================================+
! File CFile_ExpExtr.cpp              ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+---------------------------------------------------------------------------+
!                                                                           !
!      Expression : evaluation of "basic" information (int, str ...)        !
!                                                                           !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include "CFile.h"
/*-------------------------------------------------------------------------*/



/*--------------------------------------------------------------------------+
! Variables can replace parameters                                          !
+--------------------------------------------------------------------------*/
sr::wxString_cit CFile::extr_compute_variable( t_exp_comp_info &eci,
                                               wxString        &s_val
                                             ) const
{
   /*----------------------------------------------------------------------*/
   compute_exp_variable( eci, s_val ) ;
   sr::next_non_space( eci.it_exp_end, ++eci.it_exp ) ;
   /*----------------------------------------------------------------------*/
   return( eci.it_exp ) ;
   /*----------------------------------------------------------------------*/
}

/*--------------------------------------------------------------------------+
! Extraction from the "it" position of an integer value that may indirectly !
! be represented by a "variable".                                           !
! If no integer value is detected the destination is not modified.          !
+--------------------------------------------------------------------------*/
sr::wxString_cit CFile::extr_integer( t_exp_comp_info &eci, int &i_val
                                    ) const
{
   /*----------------------------------------------------------------------*/
   sr::next_non_space( eci.it_exp_end, eci.it_exp ) ;
   if( eci.it_exp == eci.it_exp_end ) { return( eci.it_exp ) ; }

   /*--( Variable ? )------------------------------------------------------*/
   if( *eci.it_exp == '%' )
   {  /*-------------------------------------------------------------------*/
      wxString s_val ;
      /*-------------------------------------------------------------------*/
      extr_compute_variable( eci, s_val ) ;
      sr::conv_str_to_int( s_val.begin(), s_val.end(), i_val ) ;
      /*-------------------------------------------------------------------*/
      return( eci.it_exp ) ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   eci.it_exp = sr::conv_str_to_int( eci.it_exp, eci.it_exp_end, i_val ) ;
   return( eci.it_exp ) ;
   /*----------------------------------------------------------------------*/
}

/*--------------------------------------------------------------------------+
! Extraction from the "it" position of a string framed with '"' or '''.     !
! It can also be indirectly represented by a non quoted "variable".         !
! If no value is present the destination is not modified.                   !
+--------------------------------------------------------------------------*/
sr::wxString_cit CFile::extr_quoted_string( t_exp_comp_info &eci,
                                            wxString &s_val
                                          ) const
{
   /*----------------------------------------------------------------------*/
   sr::next_non_space( eci.it_exp_end, eci.it_exp ) ;
   if( eci.it_exp == eci.it_exp_end ) { return( eci.it_exp ) ; }

   /*--( Variable ? )------------------------------------------------------*/
   if( *eci.it_exp == '%' )
   {  return( extr_compute_variable( eci, s_val ) ) ; }

   /*--( Here should be the string start )---------------------------------*/
   if( !sr::is_string_delimiter( *eci.it_exp ) )
   {  return( eci.it_exp ) ; }

   /*--( Keep the starting delimiter to check the end )--------------------*/
   wxUniChar c_delim = *eci.it_exp ;
   /*----------------------------------------------------------------------*/
   s_val.clear() ;
   /*----------------------------------------------------------------------*/
   for( ++eci.it_exp ;
        eci.it_exp != eci.it_exp_end && *eci.it_exp != c_delim ;
        ++eci.it_exp
      )
   {
      /*--( Escaped character ? maybe to use a delimiter )-----------------*/
      if( *eci.it_exp == '\\' && eci.it_exp + 1 != eci.it_exp_end )
      {  ++eci.it_exp ; }
      /*-------------------------------------------------------------------*/
      s_val += *eci.it_exp ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   if( eci.it_exp == eci.it_exp_end || *eci.it_exp != c_delim )
   {  s_val.clear() ; }
   else
   {  /*--( Skip spaces after the string )---------------------------------*/
      sr::next_non_space( eci.it_exp_end, ++eci.it_exp ) ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   return( eci.it_exp ) ;
   /*----------------------------------------------------------------------*/
}

/*--------------------------------------------------------------------------+
! Extraction from the "it" position of a quoted string framed with          !
! braces "{}".                                                              !
! For example as parameter to specify a file name (%T)                      !
+--------------------------------------------------------------------------*/
sr::wxString_cit CFile::extr_param_quoted_string( t_exp_comp_info &eci,
                                                  wxString        &s_val
                                                ) const
{
   /*--( There must be an opening brace )----------------------------------*/
   if( *eci.it_exp != '{' ) { return( eci.it_exp ) ; }
   /*--( Jump over it )----------------------------------------------------*/
   ++eci.it_exp ;
   /*--( Then the string can be extracted )--------------------------------*/
   extr_quoted_string( eci, s_val ) ;
   if( eci.it_exp == eci.it_exp_end ) { return( eci.it_exp ) ; }
   /*----------------------------------------------------------------------*/
   if( *eci.it_exp != '}' )
   {  s_val.clear() ; return( eci.it_exp ) ; }
   /*----------------------------------------------------------------------*/
   return( eci.it_exp ) ;
   /*----------------------------------------------------------------------*/
}

/*--------------------------------------------------------------------------+
! Extraction from the "it" position of a non quoted string framed with      !
! braces "{}"                                                               !
+--------------------------------------------------------------------------*/
sr::wxString_cit CFile::extr_param_string( t_exp_comp_info &eci,
                                           wxString        &s_val
                                         ) const
{
   /*--( There must be an opening brace )----------------------------------*/
   if( *eci.it_exp != '{' ) { return( eci.it_exp ) ; }
   s_val.clear() ;
   /*----------------------------------------------------------------------*/
   ++eci.it_exp ;
   /*--( Variable ? )------------------------------------------------------*/
   if( *eci.it_exp == '%' )
   {  return( extr_compute_variable( eci, s_val ) ) ; }

   /*--( Then the string can be extracted )--------------------------------*/
   for( ; eci.it_exp != eci.it_exp_end && *eci.it_exp != '}' ; ++eci.it_exp )
   {
      /*--( Escaped character ? )------------------------------------------*/
      if( *eci.it_exp == '\\' && eci.it_exp + 1 != eci.it_exp_end )
      {  ++eci.it_exp ; }
      /*-------------------------------------------------------------------*/
      s_val += *eci.it_exp ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   if( eci.it_exp == eci.it_exp_end )
   {  s_val.clear() ; return( eci.it_exp ) ; }
   /*----------------------------------------------------------------------*/
   return( eci.it_exp ) ;
   /*----------------------------------------------------------------------*/
}

/*--------------------------------------------------------------------------+
! Extraction from the "it" position of a "duration" string:                 !
! [+-][hour h][min m][sec s]                                                !
! The computed value is a signed number of seconds.                         !
! If no value is present the destination is not modified.                   !
+--------------------------------------------------------------------------*/
sr::wxString_cit CFile::extr_time( t_exp_comp_info &eci,
                                   int &i_nb_sec
                                 ) const
{
   /*----------------------------------------------------------------------*/
   sr::next_non_space( eci.it_exp_end, eci.it_exp ) ;
   if( eci.it_exp == eci.it_exp_end ) { return( eci.it_exp ) ; }

   /*--( Variable ? )------------------------------------------------------*/
   if( *eci.it_exp == '%' )
   {  /*-------------------------------------------------------------------*/
      wxString s_val ;
      /*-------------------------------------------------------------------*/
      extr_compute_variable( eci, s_val ) ;
      sr::conv_time_to_nb_sec( s_val.begin(), s_val.end(), i_nb_sec ) ;
      /*-------------------------------------------------------------------*/
      return( eci.it_exp ) ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
     eci.it_exp
   = sr::conv_time_to_nb_sec( eci.it_exp, eci.it_exp_end, i_nb_sec ) ;
   /*----------------------------------------------------------------------*/
   return( eci.it_exp ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                      End of File CFile_ExpExtr.cpp                        !
+==========================================================================*/
