/*====================================+=====================================+
! File CFile_CompVar.cpp              ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include "CFile.h"
#include "CApp.h"
/*-------------------------------------------------------------------------*/



/*--------------------------------------------------------------------------+
! This function should not be called by "compute_exp_variable".             !
! The expression pointer should point after the "%" and the group           !
! information.                                                              !
+--------------------------------------------------------------------------*/
sr::wxString_cit CFile::compute_exp_variable_base( t_exp_comp_info &eci,
                                                   wxString        &s_val
                                                 ) const
{
   /*--( An access to the parent container may be needed )-----------------*/
   if( get_cdir() == NULL ) { wxFAIL ; return( eci.it_exp_end ) ; }

   /*-----------------------------------------------------------------------+
   ! The name to use is the original one or another created by a previous   !
   ! sub expression ?                                                       !
   +-----------------------------------------------------------------------*/
   const wxFileName &co_name
                  = ( eci.boo_first_sub_exp ? get_name() : get_new_name() ) ;
   /*----------------------------------------------------------------------*/
   sr::wxString_cit cit_exp_last   = eci.it_exp_end - 1 ;
   wxUniChar        c_mod_case     = ' '                ;
   bool             boo_del_accent = false              ;
   bool             boo_repl_percent_xx = false         ;
   bool             boo_conv_ascii_utf8 = false         ;
   bool             boo_end_of_mod = false              ;
   sr::e_fcw        fcw_force_case                      ;
   int              i_ret                               ;

   /*----------------------------------------------------------------------*/
   s_val.clear() ;
   /*----------------------------------------------------------------------*/
   if(    wxGetApp().M_boo_force_case_word.get()
       && !wxGetApp().M_as_force_case_word.IsEmpty()
     )
   {  fcw_force_case = sr::FCW_DO_FORCE_CASE ; }
   else
   {  fcw_force_case = sr::FCW_DONT_FORCE_CASE ; }

   /*-----------------------------------------------------------------------+
   ! One or more character modifiers ?                                      !
   +-----------------------------------------------------------------------*/
   do
   {  /*-------------------------------------------------------------------*/
      switch( ( *eci.it_exp ).GetValue() )
      {
         /*--( The last speaking one is right ... )------------------------*/
         case 'u' : case 'U' : case 'l' : case 'L' :
            c_mod_case = *eci.it_exp++ ; break ;
         /*--( Replace '%xx' characters ? )--------------------------------*/
         case '#' : boo_repl_percent_xx = true ; ++eci.it_exp ; break ;
         /*--( Convert UTF8 chars from ascii to UTF8 )---------------------*/
         case '&' : boo_conv_ascii_utf8 = true ; ++eci.it_exp ; break ;
         /*--( Delete accents from characters ? )--------------------------*/
         case '@' : boo_del_accent = true ; ++eci.it_exp ; break ;
         /*--( Force the case of some words ? )----------------------------*/
         case '+' : fcw_force_case = sr::FCW_DO_FORCE_CASE ;
                    ++eci.it_exp ;
                    break ;
         case '-' : fcw_force_case = sr::FCW_DONT_FORCE_CASE ;
                    ++eci.it_exp ;
                    break ;
         /*----------------------------------------------------------------*/
         default : boo_end_of_mod = true ; break ;
         /*----------------------------------------------------------------*/
      }
      /*--( Terminate before the last character )--------------------------*/
   } while( !boo_end_of_mod && eci.it_exp < cit_exp_last ) ;

   /*----------------------------------------------------------------------*/
   if( eci.it_exp > cit_exp_last ) { return( eci.it_exp ) ; }

   /*-----------------------------------------------------------------------+
   ! And ... here comes the name of the variable !                          !
   +-----------------------------------------------------------------------*/
   switch( ( *eci.it_exp ).GetValue() )
   {
      /*-------------------------------------------------------------------*/
      case 'f' :
         /*----------------------------------------------------------------*/
         if( eci.it_exp >= cit_exp_last )
         {  s_val = co_name.GetFullName() ; }
         else
         {  /*-------------------------------------------------------------*/
            switch( ( *++eci.it_exp ).GetValue() )
            {
               /*----------------------------------------------------------*/
               case 'a' :
                  s_val = sr::absolute_path( co_name, get_cdir()->get_dir() )
                        + co_name.GetFullName() ;
                  break ;
               case 'c' : s_val = co_name.GetFullPath() ; break ;
               case 'd' : s_val = get_s_val( COL_BASE_DOS_NAME ) ; break ;
               default :
                  --eci.it_exp ;
                  s_val = co_name.GetFullName() ;
                  break ;
               /*----------------------------------------------------------*/
            }
            /*-------------------------------------------------------------*/
         }
         /*----------------------------------------------------------------*/
         break ;
      /*-------------------------------------------------------------------*/
      case 'b' :
         /*----------------------------------------------------------------*/
         if( eci.it_exp >= cit_exp_last || *( eci.it_exp + 1 ) != 'd' )
         {  s_val = get_comp_basename( co_name ) ; }
         else
         {  ++eci.it_exp ;
            s_val = get_comp_basename( get_s_val( COL_BASE_DOS_NAME ) ) ;
         }
         /*----------------------------------------------------------------*/
         break ;
      /*-------------------------------------------------------------------*/
      case 'e' :
         /*----------------------------------------------------------------*/
         if( eci.it_exp >= cit_exp_last || *( eci.it_exp + 1 ) != 'd' )
         {  s_val = get_comp_extension( co_name ) ; }
         else
         {  ++eci.it_exp ;
            s_val = get_comp_extension( get_s_val( COL_BASE_DOS_NAME ) ) ;
         }
         /*----------------------------------------------------------------*/
         break ;
      /*-------------------------------------------------------------------*/
      case 'a' : s_val = get_s_val( COL_BASE_ATTR ) ; break ;
      /*-------------------------------------------------------------------*/
      case 'y' :
         /*----------------------------------------------------------------*/
         if( eci.it_exp >= cit_exp_last || *( eci.it_exp + 1 ) != 'd' )
         {  s_val = get_s_val( COL_BASE_TYPE ) ; }
         else
         {  ++eci.it_exp ;
            s_val = get_s_val( COL_BASE_TYPE_DET ) ;
         }
         /*----------------------------------------------------------------*/
         break ;
      /*--( By default, the size is returned in the "best" unit )----------*/
      case 's' :
      {
         /*----------------------------------------------------------------*/
         wxUniChar c_unit ;
         /*----------------------------------------------------------------*/
         if(    eci.it_exp < cit_exp_last
             && (    *( eci.it_exp + 1 ) == 'b'
                  || *( eci.it_exp + 1 ) == 'k'
                  || *( eci.it_exp + 1 ) == 'm'
                  || *( eci.it_exp + 1 ) == 'g'
                )
           )
         {  c_unit = *++eci.it_exp ; }
         else
         {  c_unit = ' ' ; }
         /*----------------------------------------------------------------*/
         s_val = get_s_size( c_unit ) ;
         /*----------------------------------------------------------------*/
         break ;
         /*----------------------------------------------------------------*/
      }

      /*--( File date/time )-----------------------------------------------*/
      case 'd' :
      {
         /*----------------------------------------------------------------*/
         e_col col = COL_NB ;
         /*----------------------------------------------------------------*/
         if( eci.it_exp >= cit_exp_last ) { return( eci.it_exp ) ; }
         /*----------------------------------------------------------------*/
         switch( ( *++eci.it_exp ).GetValue() )
         {  /*-------------------------------------------------------------*/
            case 'c' : col = COL_BASE_CRE_DATE ; break ;
            case 'a' : col = COL_BASE_ACC_DATE ; break ;
            case 'm' : col = COL_BASE_MOD_DATE ; break ;
            default : --eci.it_exp ; return( eci.it_exp ) ;
            /*-------------------------------------------------------------*/
         }
         /*----------------------------------------------------------------*/
         exp_date( eci, col, s_val ) ;
         /*----------------------------------------------------------------*/
         break ;
         /*----------------------------------------------------------------*/
      }

      /*--( Number/Non-number in base name )-------------------------------*/
      case 'N' :
      {
         /*----------------------------------------------------------------*/
         bool boo_extract_num ;
         int  i_num           ;
         /*--( %N or %NN ? )-----------------------------------------------*/
         if( eci.it_exp < cit_exp_last && *( eci.it_exp + 1 ) == 'N' )
         {  boo_extract_num = false ; ++eci.it_exp ; }
         else
         {  boo_extract_num = true ; }
         /*--( An index is present ? : number of the [non]number )---------*/
         if(    eci.it_exp < cit_exp_last
             && sr::bool_isdigit( *( eci.it_exp + 1 ) )
           )
         {  i_num = sr::char_value( *++eci.it_exp ) ; }
         else
         {  i_num = 1 ; }
         /*----------------------------------------------------------------*/
         if( boo_extract_num )
         {  exp_num_in_string( eci, co_name.GetName(), i_num, s_val ) ; }
         else
         {  exp_non_num_in_string( eci, co_name.GetName(), i_num, s_val ) ; }
         /*----------------------------------------------------------------*/
         break ;
         /*----------------------------------------------------------------*/
      }

      /*--( Checksum )-----------------------------------------------------*/
      case 'c' :
      {
         /*----------------------------------------------------------------*/
         if( eci.it_exp >= cit_exp_last ) { return( eci.it_exp ) ; }
         /*----------------------------------------------------------------*/
         switch( ( *++eci.it_exp ).GetValue() )
         {  /*-------------------------------------------------------------*/
            case 'm' : s_val = get_md5()   ; break ;
            case 's' : s_val = get_sha1()  ; break ;
            case 'c' : s_val = get_crc32() ; break ;
            default : --eci.it_exp ; return( eci.it_exp ) ;
            /*-------------------------------------------------------------*/
         }
         /*----------------------------------------------------------------*/
         break ;
         /*----------------------------------------------------------------*/
      }

      /*--( Selection number )---------------------------------------------*/
      case 'n' :
      {
         /*----------------------------------------------------------------*/
         if( eci.it_exp >= cit_exp_last )
         {  s_val = get_s_val( COL_NONE_SEL_NUM ) ; }
         else
         {
            /*-------------------------------------------------------------*/
            switch( ( *++eci.it_exp ).GetValue() )
            {
               /*--( Reset in each dir )-----------------------------------*/
               case 'p' :
                  /*-------------------------------------------------------*/
                  exp_sel_num( eci,
                               get_cdir()->get_s_sel_num_rel_dir( *this ),
                               s_val
                             ) ;
                  /*-------------------------------------------------------*/
                  break ;
               /*--( Anti-collision )--------------------------------------*/
               case 'c' :
               {
                  /*-------------------------------------------------------*/
                  bool boo_without_path = (    eci.it_exp < cit_exp_last
                                            && *( eci.it_exp + 1 ) == 'f'
                                          ) ;
                  /*-------------------------------------------------------*/
                  if( boo_without_path ) { ++eci.it_exp ; }
                  /*-------------------------------------------------------*/
                  int i_val = get_cdir()->get_s_sel_num_rel_collision(
                                 *this, eci.s_current_value, boo_without_path
                                                                     ) ;
                  /*-------------------------------------------------------*/
                  if(    eci.it_exp == cit_exp_last
                      || *( eci.it_exp + 1 ) != 's'
                    )
                  {  exp_sel_num( eci, i_val, s_val ) ; }
                  else
                  {  /*----------------------------------------------------*/
                     ++eci.it_exp ;
                     /*----------------------------------------------------*/
                     exp_sel_num( eci, i_val - 1, s_val ) ;
                     /*--( Reset on the first one )------------------------*/
                     if( i_val == 0 )
                     {  s_val.clear() ; }
                     else
                     {  s_val.insert( 0, '_' ) ; }
                     /*----------------------------------------------------*/
                  }
                  /*-------------------------------------------------------*/
                  break ;
                  /*-------------------------------------------------------*/
               }
               /*--( Number of selected files )----------------------------*/
               case 's' :
                  /*-------------------------------------------------------*/
                  exp_num_pad( eci, get_cdir()->get_nb_sel(),
                               wxGetApp().M_i_sel_num_pad.get(),
                               s_val
                             ) ;
                  /*-------------------------------------------------------*/
                  break ;
               /*----------------------------------------------------------*/
               default :
                  /*-------------------------------------------------------*/
                  --eci.it_exp ;
                  exp_sel_num( eci, get_sel_num(), s_val ) ;
                  /*-------------------------------------------------------*/
                  break ;
               /*----------------------------------------------------------*/
            }
            /*-------------------------------------------------------------*/
         }
         /*----------------------------------------------------------------*/
         break ;
         /*----------------------------------------------------------------*/
      }

      /*-------------------------------------------------------------------*/
      case 'p' :
      {
         /*--( Path from right )-------------------------------------------*/
         if(    eci.it_exp < cit_exp_last
             && sr::bool_isdigit( *( eci.it_exp + 1 ) )
           )
         {  /*-------------------------------------------------------------*/
            s_val = sr::dir_from_right( co_name,
                                        sr::char_value( *++eci.it_exp ),
                                        get_cdir()->get_dir()
                                      ) ;
            /*-------------------------------------------------------------*/
         }
         else
         {  /*--( Path absolute / relative )-------------------------------*/
            switch( ( *++eci.it_exp ).GetValue() )
            {  /*----------------------------------------------------------*/
               case 'a' :
                  s_val = sr::absolute_path( co_name, get_cdir()->get_dir());
                  break ;
               case 'r' : s_val = co_name.GetPathWithSep() ;
                  break ;
               default :
                  --eci.it_exp ;
                    s_val
                  = sr::dir_from_right( co_name, 1, get_cdir()->get_dir() ) ;
                  break ;
               /*----------------------------------------------------------*/
            }
            /*-------------------------------------------------------------*/
         }
         /*----------------------------------------------------------------*/
         break ;
         /*----------------------------------------------------------------*/
      }
      /*--( Current Siren path / Siren executable path )-------------------*/
      case 'P' :
      {
         /*----------------------------------------------------------------*/
         if( eci.it_exp >= cit_exp_last || *( eci.it_exp + 1 ) != 'e' )
         {  /*--( This will add the final "/" or "\" if necessary )--------*/
            wxFileName path( get_cdir()->get_dir(), wxEmptyString ) ;
            s_val = path.GetFullPath() ;
            /*-------------------------------------------------------------*/
         }
         else
         {  /*-------------------------------------------------------------*/
            ++eci.it_exp ;
            /*-------------------------------------------------------------*/
            wxFileName path( wxGetApp().get_exe_path(), wxEmptyString ) ;
            s_val = path.GetFullPath() ;
            /*-------------------------------------------------------------*/
         }
         /*----------------------------------------------------------------*/
         break ;
         /*----------------------------------------------------------------*/
      }

      /*--( System Date/Time )---------------------------------------------*/
      case 'D' :
      {
         /*----------------------------------------------------------------*/
         exp_date( eci, st_m_ed_st.get_data(), s_val ) ;
         /*----------------------------------------------------------------*/
         break ;
         /*----------------------------------------------------------------*/
      }

      /*--( Random number & string )---------------------------------------*/
      case 'R' :
      {
         /*----------------------------------------------------------------*/
         int i_srg_rand ;
         /*----------------------------------------------------------------*/
         if( eci.it_exp >= cit_exp_last ) { return( eci.it_exp ) ; }
         /*----------------------------------------------------------------*/
         switch( ( *++eci.it_exp ).GetValue() )
         {  /*-------------------------------------------------------------*/
            case 'n' : i_srg_rand = SRG_RAND_DIGIT ; break ;
            case 'a' : i_srg_rand = SRG_RAND_ALPHA ; break ;
            case 's' : i_srg_rand = SRG_RAND_DIGIT | SRG_RAND_ALPHA ; break ;
            default : --eci.it_exp ; return( eci.it_exp ) ;
            /*-------------------------------------------------------------*/
         }
         /*----------------------------------------------------------------*/
         exp_rand( eci, i_srg_rand, s_val ) ;
         /*----------------------------------------------------------------*/
         break ;
         /*----------------------------------------------------------------*/
      }

      /*--( Line extracted from the clipboard )----------------------------*/
      case 'C' :
      {
         /*----------------------------------------------------------------*/
         int i_num ;
         /*----------------------------------------------------------------*/
         if(    eci.it_exp < cit_exp_last
             && sr::bool_isdigit( *( eci.it_exp + 1 ) )
           )
         {  i_num = sr::char_value( *++eci.it_exp ) ; }
         else
         {  i_num = get_sel_num() + 1 ; }
         /*----------------------------------------------------------------*/
         exp_clipboard_line( eci, i_num, s_val ) ;
         /*----------------------------------------------------------------*/
         break ;
         /*----------------------------------------------------------------*/
      }

      /*--( File line )----------------------------------------------------*/
      case 'T' :
      {
         /*----------------------------------------------------------------*/
         int i_num ;
         /*----------------------------------------------------------------*/
         if(    eci.it_exp < cit_exp_last
             && sr::bool_isdigit( *( eci.it_exp + 1 ) )
           )
         {  i_num = sr::char_value( *++eci.it_exp ) ; }
         else
         {  i_num = get_sel_num() + 1 ; }
         /*----------------------------------------------------------------*/
         exp_file_line( eci, i_num, s_val ) ;
         /*----------------------------------------------------------------*/
         break ;
         /*----------------------------------------------------------------*/
      }

      /*--( MP3 V1 )-------------------------------------------------------*/
      case 'm' :
      {
         /*----------------------------------------------------------------*/
         e_col col_1   = COL_NB ;
         e_col col_2   = COL_NB ;
         bool  boo_num = false  ;
         /*----------------------------------------------------------------*/
         if( eci.it_exp >= cit_exp_last ) { return( eci.it_exp ) ; }
         /*----------------------------------------------------------------*/
         switch( ( *++eci.it_exp ).GetValue() )
         {
            /*-------------------------------------------------------------*/
            case 't' : col_1 = COL_ID3V1_TITLE  ;
                       col_2 = COL_AUDTAG_TITLE ;
                       break ;
            case 'a' : col_1 = COL_ID3V1_ARTIST  ;
                       col_2 = COL_AUDTAG_ARTIST ;
                       break ;
            case 'A' : col_1 = COL_ID3V1_ALBUM  ;
                       col_2 = COL_AUDTAG_ALBUM ;
                       break ;
            case 'y' : col_1 = COL_ID3V1_YEAR  ;
                       col_2 = COL_AUDTAG_YEAR ;
                       break ;
            case 'c' : col_1 = COL_ID3V1_COMMENT  ;
                       col_2 = COL_AUDTAG_COMMENT ;
                       break ;
            case 'T' : col_1 = COL_ID3V1_TRACK_NUM  ;
                       col_2 = COL_AUDTAG_TRACK_NUM ;
                       boo_num = true ;
                       break ;
            case 'g' : col_1 = COL_ID3V1_GENRE  ;
                       col_2 = COL_AUDTAG_GENRE ;
                       break ;
            default : --eci.it_exp ; break ;
            /*-------------------------------------------------------------*/
         }
         /*----------------------------------------------------------------*/
         if( boo_num )
         {  exp_track_pad( eci, col_1, col_2, s_val ) ; }
         else
         {  s_val = id3v1aud_equiv( col_1, col_2 ) ; }
         /*----------------------------------------------------------------*/
         break ;
         /*----------------------------------------------------------------*/
      }

      /*--( Audio and Audio Tag )------------------------------------------*/
      case 'A' :
      {
         /*----------------------------------------------------------------*/
         if( eci.it_exp >= cit_exp_last ) { return( eci.it_exp ) ; }
         /*----------------------------------------------------------------*/
         if( *++eci.it_exp == 'd' )
         {  /*-------------------------------------------------------------*/
            wxUniChar c_fmt ;
            /*-------------------------------------------------------------*/
            if(    eci.it_exp < cit_exp_last
                && (    *( eci.it_exp + 1 ) == 'h'
                     || *( eci.it_exp + 1 ) == 'm'
                     || *( eci.it_exp + 1 ) == 's'
                   )
              )
            {  c_fmt = *++eci.it_exp ; }
            else
            {  c_fmt = ' ' ; }
            /*-------------------------------------------------------------*/
            s_val = get_s_duration( COL_AUDIO_DURATION, c_fmt ) ;
            /*-------------------------------------------------------------*/
         }
         else
         {
            /*-------------------------------------------------------------*/
            e_col col_1   = COL_NB ;
            e_col col_2   = COL_NB ;
            bool  boo_num = false  ;
            /*-------------------------------------------------------------*/
            switch( ( *eci.it_exp ).GetValue() )
            {
               /*----------------------------------------------------------*/
               case 'b' : col_1 = COL_AUDIO_BITRATE    ; break ;
               case 's' : col_1 = COL_AUDIO_SAMPRATE   ; break ;
               case 'M' : col_1 = COL_AUDIO_CHANNEL    ; break ;
               case 'i' : col_1 = COL_AUDIO_INFO       ; break ;
               /*----------------------------------------------------------*/
               case 't' : col_1 = COL_AUDTAG_TITLE     ;
                          col_2 = COL_ID3V1_TITLE      ;
                          break ;
               case 'a' : col_1 = COL_AUDTAG_ARTIST    ;
                          col_2 = COL_ID3V1_ARTIST     ;
                          break ;
               case 'A' : col_1 = COL_AUDTAG_ALBUM     ;
                          col_2 = COL_ID3V1_ALBUM      ;
                          break ;
               case 'y' : col_1 = COL_AUDTAG_YEAR      ;
                          col_2 = COL_ID3V1_YEAR       ;
                          break ;
               case 'c' : col_1 = COL_AUDTAG_COMMENT   ;
                          col_2 = COL_ID3V1_COMMENT    ;
                          break ;
               case 'T' : col_1 = COL_AUDTAG_TRACK_NUM ;
                          col_2 = COL_ID3V1_TRACK_NUM  ;
                          boo_num = true               ;
                          break ;
               case 'g' : col_1 = COL_AUDTAG_GENRE     ;
                          col_2 = COL_ID3V1_GENRE      ;
                          break ;
               case 'n' : col_1 = COL_AUDTAG_TRACK_NB  ;
                          boo_num = true               ;
                          break ;
               case 'k' : col_1 = COL_AUDTAG_TRACK     ;
                          boo_num = true               ;
                          break ;
               case 'D' : col_1 = COL_AUDTAG_DISK      ;
                          break ;
               /*----------------------------------------------------------*/
               case 'p' : col_1 = COL_AUDTAG_COMPOS    ; break ;
               case 'o' : col_1 = COL_AUDTAG_ORG_ART   ; break ;
               case 'C' : col_1 = COL_AUDTAG_COPYRIGHT ; break ;
               case 'u' : col_1 = COL_AUDTAG_URL       ; break ;
               case 'e' : col_1 = COL_AUDTAG_ENCOD_BY  ; break ;
               /*----------------------------------------------------------*/
               case 'I' :
                  /*-------------------------------------------------------*/
                  if( eci.it_exp >= cit_exp_last ) { return( eci.it_exp ) ; }
                  /*-------------------------------------------------------*/
                  switch( ( *++eci.it_exp ).GetValue() )
                  {  case 'f' : col_1 = COL_AUDTAG_IMG_FORMAT ; break ;
                     default : --eci.it_exp ; break ;
                  }
                  /*-------------------------------------------------------*/
                  break ;
               /*----------------------------------------------------------*/
               default : --eci.it_exp ; break ;
               /*----------------------------------------------------------*/
            }
            /*-------------------------------------------------------------*/
            if( boo_num )
            {  exp_track_pad( eci, col_1, col_2, s_val ) ; }
            else
            {  s_val = id3v1aud_equiv( col_1, col_2 ) ; }
            /*-------------------------------------------------------------*/
         }
         /*----------------------------------------------------------------*/
         break ;
         /*----------------------------------------------------------------*/
      }

      /*--( Video )--------------------------------------------------------*/
      case 'V' :
      {
         /*----------------------------------------------------------------*/
         if( eci.it_exp >= cit_exp_last ) { return( eci.it_exp ) ; }
         /*----------------------------------------------------------------*/
         if( *++eci.it_exp == 'd' )
         {  /*-------------------------------------------------------------*/
            wxUniChar c_fmt ;
            /*-------------------------------------------------------------*/
            if(    eci.it_exp < cit_exp_last
                && (    *( eci.it_exp + 1 ) == 'h'
                     || *( eci.it_exp + 1 ) == 'm'
                     || *( eci.it_exp + 1 ) == 's'
                   )
              )
            {  c_fmt = *++eci.it_exp ; }
            else
            {  c_fmt = ' ' ; }
            /*-------------------------------------------------------------*/
            s_val = get_s_duration( COL_VIDEO_DURATION, c_fmt ) ;
            /*-------------------------------------------------------------*/
         }
         else
         {
            /*-------------------------------------------------------------*/
            e_col col          = COL_NB ;
            bool  boo_date_col = false  ;
            /*-------------------------------------------------------------*/
            switch( ( *eci.it_exp ).GetValue() )
            {  /*----------------------------------------------------------*/
               case 'x' : col = COL_VIDEO_X           ; break ;
               case 'y' : col = COL_VIDEO_Y           ; break ;
               case 's' : col = COL_VIDEO_SAMPRATE    ; break ;
               case 'M' : col = COL_VIDEO_CHANNEL     ; break ;
               /*----------------------------------------------------------*/
               case 'f' : col = COL_VIDEO_FPS         ; break ;
               case 'i' : col = COL_VIDEO_INFO        ; break ;
               /*----------------------------------------------------------*/
               case 't' : col = COL_VIDTAG_TITLE      ; break ;
               case 'U' : col = COL_VIDTAG_SUBJECT    ; break ;
               case 'a' : col = COL_VIDTAG_ARTIST     ; break ;
               case 'c' : col = COL_VIDTAG_COMMENT    ; break ;
               case 'k' : col = COL_VIDTAG_KEYWORDS   ; break ;
               case 'E' : col = COL_VIDTAG_ENGINEER   ; break ;
               case 'T' : col = COL_VIDTAG_TECHNICIAN ; break ;
               case 'g' : col = COL_VIDTAG_GENRE      ; break ;
               case 'n' : col = COL_VIDTAG_CRE_DATE   ; break ;
               case 'O' : col = COL_VIDTAG_SOURCE     ; break ;
               case 'C' : col = COL_VIDTAG_COPYRIGHT  ; break ;
               case 'S' : col = COL_VIDTAG_SOFTWARE   ; break ;
               /*----------------------------------------------------------*/
               case 'I' :
                  /*-------------------------------------------------------*/
                  if( eci.it_exp >= cit_exp_last ) { return( eci.it_exp ) ; }
                  /*-------------------------------------------------------*/
                  switch( ( *++eci.it_exp ).GetValue() )
                  {  case 'f' : col = COL_VIDTAG_IMG_FORMAT ; break ;
                     default : --eci.it_exp ; break ;
                  }
                  /*-------------------------------------------------------*/
                  break ;
               /*--( DV Data )---------------------------------------------*/
               case 'D' :
                  /*-------------------------------------------------------*/
                  if( eci.it_exp >= cit_exp_last ) { return( eci.it_exp ) ; }
                  /*-------------------------------------------------------*/
                  switch( ( *++eci.it_exp ).GetValue() )
                  {  case 'd' :
                        col = COL_VIDTAG_DV_DATE ;
                        boo_date_col = true      ;
                        break ;
                     case 't' :
                        col = COL_VIDTAG_DV_TIMECODE ;
                        break ;
                     default : --eci.it_exp ; break ;
                  }
                  /*-------------------------------------------------------*/
                  break ;
               /*----------------------------------------------------------*/
               default : --eci.it_exp ; break ;
               /*----------------------------------------------------------*/
            }
            /*-------------------------------------------------------------*/
            if( boo_date_col )
            {  exp_date( eci, col, s_val ) ; }
            else
            {  s_val = get_s_val( col ) ; }
            /*-------------------------------------------------------------*/
         }
         /*----------------------------------------------------------------*/
         break ;
         /*----------------------------------------------------------------*/
      }

      /*--( Image "base" )-------------------------------------------------*/
      case 'I' :
      {
         /*----------------------------------------------------------------*/
         e_col col = COL_NB ;
         /*----------------------------------------------------------------*/
         if( eci.it_exp >= cit_exp_last ) { return( eci.it_exp ) ; }
         /*----------------------------------------------------------------*/
         switch( ( *++eci.it_exp ).GetValue() )
         {  /*-------------------------------------------------------------*/
            case 'x' : col = COL_IMG_X    ; break ;
            case 'y' : col = COL_IMG_Y    ; break ;
            case 'b' : col = COL_IMG_BPP  ; break ;
            case 'i' : col = COL_IMG_INFO ; break ;
            /*-------------------------------------------------------------*/
            default : --eci.it_exp ; break ;
            /*-------------------------------------------------------------*/
         }
         /*----------------------------------------------------------------*/
         s_val = get_s_val( col ) ;
         /*----------------------------------------------------------------*/
         break ;
         /*----------------------------------------------------------------*/
      }

      /*--( Exif )---------------------------------------------------------*/
      case 'X' :
      {
         /*--( An Exif variable name is 3 characters long )----------------*/
         if( eci.it_exp >= cit_exp_last - 1 ) { return( eci.it_exp ) ; }
         /*----------------------------------------------------------------*/
         e_col col          = COL_NB ;
         bool  boo_date_col = false  ;
         char  c1, c2                ;
         /*----------------------------------------------------------------*/
         c1 = *++eci.it_exp ;
         c2 = *++eci.it_exp ;
         /*----------------------------------------------------------------*/
         if( c1 == 'd' && c2 == 'e' )
         {  col = COL_EXIF_IMAGEDESCRIPTION ; }
         else if( c1 == 'm' && c2 == 'k' )
         {  col = COL_EXIF_MAKE ; }
         else if( c1 == 'm' && c2 == 'o' )
         {  col = COL_EXIF_MODEL ; }
         else if( c1 == 'o' && c2 == 'r' )
         {  col = COL_EXIF_ORIENTATION ; }
         else if( c1 == 'x' && c2 == 'r' )
         {  col = COL_EXIF_XRESOLUTION ; }
         else if( c1 == 'y' && c2 == 'r' )
         {  col = COL_EXIF_YRESOLUTION ; }
         else if( c1 == 'r' && c2 == 'u' )
         {  col = COL_EXIF_RESOLUTIONUNIT ; }
         else if( c1 == 's' && c2 == 'o' )
         {  col = COL_EXIF_SOFTWARE ; }
         else if( c1 == 'a' && c2 == 'r' )
         {  col = COL_EXIF_ARTIST ; }
         else if( c1 == 'd' && c2 == 't' )
         {  col = COL_EXIF_DATETIME          ; boo_date_col = true ; }
         else if( c1 == 'S' && c2 == 't' )
         {  col = COL_EXIF_SUBSECTIME  ; }
         else if( c1 == 'd' && c2 == 'o' )
         {  col = COL_EXIF_DATETIMEORIGINAL  ; boo_date_col = true ; }
         else if( c1 == 'S' && c2 == 'o' )
         {  col = COL_EXIF_SUBSECTIMEORIGINAL ; }
         else if( c1 == 'd' && c2 == 'd' )
         {  col = COL_EXIF_DATETIMEDIGITIZED ; boo_date_col = true ; }
         else if( c1 == 'S' && c2 == 'd' )
         {  col = COL_EXIF_SUBSECTIMEDIGITIZED ; }
         else if( c1 == 'w' && c2 == 'p' )
         {  col = COL_EXIF_WHITEPOINT ; }
         else if( c1 == 'p' && c2 == 'c' )
         {  col = COL_EXIF_PRIMARYCHROMATICITIES ; }
         else if( c1 == 'y' && c2 == 'c' )
         {  col = COL_EXIF_YCBCRCOEFFICIENTS ; }
         else if( c1 == 'y' && c2 == 'p' )
         {  col = COL_EXIF_YCBCRPOSITIONING ; }
         else if( c1 == 'b' && c2 == 'w' )
         {  col = COL_EXIF_REFERENCEBLACKWHITE ; }
         else if( c1 == 'c' && c2 == 'y' )
         {  col = COL_EXIF_COPYRIGHT ; }
         else if( c1 == 'e' && c2 == 'o' )
         {  col = COL_EXIF_EXIFOFFSET ; }
         else if( c1 == 'g' && c2 == 'o' )
         {  col = COL_EXIF_GPSOFFSET ; }
         else if( c1 == 't' && c2 == 'o' )
         {  col = COL_EXIF_THUMBNAIL_OFFSET ; }
         else if( c1 == 't' && c2 == 's' )
         {  col = COL_EXIF_THUMBNAIL_SIZE ; }
         else if( c1 == 'e' && c2 == 't' )
         {  col = COL_EXIF_EXPOSURETIME ; }
         else if( c1 == 'f' && c2 == 'n' )
         {  col = COL_EXIF_FNUMBER ; }
         else if( c1 == 'e' && c2 == 'p' )
         {  col = COL_EXIF_EXPOSUREPROGRAM ; }
         else if( c1 == 's' && c2 == 'y' )
         {  col = COL_EXIF_SPECTRALSENSITIVITY ; }
         else if( c1 == 's' && c2 == 'r' )
         {  col = COL_EXIF_ISOSPEEDRATINGS ; }
         else if( c1 == 'v' && c2 == 'e' )
         {  col = COL_EXIF_EXIFVERSION ; }
         else if( c1 == 'c' && c2 == 'c' )
         {  col = COL_EXIF_COMPONENTCONFIGURATION ; }
         else if( c1 == 'b' && c2 == 'p' )
         {  col = COL_EXIF_COMPRESSEDBITSPERPIXEL ; }
         else if( c1 == 's' && c2 == 's' )
         {  col = COL_EXIF_SHUTTERSPEEDVALUE ; }
         else if( c1 == 'a' && c2 == 'v' )
         {  col = COL_EXIF_APERTUREVALUE ; }
         else if( c1 == 'b' && c2 == 'v' )
         {  col = COL_EXIF_BRIGHTNESSVALUE ; }
         else if( c1 == 'e' && c2 == 'v' )
         {  col = COL_EXIF_EXPOSUREBIASVALUE ; }
         else if( c1 == 'm' && c2 == 'a' )
         {  col = COL_EXIF_MAXAPERTUREVALUE ; }
         else if( c1 == 's' && c2 == 'd' )
         {  col = COL_EXIF_SUBJECTDISTANCE ; }
         else if( c1 == 'm' && c2 == 'm' )
         {  col = COL_EXIF_METERINGMODE ; }
         else if( c1 == 'l' && c2 == 's' )
         {  col = COL_EXIF_LIGHTSOURCE ; }
         else if( c1 == 'f' && c2 == 'a' )
         {  col = COL_EXIF_FLASH ; }
         else if( c1 == 'f' && c2 == 'l' )
         {  col = COL_EXIF_FOCALLENGTH ; }
         else if( c1 == 'f' && c2 == 'e' )
         {  col = COL_EXIF_FLASHENERGY ; }
         else if( c1 == 'u' && c2 == 'c' )
         {  col = COL_EXIF_USERCOMMENT ; }
         else if( c1 == 'f' && c2 == 'v' )
         {  col = COL_EXIF_FLASHPIXVERSION ; }
         else if( c1 == 'c' && c2 == 's' )
         {  col = COL_EXIF_COLORSPACE ; }
         else if( c1 == 'i' && c2 == 'w' )
         {  col = COL_EXIF_EXIFIMAGEWIDTH ; }
         else if( c1 == 'i' && c2 == 'h' )
         {  col = COL_EXIF_EXIFIMAGEHEIGHT ; }
         else if( c1 == 's' && c2 == 'f' )
         {  col = COL_EXIF_RELATEDSOUNDFILE ; }
         else if( c1 == 'f' && c2 == 'x' )
         {  col = COL_EXIF_FOCALPLANEXRESOLUTION ; }
         else if( c1 == 'f' && c2 == 'y' )
         {  col = COL_EXIF_FOCALPLANEYRESOLUTION ; }
         else if( c1 == 'f' && c2 == 'u' )
         {  col = COL_EXIF_FOCALPLANERESOLUTIONUNIT ; }
         else if( c1 == 'e' && c2 == 'i' )
         {  col = COL_EXIF_EXPOSUREINDEX ; }
         else if( c1 == 's' && c2 == 'm' )
         {  col = COL_EXIF_SENSINGMETHOD ; }
         else if( c1 == 'f' && c2 == 's' )
         {  col = COL_EXIF_FILESOURCE ; }
         else if( c1 == 's' && c2 == 't' )
         {  col = COL_EXIF_SCENETYPE ; }
         else if( c1 == 'c' && c2 == 'r' )
         {  col = COL_EXIF_CUSTOMRENDERED ; }
         else if( c1 == 'e' && c2 == 'm' )
         {  col = COL_EXIF_EXPOSUREMODE ; }
         else if( c1 == 'w' && c2 == 'b' )
         {  col = COL_EXIF_WHITEBALANCE ; }
         else if( c1 == 'd' && c2 == 'z' )
         {  col = COL_EXIF_DIGITALZOOMRATIO ; }
         else if( c1 == 'f' && c2 == 'L' )
         {  col = COL_EXIF_FOCALLENGTHIN35MMFILM ; }
         else if( c1 == 's' && c2 == 'c' )
         {  col = COL_EXIF_SCENECAPTURETYPE ; }
         else if( c1 == 'g' && c2 == 'c' )
         {  col = COL_EXIF_GAINCONTROL ; }
         else if( c1 == 'c' && c2 == 't' )
         {  col = COL_EXIF_CONTRAST ; }
         else if( c1 == 's' && c2 == 'u' )
         {  col = COL_EXIF_SATURATION ; }
         else if( c1 == 's' && c2 == 'h' )
         {  col = COL_EXIF_SHARPNESS ; }
         else if( c1 == 's' && c2 == 'D' )
         {  col = COL_EXIF_SUBJECTDISTANCERANGE ; }
         else if( c1 == 'u' && c2 == 'i' )
         {  col = COL_EXIF_IMAGEUNIQUEID ; }
         else if( c1 == 'g' && c2 == 'v' )
         {  col = COL_EXIF_GPSVERSIONID ; }
         else if( c1 == 'l' && c2 == 'A' )
         {  col = COL_EXIF_GPSLATITUDEREF ; }
         else if( c1 == 'l' && c2 == 'a' )
         {  col = COL_EXIF_GPSLATITUDE ; }
         else if( c1 == 'l' && c2 == 'O' )
         {  col = COL_EXIF_GPSLONGITUDEREF ; }
         else if( c1 == 'l' && c2 == 'o' )
         {  col = COL_EXIF_GPSLONGITUDE ; }
         else if( c1 == 'a' && c2 == 'L' )
         {  col = COL_EXIF_GPSALTITUDEREF ; }
         else if( c1 == 'a' && c2 == 'l' )
         {  col = COL_EXIF_GPSALTITUDE ; }
         else if( c1 == 'T' && c2 == 'S' )
         {  col = COL_EXIF_GPSTIMESTAMP ; }
         else if( c1 == 's' && c2 == 'a' )
         {  col = COL_EXIF_GPSSATELLITES ; }
         else if( c1 == 'u' && c2 == 's' )
         {  col = COL_EXIF_GPSSTATUS ; }
         else if( c1 == 'm' && c2 == 'M' )
         {  col = COL_EXIF_GPSMEASUREMODE ; }
         else if( c1 == 'd' && c2 == 'p' )
         {  col = COL_EXIF_GPSDOP ; }
         else if( c1 == 's' && c2 == 'P' )
         {  col = COL_EXIF_GPSSPEEDREF ; }
         else if( c1 == 's' && c2 == 'p' )
         {  col = COL_EXIF_GPSSPEED ; }
         else if( c1 == 't' && c2 == 'R' )
         {  col = COL_EXIF_GPSTRACKREF ; }
         else if( c1 == 't' && c2 == 'r' )
         {  col = COL_EXIF_GPSTRACK ; }
         else if( c1 == 'i' && c2 == 'D' )
         {  col = COL_EXIF_GPSIMGDIRECTIONREF ; }
         else if( c1 == 'i' && c2 == 'd' )
         {  col = COL_EXIF_GPSIMGDIRECTION ; }
         else if( c1 == 'm' && c2 == 'd' )
         {  col = COL_EXIF_GPSMAPDATUM ; }
         else if( c1 == 'L' && c2 == 'A' )
         {  col = COL_EXIF_GPSDESTLATITUDEREF ; }
         else if( c1 == 'L' && c2 == 'a' )
         {  col = COL_EXIF_GPSDESTLATITUDE ; }
         else if( c1 == 'L' && c2 == 'O' )
         {  col = COL_EXIF_GPSDESTLONGITUDEREF ; }
         else if( c1 == 'L' && c2 == 'o' )
         {  col = COL_EXIF_GPSDESTLONGITUDE ; }
         else if( c1 == 'b' && c2 == 'E' )
         {  col = COL_EXIF_GPSDESTBEARINGREF ; }
         else if( c1 == 'b' && c2 == 'e' )
         {  col = COL_EXIF_GPSDESTBEARING ; }
         else if( c1 == 'D' && c2 == 'R' )
         {  col = COL_EXIF_GPSDESTDISTANCEREF ; }
         else if( c1 == 'D' && c2 == 'r' )
         {  col = COL_EXIF_GPSDESTDISTANCE ; }
         else
         {  eci.it_exp -= 2 ; }
         /*----------------------------------------------------------------*/
         if( boo_date_col )
         {  exp_date( eci, col, s_val ) ; }
         else
         {  s_val = get_s_val( col ) ; }
         /*----------------------------------------------------------------*/
         break ;
         /*----------------------------------------------------------------*/
      }

      /*--( IPTC )---------------------------------------------------------*/
      case 'Y' :
      {
         /*--( An IPTC variable name is 3 characters long )----------------*/
         if( eci.it_exp >= cit_exp_last - 1 ) { return( eci.it_exp ) ; }
         /*----------------------------------------------------------------*/
         e_col col          = COL_NB ;
         bool  boo_date_col = false  ;
         char  c1, c2                ;
         /*----------------------------------------------------------------*/
         c1 = *++eci.it_exp ;
         c2 = *++eci.it_exp ;
         /*----------------------------------------------------------------*/
         if( c1 == 'b' && c2 == 'l' )
         {  col = COL_IPTC_BYLINE ; }
         else if( c1 == 'b' && c2 == 't' )
         {  col = COL_IPTC_BYLINE_TITLE ; }
         else if( c1 == 'c' && c2 == 'y' )
         {  col = COL_IPTC_COPYRIGHT ; }
         else if( c1 == 'c' && c2 == 'r' )
         {  col = COL_IPTC_CREDIT ; }
         else if( c1 == 's' && c2 == 'r' )
         {  col = COL_IPTC_SOURCE ; }
         else if( c1 == 'c' && c2 == 'w' )
         {  col = COL_IPTC_CAPTION_WRITER ; }
         else if( c1 == 'c' && c2 == 'p' )
         {  col = COL_IPTC_CAPTION ; }
         else if( c1 == 'h' && c2 == 'l' )
         {  col = COL_IPTC_HEADLINE ; }
         else if( c1 == 's' && c2 == 'i' )
         {  col = COL_IPTC_SPECIAL_INSTR ; }
         else if( c1 == 'o' && c2 == 'n' )
         {  col = COL_IPTC_OBJECT_NAME ; }
         else if( c1 == 'd' && c2 == 'c' )
         {  col = COL_IPTC_DATETIME_CREATED  ; boo_date_col = true ; }
         else if( c1 == 'd' && c2 == 'r' )
         {  col = COL_IPTC_DATETIME_RELEASED ; boo_date_col = true ; }
         else if( c1 == 'c' && c2 == 't' )
         {  col = COL_IPTC_CITY ; }
         else if( c1 == 's' && c2 == 'l' )
         {  col = COL_IPTC_SUBLOCATION ; }
         else if( c1 == 's' && c2 == 't' )
         {  col = COL_IPTC_STATE ; }
         else if( c1 == 'c' && c2 == 'c' )
         {  col = COL_IPTC_COUNTRY_CODE ; }
         else if( c1 == 'c' && c2 == 'o' )
         {  col = COL_IPTC_COUNTRY ; }
         else if( c1 == 'o' && c2 == 't' )
         {  col = COL_IPTC_ORIGINAL_TRSF ; }
         else if( c1 == 'c' && c2 == 'a' )
         {  col = COL_IPTC_CATEGORY ; }
         else if( c1 == 's' && c2 == 'c' )
         {  col = COL_IPTC_SUPPL_CATEGORIES ; }
         else if( c1 == 'e' && c2 == 's' )
         {  col = COL_IPTC_EDIT_STATUS ; }
         else if( c1 == 'j' && c2 == 'i' )
         {  col = COL_IPTC_JOBID ; }
         else if( c1 == 'p' && c2 == 'g' )
         {  col = COL_IPTC_PROGRAM ; }
         else if( c1 == 'p' && c2 == 'v' )
         {  col = COL_IPTC_PROGRAM_VERSION ; }
         else if( c1 == 'p' && c2 == 'r' )
         {  col = COL_IPTC_PRIORITY ; }
         else if( c1 == 'o' && c2 == 'c' )
         {  col = COL_IPTC_OBJECT_CYCLE ; }
         else if( c1 == 'k' && c2 == 'w' )
         {  col = COL_IPTC_KEYWORDS ; }
         else { eci.it_exp -= 2 ; }
         /*----------------------------------------------------------------*/
         if( boo_date_col )
         {  exp_date( eci, col, s_val ) ; }
         else
         {  s_val = get_s_val( col ) ; }
         /*----------------------------------------------------------------*/
         break ;
         /*----------------------------------------------------------------*/
      }

      /*--( Office/PDF/HTML/Executable/DEB/TTF ... )-----------------------*/
      case 'O' :
      {
         /*----------------------------------------------------------------*/
         e_col col          = COL_NB ;
         bool  boo_date_col = false  ;
         /*----------------------------------------------------------------*/
         if( eci.it_exp >= cit_exp_last ) { return( eci.it_exp ) ; }
         /*----------------------------------------------------------------*/
         switch( ( *++eci.it_exp ).GetValue() )
         {  /*-------------------------------------------------------------*/
            case 't' : col = COL_DOC_TITLE       ; break ;
            case 's' : col = COL_DOC_SUBJECT     ; break ;
            case 'v' : col = COL_DOC_VERSION     ; break ;
            case 'a' : col = COL_DOC_AUTHOR      ; break ;
            case 'd' : col = COL_DOC_DESTINATION ; break ;
            case 'c' : col = COL_DOC_COMMENT     ; break ;
            case 'i' : col = COL_DOC_INFO        ; break ;
            case 'I' : col = COL_DOC_ID          ; break ;
            case 'k' : col = COL_DOC_KEYWORDS    ; break ;
            case 'A' : col = COL_DOC_APPLICATION ; break ;
            case 'N' : col = COL_DOC_COMPANY     ; break ;
            case 'C' : col = COL_DOC_COPYRIGHT   ; break ;
            case 'T' : col = COL_DOC_TRADEMARKS  ; break ;
            case 'u' : col = COL_DOC_URL         ; break ;
            /*-------------------------------------------------------------*/
            case 'n' : col = COL_DOC_CRE_DATE ;
                       boo_date_col = true    ;
                       break ;
            case 'm' : col = COL_DOC_MOD_DATE ;
                       boo_date_col = true    ;
                       break ;
            /*-------------------------------------------------------------*/
            case 'F' : col = COL_DOC_FILECOUNT   ; break ;
            case 'P' : col = COL_DOC_PAGECOUNT   ; break ;
            case 'L' : col = COL_DOC_LINECOUNT   ; break ;
            case 'W' : col = COL_DOC_WORDCOUNT   ; break ;
            case 'B' : col = COL_DOC_CHARCOUNT   ; break ;
            /*-------------------------------------------------------------*/
            default : --eci.it_exp ; break ;
            /*-------------------------------------------------------------*/
         }
         /*----------------------------------------------------------------*/
         if( boo_date_col )
         {  exp_date( eci, col, s_val ) ; }
         else
         {  s_val = get_s_val( col ) ; }
         /*----------------------------------------------------------------*/
         break ;
         /*----------------------------------------------------------------*/
      }

      /*-------------------------------------------------------------------*/
      default : s_val = wxEmptyString ; break ;
      /*-------------------------------------------------------------------*/
   }

   /*-----------------------------------------------------------------------+
   !                                                                        !
   ! Then can follow many string modifiers                                  !
   !                                                                        !
   +-----------------------------------------------------------------------*/
   i_ret = 0 ;
   /*----------------------------------------------------------------------*/
   while(    eci.it_exp < cit_exp_last
          && ( *( eci.it_exp + 1 ) == '[' || *( eci.it_exp + 1 ) == '(' )
          && i_ret == 0
        )
   {
      /*-------------------------------------------------------------------*/
      if( *++eci.it_exp == '[' )
      {  i_ret = exp_string_tab_elmt( eci, s_val ) ; }
      else
      {
         /*--( If it is not a bracket then it is a parenthesis )-----------*/
         sr::next_non_space( cit_exp_last, ++eci.it_exp ) ;
         if( eci.it_exp <= cit_exp_last )
         {
            /*-------------------------------------------------------------*/
            wxString        s_param   ;
            t_exp_comp_info eci_param ;
            int             i_val     ;

            /*--------------------------------------------------------------+
            ! Modifier parameters can be variables with all the associated  !
            ! modifiers.                                                    !
            ! First modifier parameter is a one ?                           !
            +--------------------------------------------------------------*/
            if( *eci.it_exp == '%' )
            {
               /*-----------------------------------------------------------+
               ! It is "computed" and the result will be used as a value.   !
               ! After this call "it_exp" will point after the variable     !
               +-----------------------------------------------------------*/
               extr_compute_variable( eci, s_param ) ;
               /*--( The next char will help to identify the modifier )----*/
               sr::next_non_space( eci.it_exp_end, eci.it_exp ) ;
               /*--( Spaces are allowed in front of the variable content )-*/
               eci_param.boo_first_sub_exp = true ;
               eci_param.it_exp = s_param.begin() ;
               eci_param.it_exp_end = s_param.end() ;
               sr::next_non_space( eci_param.it_exp_end, eci_param.it_exp ) ;
               /*----------------------------------------------------------*/
            }

            /*--------------------------------------------------------------+
            ! Now the modifier has to be identified ...                     !
            ! Regular expression, replace or substr                         !
            +--------------------------------------------------------------*/

            /*--------------------------------------------------------------+
            ! If "s_param" is not empty it may contain the regular          !
            ! expression or a transliteration                               !
            +--------------------------------------------------------------*/
            if(    s_param.size() > 3
                && eci.it_exp <= cit_exp_last
                && *eci.it_exp == ')'
                && *eci_param.it_exp == 's'
                && *( eci_param.it_exp + 1 ) == '/'
              )
            {  i_ret = exp_regex( eci_param, s_val ) ; }
            else /*--( Regular expression written "in clear" )-------------*/
            if( s_param.empty() && *eci.it_exp == 's' )
            {  i_ret = exp_regex( eci, s_val ) ; }
            else
            if(    s_param.size() > 4
                && eci.it_exp <= cit_exp_last
                && *eci.it_exp == ')'
                && *eci_param.it_exp == 't'
                && *( eci_param.it_exp + 1 ) == 'r'
                && *( eci_param.it_exp + 2 ) == '/'
              )
            {  i_ret = exp_tr( eci_param, s_val ) ; }
            else /*--( Transliteration written "in clear" )----------------*/
            if( s_param.empty() && *eci.it_exp == 't' )
            {  i_ret = exp_tr( eci, s_val ) ; }
            else /*--( Replacement ? )-------------------------------------*/
            if(    (    !s_param.empty()
                     &&    extr_integer( eci_param, i_val )
                        != eci_param.it_exp_end
                   )
                || (    s_param.empty()
                     && sr::is_string_delimiter( *eci.it_exp )
                   )
              )
            {  i_ret = exp_replace( eci, s_param, s_val ) ; }
            else /*--( Substring extraction ? (by position) )--------------*/
            {  i_ret = exp_substr( eci, s_param, s_val ) ; }
            /*-------------------------------------------------------------*/
         }
         /*--( The closing parenthesis should be here )--------------------*/
         if( eci.it_exp < cit_exp_last && *eci.it_exp != ')' )
         {  i_ret = -100 ; }
         /*----------------------------------------------------------------*/
      }
      /*-------------------------------------------------------------------*/
   }

   /*--( If it went bad then clean ... )-----------------------------------*/
   if( i_ret != 0 ) { s_val.clear() ; }

   /*--( Useful to continue ? )--------------------------------------------*/
   if( s_val.empty() ) { return( eci.it_exp ) ; }

   /*-----------------------------------------------------------------------+
   ! The character modifiers previously extracted are now applied.          !
   ! The "percent" replacement can generate accented chars. That's why it   !
   ! is applied first.                                                      !
   ! These characters can be part of an UTF8-ascii sequence. That's why it  !
   ! is applied second.                                                     !
   +-----------------------------------------------------------------------*/
   if( boo_repl_percent_xx )
   {  s_val = sr::replace_percent_xx( s_val, sr::CLS_DO_CLEAN_STRING ) ; }
   /*----------------------------------------------------------------------*/
   if( boo_conv_ascii_utf8 )
   {  s_val = sr::convert_ascii_utf8( s_val, sr::CLS_DO_CLEAN_STRING ) ; }
   /*----------------------------------------------------------------------*/
   if( boo_del_accent ) { s_val = sr::unaccent( s_val ) ; }

   /*--( Only one case modifier applied: the last specified one )----------*/
   switch( c_mod_case.GetValue() )
   {
      /*-------------------------------------------------------------------*/
      case 'u' :
         sr::fcw_upper( s_val, fcw_force_case ) ;
         break ;
      case 'U' :
         sr::fcw_upper_first_word_letter( s_val, fcw_force_case ) ;
         break ;
      case 'l' :
         sr::fcw_lower( s_val, fcw_force_case ) ;
         break ;
      case 'L' :
         sr::fcw_upper_first_letter_lower_rest( s_val, fcw_force_case ) ;
         break ;
      /*-------------------------------------------------------------------*/
      default :
         if( fcw_force_case == sr::FCW_DO_FORCE_CASE )
         {  sr::fcw_update( s_val ) ; }
         break ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   return( eci.it_exp ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
sr::wxString_cit CFile::compute_exp_variable( t_exp_comp_info &eci,
                                              wxString        &s_val
                                            ) const
{
   /*--( An access to the parent container may be needed )-----------------*/
   if( get_cdir() == NULL ) { wxFAIL ; return( eci.it_exp_end ) ; }

   /*----------------------------------------------------------------------*/
   s_val.clear() ;

   /*-----------------------------------------------------------------------+
   ! Only a "variable" expression is evaluated. It must begin with a '%'    !
   +-----------------------------------------------------------------------*/
   if( eci.it_exp >= eci.it_exp_end - 1 || *eci.it_exp != '%' )
   {  return( eci.it_exp ) ; }
   /*--( Jump over the '%' )-----------------------------------------------*/
   ++eci.it_exp ;

   /*-----------------------------------------------------------------------+
   ! Then can follow the "group" information in the following form :        !
   ! < size , ind >                                                         !
   ! - size : number of members in the group                                !
   ! - ind  : the member in the group ( 1 <= N <= size ) default value is 1 !
   +-----------------------------------------------------------------------*/
   if( eci.it_exp >= eci.it_exp_end || *eci.it_exp != '<' )
   {  return( compute_exp_variable_base( eci, s_val ) ) ; }
   /*--( Skip the '<' )----------------------------------------------------*/
   ++eci.it_exp ;

   /*----------------------------------------------------------------------*/
   int i_group_size = -1 ; // No default value for the group size
   int i_group_ind  =  0 ; // Default is the first member of the group

   /*--( Size of the file group : number consecutive selected files )------*/
   extr_integer( eci, i_group_size ) ;
   if( i_group_size <= 0 || eci.it_exp == eci.it_exp_end )
   {  return( eci.it_exp_end ) ; }

   /*--( A position in the group is defined ? )----------------------------*/
   if( *eci.it_exp == ',' )
   {
      /*-------------------------------------------------------------------*/
      ++eci.it_exp ;
      /*-------------------------------------------------------------------*/
      extr_integer( eci, i_group_ind ) ;
      if( eci.it_exp == eci.it_exp_end ) { return( eci.it_exp_end ) ; }
      /*--( Internally the position start at 0 )---------------------------*/
      --i_group_ind ;
      /*--( Minimal control )----------------------------------------------*/
      if( i_group_ind < 0 || i_group_ind >= i_group_size )
      {  return( eci.it_exp_end ) ; }
      /*-------------------------------------------------------------------*/
   }

   /*--( Here should be the closing element )------------------------------*/
   if( *eci.it_exp != '>' ) { return( eci.it_exp_end ) ; }
   /*--( Skip it )---------------------------------------------------------*/
   ++eci.it_exp ;

   /*--( Group size set to 1 means ... no group )--------------------------*/
   if( i_group_size == 1 )
   {  return( compute_exp_variable_base( eci, s_val ) ) ; }

   /*-----------------------------------------------------------------------+
   ! Find the file to which this couple refers                              !
   +-----------------------------------------------------------------------*/
   int i_sel_num= get_sel_num() - get_sel_num() % i_group_size + i_group_ind;
   if( i_sel_num >= get_cdir()->get_nb_sel() )
   {  return( eci.it_exp_end ) ; }

   /*--( Conversion from selection number to "real" indice of the file )---*/
   int i_num = get_cdir()->get_sel_file_num( i_sel_num ) ;

   /*--( The value computed is extracted from this file )------------------*/
   return( ( *get_cdir() )[ i_num ].compute_exp_variable_base( eci, s_val ));
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                      End of file CFile_CompVar.cpp                        !
+==========================================================================*/
