/*====================================+=====================================+
! File CFavourite.cpp                 ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include <wx/menu.h>
#include "CApp.h"
#include "siren.h"
#include "common/sr_lib.h"
#include "dynmenu/CFavourite.h"
#include "CCombo.h"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
CDlgFavEdit::CDlgFavEdit( wxWindow *parent, CDynMenu *p_dm )
           : CDlgDynMenuEdit( parent, p_dm )
{
   /*----------------------------------------------------------------------*/
   SetTitle( _( "Favourite" ) ) ;
   m_st_name->SetLabel( _( "Name" ) ) ;
   m_st_exp->SetLabel( _( "Expression" ) ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CDlgFavEdit::~CDlgFavEdit()
{  ; }

/*-------------------------------------------------------------------------*/
int CDlgFavEdit::validate_data()
{
   /*----------------------------------------------------------------------*/
   if( m_s_exp->GetValue().empty() )
   {  sr::error_message( _( "The expression is mandatory" ) ) ;
      return( -1 ) ;
   }
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CDlgFav::CDlgFav( CDynMenu *p_dm ) : CDlgDynMenu( p_dm )
{
   /*----------------------------------------------------------------------*/
   SetTitle( _( "Favourites" ) ) ;
   /*-----------------------------------------------------------------------+
   ! This help is mainly used for the Tools.                                !
   ! It is useless and therefore hidden for the favourites.                 !
   +-----------------------------------------------------------------------*/
   m_st_help->Hide() ;
   /*----------------------------------------------------------------------*/
   m_lv->InsertColumn( 0, _( "Name" ), wxLIST_FORMAT_LEFT,
                       m_p_dm->M_i_list_colw_name.get()
                     ) ;
   m_lv->InsertColumn( 1, _( "Expression" ), wxLIST_FORMAT_LEFT,
                       m_p_dm->M_i_list_colw_exp.get()
                     ) ;
   /*----------------------------------------------------------------------*/
   wxGetApp().init_tlw_rect( this, m_p_dm->M_rec_dlg ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CDlgFav::~CDlgFav()
{  ; }

/*-------------------------------------------------------------------------*/
CFavourite::CFavourite() : CDynMenu( 3, FAV_MENU_ID_START )
{  ; }

/*-------------------------------------------------------------------------*/
CFavourite::~CFavourite()
{  ; }

/*--------------------------------------------------------------------------+
! These elements are supposed to serve as examples and therefore are        !
! created at very first start                                               !
+--------------------------------------------------------------------------*/
void CFavourite::create_default_elmts()
{
   /*--( Add some expressions to "help" )----------------------------------*/
   M_tb_s_name.set( m_i_nb_active, _( "Example : &Uppercase" ) ) ;
   M_tb_s_exp.set(  m_i_nb_active, "%uf" ) ;
   ++m_i_nb_active ;
   /*----------------------------------------------------------------------*/
   M_tb_s_name.set( m_i_nb_active, _( "Example : Prefix with a &number" ) ) ;
   M_tb_s_exp.set(  m_i_nb_active, "%n_%f" ) ;
   ++m_i_nb_active ;
   /*----------------------------------------------------------------------*/
   M_tb_s_name.set( m_i_nb_active, _( "Example : Timestamp &photo" ) ) ;
   M_tb_s_exp.set(  m_i_nb_active, "%b_%Xdo.%e" ) ;
   ++m_i_nb_active ;
   /*----------------------------------------------------------------------*/
   M_tb_s_name.set( m_i_nb_active,
                    _( "Example : Replace &dots with spaces" )
                  ) ;
   M_tb_s_exp.set(  m_i_nb_active, "%b(\".\",\" \").%e" ) ;
   ++m_i_nb_active ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFavourite::add()
{
   /*----------------------------------------------------------------------*/
   CDlgFavEdit dlg( wxGetApp().m_frame, this ) ;
   CDynMenu::add( &dlg ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFavourite::organize()
{
   /*----------------------------------------------------------------------*/
   CDlgFav dlg( this ) ;
   CDynMenu::organize( &dlg ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFavourite::menu_item_action( int i_id_menu )
{
   /*----------------------------------------------------------------------*/
   int i_num = i_id_menu - m_co_i_menu_id_start ;
   /*----------------------------------------------------------------------*/
   if( i_num < 0 || i_num >= m_i_nb_active )
   {  return ; }
   /*----------------------------------------------------------------------*/
   m_i_current = i_num ;
   wxGetApp().m_frame->m_cb_exp->SetValue( M_tb_s_exp.get( i_num ) ) ;
   wxGetApp().get_fl()->compute_new_names() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                       End of file CFavourite.cpp                          !
+==========================================================================*/
