/*====================================+=====================================+
! File CListCtrlBase.cpp              ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include "common/CListCtrlBase.h"
#include "common/sr_lib.h"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
void CListCtrlBase::show_grid( bool boo_on )
{
   /*----------------------------------------------------------------------*/
   SetSingleStyle( wxLC_HRULES, boo_on ) ;
   SetSingleStyle( wxLC_VRULES, boo_on ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CListCtrlBase::col_width_for_text( const wxString &s ) const
{
   /*----------------------------------------------------------------------*/
   int i_width  ;
   int i_height ;
   /*----------------------------------------------------------------------*/
   GetTextExtent( s, &i_width, &i_height ) ;
   /*-----------------------------------------------------------------------+
   ! Add space between cells. cf wx/src/common/headerctrlcmn.cpp + ...      !
   +-----------------------------------------------------------------------*/
   return( 6 + i_width + 6 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
wxString CListCtrlBase::get_item_text( int i_item, int i_col ) const
{
   /*----------------------------------------------------------------------*/
   wxListItem li ;
   /*----------------------------------------------------------------------*/
   li.m_mask   = wxLIST_MASK_TEXT ;
   li.m_itemId = i_item ;
   li.m_col    = i_col ;
   GetItem( li ) ;
   /*----------------------------------------------------------------------*/
   return( li.m_text ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CListCtrlBase::set_item_active( long l_item )
{
   /*--( Unhighlight all items to highlight only the chosen one )----------*/
   set_item_hil( -1, false ) ;
   /*----------------------------------------------------------------------*/
   if( l_item < 0 || l_item >= GetItemCount() ) { return ; }
   /*----------------------------------------------------------------------*/
   set_item_state( l_item, wxLIST_STATE_FOCUSED | wxLIST_STATE_SELECTED ) ;
   set_item_visible( l_item ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CListCtrlBase::swap_items( int i_item1, int i_item2 )
{
   /*----------------------------------------------------------------------*/
   const int  co_i_nb_col   = GetColumnCount() ;
   const long co_state_info = wxLIST_STATE_FOCUSED | wxLIST_STATE_SELECTED ;
   int        i_col    ;
   wxString   s1       ;
   wxString   s2       ;
   long       l_state1 ;
   long       l_state2 ;

   /*----------------------------------------------------------------------*/
   l_state1 = GetItemState( i_item1, co_state_info ) ;
   l_state2 = GetItemState( i_item2, co_state_info ) ;
   /*----------------------------------------------------------------------*/
   for( i_col = 0 ; i_col < co_i_nb_col ; ++i_col )
   {
      /*-------------------------------------------------------------------*/
      s1 = get_item_text( i_item1, i_col ) ;
      s2 = get_item_text( i_item2, i_col ) ;
      /*-------------------------------------------------------------------*/
      set_item_text( i_item1, i_col, s2 ) ;
      set_item_text( i_item2, i_col, s1 ) ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   SetItemState( i_item1, l_state2, co_state_info ) ;
   SetItemState( i_item2, l_state1, co_state_info ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CListCtrlBase::move_hil( e_lcb_updown lcb_updown )
{
   /*----------------------------------------------------------------------*/
   sr::t_vec_int vi_hil      ;
   long          l_item = -1 ;

   /*--( Extract the list of highlighted items )---------------------------*/
   while( ( l_item = get_next_hil_item( l_item ) ) != -1 )
   {  vi_hil.push_back( l_item ) ; }

   /*--( Nothing to do ? )-------------------------------------------------*/
   if( vi_hil.empty() ) { return ; }
   /*--( Don't move after the edges )--------------------------------------*/
   if(   ( lcb_updown == LCB_UP   && vi_hil[ 0 ] == 0 )
      || ( lcb_updown == LCB_DOWN && vi_hil.back() == GetItemCount() - 1 )
     )
   {  return ; }

   /*--( Now make the move ... )-------------------------------------------*/
   if( lcb_updown == LCB_UP )
   {  /*-------------------------------------------------------------------*/
      for( l_item = 0 ; l_item < ( long )vi_hil.size() ; ++l_item )
      {  swap_items( vi_hil[ l_item ], vi_hil[ l_item ] - 1 ) ; }
      /*-------------------------------------------------------------------*/
      set_item_visible( vi_hil[ 0 ] - 1 ) ;
      /*-------------------------------------------------------------------*/
   }
   else
   {  /*-------------------------------------------------------------------*/
      for( l_item = ( long )vi_hil.size() - 1 ; l_item >= 0 ; --l_item )
      {  swap_items( vi_hil[ l_item ], vi_hil[ l_item ] + 1 ) ; }
      /*-------------------------------------------------------------------*/
      set_item_visible( vi_hil.back() + 1 ) ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   SetFocus() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CListCtrlBase::delete_hil()
{
   /*----------------------------------------------------------------------*/
   long l_item       = -1 ;
   long l_item_repos = -1 ;
   /*----------------------------------------------------------------------*/
   while( ( l_item = get_next_hil_item( -1 ) ) != -1 )
   {  DeleteItem( l_item_repos = l_item ) ; }
   /*----------------------------------------------------------------------*/
   if( l_item_repos >= 0 )
   {
      /*-------------------------------------------------------------------*/
      l_item_repos = wxMin( l_item_repos, GetItemCount() - 1 ) ;
      set_item_active( l_item_repos ) ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   SetFocus() ;
   /*----------------------------------------------------------------------*/
}

/*--------------------------------------------------------------------------+
! This function will set the couple item/column based on a point (x,y).     !
! This function has been created because "HitTest/subitem" is only          !
! available under wxMSW.                                                    !
+--------------------------------------------------------------------------*/
int CListCtrlBase::get_item_col_at_point( const wxPoint &pt,
                                          long &l_item, long &l_col
                                        )
{
   /*----------------------------------------------------------------------*/
   int i_flags = wxLIST_HITTEST_ONITEM ;
   /*--( Got to know the item, if any ... )--------------------------------*/
   l_col = -1 ;
   if( ( l_item = HitTest( pt, i_flags, &l_col ) ) == wxNOT_FOUND )
   {  return( -1 ) ; }

   /*-----------------------------------------------------------------------+
   ! If the column is set then the "manual" computation has not to be done  !
   ! This should happen only under MSW                                      !
   +-----------------------------------------------------------------------*/
   if( l_col >= 0 ) { return( 0 ) ; }

   /*--( Search "by hand" )------------------------------------------------*/
   const long co_l_nb_col = GetColumnCount() ;
   wxRect rect ;
   /*----------------------------------------------------------------------*/
   for( l_col = 0 ;
           l_col < co_l_nb_col
        && GetSubItemRect( l_item, l_col, rect )
        && ( pt.x < rect.GetLeft() || pt.x > rect.GetRight() ) ;
        ++l_col
      )
   {  ; }
   /*----------------------------------------------------------------------*/
   if( l_col >= co_l_nb_col ) { return( -2 ) ; }
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                    End of file CListCtrlBase.cpp                          !
+==========================================================================*/
