/*====================================+=====================================+
! File CExternalData.cpp              ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include <wx/sstream.h>
#include <wx/txtstrm.h>
#include <wx/clipbrd.h>
#include <wx/log.h>
#include "siren.h"  // Only for the "g_co_i_string_sz_max" constant
#include "common/sr_lib.h"
#include "common/sr_string.h"
#include "common/CExternalData.h"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
wxString CExternalDataLine::get_line( int i_num_line )
{
   /*----------------------------------------------------------------------*/
   if( m_boo_reload ) { reload() ; }
   /*----------------------------------------------------------------------*/
   if( i_num_line < 0 || i_num_line >= ( int )m_as_line.GetCount() )
   {  return( wxEmptyString ) ; }
   /*----------------------------------------------------------------------*/
   return( m_as_line[ i_num_line ] ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CExternalDataLine::add_all_lines( const wxString &s_text )
{
   /*----------------------------------------------------------------------*/
   size_t sz_num ;

   /*--( Split the text into lines )---------------------------------------*/
   m_as_line = wxSplit( s_text, '\n', '\0' ) ;

   /*--( The lines have to be "prepared". The empty ones are kept )--------*/
   for( sz_num = 0 ; sz_num < m_as_line.GetCount() ; ++sz_num )
   {
      /*--( The cleaning will truncate to max and strip ending '\r' )------*/
      if( !m_as_line[ sz_num ].empty() )
      {  sr::clean_string( m_as_line[ sz_num ] ) ; }
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CExternalData_Clipboard::reload()
{
   /*-----------------------------------------------------------------------+
   ! Under wxWidgets, I don't know how to check that the clipboard content  !
   ! has changed.                                                           !
   +-----------------------------------------------------------------------*/
   zero_tab_line() ;

   /*----------------------------------------------------------------------*/
   if( wxTheClipboard->Open() )
   {
      /*-------------------------------------------------------------------*/
      if( wxTheClipboard->IsSupported( wxDF_TEXT ) )
      {  /*----------------------------------------------------------------*/
         wxTextDataObject data ;
         wxTheClipboard->GetData( data ) ;
         /*----------------------------------------------------------------*/
         add_all_lines( data.GetText() ) ;
         /*----------------------------------------------------------------*/
      }
      /*-------------------------------------------------------------------*/
      wxTheClipboard->Close() ;
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CExternalData_File::CTextFile::CTextFile( const wxFileName &name )
{
   /*----------------------------------------------------------------------*/
   m_name = name ;
   zero_dt_mod() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CExternalData_File::CTextFile::reload()
{
   /*----------------------------------------------------------------------*/
   wxFile     text_file                ; // Destructor will close the file
   wxDateTime dt_mod                   ;
   char       tb_c_buffer[ 1024 * 20 ] ;
   size_t     sz_read                  ;
   wxLogNull  no_log                   ;

   /*----------------------------------------------------------------------*/
   if( !get_reload() ) { return( 0 ) ; }

   /*----------------------------------------------------------------------*/
   set_reload( false ) ;

   /*--( Access problem ? delete the data )--------------------------------*/
   dt_mod = m_name.GetModificationTime() ;
   if( !dt_mod.IsValid() )
   {
      /*-------------------------------------------------------------------*/
      zero_tab_line() ;
      zero_dt_mod()   ;
      /*-------------------------------------------------------------------*/
      return( -1 ) ;
      /*-------------------------------------------------------------------*/
   }

   /*--( The file has not been modified ? So it is useless to reload it )--*/
   if( m_dt_mod.IsValid() && m_dt_mod == dt_mod )
   {  return( 0 ) ; }

   /*----------------------------------------------------------------------*/
   zero_tab_line() ;
   zero_dt_mod()   ;

   /*----------------------------------------------------------------------*/
   if( !text_file.Open( m_name.GetFullPath(), wxFile::read ) )
   {  return( -2 ) ; }

   /*--( Try to fill up the buffer )---------------------------------------*/
   sz_read = text_file.Read( tb_c_buffer, sizeof( tb_c_buffer ) ) ;
   if( ( int )sz_read == wxInvalidOffset )
   {  return( -3 ) ; }

   /*-----------------------------------------------------------------------+
   ! Convert the string to the current format:                              !
   ! the source can be ansi, unicode BE/LE ...                              !
   +-----------------------------------------------------------------------*/
   wxString s_buffer( tb_c_buffer, wxConvAuto(), sz_read ) ;

   /*--( Split the text lines into an array )------------------------------*/
   add_all_lines( s_buffer ) ;

   /*--( The file lines will only be reloaded if modified since ... )------*/
   m_dt_mod = dt_mod ;
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CExternalData_File::CExternalData_File()
{
   /*----------------------------------------------------------------------*/
   reset_active_file() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CExternalData_File::~CExternalData_File()
{  ; }

/*--------------------------------------------------------------------------+
! The file name is stored "absolute" ...                                    !
+--------------------------------------------------------------------------*/
void CExternalData_File::set_active_file( const wxString &s_dir,
                                          const wxString &s_name
                                        )
{
   /*----------------------------------------------------------------------*/
   wxFileName name ;
   wxString   s_full_path ;

   /*----------------------------------------------------------------------*/
   if( s_name.empty() ) { wxFAIL ; return ; }
   /*----------------------------------------------------------------------*/
   name.Assign( s_name ) ;
   name.MakeAbsolute( s_dir ) ;
   /*-----------------------------------------------------------------------+
   ! As the "wxFileName" comparison is heavy, "wxString" is used instead.   !
   ! For "case insensitive" systems the "trick" is to compare the name in   !
   ! lower case.                                                            !
   +-----------------------------------------------------------------------*/
   s_full_path = name.GetFullPath() ;
   if( !wxFileName::IsCaseSensitive() )
   {  s_full_path.MakeLower() ; }
   /*--( Already got have this file ? )------------------------------------*/
   m_it_active_file = m_map_file_text.find( s_full_path ) ;

   /*--( Add it if not found )---------------------------------------------*/
   if( m_it_active_file == m_map_file_text.end() )
   {
      /*-------------------------------------------------------------------*/
      std::pair< t_map_file_text_it, bool > ret_insert ;
      /*-------------------------------------------------------------------*/
        ret_insert
      = m_map_file_text.insert( std::pair< wxString, CTextFile >(
                                               s_full_path, CTextFile( name )
                                                                )
                              ) ;
      /*--( The insert should have been done )-----------------------------*/
      if( !ret_insert.second ) { wxFAIL ; return ; }
      /*-------------------------------------------------------------------*/
      m_it_active_file = ret_insert.first ;
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CExternalData_File::reset()
{
   /*----------------------------------------------------------------------*/
   for( m_it_active_file = m_map_file_text.begin() ;
        m_it_active_file != m_map_file_text.end() ;
        ++m_it_active_file
      )
   {  m_it_active_file->second.reset() ; }
   /*----------------------------------------------------------------------*/
   reset_active_file() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
wxString CExternalData_File::get_line( int i_num_line )
{
   /*----------------------------------------------------------------------*/
   if( m_it_active_file == m_map_file_text.end() )
   {  return( wxEmptyString ) ; }
   /*----------------------------------------------------------------------*/
   return( m_it_active_file->second.get_line( i_num_line ) ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                      End of file CExternalData.cpp                        !
+==========================================================================*/
