/*====================================+=====================================+
! File CCrypt.cpp                     ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+---------------------------------------------------------------------------+
!                                                                           !
!                            Crypt strings                                  !
!                                                                           !
+-------+-------------------------------------------------------------------+
! Notes !                                                                   !
+-------+                                                                   !
! This code is based on information found at this address:                  !
!                                                                           !
! RC4: http://en.wikipedia.org/wiki/Rc4                                     !
!                                                                           !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include <algorithm>
#include "common/CCrypt.h"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
void CCryptRC4::init( const unsigned char *p_uc_pwd, size_t sz_pwd_len )
{
   /*----------------------------------------------------------------------*/
   unsigned char uc_i  ;
   int           i_pos ;
   /*----------------------------------------------------------------------*/
   for( i_pos = 0 ; i_pos < 256 ; ++i_pos )
   {  m_tb_uc_S[ i_pos ] = i_pos ; }
   /*----------------------------------------------------------------------*/
   for( i_pos = uc_i = 0 ; i_pos < 256 ; ++i_pos )
   {
      /*-------------------------------------------------------------------*/
      uc_i += m_tb_uc_S[ i_pos ] + p_uc_pwd[ i_pos % sz_pwd_len ] ;
      /*-------------------------------------------------------------------*/
      std::swap( m_tb_uc_S[ uc_i ], m_tb_uc_S[ i_pos ] ) ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CCryptRC4::crypt( const unsigned char *p_uc_in, size_t sz_in_len,
                       unsigned char *p_uc_out
                     )
{
   /*----------------------------------------------------------------------*/
   unsigned char uc_i = 0 ;
   unsigned char uc_j = 0 ;
   unsigned char uc_c = 0 ;
   int           i_pos_in ;

   /*----------------------------------------------------------------------*/
   for( i_pos_in = 0 ; i_pos_in < ( int )sz_in_len ; ++i_pos_in )
   {
      /*-------------------------------------------------------------------*/
      ++uc_i ;
      uc_j += m_tb_uc_S[ uc_i ] ;
      /*-------------------------------------------------------------------*/
      std::swap( m_tb_uc_S[ uc_i ], m_tb_uc_S[ uc_j ] ) ;
      /*-------------------------------------------------------------------*/
      uc_c = m_tb_uc_S[ uc_i ] + m_tb_uc_S[ uc_j ] ;
      p_uc_out[ i_pos_in ] = m_tb_uc_S[ uc_c ] ^ p_uc_in[ i_pos_in ] ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CCryptRC4::crypt( const char *p_c_in, char *p_c_out )
{
   /*----------------------------------------------------------------------*/
   int i_len = strlen( p_c_in ) ;
   /*----------------------------------------------------------------------*/
   crypt( ( unsigned char * )p_c_in, i_len, ( unsigned char * )p_c_out ) ;
   /*--( RC4 doesn't change the message length )---------------------------*/
   p_c_out[ i_len ] = '\0' ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                          End of file CCrypt.cpp                           !
+==========================================================================*/
