/*====================================+=====================================+
! File CWizard.cpp                    ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+---------------------------------------------------------------------------+
!                                                                           !
! Once opened the windows is kept alive via a pointer in CFrame.            !
! This will allow the user to review the parameters used.                   !
!                                                                           !
! A modeless dialog could have been used but I think that for the user it   !
! can be confusing. Especially if he changes the current first selected     !
! file. In this case the wizard's "new name" won't be recomputed.           !
!                                                                           !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include "CApp.h"
#include "common/CChoice.h"
#include "common/CSTEllipsize.h"
#include "CWizard.h"
#include "CCombo.h"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
BEGIN_EVENT_TABLE( CWizard, CWizardBase )
   /*----------------------------------------------------------------------*/
   EVT_NOTEBOOK_PAGE_CHANGED( wxID_ANY, CWizard::OnNotebookPageChanged )
   /*----------------------------------------------------------------------*/
END_EVENT_TABLE()
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
static const char *st_co_p_c_case_l
                = wxTRANSLATE( "Lower case" ) ;
static const char *st_co_p_c_case_u
                = wxTRANSLATE( "Upper case" ) ;
static const char *st_co_p_c_case_L
                = wxTRANSLATE( "Upper first letter, lower rest" ) ;
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
CWizardPanPredefined::CWizardPanPredefined( wxWindow *parent )
                    : CWizardPanPredefinedBase( parent, wxID_ANY )
{
   /*--( General )---------------------------------------------------------*/
   m_cho_general->append_stringdata( wxEmptyString ) ;
   m_cho_general->append_stringdata( _( "Selection number, name" ),
                                     "%n - %f"
                                   ) ;
   m_cho_general->append_stringdata( _( "Name, selection number" ),
                                     "%b - %n.%e"
                                   ) ;
   m_cho_general->append_stringdata( wxGetTranslation( st_co_p_c_case_l ),
                                     "%lf"
                                   ) ;
   m_cho_general->append_stringdata( wxGetTranslation( st_co_p_c_case_u ),
                                     "%uf"
                                   ) ;
   m_cho_general->append_stringdata( wxGetTranslation( st_co_p_c_case_L ),
                                     "%Lf"
                                   ) ;
   m_cho_general->append_stringdata( _( "Remove accents" ), "%@f" ) ;
   m_cho_general->append_stringdata( _( "Replace '_' with spaces" ),
                                     "%f(\"_\",\" \")"
                                   ) ;
   m_cho_general->append_stringdata( _( "Replace '_' and '.' with spaces" ),
                                     "%b(\"_\",\" \")(\".\",\" \").%e"
                                   ) ;
   m_cho_general->SetSelection( 0 ) ;

   /*--( Music )-----------------------------------------------------------*/
   m_cho_music->append_stringdata( wxEmptyString ) ;
   m_cho_music->append_stringdata( _( "Title" ), "%At.%e" ) ;
   m_cho_music->append_stringdata( _( "Track, title" ), "%AT - %At.%e" ) ;
   m_cho_music->append_stringdata( _( "Album, track, title" ),
                                   "%AA - %AT - %At.%e"
                                 ) ;
   m_cho_music->append_stringdata( _( "Artist, album, track, title" ),
                                   "%Aa - %AA - %AT - %At.%e"
                                 ) ;
   m_cho_music->SetSelection( 0 ) ;

   /*--( Photo )-----------------------------------------------------------*/
   m_cho_photo->append_stringdata( wxEmptyString ) ;
   m_cho_photo->append_stringdata( _( "Date, name" ),
                                   "%Xdod - %f"
                                 ) ;
   m_cho_photo->append_stringdata( _( "Date & time, name" ),
                                   "%Xdo - %f"
                                 ) ;
   m_cho_photo->append_stringdata( _( "Date & time (spaced), name" ),
                                   "%Xdo{\"%Y %m %d - %H %M %S\"} - %f"
                                 ) ;
   m_cho_photo->append_stringdata( _( "Date & time, unique number" ),
                                   "%Xdo - %nc.%e"
                                 ) ;
   m_cho_photo->SetSelection( 0 ) ;

   /*--( Video )-----------------------------------------------------------*/
   m_cho_video->append_stringdata( wxEmptyString ) ;
   m_cho_video->append_stringdata( _( "Title" ), "%Vt.%e" ) ;
   m_cho_video->append_stringdata( _( "Artist, title" ), "%Va - %Vt.%e" ) ;
   m_cho_video->SetSelection( 0 ) ;

   /*--( Document )--------------------------------------------------------*/
   m_cho_doc->append_stringdata( wxEmptyString ) ;
   m_cho_doc->append_stringdata( _( "Title" ), "%Ot.%e" ) ;
   m_cho_doc->append_stringdata( _( "Author, title" ), "%Oa - %Ot.%e" ) ;
   m_cho_doc->append_stringdata( _( "Modification date & time, title" ),
                                 "%Om - %Ot.%e"
                               ) ;
   m_cho_doc->append_stringdata( _( "Modification date & time (spaced), "
                                    "title"
                                  ),
                                 "%Om{\"%Y %m %d - %H %M %S\"} - %Ot.%e"
                               ) ;
   m_cho_doc->append_stringdata( _( "Date & time, unique number" ),
                                 "%Om - %nc.%e"
                               ) ;
   m_cho_doc->SetSelection( 0 ) ;

   /*----------------------------------------------------------------------*/
}

/*--( The combos are mutually "exclusive" )--------------------------------*/
void CWizardPanPredefined::build_expression( wxString &s_exp ) const
{
   /*----------------------------------------------------------------------*/
   const size_t co_sz_nb_item = m_fgsizer_cho->GetItemCount() ;
   CChoice *p_cho ;
   size_t  sz_num ;

   /*--( Go through choice combos ... )------------------------------------*/
   for( sz_num = 1 ; sz_num < co_sz_nb_item ; sz_num += 2 )
   {
      /*--( Every "even" window is a CChoice )-----------------------------*/
      p_cho = ( CChoice * )m_fgsizer_cho->GetItem( sz_num )->GetWindow() ;
      /*--( Something found ? )--------------------------------------------*/
      s_exp = p_cho->get_stringdata() ;
      if( !s_exp.empty() ) { return ; }
      /*-------------------------------------------------------------------*/
   }

   /*--( Default expression )----------------------------------------------*/
   s_exp = "%b.%e" ;
   /*----------------------------------------------------------------------*/
}

/*--( The combos are mutually "exclusive" )--------------------------------*/
void CWizardPanPredefined::OnChoice( wxCommandEvent &event )
{
   /*----------------------------------------------------------------------*/
   wxWindow *p_object = ( wxWindow * )event.GetEventObject() ;
   const size_t co_sz_nb_item = m_fgsizer_cho->GetItemCount() ;
   CChoice *p_cho ;
   size_t  sz_num ;

   /*--( Scan the choice combos ... )------------------------------------*/
   for( sz_num = 1 ; sz_num < co_sz_nb_item ; sz_num += 2 )
   {
      /*--( Every "even" window is a CChoice )-----------------------------*/
      p_cho = ( CChoice * )m_fgsizer_cho->GetItem( sz_num )->GetWindow() ;
      /*--( Something found ? )--------------------------------------------*/
      if( p_cho != p_object ) { p_cho->SetSelection( 0 ) ; }
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
   wxGetApp().m_frame->m_wizard->recompute() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CWizardPanManual::CWizardPanManual( wxWindow *parent )
                : CWizardPanManualBase( parent, wxID_ANY )
{
   /*----------------------------------------------------------------------*/
   m_cho_bn_case->append_stringdata( wxEmptyString ) ;
   m_cho_bn_case->append_stringdata( wxGetTranslation( st_co_p_c_case_l ),
                                     "l"
                                   ) ;
   m_cho_bn_case->append_stringdata( wxGetTranslation( st_co_p_c_case_u ),
                                     "u"
                                   ) ;
   m_cho_bn_case->append_stringdata( wxGetTranslation( st_co_p_c_case_L ),
                                     "L"
                                   ) ;
   /*--( Same "case" choice for base name and extension )------------------*/
   m_cho_ext_case->append_all_stringdata( m_cho_bn_case ) ;
   /*----------------------------------------------------------------------*/
   m_cho_bn_case->SetSelection( 0 ) ;
   m_cho_ext_case->SetSelection( 0 ) ;
   /*----------------------------------------------------------------------*/
   m_cho_bn_before_var->append_stringdata( wxEmptyString ) ;
   m_cho_bn_before_var->append_stringdata( _( "Selection number" ), "%n" ) ;
   m_cho_bn_before_var->append_stringdata( _( "Unique number" ), "%nc" ) ;
   m_cho_bn_before_var->append_stringdata( _( "Audio track number" ), "%AT");
   m_cho_bn_before_var->append_stringdata( _( "Audio track title" ), "%At" );
   m_cho_bn_before_var->append_stringdata( _( "Today's date" ), "%Dd" ) ;
   m_cho_bn_before_var->append_stringdata( _( "Exif date" ), "%Xdod" ) ;
   m_cho_bn_before_var->append_stringdata( _( "Exif date & time" ), "%Xdo" );
   m_cho_bn_before_var->append_stringdata( _("Exif date & time (spaced)" ) ,
                                           "%Xdo{\"%Y %m %d - %H %M %S\"}"
                                         ) ;
   /*--( Same "variable" choice for before and after the base name )-------*/
   m_cho_bn_after_var->append_all_stringdata( m_cho_bn_before_var ) ;
   /*----------------------------------------------------------------------*/
   m_cho_bn_before_var->SetSelection( 0 ) ;
   m_cho_bn_after_var->SetSelection( 0 ) ;

   /*-----------------------------------------------------------------------+
   ! Change font except for the built expression. On wxMSW combined with    !
   ! the increase of font size, the result is not very nice.                !
   +-----------------------------------------------------------------------*/
   //sr::set_font_fix( m_st_disp_exp, wxGetApp().M_boo_exp_fix.get() ) ;
   sr::set_font_fix( m_s_bn_before_text, true ) ;
   sr::set_font_fix( m_s_bn, true ) ;
   sr::set_font_fix( m_s_bn_repl_from, true ) ;
   sr::set_font_fix( m_s_bn_repl_to, true ) ;
   sr::set_font_fix( m_i_bn_subs_from, true ) ;
   sr::set_font_fix( m_i_bn_subs_nb, true ) ;
   sr::set_font_fix( m_s_bn_after_text, true ) ;
   sr::set_font_fix( m_s_ext, true ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CWizardPanManual::OnChoice( wxCommandEvent &event )
{  wxGetApp().m_frame->m_wizard->recompute() ; }

/*-------------------------------------------------------------------------*/
void CWizardPanManual::OnText( wxCommandEvent &event )
{  wxGetApp().m_frame->m_wizard->recompute() ; }

/*-------------------------------------------------------------------------*/
void CWizardPanManual::OnSpin( wxSpinEvent &event )
{  wxGetApp().m_frame->m_wizard->recompute() ; }

/*-------------------------------------------------------------------------*/
wxString CWizardPanManual::constant_string( const wxTextCtrl *p_text,
                                            bool boo_delimited
                                          ) const
{
   /*----------------------------------------------------------------------*/
   wxString s_text ;
   /*----------------------------------------------------------------------*/
   s_text = p_text->GetValue() ;
   sr::double_backslash( s_text ) ;
   s_text.Replace( "*", "\\*" ) ;
   /*----------------------------------------------------------------------*/
   if( boo_delimited )
   {  s_text.Replace( "\"", "\\\"" ) ; }
   else
   {  s_text.Replace( "%", "\\%" ) ; }
   /*----------------------------------------------------------------------*/
   return( s_text ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CWizardPanManual::build_expression( wxString &s_exp ) const
{
   /*----------------------------------------------------------------------*/
   wxString s_val ;

   /*----------------------------------------------------------------------*/
   s_exp  = m_cho_bn_before_var->get_stringdata() ;
   s_exp += constant_string( m_s_bn_before_text, false ) ;

   /*----------------------------------------------------------------------*/
   s_val = constant_string( m_s_bn, false ) ;
   /*--( Constant text to replace the base name ? )------------------------*/
   if( !s_val.empty() )
   {  s_exp += s_val ; }
   else
   {  /*--( Use the base name variable )-----------------------------------*/
      s_exp += '%' + m_cho_bn_case->get_stringdata() + 'b' ;
      /*--( Replace )------------------------------------------------------*/
      s_val = constant_string( m_s_bn_repl_from, true ) ;
      if( !s_val.empty() )
      {  /*----------------------------------------------------------------*/
         s_exp += "(\"" + s_val + '"' ;
         /*----------------------------------------------------------------*/
         s_val = constant_string( m_s_bn_repl_to, true ) ;
         if( !s_val.empty() ) { s_exp += ",\"" + s_val + '"' ; }
         /*----------------------------------------------------------------*/
         s_exp += ')' ;
         /*----------------------------------------------------------------*/
      }
      /*--( Substr )-------------------------------------------------------*/
      int i_val = m_i_bn_subs_from->GetValue() ;
      if( i_val != 0 )
      {  /*----------------------------------------------------------------*/
         s_exp += wxString::Format( "(%d", i_val ) ;
         /*----------------------------------------------------------------*/
         i_val = m_i_bn_subs_nb->GetValue() ;
         if( i_val != 0 ) { s_exp += wxString::Format( ",%d", i_val ) ; }
         /*----------------------------------------------------------------*/
         s_exp += ")" ;
         /*----------------------------------------------------------------*/
      }
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   s_exp += constant_string( m_s_bn_after_text, false ) ;
   s_exp += m_cho_bn_after_var->get_stringdata() ;

   /*--( Now, the extension )----------------------------------------------*/
   s_exp += '.' ;
   s_val = constant_string( m_s_ext, false ) ;
   /*--( Constant text to replace the base name ? )------------------------*/
   if( !s_val.empty() )
   {  s_exp += s_val ; }
   else
   {  /*--( Use the extension variable )-----------------------------------*/
      s_exp += '%' + m_cho_ext_case->get_stringdata() + 'e' ;
      /*-------------------------------------------------------------------*/
   }
   /*--( Remove the spaces from the front )--------------------------------*/
   s_exp.Trim( false ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CWizard::CWizard( wxWindow *parent )
       : CWizardBase( parent ), m_i_file_example( -1 )
{
   /*----------------------------------------------------------------------*/
   init() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CWizard::~CWizard()
{
   /*----------------------------------------------------------------------*/
   wxGetApp().save_tlw_rect( this, wxGetApp().M_rec_wizard ) ;
   /*--( Avoid the delete from the Frame )---------------------------------*/
   wxGetApp().m_frame->m_wizard = NULL ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CWizard::init()
{
   /*----------------------------------------------------------------------*/
   m_pan_predefined = new CWizardPanPredefined( m_nb ) ;
   m_pan_manual     = new CWizardPanManual( m_nb )     ;
   /*----------------------------------------------------------------------*/
   m_nb->AddPage( m_pan_predefined, _( "Expression by file type" ) ) ;
   m_nb->AddPage( m_pan_manual    , _( "Build a simple expression" ) ) ;
   m_nb->SetSelection( 0 ) ;

   /*----------------------------------------------------------------------*/
   init_example() ;
   recompute() ;

   /*----------------------------------------------------------------------*/
   wxGetApp().init_tlw_rect( this, wxGetApp().M_rec_wizard ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CWizard::OnNotebookPageChanged( wxNotebookEvent &event )
{
   /*----------------------------------------------------------------------*/
   recompute() ;
   event.Skip() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CWizard::OnBtOk( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   validate_expression() ;
   EndModal( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CWizard::OnBtApply( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   validate_expression() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CWizard::init_example()
{
   /*----------------------------------------------------------------------*/
   if( wxGetApp().get_fl()->m_dir.get_nb_sel() == 0 )
   {
      /*--( Clean the UI elements related to the example )-----------------*/
      m_i_file_example = -1 ;
      m_st_first_from->SetForegroundColour( *wxBLUE ) ;
      m_st_first_from->SetLabel( _( "No file selected" ) ) ;
      m_st_first_to->SetLabel( wxEmptyString ) ;
      /*-------------------------------------------------------------------*/
      m_pan_manual->m_st_bn_title_sep->SetLabel( wxEmptyString ) ;
      m_pan_manual->m_st_bn_val->SetLabel( wxEmptyString ) ;
      m_pan_manual->m_st_ext_title_sep->SetLabel( wxEmptyString ) ;
      m_pan_manual->m_st_ext_val->SetLabel( wxEmptyString ) ;
      /*-------------------------------------------------------------------*/
   }
   else
   {
      /*-------------------------------------------------------------------*/
      m_i_file_example = wxGetApp().get_fl()->m_dir.get_sel_file_num( 0 ) ;
      wxFileName fn_example(
                    wxGetApp().get_fl()->m_dir[ m_i_file_example ].get_name()
                           ) ;
      /*-------------------------------------------------------------------*/
      m_st_first_from->SetForegroundColour( wxNullColour ) ;
      m_st_first_from->SetLabel( fn_example.GetFullPath() ) ;
      /*--( Show the different parts in the titles )-----------------------*/
      m_pan_manual->m_st_bn_title_sep->SetLabel( ":" ) ;
      m_pan_manual->m_st_bn_val->SetLabel( fn_example.GetName() ) ;
      m_pan_manual->m_st_ext_title_sep->SetLabel( ":" ) ;
      m_pan_manual->m_st_ext_val->SetLabel( fn_example.GetExt() ) ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CWizard::recompute_example()
{
   /*----------------------------------------------------------------------*/
   if( m_i_file_example >= 0 )
   {
      /*-------------------------------------------------------------------*/
      wxFileName new_name ;
      /*-------------------------------------------------------------------*/
        new_name
      = wxGetApp().get_fl()->m_dir[ m_i_file_example].compute_exp( m_s_exp );
      /*-------------------------------------------------------------------*/
      m_st_first_to->SetLabel( new_name.GetFullPath() ) ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CWizard::recompute()
{
   /*----------------------------------------------------------------------*/
   switch( m_nb->GetSelection() )
   {
      /*-------------------------------------------------------------------*/
      case 0 : m_pan_predefined->build_expression( m_s_exp ) ;
               break ;
      case 1 : m_pan_manual->build_expression( m_s_exp ) ;
               break ;
      /*--( Call during dialog creation ? )--------------------------------*/
      default : return ;
      /*-------------------------------------------------------------------*/
   }

   /*--( Display the expression )------------------------------------------*/
   m_st_disp_exp->SetLabel( m_s_exp ) ;

   /*--( And recompute the example )---------------------------------------*/
   recompute_example() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CWizard::validate_expression() const
{
   /*----------------------------------------------------------------------*/
   wxGetApp().m_frame->m_cb_exp->SetValue( m_s_exp ) ;
   wxGetApp().get_fl()->compute_new_names() ;
   wxGetApp().m_frame->Refresh() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                        End of file CWizard.cpp                            !
+==========================================================================*/
