/*====================================+=====================================+
! File CTagVisu.cpp                   ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include <wx/menu.h>
#include "CApp.h"
#include "CTagVisu.h"
#include "CCombo.h"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
BEGIN_EVENT_TABLE( CTagVisu, wxTreeCtrl )
   /*----------------------------------------------------------------------*/
   EVT_TREE_ITEM_COLLAPSED( wxID_ANY, CTagVisu::OnExpandOrCollapse )
   EVT_TREE_ITEM_MENU( wxID_ANY, CTagVisu::OnItemMenu )
   /*----------------------------------------------------------------------*/
END_EVENT_TABLE()
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
CTagVisu::CTagVisu( wxWindow *parent, wxWindowID id )
        : wxTreeCtrl( parent, id, wxDefaultPosition, wxDefaultSize,
                        wxSUNKEN_BORDER | wxTR_DEFAULT_STYLE
                      | wxTR_HIDE_ROOT | wxTR_HAS_BUTTONS | wxTR_NO_LINES
                      | wxTR_TWIST_BUTTONS
                    )
{
   /*----------------------------------------------------------------------*/
   int i_grp ;
   /*----------------------------------------------------------------------*/
   for( i_grp = 0 ; i_grp < GRP_NB ; ++i_grp )
   {  m_tb_boo_grp_expanded[ i_grp ] = false ; }
   /*----------------------------------------------------------------------*/
   SetIndent( 20 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CTagVisu::~CTagVisu()
{  ; }

/*--------------------------------------------------------------------------+
! Under Ubuntu with default theme, as there is no "scroll bar", the         !
! characters drawn in the "ghost" scrollbar are not erased. For now,        !
! the issue has to be manually handled.                                     !
+--------------------------------------------------------------------------*/
void CTagVisu::OnExpandOrCollapse( wxTreeEvent &event )
{
   /*----------------------------------------------------------------------*/
#ifdef __WXGTK__
   bool boo_refresh = CanScroll( wxVERTICAL ) ;
#endif // __WXGTK__
   /*----------------------------------------------------------------------*/
   event.Skip() ;
   /*----------------------------------------------------------------------*/
#ifdef __WXGTK__
   if( boo_refresh ) { Refresh() ; }
#endif // __WXGTK__
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CTagVisu::OnItemMenu( wxTreeEvent &event )
{
   /*----------------------------------------------------------------------*/
   wxTreeItemId ti_item       ;
   int          i_flags       ;
   wxMenu       menu          ;
   wxString     s_var         ;
   wxString     s_val         ;
   wxString     s_help_anchor ;

   /*----------------------------------------------------------------------*/
   ti_item = HitTest( event.GetPoint(), i_flags ) ;
   if( !ti_item.IsOk() ) { return ; }

   /*----------------------------------------------------------------------*/
   if( get_var_val_anchor( ti_item, s_var, s_val, s_help_anchor ) != 0 )
   {  return ; }

   /*--( Variable group ? )------------------------------------------------*/
   if( s_var.empty() )
   {  menu.Append( IDM_HELP_VAR, _( "&Help" ) ) ; }
   else
   {
      /*-------------------------------------------------------------------*/
      menu.Append( IDM_INS_VAR,
                   wxString::Format( _( "&Insert associated variable into "
                                        "expression (%s)"
                                      ), s_var
                                   )
                 ) ;
      /*-------------------------------------------------------------------*/
      menu.Append( IDM_INS_VAL, _( "Insert &value into expression" ) ) ;
      menu.Append( IDM_COPY_VAL_CLIPBOARD, _( "&Copy value to clipboard" ) );
      /*-------------------------------------------------------------------*/
      s_help_anchor = s_var ;
      /*-------------------------------------------------------------------*/
      menu.Append( IDM_HELP_VAR,
                   wxString::Format( _( "&Help about associated variable "
                                        "(%s)"
                                      ), s_var
                                   )
                 ) ;
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
   switch( GetPopupMenuSelectionFromUser( menu, event.GetPoint() ) )
   {
      /*-------------------------------------------------------------------*/
      case IDM_INS_VAR :
         wxGetApp().m_frame->m_cb_exp->WriteText( s_var ) ;
         wxGetApp().get_fl()->compute_new_names() ;
         break ;
      /*-------------------------------------------------------------------*/
      case IDM_INS_VAL :
         wxGetApp().m_frame->m_cb_exp->WriteText( s_val ) ;
         wxGetApp().get_fl()->compute_new_names() ;
         break ;
      /*-------------------------------------------------------------------*/
      case IDM_COPY_VAL_CLIPBOARD :
         sr::set_clipboard( s_val ) ;
         break ;
      /*-------------------------------------------------------------------*/
      case IDM_HELP_VAR :
         wxGetApp().m_frame->show_help( HELP_VAR "#" + s_help_anchor ) ;
         break ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
}

/*--------------------------------------------------------------------------+
! Get the variable and value associated to item tag                         !
+--------------------------------------------------------------------------*/
int CTagVisu::get_var_val_anchor( wxTreeItemId ti_item,
                                  wxString &s_var, wxString &s_val,
                                  wxString &s_help_anchor
                                )
{
   /*----------------------------------------------------------------------*/
   CTagVisuData *p_data ;
   int          i_col   ;
   CFile        *p_file ;

   /*----------------------------------------------------------------------*/
   s_var.clear() ;
   s_val.clear() ;
   s_help_anchor.clear() ;
   /*----------------------------------------------------------------------*/
   if( !ti_item.IsOk() )
   {  return( -1 ) ; }

   /*--( Get element information )-----------------------------------------*/
   p_data = static_cast< CTagVisuData * >( GetItemData( ti_item ) ) ;
   if( p_data == NULL ) { return( -2 ) ; }

   /*--( Root children are variable groups )-------------------------------*/
   if( GetItemParent( ti_item ) == GetRootItem() )
   {
      /*--( The data contains the group enum id )--------------------------*/
        s_help_anchor
      = wxGetApp().m_colgroup.get_help_anchor( p_data->m_i_val ) ;
      /*-------------------------------------------------------------------*/
   }
   else
   {
      /*-------------------------------------------------------------------*/
      i_col = wxGetApp().get_fl()->m_tb_subitem_in_tb_col[ p_data->m_i_val ];
      p_file = wxGetApp().get_fl()->get_p_file_focus() ;
      /*-------------------------------------------------------------------*/
      s_var = wxGetApp().get_fl()->m_tb_col[ i_col ].m_s_var_name ;
      if( p_file != NULL )
      {  s_val = p_file->get_s_val( p_data->m_i_val ) ; }
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CTagVisu::help()
{
   /*----------------------------------------------------------------------*/
   wxString s_help_anchor ;
   wxString s_val ;

   /*--( It will be a group or a member of a group => 2 times s_anchor )---*/
   if( get_var_val_anchor( GetFocusedItem(),
                           s_help_anchor, s_val, s_help_anchor
                         ) != 0
     )
   {  return( -1 ) ; }
   /*----------------------------------------------------------------------*/
   wxGetApp().m_frame->show_help( HELP_VAR "#" + s_help_anchor ) ;
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*--------------------------------------------------------------------------+
! For a better display experience ... the open/close group states are kept  !
+--------------------------------------------------------------------------*/
void CTagVisu::visu( const CFile *p_file )
{
   /*----------------------------------------------------------------------*/
   wxString           s_file_abs_full_path           ;
   wxDateTime         dt_file_mod                    ;
   wxULongLong        ull_file_size                  ;
   const CFileList    *co_p_fl = wxGetApp().get_fl() ;
   wxTreeItemId       ti_root                        ;
   wxTreeItemId       tb_ti_grp[ GRP_NB ]            ;
   CFile::t_s_val_cit it_val                         ;
   int                i_grp                          ;
   int                i_col                          ;
   wxTreeItemId       ti                             ;
   CTagVisuData       *p_data                        ;
   wxTreeItemIdValue  cookie                         ;

   /*--( Keep track of the file to limit reloads )-------------------------*/
   if( p_file != NULL )
   {  s_file_abs_full_path = p_file->get_abs_full_path() ;
      dt_file_mod = p_file->get_dt_val( COL_BASE_MOD_DATE ) ;
      ull_file_size = p_file->get_size() ;
   }
   /*--( Something to do ? )-----------------------------------------------*/
   if(    m_s_file_abs_full_path == s_file_abs_full_path
       && m_dt_file_mod.IsValid()
       && m_dt_file_mod   == dt_file_mod
       && m_ull_file_size == ull_file_size
     )
   {  return ; }

   /*--( No refresh. Else the flickering can be unpleasant )---------------*/
   Freeze() ;

   /*--( Extract current groups tree "expansion" state )-------------------*/
   ti_root = GetRootItem() ;
   if( ti_root.IsOk() )
   {
      /*-------------------------------------------------------------------*/
      for( ti = GetFirstChild( ti_root, cookie ) ;
           ti.IsOk() ;
           ti = GetNextChild( ti_root, cookie )
         )
      {  /*----------------------------------------------------------------*/
         p_data = static_cast< CTagVisuData * >( GetItemData( ti ) ) ;
         /*----------------------------------------------------------------*/
         if( p_data != NULL )
         {  m_tb_boo_grp_expanded[ p_data->m_i_val ] = IsExpanded( ti ) ; }
         /*----------------------------------------------------------------*/
      }
      /*-------------------------------------------------------------------*/
   }

   /*--( Clean )-----------------------------------------------------------*/
   DeleteAllItems() ;
   /*----------------------------------------------------------------------*/
   if( s_file_abs_full_path.empty() )
   {  goto func_end ; }

   /*--( First, the root )-------------------------------------------------*/
   ti_root = AddRoot( "Root" ) ;
   /*-----------------------------------------------------------------------+
   ! The map won't contain:                                                 !
   ! - "Current" and "New name" because they are not part of the map        !
   ! - "Selection number" if the file is not selected (string not in map)   !
   +-----------------------------------------------------------------------*/
   for( it_val  = p_file->get_map_s_val().begin() ;
        it_val != p_file->get_map_s_val().end() ;
        ++it_val
      )
   {  /*-------------------------------------------------------------------*/
      i_col = co_p_fl->m_tb_subitem_in_tb_col[ it_val->first ] ;
      i_grp = co_p_fl->m_tb_col[ i_col ].m_grp ;
      /*-------------------------------------------------------------------*/
      if( i_grp >= GRP_BASE )
      {
         /*--( Create the group if not already done )----------------------*/
         if( !tb_ti_grp[ i_grp ].IsOk() )
         {  /*-------------------------------------------------------------*/
              tb_ti_grp[ i_grp ]
            = AppendItem( ti_root, wxGetApp().m_colgroup.get_name( i_grp ),
                          -1, -1, new CTagVisuData( i_grp )
                        ) ;
            /*-------------------------------------------------------------*/
         }
         /*--( Add the item )----------------------------------------------*/
         AppendItem( tb_ti_grp[ i_grp ],
                       co_p_fl->m_tb_col[ i_col ].m_s_name
                     + ": " + it_val->second,
                     -1, -1, new CTagVisuData( it_val->first )
                   ) ;
         /*----------------------------------------------------------------*/
      }
      /*-------------------------------------------------------------------*/
   }

   /*--( Reexpanded groups )-----------------------------------------------*/
   for( i_grp = 0 ; i_grp < GRP_NB ; ++i_grp )
   {
      /*-------------------------------------------------------------------*/
      if( m_tb_boo_grp_expanded[ i_grp ] && tb_ti_grp[ i_grp ].IsOk() )
      {  Expand( tb_ti_grp[ i_grp ] ) ; }
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
func_end :
   /*----------------------------------------------------------------------*/
   Layout() ;
   Thaw() ;
   /*----------------------------------------------------------------------*/
   m_s_file_abs_full_path = s_file_abs_full_path ;
   m_dt_file_mod = dt_file_mod ;
   m_ull_file_size = ull_file_size ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                          End of file CTagVisu.cpp                         !
+==========================================================================*/
