/*====================================+=====================================+
! File CFileAccess.cpp                ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include <wx/wx.h>
#include "CFileAccess.h"
#include "common/sr_lib.h"
/*-------------------------------------------------------------------------*/



/*--( The offset of the end of the file )----------------------------------*/
wxFileOffset CFileAccess::get_end_offset()
{
   /*----------------------------------------------------------------------*/
   wxFileOffset fo_off_end  ;
   wxFileOffset fo_off_sav  ;
   /*----------------------------------------------------------------------*/
   if(    ( fo_off_sav = Tell() ) == wxInvalidOffset
       || SeekEnd() == wxInvalidOffset
       || ( fo_off_end = Tell() ) == wxInvalidOffset
       || Seek( fo_off_sav ) == wxInvalidOffset
     )
   {  return( wxInvalidOffset ) ; }
   /*----------------------------------------------------------------------*/
   return( fo_off_end ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileAccess::read_buffer( size_t sz, void *p_buffer )
{
   /*----------------------------------------------------------------------*/
   size_t sz_read ;
   /*----------------------------------------------------------------------*/
   if( ( sz_read = Read( p_buffer, sz ) ) == ( size_t )wxInvalidOffset )
   {  return( -1 ) ; }
   /*----------------------------------------------------------------------*/
   if( sz_read != sz )
   {  return( -2 ) ; }
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileAccess::read_buffer( size_t sz, wxMemoryBuffer &mb )
{
   /*----------------------------------------------------------------------*/
   size_t sz_read ;
   /*----------------------------------------------------------------------*/
   sz_read = Read( mb.GetWriteBuf( sz ), sz ) ;
   mb.UngetWriteBuf( sz ) ;
   /*----------------------------------------------------------------------*/
   if( sz_read == ( size_t )wxInvalidOffset )
   {  return( -1 ) ; }
   /*----------------------------------------------------------------------*/
   if( sz_read != sz )
   {  return( -2 ) ; }
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*--( sz: size to read & size finally read )-------------------------------*/
int CFileAccess::read_buffer_max( size_t &sz, void *p_buffer )
{
   /*----------------------------------------------------------------------*/
   size_t sz_read ;
   /*----------------------------------------------------------------------*/
   if( ( sz_read = Read( p_buffer, sz ) ) == ( size_t )wxInvalidOffset )
   {  return( -1 ) ; }
   /*----------------------------------------------------------------------*/
   sz = sz_read ;
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*--( The sequence is skipped ... )----------------------------------------*/
int CFileAccess::search_next_seq( const wxUint8 b, size_t sz_size,
                                  wxFileOffset &fo_offset
                                )
{
   /*----------------------------------------------------------------------*/
   wxUint8 tb_b_buffer[ 512 ] ;
   size_t  sz_buffer          ;
   int     i_num              ;

   /*----------------------------------------------------------------------*/
   do
   {  /*-------------------------------------------------------------------*/
      sz_buffer = wxMin( sizeof( tb_b_buffer ), sz_size ) ;
      /*-------------------------------------------------------------------*/
      if( read_buffer_max( sz_buffer, tb_b_buffer ) != 0 )
      {  return( -1 ) ; }
      /*--( File end reached ? )-------------------------------------------*/
      if( sz_buffer < sizeof( tb_b_buffer ) && sz_size > sz_buffer )
      {  sz_size = sz_buffer ; }
      /*-------------------------------------------------------------------*/
      for( i_num = 0 ;
           i_num < ( int )sz_buffer && tb_b_buffer[ i_num ] != b ;
           ++i_num
         )
      {  ; }
      /*-------------------------------------------------------------------*/
      sz_size -= sz_buffer ;
      /*-------------------------------------------------------------------*/
   } while( tb_b_buffer[ i_num ] != b && sz_size != 0 ) ;

   /*--( Found ? )---------------------------------------------------------*/
   if( tb_b_buffer[ i_num ] != b ) { return( -2 ) ; }

   /*--( Set the pointer after the sequence )------------------------------*/
   fo_offset = get_offset() - sz_buffer + i_num + sizeof( b ) ;
   /*----------------------------------------------------------------------*/
   if( set_offset( fo_offset ) != 0 ) { return( -3 ) ; }
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*--( The sequence is skipped ... )----------------------------------------*/
int CFileAccess::search_prev_seq( const wxUint32 dw, size_t sz_size,
                                  wxFileOffset &fo_offset
                                )
{
   /*----------------------------------------------------------------------*/
   wxUint8  tb_b_buffer[ 1024 * 4 ] ;
   size_t   sz_buffer               ;
   bool     boo_first_buffer = true ;
   wxUint32 dw_val           = 0    ;
   int      i_num                   ;
   /*----------------------------------------------------------------------*/
   fo_offset = get_offset() ;
   /*----------------------------------------------------------------------*/
   do
   {  /*-------------------------------------------------------------------*/
      sz_buffer  = wxMin( sizeof( tb_b_buffer ), sz_size ) ;
      fo_offset -= sz_buffer ;
      if( fo_offset < 0 ) { fo_offset = 0 ; }
      /*-------------------------------------------------------------------*/
      if( set_offset( fo_offset ) != 0 ) { return( -1 ) ; }
      if( read_buffer_max( sz_buffer, tb_b_buffer ) != 0 )
      {  return( -2 ) ; }
      /*-------------------------------------------------------------------*/
      if( !boo_first_buffer )
      {  i_num = sz_buffer ; }
      else
      {  /*----------------------------------------------------------------*/
         boo_first_buffer = false ;
         i_num = sz_buffer - sizeof( dw_val ) ;
         /*----------------------------------------------------------------*/
         if( i_num >= 0 )
         {  dw_val = sr::pb_to_ui32( &tb_b_buffer[ i_num ] ) ; }
         /*----------------------------------------------------------------*/
      }
      /*-------------------------------------------------------------------*/
      while( --i_num >= 0 && dw_val != dw )
      {  /*----------------------------------------------------------------*/
         dw_val <<= 8 ;
         dw_val |= tb_b_buffer[ i_num ] ;
         /*----------------------------------------------------------------*/
      }
      /*-------------------------------------------------------------------*/
      sz_size -= sz_buffer ;
      /*-------------------------------------------------------------------*/
   } while( dw_val != dw && fo_offset > 0 && sz_size != 0 ) ;

   /*--( Found ? )---------------------------------------------------------*/
   if( dw_val != dw ) { return( -3 ) ; }

   /*--( Set the pointer after the sequence )------------------------------*/
   fo_offset += i_num + 1 + sizeof( dw_val ) ;
   if( set_offset( fo_offset ) != 0 ) { return( -4 ) ; }
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*--( The sequence is skipped ... )----------------------------------------*/
int CFileAccess::search_last_seq( const wxUint32 dw, size_t sz_size,
                                  wxFileOffset &fo_offset
                                )
{
   /*----------------------------------------------------------------------*/
   if( set_offset_from_end( 0 ) != 0 )
   {  return( -50 ) ; }
   /*----------------------------------------------------------------------*/
   return( search_prev_seq( dw, sz_size, fo_offset ) ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileAccess::read_data( wxUint8 &b )
{
   /*----------------------------------------------------------------------*/
   if( read_buffer( sizeof( b ), &b ) != 0 )
   {  return( -1 ) ; }
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileAccess::read_data( wxUint32 &dw )
{
   /*----------------------------------------------------------------------*/
   if( read_buffer( sizeof( dw ), &dw ) != 0 )
   {  return( -1 ) ; }
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileAccess::read_be_data( size_t sz, wxUint32 &dw )
{
   /*----------------------------------------------------------------------*/
   if( sz > sizeof( dw ) ) { return( -1 ) ; }
   /*----------------------------------------------------------------------*/
   dw = 0 ;
   /*----------------------------------------------------------------------*/
   if( read_buffer( sz, ( wxUint8 * )&dw + sizeof( dw ) - sz ) != 0 )
   {  return( -2 ) ; }
   /*----------------------------------------------------------------------*/
#if wxBYTE_ORDER == wxLITTLE_ENDIAN
   dw = wxUINT32_SWAP_ALWAYS( dw ) ;
#endif
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileAccess::read_be_data( size_t sz, wxUint64 &ddw )
{
   /*----------------------------------------------------------------------*/
   if( sz > sizeof( ddw ) ) { return( -1 ) ; }
   /*----------------------------------------------------------------------*/
   ddw = 0 ;
   /*----------------------------------------------------------------------*/
   if( read_buffer( sz, ( wxUint8 * )&ddw + sizeof( ddw ) - sz ) != 0 )
   {  return( -2 ) ; }
   /*----------------------------------------------------------------------*/
#if wxBYTE_ORDER == wxLITTLE_ENDIAN
   ddw = wxUINT64_SWAP_ALWAYS( ddw ) ;
#endif
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileAccess::read_le_data( wxUint16 &w )
{
   /*----------------------------------------------------------------------*/
   if( read_buffer( sizeof( w ), &w ) != 0 )
   {  return( -1 ) ; }
   /*----------------------------------------------------------------------*/
#if wxBYTE_ORDER == wxBIG_ENDIAN
   w = wxUINT16_SWAP_ALWAYS( w ) ;
#endif
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileAccess::read_be_data( wxUint16 &w )
{
   /*----------------------------------------------------------------------*/
   if( read_buffer( sizeof( w ), &w ) != 0 )
   {  return( -1 ) ; }
   /*----------------------------------------------------------------------*/
#if wxBYTE_ORDER == wxLITTLE_ENDIAN
   w = wxUINT16_SWAP_ALWAYS( w ) ;
#endif
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileAccess::read_le_data( wxUint32 &dw )
{
   /*----------------------------------------------------------------------*/
   if( read_buffer( sizeof( dw ), &dw ) != 0 )
   {  return( -1 ) ; }
   /*----------------------------------------------------------------------*/
#if wxBYTE_ORDER == wxBIG_ENDIAN
   dw = wxUINT32_SWAP_ALWAYS( dw ) ;
#endif
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileAccess::read_be_data( wxUint32 &dw )
{
   /*----------------------------------------------------------------------*/
   if( read_buffer( sizeof( dw ), &dw ) != 0 )
   {  return( -1 ) ; }
   /*----------------------------------------------------------------------*/
#if wxBYTE_ORDER == wxLITTLE_ENDIAN
   dw = wxUINT32_SWAP_ALWAYS( dw ) ;
#endif
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileAccess::read_le_data( wxUint64 &ddw )
{
   /*----------------------------------------------------------------------*/
   if( read_buffer( sizeof( ddw ), &ddw ) != 0 )
   {  return( -1 ) ; }
   /*----------------------------------------------------------------------*/
#if wxBYTE_ORDER == wxBIG_ENDIAN
   ddw = wxUINT64_SWAP_ALWAYS( ddw ) ;
#endif
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileAccess::read_be_data( wxUint64 &ddw )
{
   /*----------------------------------------------------------------------*/
   if( read_buffer( sizeof( ddw ), &ddw ) != 0 )
   {  return( -1 ) ; }
   /*----------------------------------------------------------------------*/
#if wxBYTE_ORDER == wxLITTLE_ENDIAN
   ddw = wxUINT64_SWAP_ALWAYS( ddw ) ;
#endif
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileAccess::read_le_data( str_chunk &chunk )
{
   /*----------------------------------------------------------------------*/
   if( read_buffer( sizeof( chunk ), &chunk ) != 0 )
   {  return( -1 ) ; }
   /*----------------------------------------------------------------------*/
#if wxBYTE_ORDER == wxBIG_ENDIAN
// chunk.dw_id   = wxUINT32_SWAP_ALWAYS( chunk.dw_id   ) ;
   chunk.dw_size = wxUINT32_SWAP_ALWAYS( chunk.dw_size ) ;
#endif
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileAccess::read_be_data( str_chunk &chunk )
{
   /*----------------------------------------------------------------------*/
   if( read_buffer( sizeof( chunk ), &chunk ) != 0 )
   {  return( -1 ) ; }
   /*----------------------------------------------------------------------*/
#if wxBYTE_ORDER == wxLITTLE_ENDIAN
// chunk.dw_id   = wxUINT32_SWAP_ALWAYS( chunk.dw_id   ) ;
   chunk.dw_size = wxUINT32_SWAP_ALWAYS( chunk.dw_size ) ;
#endif
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileAccess::read_be_data( str_atom &atom )
{
   /*----------------------------------------------------------------------*/
   if( read_buffer( sizeof( atom ), &atom ) != 0 )
   {  return( -1 ) ; }
   /*----------------------------------------------------------------------*/
#if wxBYTE_ORDER == wxLITTLE_ENDIAN
   atom.dw_size = wxUINT32_SWAP_ALWAYS( atom.dw_size ) ;
// atom.dw_id   = wxUINT32_SWAP_ALWAYS( atom.dw_id   ) ;
#endif
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileAccess::read_be_data( str_atom_short &atom_short )
{
   /*----------------------------------------------------------------------*/
   if( read_buffer( sizeof( atom_short ), &atom_short ) != 0 )
   {  return( -1 ) ; }
   /*----------------------------------------------------------------------*/
#if wxBYTE_ORDER == wxLITTLE_ENDIAN
   atom_short.w_size = wxUINT16_SWAP_ALWAYS( atom_short.w_size ) ;
// atom_short.w_id   = wxUINT16_SWAP_ALWAYS( atom_short.w_id   ) ;
#endif
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileAccess::read_le_data( str_riff_header &rh )
{
   /*----------------------------------------------------------------------*/
   if(    read_le_data( rh.main_chunk ) != 0
       || read_le_data( rh.dw_id ) != 0
     )
   {  return( -1 ) ; }

   /*--( It has to begin with ... )----------------------------------------*/
   if( rh.main_chunk.dw_id != SR_FOURCC( 'R','I','F','F' ) )
   {  return( -2 ) ; }

   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*--( Only the beginning of the structure might be needed )----------------*/
int CFileAccess::read_le_data( str_WAVEFORMATEX &wfx, size_t sz_size )
{
   /*----------------------------------------------------------------------*/
   if( read_buffer( sz_size, &wfx ) != 0 )
   {  return( -1 ) ; }
   /*----------------------------------------------------------------------*/
#if wxBYTE_ORDER == wxBIG_ENDIAN
   wfx.wFormatTag      = wxUINT16_SWAP_ALWAYS( wfx.wFormatTag      ) ;
   wfx.nChannels       = wxUINT16_SWAP_ALWAYS( wfx.nChannels       ) ;
   wfx.nSamplesPerSec  = wxUINT32_SWAP_ALWAYS( wfx.nSamplesPerSec  ) ;
   wfx.nAvgBytesPerSec = wxUINT32_SWAP_ALWAYS( wfx.nAvgBytesPerSec ) ;
   wfx.nBlockAlign     = wxUINT16_SWAP_ALWAYS( wfx.nBlockAlign     ) ;
   wfx.wBitsPerSample  = wxUINT16_SWAP_ALWAYS( wfx.wBitsPerSample  ) ;
   wfx.cbSize          = wxUINT16_SWAP_ALWAYS( wfx.cbSize          ) ;
#endif
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileAccess::read_le_data( str_BITMAPINFOHEADER &bih )
{
   /*----------------------------------------------------------------------*/
   if( read_buffer( sizeof( bih ), &bih ) != 0 )
   {  return( -1 ) ; }
   /*----------------------------------------------------------------------*/
#if wxBYTE_ORDER == wxBIG_ENDIAN
   bih.biSize          = wxUINT32_SWAP_ALWAYS( bih.biSize          ) ;
   bih.biWidth         = wxINT32_SWAP_ALWAYS(  bih.biWidth         ) ;
   bih.biHeight        = wxINT32_SWAP_ALWAYS(  bih.biHeight        ) ;
   bih.biPlanes        = wxUINT16_SWAP_ALWAYS( bih.biPlanes        ) ;
   bih.biBitCount      = wxUINT16_SWAP_ALWAYS( bih.biBitCount      ) ;
   bih.biCompression   = wxUINT32_SWAP_ALWAYS( bih.biCompression   ) ;
   bih.biSizeImage     = wxUINT32_SWAP_ALWAYS( bih.biSizeImage     ) ;
   bih.biXPelsPerMeter = wxINT16_SWAP_ALWAYS(  bih.biXPelsPerMeter ) ;
   bih.biYPelsPerMeter = wxINT16_SWAP_ALWAYS(  bih.biYPelsPerMeter ) ;
   bih.biClrUsed       = wxUINT32_SWAP_ALWAYS( bih.biClrUsed       ) ;
   bih.biClrImportant  = wxUINT32_SWAP_ALWAYS( bih.biClrImportant  ) ;
#endif
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                      End of file CFileAccess.cpp                          !
+==========================================================================*/
