/*====================================+=====================================+
! File CDlgManRen.cpp                 ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include <wx/filename.h>
#include "CApp.h"
#include "CDlgManRen.h"
#include "siren.h"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
CDlgManRen::CDlgManRen( wxWindow *parent )
          : CDlgManRenBase( parent )
{
   /*----------------------------------------------------------------------*/
   wxGetApp().init_tlw_rect( this, wxGetApp().M_rec_manren ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CDlgManRen::~CDlgManRen()
{
   /*----------------------------------------------------------------------*/
   wxGetApp().save_tlw_rect( this, wxGetApp().M_rec_manren ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CDlgManRen::OnKeyDown( wxKeyEvent &event )
{
   /*----------------------------------------------------------------------*/
   if( g_is_edit_info_event( event ) )
   {  g_disp_edit_info( m_s_name ) ; }
   else
   {  event.Skip() ; }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CDlgManRen::OnBtOk( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   EndModal( wxID_OK ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CDlgManRen::OnSetFocusName( wxFocusEvent &event )
{
   /*----------------------------------------------------------------------*/
   wxString s_name = m_s_name->GetValue() ;
   wxString s_path ;
   wxString s_ext ;
   long     l_sel_from ;
   long     l_sel_to ;

   /*--( Limit text selection to the base name part )----------------------*/
   wxFileName::SplitPath( s_name, &s_path, NULL, &s_ext ) ;
   l_sel_from = ( s_path.empty() ? 0 : s_path.size() + 1 ) ;
   l_sel_to   = s_name.size() - ( s_ext.empty() ? 0 : 1 + s_ext.size() ) ;
   m_s_name->SetSelection( l_sel_from, l_sel_to ) ;

   /*----------------------------------------------------------------------*/
   m_s_name->Unbind( wxEVT_SET_FOCUS, &CDlgManRen::OnSetFocusName, this ) ;
   /*----------------------------------------------------------------------*/
   event.Skip() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CDlgManRen::get_modal( wxString &s_name )
{
   /*----------------------------------------------------------------------*/
   m_s_name->Bind( wxEVT_SET_FOCUS, &CDlgManRen::OnSetFocusName, this ) ;
   /*----------------------------------------------------------------------*/
   m_s_name->SetValue( s_name ) ;
   m_s_name->SetFocus() ;
   /*----------------------------------------------------------------------*/
   if( ShowModal() == wxID_OK )
   {  s_name = m_s_name->GetValue() ; }
   /*----------------------------------------------------------------------*/
   return( GetReturnCode() ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                       End of file CDlgManRen.cpp                          !
+==========================================================================*/
