/*====================================+=====================================+
! File CDirHistory.cpp                ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include <wx/menu.h>
#include "CApp.h"
#include "CDirHistory.h"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
void CDirHistory::add( const wxString &s_val )
{
   /*--( Don't store twice the same value )--------------------------------*/
   if( !m_as_val.empty() && m_as_val.Last() == s_val )
   {  return ; }
   /*--( Delete what comes after, like a file explorer does )--------------*/
   if( m_i_curr_val < ( int )m_as_val.GetCount() - 1 )
   {  m_as_val.RemoveAt( m_i_curr_val + 1,
                         m_as_val.GetCount() - m_i_curr_val - 1
                       ) ;
   }
   /*--( Limit the history size )------------------------------------------*/
   if( m_as_val.GetCount() >= HISTORY_MAX_SIZE )
   {  m_as_val.RemoveAt( 0 ) ; }
   /*----------------------------------------------------------------------*/
   m_as_val.Add( s_val ) ;
   /*----------------------------------------------------------------------*/
   m_i_curr_val = m_as_val.GetCount() - 1 ;
   /*----------------------------------------------------------------------*/
}

/*--( A relative number is "relative" to the current value: +/- )---------*/
bool CDirHistory::get_relative_exists( int i_pos ) const
{
   /*----------------------------------------------------------------------*/
   int i_num = m_i_curr_val + i_pos ;
   /*----------------------------------------------------------------------*/
   return( i_num >= 0 && i_num < ( int )m_as_val.GetCount() ) ;
   /*----------------------------------------------------------------------*/
}

/*--------------------------------------------------------------------------+
! "returns" the string relatively to the current position.                  !
! The index can be positive or negative.                                    !
! This function doesn't change the "current" value.                         !
+--------------------------------------------------------------------------*/
int CDirHistory::get_relative( int i_pos, wxString &s_val ) const
{
   /*----------------------------------------------------------------------*/
   if( !get_relative_exists( i_pos ) )
   {  s_val.clear() ; return( -1 ) ; }
   /*----------------------------------------------------------------------*/
   s_val = m_as_val[ m_i_curr_val + i_pos ] ;
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CDirHistory::move_back( wxString &s_val )
{
   /*----------------------------------------------------------------------*/
   if( !get_back_possible() ) { s_val.clear() ; return( -1 ) ; }
   /*----------------------------------------------------------------------*/
   s_val = m_as_val[ --m_i_curr_val ] ;
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CDirHistory::move_forward( wxString &s_val )
{
   /*----------------------------------------------------------------------*/
   if( !get_forward_possible() ) { s_val.clear() ; return( -1 ) ; }
   /*----------------------------------------------------------------------*/
   s_val = m_as_val[ ++m_i_curr_val ] ;
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CDirHistory::move_to( int i_num, wxString &s_val )
{
   /*----------------------------------------------------------------------*/
   if( i_num < 0 || i_num >= ( int )m_as_val.GetCount() )
   {  s_val.clear() ; return( -1 ) ; }
   /*----------------------------------------------------------------------*/
   m_i_curr_val = i_num             ;
   s_val = m_as_val[ m_i_curr_val ] ;
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CDirHistory::fill_menu( wxMenu *p_menu, e_dh_direction dh_direction
                          ) const
{
   /*----------------------------------------------------------------------*/
   const int co_i_max_option_nb = 25 ;
   int       i_option_incr           ;
   int       i_option_num            ;
   wxString  s_dir                   ;

   /*----------------------------------------------------------------------*/
   i_option_incr = ( dh_direction == DH_BACK ? -1 : +1 ) ;

   /*-----------------------------------------------------------------------+
   ! The default command is the one used by the associated dropdown button  !
   +-----------------------------------------------------------------------*/
   for( i_option_num = 1 ;
           get_relative( i_option_num * i_option_incr, s_dir ) == 0
        && i_option_num <= co_i_max_option_nb
        && i_option_num < g_co_i_reserve_menu_id ;
        ++i_option_num
      )
   {  /*-------------------------------------------------------------------*/
      if( i_option_num == 2 ) { p_menu->AppendSeparator() ; }
      /*-------------------------------------------------------------------*/
      p_menu->Append(   HIS_MENU_ID_START
                      + m_i_curr_val
                      + i_option_num * i_option_incr,
                      s_dir
                    ) ;
      /*-------------------------------------------------------------------*/
   }

   /*--( The menu choice will be handled in a standard event )-------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                       End of file CDirHistory.cpp                         !
+==========================================================================*/
