/*====================================+=====================================+
! File CCompletion.cpp                ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include <wx/menu.h>
#include "CApp.h"
#include "CCompletion.h"
#include "CCombo.h"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
static const CCompletion::str_var_desc st_tb_vd_completion_base[]
= {
    { "%f", wxTRANSLATE( "File name without path" ) },
    { "%fa", wxTRANSLATE( "File name with absolute path" ) },
    { "%fc", wxTRANSLATE( "File name as displayed/computed" ) },
    { "%fd", wxTRANSLATE( "DOS Name without path" ) },
    { "%b", wxTRANSLATE( "Base name" ) },
    { "%bd", wxTRANSLATE( "DOS base name" ) },
    { "%e", wxTRANSLATE( "Extension" ) },
    { "%ed", wxTRANSLATE( "DOS name extension" ) },
    { "%s", wxTRANSLATE( "Size in most appropriate unit" ) },
    { "%sb", wxTRANSLATE( "Size in bytes" ) },
    { "%sk", wxTRANSLATE( "Size in kibibytes" ) },
    { "%sm", wxTRANSLATE( "Size in mebibytes" ) },
    { "%sg", wxTRANSLATE( "Size in gibibytes" ) },
    { "%a", wxTRANSLATE( "Attributes" ) },
    { "%y", wxTRANSLATE( "Type" ) },
    { "%yd", wxTRANSLATE( "Type detected" ) },
    { "%dm", wxTRANSLATE( "Modification date and time" ) },
    { "%dmd", wxTRANSLATE( "Modification date" ) },
    { "%dmt", wxTRANSLATE( "Modification time" ) },
    { "%dc", wxTRANSLATE( "Creation date and time" ) },
    { "%dcd", wxTRANSLATE( "Creation date" ) },
    { "%dct", wxTRANSLATE( "Creation time" ) },
    { "%da", wxTRANSLATE( "Last access date and time" ) },
    { "%dad", wxTRANSLATE( "Last access date" ) },
    { "%dat", wxTRANSLATE( "Last access time" ) },
    { "%cm", wxTRANSLATE( "MD5 checksum" ) },
    { "%cs", wxTRANSLATE( "SHA1 checksum" ) },
    { "%cc", wxTRANSLATE( "CRC32 checksum" ) },
    { "%N", wxTRANSLATE( "1st number in base name" ) },
    { "%N2", wxTRANSLATE( "2nd number in base name" ),
      HELP_VAR "#%N"
    },
    { "%Nn", wxTRANSLATE( "nth number in base name" ),
      HELP_VAR "#%N"
    },
    { "%NN", wxTRANSLATE( "1st non numeric string in base name" ) },
    { "%NN2", wxTRANSLATE( "2nd non numeric string in base name" ),
      HELP_VAR "#%NN"
    },
    { "%NNn", wxTRANSLATE( "nth non numeric string in base name" ),
      HELP_VAR "#%NN"
    },
    { "%n", wxTRANSLATE( "Selection number in file list" ) },
    { "%np", wxTRANSLATE( "Selection number relative to file path" ) },
    { "%nc",
      wxTRANSLATE( "Selection number relative to a name collision" )
    },
    { "%ncs",
      wxTRANSLATE( "Selection collision number starting at the 2nd elmt" )
    },
    { "%ncf", wxTRANSLATE( "\"%nc\" path not taken into account" ) },
    { "%ncfs", wxTRANSLATE( "\"%ncs\" path not taken into account" ) },
    { "%ns", wxTRANSLATE( "Number of selected files" ) },
    { "%p", wxTRANSLATE( "Parent directory" ) },
    { "%pn", wxTRANSLATE( "nth level parent directory" ), HELP_VAR "#%p" },
    { "%pa", wxTRANSLATE( "Absolute path" ) },
    { "%pr", wxTRANSLATE( "Relative path" ) },
    { "%P", wxTRANSLATE( "Current directory" ) },
    { "%Pe", wxTRANSLATE( "Siren executable directory" ) },
    { "%D", wxTRANSLATE( "Current date and time" ) },
    { "%Dd", wxTRANSLATE( "Current date" ) },
    { "%Dt", wxTRANSLATE( "Current time" ) },
    { "%Rn", wxTRANSLATE( "Random numeric string" ) },
    { "%Ra", wxTRANSLATE( "Random alphabetical string" ) },
    { "%Rs", wxTRANSLATE( "Random alphanumeric string" ) },
    { "%C", wxTRANSLATE( "Clipboard line" ) },
    { "%C1", wxTRANSLATE( "1st clipboard line" ), HELP_VAR "#%C" },
    { "%Cn", wxTRANSLATE( "nth clipboard line" ), HELP_VAR "#%C" },
    { "%T{\"\"}", wxTRANSLATE( "Text file line" ), HELP_VAR "#%T" },
    { "%T1{\"\"}", wxTRANSLATE( "1st text file line" ), HELP_VAR "#%T" },
    { "%Tn{\"\"}", wxTRANSLATE( "nth text file line" ), HELP_VAR "#%T" },
    { "*", wxTRANSLATE( "Base name or extension" ), HELP_ADV "#star" },
    { "#{\"\"}", wxTRANSLATE( "Include a favourite expression" ),
      HELP_ADV "#incl"
    },
    { NULL }
  } ;

static const CCompletion::str_var_desc st_tb_vd_completion_audio[]
= {
    { "%Ab", wxTRANSLATE( "Bitrate" ) },
    { "%As", wxTRANSLATE( "Sampling rate" ) },
    { "%AM", wxTRANSLATE( "Mode (mono/stereo/...)" ) },
    { "%Ad", wxTRANSLATE( "Duration" ) },
    { "%Adh", wxTRANSLATE( "Duration in hours, minutes and seconds" ) },
    { "%Adm", wxTRANSLATE( "Duration in minutes and seconds" ) },
    { "%Ads", wxTRANSLATE( "Duration in seconds" ) },
    { "%Ai", wxTRANSLATE( "Information" ) },
    { NULL }
  } ;

static const CCompletion::str_var_desc st_tb_vd_completion_id3v1_tag[]
= {
    { "%mt", wxTRANSLATE( "Title" ) },
    { "%ma", wxTRANSLATE( "Artist" ) },
    { "%mA", wxTRANSLATE( "Album" ) },
    { "%my", wxTRANSLATE( "Year" ) },
    { "%mc", wxTRANSLATE( "Comment" ) },
    { "%mT", wxTRANSLATE( "Track number" ) },
    { "%mg", wxTRANSLATE( "Genre" ) },
    { NULL }
  } ;

static const CCompletion::str_var_desc st_tb_vd_completion_audio_tag[]
= {
    { "%At", wxTRANSLATE( "Title" ) },
    { "%Aa", wxTRANSLATE( "Artist" ) },
    { "%AA", wxTRANSLATE( "Album" ) },
    { "%Ay", wxTRANSLATE( "Year" ) },
    { "%Ac", wxTRANSLATE( "Comment" ) },
    { "%AT", wxTRANSLATE( "Track number" ) },
    { "%An", wxTRANSLATE( "Number of tracks" ) },
    { "%Ak", wxTRANSLATE( "Track" ) },
    { "%AD", wxTRANSLATE( "Disk" ) },
    { "%Ag", wxTRANSLATE( "Genre" ) },
    { "%Ap", wxTRANSLATE( "Composer" ) },
    { "%Ao", wxTRANSLATE( "Original artist" ) },
    { "%AC", wxTRANSLATE( "Copyright" ) },
    { "%Au", wxTRANSLATE( "URL" ) },
    { "%Ae", wxTRANSLATE( "Encoded by" ) },
    { "%AIf", wxTRANSLATE( "Format of attached image" ) },
    { NULL }
  } ;

static const CCompletion::str_var_desc st_tb_vd_completion_video[]
= {
    { "%Vx", wxTRANSLATE( "Width" ) },
    { "%Vy", wxTRANSLATE( "Height" ) },
    { "%Vs", wxTRANSLATE( "Sampling rate" ) },
    { "%VM", wxTRANSLATE( "Mode (mono/stereo/...)" ) },
    { "%Vd", wxTRANSLATE( "Duration" ) },
    { "%Vdh", wxTRANSLATE( "Duration in hours, minutes and seconds" ) },
    { "%Vdm", wxTRANSLATE( "Duration in minutes and seconds" ) },
    { "%Vds", wxTRANSLATE( "Duration in seconds" ) },
    { "%Vf", wxTRANSLATE( "Frames per second" ) },
    { "%Vi", wxTRANSLATE( "Information" ) },
    { NULL }
  } ;

static const CCompletion::str_var_desc st_tb_vd_completion_video_tag[]
= {
    { "%Vt", wxTRANSLATE( "Title" ) },
    { "%VU", wxTRANSLATE( "Subject" ) },
    { "%Va", wxTRANSLATE( "Artist" ) },
    { "%Vc", wxTRANSLATE( "Comment" ) },
    { "%Vk", wxTRANSLATE( "Keywords" ) },
    { "%VE", wxTRANSLATE( "Engineer" ) },
    { "%VT", wxTRANSLATE( "Technician" ) },
    { "%Vg", wxTRANSLATE( "Genre" ) },
    { "%Vn", wxTRANSLATE( "Creation date" ) },
    { "%VO", wxTRANSLATE( "Source" ) },
    { "%VC", wxTRANSLATE( "Copyright" ) },
    { "%VS", wxTRANSLATE( "Software" ) },
    { "%VIf", wxTRANSLATE( "Format of attached image" ) },
    { "%VDd", wxTRANSLATE( "DV avi date" ) },
    { "%VDdd", wxTRANSLATE( "DV avi date \"date part\"" ) },
    { "%VDdt", wxTRANSLATE( "DV avi date \"time part\"" ) },
    { "%VDt", wxTRANSLATE( "DV avi time code" ) },
    { NULL }
  } ;

static const CCompletion::str_var_desc st_tb_vd_completion_image[]
= {
    { "%Ix", wxTRANSLATE( "Width" ) },
    { "%Iy", wxTRANSLATE( "Height" ) },
    { "%Ib", wxTRANSLATE( "Bits per pixel" ) },
    { "%Ii", wxTRANSLATE( "Information" ) },
    { NULL }
  } ;

static const CCompletion::str_var_desc st_tb_vd_completion_exif[]
= {
    { "%Xde", wxTRANSLATE( "ImageDescription" ) },
    { "%Xmk", wxTRANSLATE( "Make" ) },
    { "%Xmo", wxTRANSLATE( "Model" ) },
    { "%Xor", wxTRANSLATE( "Orientation" ) },
    { "%Xxr", wxTRANSLATE( "XResolution" ) },
    { "%Xyr", wxTRANSLATE( "YResolution" ) },
    { "%Xru", wxTRANSLATE( "ResolutionUnit" ) },
    { "%Xso", wxTRANSLATE( "Software" ) },
    { "%Xar", wxTRANSLATE( "Artist" ) },
    { "%Xdt", wxTRANSLATE( "DateTime" ) },
    { "%Xdtd", wxTRANSLATE( "DateTime \"date part\"" ) },
    { "%Xdtt", wxTRANSLATE( "DateTime \"time part\"" ) },
    { "%XSt", wxTRANSLATE( "SubsecTime" ) },
    { "%Xwp", wxTRANSLATE( "WhitePoint" ) },
    { "%Xpc", wxTRANSLATE( "PrimaryChromaticities" ) },
    { "%Xyc", wxTRANSLATE( "YCbCrCoefficients" ) },
    { "%Xyp", wxTRANSLATE( "YCbCrPositioning" ) },
    { "%Xbw", wxTRANSLATE( "ReferenceBlackWhite" ) },
    { "%Xcy", wxTRANSLATE( "Copyright" ) },
    { "%Xeo", wxTRANSLATE( "ExifOffset" ) },
    { "%Xgo", wxTRANSLATE( "GPSOffset" ) },
    { "%Xto", wxTRANSLATE( "ThumbnailOffset" ) },
    { "%Xts", wxTRANSLATE( "ThumbnailSize" ) },
    { "%Xet", wxTRANSLATE( "ExposureTime" ) },
    { "%Xfn", wxTRANSLATE( "FNumber" ) },
    { "%Xep", wxTRANSLATE( "ExposureProgram" ) },
    { "%Xsy", wxTRANSLATE( "SpectralSensitivity" ) },
    { "%Xsr", wxTRANSLATE( "ISOSpeedRatings" ) },
    { "%Xve", wxTRANSLATE( "ExifVersion" ) },
    { "%Xdo", wxTRANSLATE( "DateTimeOriginal" ) },
    { "%Xdod", wxTRANSLATE( "DateTimeOriginal \"date part\"" ) },
    { "%Xdot", wxTRANSLATE( "DateTimeOriginal \"time part\"" ) },
    { "%XSo", wxTRANSLATE( "SubsecTimeOriginal" ) },
    { "%Xdd", wxTRANSLATE( "DateTimeDigitized" ) },
    { "%Xddd", wxTRANSLATE( "DateTimeDigitized \"date part\"" ) },
    { "%Xddt", wxTRANSLATE( "DateTimeDigitized \"time part\"" ) },
    { "%XSd", wxTRANSLATE( "SubsecTimeDigitized" ) },
    { "%Xcc", wxTRANSLATE( "ComponentConfiguration" ) },
    { "%Xbp", wxTRANSLATE( "CompressedBitsPerPixel" ) },
    { "%Xss", wxTRANSLATE( "ShutterSpeedValue" ) },
    { "%Xav", wxTRANSLATE( "ApertureValue" ) },
    { "%Xbv", wxTRANSLATE( "BrightnessValue" ) },
    { "%Xev", wxTRANSLATE( "ExposureBiasValue" ) },
    { "%Xma", wxTRANSLATE( "MaxApertureValue" ) },
    { "%Xsd", wxTRANSLATE( "SubjectDistance" ) },
    { "%Xmm", wxTRANSLATE( "MeteringMode" ) },
    { "%Xls", wxTRANSLATE( "LightSource" ) },
    { "%Xfa", wxTRANSLATE( "Flash" ) },
    { "%Xfl", wxTRANSLATE( "FocalLength" ) },
    { "%Xfe", wxTRANSLATE( "FlashEnergy" ) },
    { "%Xuc", wxTRANSLATE( "UserComment" ) },
    { "%Xfv", wxTRANSLATE( "FlashPixVersion" ) },
    { "%Xcs", wxTRANSLATE( "ColorSpace" ) },
    { "%Xiw", wxTRANSLATE( "ExifImageWidth" ) },
    { "%Xih", wxTRANSLATE( "ExifImageHeight" ) },
    { "%Xsf", wxTRANSLATE( "RelatedSoundFile" ) },
    { "%Xfx", wxTRANSLATE( "FocalPlaneXResolution" ) },
    { "%Xfy", wxTRANSLATE( "FocalPlaneYResolution" ) },
    { "%Xfu", wxTRANSLATE( "FocalPlaneResolutionUnit" ) },
    { "%Xei", wxTRANSLATE( "ExposureIndex" ) },
    { "%Xsm", wxTRANSLATE( "SensingMethod" ) },
    { "%Xfs", wxTRANSLATE( "FileSource" ) },
    { "%Xst", wxTRANSLATE( "SceneType" ) },
    { "%Xcr", wxTRANSLATE( "CustomRendered" ) },
    { "%Xem", wxTRANSLATE( "ExposureMode" ) },
    { "%Xwb", wxTRANSLATE( "WhiteBalance" ) },
    { "%Xdz", wxTRANSLATE( "DigitalZoomRatio" ) },
    { "%XfL", wxTRANSLATE( "FocalLengthIn35mmFilm" ) },
    { "%Xsc", wxTRANSLATE( "SceneCaptureType" ) },
    { "%Xgc", wxTRANSLATE( "GainControl" ) },
    { "%Xct", wxTRANSLATE( "Contrast" ) },
    { "%Xsu", wxTRANSLATE( "Saturation" ) },
    { "%Xsh", wxTRANSLATE( "Sharpness" ) },
    { "%XsD", wxTRANSLATE( "SubjectDistanceRange" ) },
    { "%Xui", wxTRANSLATE( "ImageUniqueID" ) },
    { "%Xgv", wxTRANSLATE( "GPSVersionID" ) },
    { "%XlA", wxTRANSLATE( "GPSLatitudeRef" ) },
    { "%Xla", wxTRANSLATE( "GPSLatitude" ) },
    { "%XlO", wxTRANSLATE( "GPSLongitudeRef" ) },
    { "%Xlo", wxTRANSLATE( "GPSLongitude" ) },
    { "%XaL", wxTRANSLATE( "GPSAltitudeRef" ) },
    { "%Xal", wxTRANSLATE( "GPSAltitude" ) },
    { "%XTS", wxTRANSLATE( "GPSTimeStamp" ) },
    { "%Xsa", wxTRANSLATE( "GPSSatellites" ) },
    { "%Xus", wxTRANSLATE( "GPSStatus" ) },
    { "%XmM", wxTRANSLATE( "GPSMeasureMode" ) },
    { "%Xdp", wxTRANSLATE( "GPSDOP" ) },
    { "%XsP", wxTRANSLATE( "GPSSpeedRef" ) },
    { "%Xsp", wxTRANSLATE( "GPSSpeed" ) },
    { "%XtR", wxTRANSLATE( "GPSTrackRef" ) },
    { "%Xtr", wxTRANSLATE( "GPSTrack" ) },
    { "%XiD", wxTRANSLATE( "GPSImgDirectionRef" ) },
    { "%Xid", wxTRANSLATE( "GPSImgDirection" ) },
    { "%Xmd", wxTRANSLATE( "GPSMapDatum" ) },
    { "%XLA", wxTRANSLATE( "GPSDestLatitudeRef" ) },
    { "%XLa", wxTRANSLATE( "GPSDestLatitude" ) },
    { "%XLO", wxTRANSLATE( "GPSDestLongitudeRef" ) },
    { "%XLo", wxTRANSLATE( "GPSDestLongitude" ) },
    { "%XbE", wxTRANSLATE( "GPSDestBearingRef" ) },
    { "%Xbe", wxTRANSLATE( "GPSDestBearing" ) },
    { "%XDR", wxTRANSLATE( "GPSDestDistanceRef" ) },
    { "%XDr", wxTRANSLATE( "GPSDestDistance" ) },
    { NULL }
  } ;

static const CCompletion::str_var_desc st_tb_vd_completion_iptc[]
= {
    { "%Ybl", wxTRANSLATE( "ByLine" ) },
    { "%Ybt", wxTRANSLATE( "BylineTitle" ) },
    { "%Ycy", wxTRANSLATE( "Copyright" ) },
    { "%Ycr", wxTRANSLATE( "Credit" ) },
    { "%Ysr", wxTRANSLATE( "Source" ) },
    { "%Ycw", wxTRANSLATE( "CaptionWriter" ) },
    { "%Ycp", wxTRANSLATE( "Caption" ) },
    { "%Yhl", wxTRANSLATE( "HeadLine" ) },
    { "%Ysi", wxTRANSLATE( "SpecialInstr" ) },
    { "%Yon", wxTRANSLATE( "ObjectName" ) },
    { "%Ydc", wxTRANSLATE( "DateTimeCreated" ) },
    { "%Ydcd", wxTRANSLATE( "DateTimeCreated \"date part\"" ) },
    { "%Ydct", wxTRANSLATE( "DateTimeCreated \"time part\"" ) },
    { "%Ydr", wxTRANSLATE( "DateTimeReleased" ) },
    { "%Ydrd", wxTRANSLATE( "DateTimeReleased \"date part\"" ) },
    { "%Ydrt", wxTRANSLATE( "DateTimeReleased \"time part\"" ) },
    { "%Yct", wxTRANSLATE( "City" ) },
    { "%Ysl", wxTRANSLATE( "SubLocation" ) },
    { "%Yst", wxTRANSLATE( "State" ) },
    { "%Ycc", wxTRANSLATE( "CountryCode" ) },
    { "%Yco", wxTRANSLATE( "Country" ) },
    { "%Yot", wxTRANSLATE( "OriginalTrsf" ) },
    { "%Yca", wxTRANSLATE( "Category" ) },
    { "%Ysc", wxTRANSLATE( "SupplCategories" ) },
    { "%Yes", wxTRANSLATE( "EditStatus" ) },
    { "%Yji", wxTRANSLATE( "JobId" ) },
    { "%Ypg", wxTRANSLATE( "Program" ) },
    { "%Ypv", wxTRANSLATE( "ProgramVersion" ) },
    { "%Ypr", wxTRANSLATE( "Priority" ) },
    { "%Yoc", wxTRANSLATE( "ObjectCycle" ) },
    { "%Ykw", wxTRANSLATE( "Keywords" ) },
    { NULL }
  } ;

static const CCompletion::str_var_desc st_tb_vd_completion_document[]
= {
    { "%Ot", wxTRANSLATE( "Title" ) },
    { "%Os", wxTRANSLATE( "Subject" ) },
    { "%Ov", wxTRANSLATE( "Version" ) },
    { "%Oa", wxTRANSLATE( "Author" ) },
    { "%Od", wxTRANSLATE( "Destination" ) },
    { "%Oc", wxTRANSLATE( "Comments" ) },
    { "%Oi", wxTRANSLATE( "Information" ) },
    { "%OI", wxTRANSLATE( "ID" ) },
    { "%Ok", wxTRANSLATE( "Keywords" ) },
    { "%On", wxTRANSLATE( "Creation date" ) },
    { "%Ond", wxTRANSLATE( "Creation date \"date part\"" ) },
    { "%Ont", wxTRANSLATE( "Creation date \"time part\"" ) },
    { "%Om", wxTRANSLATE( "Modification date" ) },
    { "%Omd", wxTRANSLATE( "Modification date \"date part\"" ) },
    { "%Omt", wxTRANSLATE( "Modification date \"time part\"" ) },
    { "%OA", wxTRANSLATE( "Application" ) },
    { "%ON", wxTRANSLATE( "Company" ) },
    { "%OC", wxTRANSLATE( "Copyright" ) },
    { "%OT", wxTRANSLATE( "Trademarks" ) },
    { "%Ou", wxTRANSLATE( "URL" ) },
    { "%OF", wxTRANSLATE( "Number of files" ) },
    { "%OP", wxTRANSLATE( "Number of pages" ) },
    { "%OL", wxTRANSLATE( "Number of lines" ) },
    { "%OW", wxTRANSLATE( "Number of words" ) },
    { "%OB", wxTRANSLATE( "Number of chars" ) },
    { NULL }
  } ;

static const CCompletion::str_var_desc st_tb_vd_completion_modifier[]
= {
    { "u", wxTRANSLATE( "Uppercase" ) },
    { "l", wxTRANSLATE( "Lowercase" ) },
    { "U", wxTRANSLATE( "Upper first char of each word, lower rest" ) },
    { "L", wxTRANSLATE( "Upper first char, lower rest" ) },
    { "@", wxTRANSLATE( "Accented to standard ASCII" ) },
    { "#", wxTRANSLATE( "Conversion of '%XX' characters" ),
      HELP_MOD "#_"
    },
    { "&", wxTRANSLATE( "UTF8-ascii to UTF8" ) },
    { "+", wxTRANSLATE( "Force case of some words" ) },
    { "-", wxTRANSLATE( "Do not force case of some words" ) },
    { "[i,\"s\"]", wxTRANSLATE( "One array-string element" ),
      HELP_MOD "#bracket"
    },
    { "[i,n,\"s\"]", wxTRANSLATE( "Array-string elements" ),
      HELP_MOD "#bracket"
    },
    { "(p,n)", wxTRANSLATE( "Substring" ),
      HELP_MOD "#mod_substr"
    },
    { "(\"\",\"\",s,n,c)", wxTRANSLATE( "Replace string" ),
      HELP_MOD "#mod_repl"
    },
    { "(\"\")", wxTRANSLATE( "Delete string" ),
      HELP_MOD "#mod_repl"
    },
    { "(s/e/f/m)", wxTRANSLATE( "Regular expression" ),
      HELP_MOD "#mod_regex"
    },
    { "(tr/f/t/m)", wxTRANSLATE( "Transliteration" ),
      HELP_MOD "#mod_tr"
    },
    { "{\"\",t}", wxTRANSLATE( "Date format" ),
      HELP_MOD "#date"
    },
    { "{p,s,i}", wxTRANSLATE( "Selection number" ),
      HELP_MOD "#mosp_sn"
    },
    { "{p,v,n}", wxTRANSLATE( "Number in base name" ),
      HELP_MOD "#mosp_nb"
    },
    { "{n}", wxTRANSLATE( "Non numeric string in base name" ),
      HELP_MOD "#mosp_nn"
    },
    { "{p}", wxTRANSLATE( "Number size" ),
      HELP_MOD "#mosp_ns"
    },
    { "<p,i>", wxTRANSLATE( "Data from a group member file" ),
      HELP_MOD "#group_ren"
    },
    { NULL }
  } ;

static const CCompletion::str_var_desc st_tb_vd_completion_date[]
= {
    { "%a", wxTRANSLATE( "Abbreviated weekday name" ) },
    { "%A", wxTRANSLATE( "Weekday name" ) },
    { "%b", wxTRANSLATE( "Abbreviated month name" ) },
    { "%B", wxTRANSLATE( "Month name" ) },
    { "%c", wxTRANSLATE( "Date/time \"local\"" ) },
    { "%d", wxTRANSLATE( "Day (01-31)" ) },
    { "%H", wxTRANSLATE( "Hour (00-23)" ) },
    { "%I", wxTRANSLATE( "Hour (01-12)" ) },
    { "%j", wxTRANSLATE( "Day (001-366)" ) },
    { "%m", wxTRANSLATE( "Month (01-12)" ) },
    { "%M", wxTRANSLATE( "Minute (00-59)" ) },
    { "%p", wxTRANSLATE( "A.M./P.M." ) },
    { "%S", wxTRANSLATE( "Second (00-59)" ) },
    { "%U", wxTRANSLATE( "Week (Sunday)" ) },
    { "%w", wxTRANSLATE( "Day (0-6)" ) },
    { "%W", wxTRANSLATE( "Week (Monday)" ) },
    { "%x", wxTRANSLATE( "Date \"local\"" ) },
    { "%X", wxTRANSLATE( "Time \"local\"" ) },
    { "%y", wxTRANSLATE( "Year (00-99)" ) },
    { "%Y", wxTRANSLATE( "Year" ) },
    { "%z", wxTRANSLATE( "Time-zone" ) },
    { "%%", wxTRANSLATE( "'%'" ) },
    { "%#c", wxTRANSLATE( "Date/time \"local\" long" ), HELP_DATE "#%_c" },
    { "%#x", wxTRANSLATE( "Date \"local\" long" ), HELP_DATE "#%_x" },
    { NULL }
  } ;



/*-------------------------------------------------------------------------*/
BEGIN_EVENT_TABLE( CCompletionList, wxListCtrl )
   /*----------------------------------------------------------------------*/
   EVT_KEY_DOWN( CCompletionList::OnKeyDown )
   EVT_LIST_ITEM_RIGHT_CLICK( wxID_ANY, CCompletionList::OnItemRightClick )
   EVT_LIST_ITEM_ACTIVATED( wxID_ANY, CCompletionList::OnItemActivated )
   /*----------------------------------------------------------------------*/
END_EVENT_TABLE()
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
CCompletionList::CCompletionList( wxWindow *parent,
                                  CCompletion *p_completion,
                                  const wxString &s_def_help_file
                                )
               : CListCtrlBase( parent, wxID_ANY,
                                wxDefaultPosition, wxDefaultSize,
                                wxLC_REPORT | wxLC_NO_HEADER
                              ),
                 m_p_completion( p_completion ),
                 m_s_def_help_file( s_def_help_file )
{
   /*----------------------------------------------------------------------*/
   InsertColumn( 0, wxEmptyString, wxLIST_FORMAT_LEFT, -1 ) ;
   InsertColumn( 1, wxEmptyString, wxLIST_FORMAT_LEFT, -1 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CCompletionList::OnKeyDown( wxKeyEvent &event )
{
   /*----------------------------------------------------------------------*/
   if( event.GetKeyCode() == WXK_F1 )
   {  show_help_for_current_item() ; }
   else
   {  event.Skip() ; }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CCompletionList::OnItemRightClick( wxListEvent &event )
{
   /*----------------------------------------------------------------------*/
   wxMenu menu ;
   /*----------------------------------------------------------------------*/
   menu.Append( IDM_INS_VAR , _( "&Insert into expression" ) ) ;
   menu.Append( IDM_HELP_VAR, _( "&Help" ) ) ;

   /*----------------------------------------------------------------------*/
   switch( GetPopupMenuSelectionFromUser( menu, event.GetPoint() ) )
   {
      /*-------------------------------------------------------------------*/
      case IDM_INS_VAR :
      {
         /*----------------------------------------------------------------*/
         wxListEvent event_activate( event ) ;
         event_activate.SetEventType( wxEVT_LIST_ITEM_ACTIVATED ) ;
         wxPostEvent( this, event_activate ) ;
         /*----------------------------------------------------------------*/
         break ;
         /*----------------------------------------------------------------*/
      }
      /*-------------------------------------------------------------------*/
      case IDM_HELP_VAR :
         show_help_for_current_item() ;
         break ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CCompletionList::OnItemActivated( wxListEvent &event )
{
   /*--( Add the text to the control maybe replacing the selected text )---*/
   m_p_completion->m_p_textctrl->WriteText( event.GetText() ) ;
   /*--( The expression has changed, the new names have to be recomputed )-*/
   if(    m_p_completion->m_p_textctrl
       == wxGetApp().m_frame->m_cb_exp->GetTextCtrl()
     )
   {  wxGetApp().get_fl()->compute_new_names() ; }
   else
   {  /*--( Send Enter key stroke event to the linked control )------------*/
      wxCommandEvent event_change( wxEVT_COMMAND_TEXT_ENTER, 0 ) ;
      event_change.SetId( m_p_completion->m_p_textctrl->GetId() ) ;
      wxPostEvent( m_p_completion->m_p_textctrl, event_change ) ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CCompletionList::show_help_for_current_item()
{
   /*----------------------------------------------------------------------*/
   const long co_l_item = get_item_focus() ;
   const char *co_p_c_help = ( const char * )GetItemData( co_l_item ) ;
   wxString s_help ;

   /*--( Specific help#anchor or use text as anchor in the def help file )-*/
   if( co_p_c_help != NULL )
   {  s_help = co_p_c_help ; }
   else
   {  s_help = m_s_def_help_file + '#' + GetItemText( co_l_item ) ; }
   /*----------------------------------------------------------------------*/
   wxGetApp().m_frame->show_help( s_help ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
long CCompletionList::search_for( const wxString &s ) const
{
   /*----------------------------------------------------------------------*/
   long l_item ;
   const long co_l_item_max = GetItemCount() ;
   /*----------------------------------------------------------------------*/
   for( l_item = 0 ; l_item < co_l_item_max && GetItemText( l_item ) != s ;
        ++l_item
      )
   {  ; }
   /*----------------------------------------------------------------------*/
   return( l_item < co_l_item_max ? l_item : wxNOT_FOUND ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CCompletion::CCompletion( CCombo *p_combo,
                          wxToolBarToolBase *p_to_btn,
                          wxMenuItem *p_menu_item,
                          const wxString &s_title,
                          CCompletion *&p_saved_addr,
                          CConfigRect &cfg_rec
                        )
           : wxFrame( p_combo, wxID_ANY, s_title,
                      wxDefaultPosition, wxDefaultSize,
                        wxDEFAULT_FRAME_STYLE
                      | wxFRAME_TOOL_WINDOW
                      | wxFRAME_FLOAT_ON_PARENT
                    ),
             m_p_parent( p_combo ), m_p_textctrl( p_combo->GetTextCtrl() ),
             m_p_to_btn( p_to_btn ), m_p_menu_item( p_menu_item ),
             m_p_saved_addr( p_saved_addr ), m_cfg_rec( cfg_rec )
{
   /*----------------------------------------------------------------------*/
   init() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CCompletion::CCompletion( wxTextCtrl *p_textctrl,
                          wxToolBarToolBase *p_to_btn,
                          wxMenuItem *p_menu_item,
                          const wxString &s_title,
                          CCompletion *&p_saved_addr,
                          CConfigRect &cfg_rec
                        )
           : wxFrame( p_textctrl, wxID_ANY, s_title,
                      wxDefaultPosition, wxDefaultSize,
                        wxDEFAULT_FRAME_STYLE
                      | wxFRAME_TOOL_WINDOW
                      | wxFRAME_FLOAT_ON_PARENT
                    ),
             m_p_parent( p_textctrl ), m_p_textctrl( p_textctrl ),
             m_p_to_btn( p_to_btn ), m_p_menu_item( p_menu_item ),
             m_p_saved_addr( p_saved_addr ), m_cfg_rec( cfg_rec )
{
   /*----------------------------------------------------------------------*/
   init() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CCompletion::~CCompletion()
{
   /*----------------------------------------------------------------------*/
   m_p_to_btn->GetToolBar()->ToggleTool( m_p_to_btn->GetId(), false ) ;
   if( m_p_menu_item != NULL ) { m_p_menu_item->Check( false ) ; }
   /*----------------------------------------------------------------------*/
   wxGetApp().save_tlw_rect( this, m_cfg_rec ) ;
   /*--( This window is not displayed any more )---------------------------*/
   m_p_saved_addr = NULL ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CCompletionList *CCompletion::create_page( const wxString &s_title,
                                           const wxString &s_def_help_file
                                         )
{
   /*----------------------------------------------------------------------*/
   CCompletionList *p_list
                 = new CCompletionList( m_nb, this, s_def_help_file ) ;
   /*----------------------------------------------------------------------*/
   m_vec_list.push_back( p_list ) ;
   m_nb->AddPage( p_list, s_title ) ;
   return( p_list ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CCompletion::add_page( const wxString &s_title,
                            const str_var_desc *p_vd,
                            const wxString &s_def_help_file
                          )
{
   /*----------------------------------------------------------------------*/
   CCompletionList *p_list = create_page( s_title, s_def_help_file ) ;
   int             i_num ;
   /*----------------------------------------------------------------------*/
   for( i_num = 0 ; p_vd->co_p_c_var != NULL ; ++p_vd, ++i_num )
   {
      /*-------------------------------------------------------------------*/
      p_list->InsertItem( i_num, p_vd->co_p_c_var ) ;
      p_list->SetItem( i_num, 1, wxGetTranslation( p_vd->co_p_c_desc ) ) ;
      p_list->SetItemPtrData( i_num, ( wxUIntPtr )p_vd->co_p_c_help ) ;
      /*-------------------------------------------------------------------*/
      if( i_num % 2 == 1 && wxGetApp().M_boo_list_alt_attr.get() )
      {  p_list->SetItemBackgroundColour( i_num,
                                          p_list->get_alternate_attr()
                                        ) ;
      }
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   p_list->SetColumnWidth( 0, wxLIST_AUTOSIZE ) ;
   p_list->SetColumnWidth( 1, wxLIST_AUTOSIZE ) ;
   /*--( It looks nicer with the item focused )----------------------------*/
   p_list->set_item_active( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CCompletion::add_page( int i_grp, const str_var_desc *p_vd,
                            const wxString &s_def_help_file
                          )
{
   /*----------------------------------------------------------------------*/
   wxASSERT( i_grp >= GRP_NONE && i_grp < GRP_NB ) ;
   /*----------------------------------------------------------------------*/
   add_page( wxGetApp().m_colgroup.get_name( i_grp ), p_vd,
             s_def_help_file
           ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CCompletion::add_page_env_var( const wxString &s_title )
{
   /*----------------------------------------------------------------------*/
   CCompletionList *p_list = create_page( s_title, HELP_ADV ) ;
   wxEnvVariableHashMap  wxmap_env ;
   wxEnvVariableHashMap::const_iterator cit_wxmap ;
   sr::t_map_str_str     map_env ;
   sr::t_map_str_str_cit cit_map ;
   int                   i_num   ;

   /*----------------------------------------------------------------------*/
   if( !wxGetEnvMap( &wxmap_env ) ) { return ; }

   /*-----------------------------------------------------------------------+
   ! The environment variables have to listed alphabetically.
   ! Unfortunately, contrary to a std::map, wxEnvVariableHashMap doesn't    !
   ! "give back" its elements sorted. Therefore an intermediate std::map is !
   ! used.                                                                  !
   +-----------------------------------------------------------------------*/
   for( cit_wxmap = wxmap_env.begin() ;
        cit_wxmap != wxmap_env.end() ;
        ++cit_wxmap
      )
   {  map_env[ cit_wxmap->first ] = cit_wxmap->second ; }

   /*--( Then fill the list (the map is "sorted") )------------------------*/
   for( cit_map = map_env.begin(), i_num = 0 ;
        cit_map != map_env.end() ;
        ++cit_map, ++i_num
      )
   {
      /*-------------------------------------------------------------------*/
      p_list->InsertItem( i_num, "${" + cit_map->first + '}' ) ;
      p_list->SetItem( i_num, 1, cit_map->second ) ;
      p_list->SetItemPtrData( i_num, ( wxUIntPtr )( HELP_ADV "#enva" ) ) ;
      /*-------------------------------------------------------------------*/
      if( i_num % 2 == 1 && wxGetApp().M_boo_list_alt_attr.get() )
      {  p_list->SetItemBackgroundColour( i_num,
                                          p_list->get_alternate_attr()
                                        ) ;
      }
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
   p_list->SetColumnWidth( 0, wxLIST_AUTOSIZE ) ;
   p_list->SetColumnWidth( 1, wxLIST_AUTOSIZE ) ;
   /*--( It looks nicer with an item focused )-----------------------------*/
   p_list->set_item_active( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CCompletion::init()
{
   /*----------------------------------------------------------------------*/
   wxPanel    *panel = new wxPanel( this ) ;
   wxBoxSizer *sizer = new wxBoxSizer( wxVERTICAL ) ;

   /*----------------------------------------------------------------------*/
   panel->SetSizer( sizer ) ;
   m_nb = new wxNotebook( panel, wxID_ANY ) ;
   sizer->Add( m_nb, 1, wxEXPAND ) ;

   /*--( Never initialized or position not saved )-------------------------*/
   if( m_cfg_rec.get().GetSize() == wxDefaultSize )
   {
      /*-------------------------------------------------------------------*/
      wxRect rect( m_p_parent->GetScreenRect() ) ;
      wxRect size_border( m_p_parent->GetWindowBorderSize() ) ;
      /*-------------------------------------------------------------------*/
      rect.x     -= size_border.GetX() ;
      rect.y     += rect.height - size_border.GetY() ;
      rect.width  = 500 ;
      rect.height = 300 ;
      /*-------------------------------------------------------------------*/
      m_cfg_rec.set( rect ) ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   wxGetApp().tlw_set_rect( this, m_cfg_rec.get() ) ;

   /*--( Add all pages )---------------------------------------------------*/
   add_page( GRP_BASE, st_tb_vd_completion_base, HELP_VAR ) ;
   add_page( GRP_AUDIO, st_tb_vd_completion_audio, HELP_VAR ) ;
   add_page( GRP_ID3V1, st_tb_vd_completion_id3v1_tag, HELP_VAR ) ;
   add_page( GRP_AUDTAG, st_tb_vd_completion_audio_tag, HELP_VAR ) ;
   add_page( GRP_VIDEO, st_tb_vd_completion_video, HELP_VAR ) ;
   add_page( GRP_VIDTAG, st_tb_vd_completion_video_tag, HELP_VAR ) ;
   add_page( GRP_IMG, st_tb_vd_completion_image, HELP_VAR ) ;
   add_page( GRP_EXIF, st_tb_vd_completion_exif, HELP_VAR ) ;
   add_page( GRP_IPTC, st_tb_vd_completion_iptc, HELP_VAR ) ;
   add_page( GRP_DOC, st_tb_vd_completion_document, HELP_VAR ) ;
   add_page( _( "Modifiers" ), st_tb_vd_completion_modifier, HELP_MOD ) ;
   add_page( _( "Date format" ),  st_tb_vd_completion_date, HELP_DATE ) ;
   add_page_env_var( _( "Environment" ) ) ;

   /*--( First page first ... )--------------------------------------------*/
   m_nb->SetSelection( 0 ) ;

   /*----------------------------------------------------------------------*/
   Show( true ) ;
   /*----------------------------------------------------------------------*/
   m_p_to_btn->GetToolBar()->ToggleTool( m_p_to_btn->GetId(), true ) ;
   if( m_p_menu_item != NULL ) { m_p_menu_item->Check( true ) ; }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CCompletion::assign_focus()
{
   /*----------------------------------------------------------------------*/
   if(    m_nb != NULL
       && m_nb->GetSelection() >= 0
       && m_nb->GetSelection() < ( int )m_vec_list.size()
     )
   {  m_vec_list[ m_nb->GetSelection() ]->SetFocus() ; }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CCompletion::show_current_var()
{
   /*----------------------------------------------------------------------*/
   wxString s_search      ;
   long     l_pos_from    ;
   long     l_pos_to      ;
   long     l_pos_percent ;

   /*----------------------------------------------------------------------*/
   m_p_textctrl->GetSelection( &l_pos_from, &l_pos_to ) ;
   s_search = m_p_textctrl->GetValue() ;
   /*--( Search backward for the start of the name )-----------------------*/
   l_pos_percent = s_search.rfind( '%', l_pos_from ) ;
   /*----------------------------------------------------------------------*/
   if( l_pos_percent != ( int )wxString::npos )
   {
      /*--( Search forward for the end of the name )-----------------------*/
      l_pos_from = l_pos_percent ;
      /*-------------------------------------------------------------------*/
      for( l_pos_to = l_pos_from + 1 ;
              l_pos_to < ( long )s_search.size()
           && sr::bool_isalnum( s_search[ l_pos_to ] ) ;
           ++l_pos_to
         )
      {  ; }
      /*-------------------------------------------------------------------*/
      s_search = s_search.Mid( l_pos_from, l_pos_to - l_pos_from ) ;
      /*-------------------------------------------------------------------*/
   }

   /*--( Something to search for ? )---------------------------------------*/
   if( s_search.empty() ) { return ; }

   /*--( And then search for it in the lists )-----------------------------*/
   int  i_num_page ;
   long l_item     ;
   for( i_num_page = l_item = 0 ;
           i_num_page < ( int )m_vec_list.size()
        && ( l_item = m_vec_list[ i_num_page ]->search_for( s_search )
           ) == wxNOT_FOUND ;
        ++i_num_page
      )
   {  ; }

   /*--( Something found ? )-----------------------------------------------*/
   if( i_num_page >= ( int )m_vec_list.size() ) { return ; }

   /*--( Display what has been found )-------------------------------------*/
   m_nb->SetSelection( i_num_page ) ;
   m_vec_list[ i_num_page ]->SetFocus() ;
   m_vec_list[ i_num_page ]->set_item_active( l_item ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                         End of file CCompletion.cpp                       !
+==========================================================================*/
