/*====================================+=====================================+
! File CCombo.cpp                     ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include "common/sr_lib.h"
#include "CApp.h"
#include "CCombo.h"
#include "CCompletion.h"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
BEGIN_EVENT_TABLE( CListBoxComboPopup, wxListBox )
   EVT_MOTION( CListBoxComboPopup::OnMouseMove )
   EVT_LEFT_UP( CListBoxComboPopup::OnMouseLeftClick )
   EVT_RIGHT_UP( CListBoxComboPopup::OnMouseRightClick )
   EVT_KEY_DOWN( CListBoxComboPopup::OnKeyDown )
END_EVENT_TABLE()
/*-------------------------------------------------------------------------*/
BEGIN_EVENT_TABLE( CCombo, wxComboCtrl )
   EVT_KEY_DOWN( CCombo::OnKeyDown )
   EVT_SET_FOCUS( CCombo::OnFocusSet )
   EVT_KILL_FOCUS( CCombo::OnFocusKill )
END_EVENT_TABLE()
/*-------------------------------------------------------------------------*/
BEGIN_EVENT_TABLE( CComboExp, CCombo )
   EVT_KEY_DOWN( CComboExp::OnKeyDown )
END_EVENT_TABLE()
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
CCombo::CCombo( wxWindow *parent, wxWindowID id,
                const wxString &value,
                const wxPoint &pos,
                const wxSize &size,
                int WXUNUSED( n ),
                const wxString WXUNUSED( choices )[],
                long style,
                bool boo_case_sens
              )
       : wxComboCtrl(), m_boo_simulate_enter_key( true )
{
   /*-----------------------------------------------------------------------+
   ! I would have liked to add "wxTE_NOHIDESEL" but the result under XP is  !
   ! hugly.                                                                 !
   +-----------------------------------------------------------------------*/
   Create( parent, id, value, pos, size,
           style | wxCC_STD_BUTTON | wxWANTS_CHARS
         ) ;
   /*----------------------------------------------------------------------*/
   m_popup = new CListBoxComboPopup() ;
   SetPopupControl( m_popup ) ;
   m_popup->set_case_sens( boo_case_sens ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CListBoxComboPopup::OnMouseMove( wxMouseEvent &event )
{
   /*----------------------------------------------------------------------*/
   int i_sel = wxListBox::HitTest( event.GetPosition() ) ;
   if( i_sel != wxNOT_FOUND ) { wxListBox::Select( i_sel ) ; }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CListBoxComboPopup::choose_current_list_element()
{
   /*----------------------------------------------------------------------*/
   m_i_val = wxListBox::GetSelection() ;
   Dismiss() ;
   /*----------------------------------------------------------------------*/
   move_current_value_to_top() ;
   /*--( Execute the action associated when the value changes ? )----------*/
   static_cast< CCombo * >( GetComboCtrl() )->simulate_enter_key_pressed() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CListBoxComboPopup::OnMouseLeftClick( wxMouseEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   choose_current_list_element() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CListBoxComboPopup::delete_current_list_element()
{
   /*----------------------------------------------------------------------*/
   int i_sel = wxListBox::GetSelection() ;
   /*----------------------------------------------------------------------*/
   if( !wxListBox::GetString( i_sel ).empty() )
   {
      /*-------------------------------------------------------------------*/
      wxListBox::Delete( i_sel ) ;
      /*--( Set current selection if possible )----------------------------*/
      if( i_sel >= ( int )wxListBox::GetCount() )
      {  i_sel = wxListBox::GetCount() - 1 ; }
      if( i_sel >= 0 )
      {  wxListBox::Select( i_sel ) ; }
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CListBoxComboPopup::OnMouseRightClick( wxMouseEvent & WXUNUSED( event ))
{
   /*----------------------------------------------------------------------*/
   delete_current_list_element() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CListBoxComboPopup::OnKeyDown( wxKeyEvent &event )
{
   /*----------------------------------------------------------------------*/
   switch( event.GetKeyCode() )
   {
      /*-------------------------------------------------------------------*/
      case WXK_DELETE :
         delete_current_list_element() ;
         break ;
      /*--( Can't catch ENTER key stroke ... use SPACE instead )-----------*/
      case WXK_SPACE :
         choose_current_list_element() ;
         break ;
      /*-------------------------------------------------------------------*/
      case WXK_UP :
         if( wxListBox::GetSelection() > 0 )
         {  wxListBox::Select( wxListBox::GetSelection() - 1 ) ; }
         break ;
      /*-------------------------------------------------------------------*/
      case WXK_DOWN :
         if( wxListBox::GetSelection() < ( int )wxListBox::GetCount() - 1  )
         {  wxListBox::Select( wxListBox::GetSelection() + 1 ) ; }
         break ;
      /*-------------------------------------------------------------------*/
      default :
         event.Skip() ;
         break ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CListBoxComboPopup::add_value_to_list( const wxString &s )
{
   /*--( No empty strings or duplicates in the list )----------------------*/
   if( !s.empty() && FindString( s, m_boo_case_sens ) == wxNOT_FOUND )
   {  Insert( s, 0 ) ; }
   /*----------------------------------------------------------------------*/
}

/*--( Move current selected value to top of the list: MRU )----------------*/
void CListBoxComboPopup::move_current_value_to_top()
{
   /*----------------------------------------------------------------------*/
   wxString s_val ;
   int      i_pos ;
   /*----------------------------------------------------------------------*/
   if( ( i_pos = GetSelection() ) == wxNOT_FOUND )
   {  return ; }
   /*----------------------------------------------------------------------*/
   s_val = GetString( i_pos ) ;
   /*--( The empty (cleaner) string is not moved )-------------------------*/
   if( !s_val.empty() )
   {  Delete( i_pos ) ;
      Insert( s_val, 0 ) ;
      Select( 0 )  ;
   }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CCombo::OnKeyDown( wxKeyEvent &event )
{
   /*----------------------------------------------------------------------*/
   if( g_is_edit_info_event( event ) )
   {  g_disp_edit_info( GetTextCtrl() ) ; }
   else
   if( event.GetKeyCode() == WXK_F1 )
   {  wxGetApp().m_frame->show_help( m_s_help_page ) ; }
   else
   {  event.Skip() ; }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CCombo::OnFocusSet( wxFocusEvent &event )
{
   /*----------------------------------------------------------------------*/
   m_s_setfocus_val = GetValue() ;
   /*----------------------------------------------------------------------*/
   event.Skip() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CCombo::OnFocusKill( wxFocusEvent &event )
{
   /*----------------------------------------------------------------------*/
   if( m_s_setfocus_val != GetValue() )
   {  simulate_enter_key_pressed() ; }
   /*----------------------------------------------------------------------*/
   event.Skip() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CCombo::simulate_enter_key_pressed()
{
   /*----------------------------------------------------------------------*/
   if( !m_boo_simulate_enter_key ) { return ; }

   /*--( Execute the action associated when the value changes ? )----------*/
   if( HasFlag( wxTE_PROCESS_ENTER ) )
   {  /*-------------------------------------------------------------------*/
      wxCommandEvent event_change( wxEVT_COMMAND_TEXT_ENTER, 0 ) ;
      event_change.SetId( GetId() ) ;
      wxPostEvent( this, event_change ) ;
      /*-------------------------------------------------------------------*/
      m_s_setfocus_val = GetValue() ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CComboFil::CComboFil( wxWindow *parent, wxWindowID id,
                      const wxString &value,
                      const wxPoint &pos,
                      const wxSize &size,
                      int n, const wxString choices[],
                      long style
                    )
          : CComboWithCleaner( parent, id, value, pos, size, n, choices,
                               style, wxFileName::IsCaseSensitive()
                             )
{
   /*----------------------------------------------------------------------*/
   m_s_help_page = HELP_FIL ;
   SetToolTip(  _( "File filter examples :\n"
                   "*photo*\n"
                   "*.txt\n"
                   "*.txt;a*.mp3"
                 )
             ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CComboDir::CComboDir( wxWindow *parent, wxWindowID id,
                      const wxString &value,
                      const wxPoint &pos,
                      const wxSize &size,
                      int n, const wxString choices[],
                      long style
                    )
          : CCombo( parent, id, value, pos, size, n, choices,
                    style, wxFileName::IsCaseSensitive()
                  )
{  m_s_help_page = HELP_USER "#dicb" ; }

/*-------------------------------------------------------------------------*/
CComboExp::CComboExp( wxWindow *parent, wxWindowID id,
                      const wxString &value,
                      const wxPoint &pos,
                      const wxSize &size,
                      int n, const wxString choices[],
                      long style
                    )
          : CComboWithCleaner( parent, id, value, pos, size, n, choices,
                               style, true
                             )
{  m_s_help_page = HELP_EXP ; }

/*-------------------------------------------------------------------------*/
void CComboExp::OnKeyDown( wxKeyEvent &event )
{
   /*--( Ctrl+Shift+I => Insert name )-------------------------------------*/
   if(    event.GetKeyCode() == 'I'
       &&    ( event.GetModifiers() & ~wxMOD_ALT )
          == ( wxMOD_CMD | wxMOD_SHIFT )
     )
   {  /*-------------------------------------------------------------------*/
      CFile *p_file = wxGetApp().get_fl()->get_p_file_focus() ;
      /*-------------------------------------------------------------------*/
      if( p_file != NULL )
      {  WriteText( p_file->get_full_name() ) ; }
      /*-------------------------------------------------------------------*/
   }
   else /*--( Ctrl+Shift+B => Double backslashes )-------------------------*/
   if(    event.GetKeyCode() == 'B'
       &&    ( event.GetModifiers() & ~wxMOD_ALT )
          == ( wxMOD_CMD | wxMOD_SHIFT )
     )
   {  /*-------------------------------------------------------------------*/
      CFile *p_file = wxGetApp().get_fl()->get_p_file_focus() ;
      /*-------------------------------------------------------------------*/
      if( p_file != NULL )
      {  /*----------------------------------------------------------------*/
         long l_pos_from ;
         long l_pos_to   ;
         /*----------------------------------------------------------------*/
         GetTextCtrl()->GetSelection( &l_pos_from, &l_pos_to ) ;

         /*--( Heavy but seems the best way to achieve it ... )------------*/
         if( l_pos_from < l_pos_to )
         {
            /*-------------------------------------------------------------*/
            wxString s_val ;
            /*-------------------------------------------------------------*/
            s_val.assign( GetValue(), l_pos_from, l_pos_to - l_pos_from ) ;
            sr::double_backslash( s_val ) ;
            WriteText( s_val ) ;
            /*-------------------------------------------------------------*/
         }
         /*----------------------------------------------------------------*/
      }
      /*-------------------------------------------------------------------*/
   }
   else /*--( "Standard" combo behaviour )---------------------------------*/
   {  CCombo::OnKeyDown( event ) ; }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                         End of file CCombo.cpp                            !
+==========================================================================*/
