/*====================================+=====================================+
! File CColGroup.cpp                  ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include "CColGroup.h"
#include "CApp.h"
/*-------------------------------------------------------------------------*/
#include "small-icons/grp_base.xpm"
#include "famfamfam/grp_audio.xpm"
#include "grp_id3v1.xpm"
#include "grp_audtag.xpm"
#include "famfamfam/grp_video.xpm"
#include "small-icons/grp_vidtag.xpm"
#include "famfamfam/grp_img.xpm"
#include "famfamfam/grp_exif.xpm"
#include "grp_iptc.xpm"
#include "small-icons/grp_doc.xpm"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
CColGroup::CColGroup()
{
   /*----------------------------------------------------------------------*/
   m_tb_group[ GRP_NONE   ].m_i_id_bt       = -1                ;
   m_tb_group[ GRP_NONE   ].m_s_var_name    = wxEmptyString     ;
   m_tb_group[ GRP_NONE   ].m_s_help_anchor = wxEmptyString     ;
   m_tb_group[ GRP_NONE   ].m_xpm           = NULL              ;
   /*----------------------------------------------------------------------*/
   m_tb_group[ GRP_BASE   ].m_i_id_bt       = ID_GRP_BASE       ;
   m_tb_group[ GRP_BASE   ].m_s_var_name    = "disp_grp_base"   ;
   m_tb_group[ GRP_BASE   ].m_s_help_anchor = "base"            ;
   m_tb_group[ GRP_BASE   ].m_xpm           = grp_base_xpm      ;
   /*----------------------------------------------------------------------*/
   m_tb_group[ GRP_AUDIO  ].m_i_id_bt       = ID_GRP_AUDIO      ;
   m_tb_group[ GRP_AUDIO  ].m_s_var_name    = "disp_grp_audio"  ;
   m_tb_group[ GRP_AUDIO  ].m_s_help_anchor = "audio"           ;
   m_tb_group[ GRP_AUDIO  ].m_xpm           = grp_audio_xpm     ;
   /*----------------------------------------------------------------------*/
   m_tb_group[ GRP_ID3V1  ].m_i_id_bt       = ID_GRP_ID3V1      ;
   m_tb_group[ GRP_ID3V1  ].m_s_var_name    = "disp_grp_id3v1"  ;
   m_tb_group[ GRP_ID3V1  ].m_s_help_anchor = "id3v1"           ;
   m_tb_group[ GRP_ID3V1  ].m_xpm           = grp_id3v1_xpm     ;
   /*----------------------------------------------------------------------*/
   m_tb_group[ GRP_AUDTAG ].m_i_id_bt       = ID_GRP_AUDTAG     ;
   m_tb_group[ GRP_AUDTAG ].m_s_var_name    = "disp_grp_audtag" ;
   m_tb_group[ GRP_AUDTAG ].m_s_help_anchor = "audio_tag"       ;
   m_tb_group[ GRP_AUDTAG ].m_xpm           = grp_audtag_xpm    ;
   /*----------------------------------------------------------------------*/
   m_tb_group[ GRP_VIDEO  ].m_i_id_bt       = ID_GRP_VIDEO      ;
   m_tb_group[ GRP_VIDEO  ].m_s_var_name    = "disp_grp_video"  ;
   m_tb_group[ GRP_VIDEO  ].m_s_help_anchor = "video"           ;
   m_tb_group[ GRP_VIDEO  ].m_xpm           = grp_video_xpm     ;
   /*----------------------------------------------------------------------*/
   m_tb_group[ GRP_VIDTAG ].m_i_id_bt       = ID_GRP_VIDTAG     ;
   m_tb_group[ GRP_VIDTAG ].m_s_var_name    = "disp_grp_vidtag" ;
   m_tb_group[ GRP_VIDTAG ].m_s_help_anchor = "video_tag"       ;
   m_tb_group[ GRP_VIDTAG ].m_xpm           = grp_vidtag_xpm    ;
   /*----------------------------------------------------------------------*/
   m_tb_group[ GRP_IMG    ].m_i_id_bt       = ID_GRP_IMG        ;
   m_tb_group[ GRP_IMG    ].m_s_var_name    = "disp_grp_img"    ;
   m_tb_group[ GRP_IMG    ].m_s_help_anchor = "image"           ;
   m_tb_group[ GRP_IMG    ].m_xpm           = grp_img_xpm       ;
   /*----------------------------------------------------------------------*/
   m_tb_group[ GRP_EXIF   ].m_i_id_bt       = ID_GRP_EXIF       ;
   m_tb_group[ GRP_EXIF   ].m_s_var_name    = "disp_grp_exif"   ;
   m_tb_group[ GRP_EXIF   ].m_s_help_anchor = "exif"            ;
   m_tb_group[ GRP_EXIF   ].m_xpm           = grp_exif_xpm      ;
   /*----------------------------------------------------------------------*/
   m_tb_group[ GRP_IPTC   ].m_i_id_bt       = ID_GRP_IPTC       ;
   m_tb_group[ GRP_IPTC   ].m_s_var_name    = "disp_grp_iptc"   ;
   m_tb_group[ GRP_IPTC   ].m_s_help_anchor = "iptc"            ;
   m_tb_group[ GRP_IPTC   ].m_xpm           = grp_iptc_xpm      ;
   /*----------------------------------------------------------------------*/
   m_tb_group[ GRP_DOC    ].m_i_id_bt       = ID_GRP_DOC        ;
   m_tb_group[ GRP_DOC    ].m_s_var_name    = "disp_grp_doc"    ;
   m_tb_group[ GRP_DOC    ].m_s_help_anchor = "doc"             ;
   m_tb_group[ GRP_DOC    ].m_xpm           = grp_doc_xpm       ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CColGroup::~CColGroup()
{  ; }

/*--------------------------------------------------------------------------+
! The names can be translated only after the message catalog has been       !
! loaded. That's done once the config file has been loaded too because it   !
! can contain the language.                                                 !
! So the initialisations have to be separated: "var names" then names       !
+--------------------------------------------------------------------------*/
void CColGroup::init_names()
{
   /*----------------------------------------------------------------------*/
   m_tb_group[ GRP_NONE   ].m_s_name = _( "None" )      ;
   m_tb_group[ GRP_BASE   ].m_s_name = _( "Base" )      ;
   m_tb_group[ GRP_AUDIO  ].m_s_name = _( "Audio" )     ;
   m_tb_group[ GRP_ID3V1  ].m_s_name = _( "Id3v1 tag" ) ;
   m_tb_group[ GRP_AUDTAG ].m_s_name = _( "Audio tag" ) ;
   m_tb_group[ GRP_VIDEO  ].m_s_name = _( "Video" )     ;
   m_tb_group[ GRP_VIDTAG ].m_s_name = _( "Video tag" ) ;
   m_tb_group[ GRP_IMG    ].m_s_name = _( "Image" )     ;
   m_tb_group[ GRP_EXIF   ].m_s_name = _( "Exif" )      ;
   m_tb_group[ GRP_IPTC   ].m_s_name = _( "Iptc" )      ;
   m_tb_group[ GRP_DOC    ].m_s_name = _( "Document" )  ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CColGroup::get_id_bt_grp( int i_id_bt ) const
{
   /*----------------------------------------------------------------------*/
   int i_grp ;
   /*----------------------------------------------------------------------*/
   for( i_grp = 0 ;
        i_grp < GRP_NB && m_tb_group[ i_grp ].m_i_id_bt != i_id_bt ;
        ++i_grp
      )
   {  ; }
   /*----------------------------------------------------------------------*/
   return( i_grp < GRP_NB ? i_grp : -1 ) ;
   /*----------------------------------------------------------------------*/
}

/*--( The configuration must have been loaded )----------------------------*/
void CColGroup::add_buttons( wxToolBar *p_tb )
{
   /*----------------------------------------------------------------------*/
   str_group *p_grp ;
   int       i_grp  ;
   /*----------------------------------------------------------------------*/
   for( i_grp = 0, p_grp = m_tb_group ; i_grp < GRP_NB ; ++i_grp, ++p_grp )
   {
      /*-------------------------------------------------------------------*/
      if( p_grp->m_s_var_name.empty() || p_grp->m_i_id_bt < 0 )
      {  continue ; }
      /*-------------------------------------------------------------------*/
      p_tb->AddCheckTool( p_grp->m_i_id_bt, wxEmptyString,
                          wxBitmap( p_grp->m_xpm ), wxNullBitmap,
                          p_grp->get_help_text()
                        )->Toggle( p_grp->M_cb_checked.get() ) ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CColGroup::synchro_used_disp_button()
{
   /*----------------------------------------------------------------------*/
   str_group *p_grp ;
   int       i_grp  ;
   wxToolBar *p_tb = wxGetApp().get_tb_grp() ;
   /*----------------------------------------------------------------------*/
   wxASSERT( p_tb != NULL ) ;
   /*----------------------------------------------------------------------*/
   for( i_grp = 0, p_grp = m_tb_group ; i_grp < GRP_NB ; ++i_grp, ++p_grp )
   {
      /*--( Some info are mandatory to do it ... )-------------------------*/
      if(    p_grp->m_s_var_name.empty() || p_grp->m_i_id_bt < 0
          || p_grp->M_cb_checked.get() == p_grp->m_boo_used
        )
      {  continue ; }
      /*-------------------------------------------------------------------*/
      p_grp->M_cb_checked.set( p_grp->m_boo_used ) ;
      /*-------------------------------------------------------------------*/
      p_tb->ToggleTool( p_grp->m_i_id_bt, p_grp->M_cb_checked.get() ) ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CColGroup::init_var()
{
   /*----------------------------------------------------------------------*/
   int i_grp  ;
   /*----------------------------------------------------------------------*/
   for( i_grp = 0 ; i_grp < GRP_NB ; ++i_grp )
   {
      /*-------------------------------------------------------------------*/
      if( m_tb_group[ i_grp ].m_s_var_name.empty() )
      {  continue ; }
      /*--( By default the BASE group is displayed )-----------------------*/
      m_tb_group[ i_grp ].M_cb_checked.init(
                              "/current/" + m_tb_group[ i_grp ].m_s_var_name,
                              ( i_grp == GRP_BASE )
                                           ) ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CColGroup::save_var()
{
   /*----------------------------------------------------------------------*/
   int i_grp ;
   /*----------------------------------------------------------------------*/
   for( i_grp = 0 ; i_grp < GRP_NB ; ++i_grp )
   {
      /*-------------------------------------------------------------------*/
      if( m_tb_group[ i_grp ].m_s_var_name.empty() )
      {  continue ; }
      /*-------------------------------------------------------------------*/
      m_tb_group[ i_grp ].M_cb_checked.save() ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                          End of file CColGroup.cpp                        !
+==========================================================================*/
