/*====================================+=====================================+
! File siren_info.h                   ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+---------------------------------------------------------------------------+
!                                                                           !
!                     Siren's global text information                       !
!                                                                           !
+-------+-------------------------------------------------------------------+
! Notes !                                                                   !
+-------+                                                                   !
! Suffixes :                                                                !
!    _8859  : used in MSW ".rc"                                             !
!    _ASCII : used in command line usage                                    !
!                                                                           !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#ifndef SIREN_INFO_H
#define SIREN_INFO_H
/*-------------------------------------------------------------------------*/


/*-------------------------------------------------------------------------*/
#include "siren_build_number.h"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#define SIREN_DISPLAY_NAME  "Siren"
#define SIREN_NAME          "siren"
/*--( Under GTK, "http://" generates 2 url open calls )--------------------*/
#define SIREN_HOST          "scarabee-software.net"
#define SIREN_URL_SITE      SIREN_HOST
#define SIREN_URL_FORUM     SIREN_HOST "/forum"
#define SIREN_URL_DOWNLOAD  SIREN_HOST
/*-------------------------------------------------------------------------*/
#define SIREN_VERSION_MSWRC 3,1,4,0
#define SIREN_VERSION       "3.14" // " beta 2 build " SIREN_BUILD_NUMBER
/*-------------------------------------------------------------------------*/
#define SIREN_DATES         "2002-2013"
#define SIREN_COMPANY_ASCII "Remi PASCAL"
#define SIREN_COMPANY       wxString::FromUTF8( "R\xc3\xa9mi PASCAL" )
#define SIREN_COMPANY_8859  "R\xe9mi PASCAL"
/*-------------------------------------------------------------------------*/
#define SIREN_COPYRIGHT_ASCII \
        "Copyright (C) " SIREN_DATES " " SIREN_COMPANY_ASCII
#define SIREN_COPYRIGHT \
          "Copyright " \
        + wxString::FromUTF8( "\xc2\xa9" ) \
        + " " SIREN_DATES " " + SIREN_COMPANY
#define SIREN_COPYRIGHT_8859 \
        "Copyright \xa9 " SIREN_DATES " " SIREN_COMPANY_8859
/*-------------------------------------------------------------------------*/
#define SIREN_DESCRIPTION \
        wxTRANSLATE( "Siren is a file renamer" )
/*-------------------------------------------------------------------------*/
#define SIREN_LICENSE \
        wxTRANSLATE( "Siren is free of charge and distributed under " \
                     "the GPLv3 license" \
                   )
/*--( Under GTK, "http://" generates 2 url open calls )--------------------*/
#define SIREN_LICENSE_URL "www.gnu.org/licenses/gpl.html"

/*-------------------------------------------------------------------------*/
#define SIREN_MAIL \
        "Siren <siren@scarabee-software.net>"
#define SIREN_MAIL_TRANSLATOR \
        "English <siren.translation@scarabee-software.net>"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#endif // SIREN_INFO_H
/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                         End of file siren_info.h                          !
+==========================================================================*/
