/*====================================+=====================================+
! File siren.h                        ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+---------+-----------------------------------------------------------------+
! History !                                                                 !
+---------+                                                                 !
! Date        Version  Description                                          !
! ----------  -------  ---------------------------------------------------- !
! 2013/12/27   3.14    3.14 released (1029)                                 !
! 2013/12/16   3.14    beta 2 released (1027)                               !
! 2013/12/08   3.14    beta 1 released (1024)                               !
! 2013/11/14   3.14    Back to wx2.9.5 (mousewheel pb) and avi duration bug !
! 2013/10/30   3.14    File system watcher                                  !
! 2013/08/08   3.14    Detect file type and call "correct" init function    !
! 2013/07/31   3.13    3.13 released (build 970)                            !
! 2013/07/28   3.13    beta 2 released (969)                                !
! 2013/07/25   3.13    New vars : %Adh, %Adm, %Ads, %Vdh, %Vdm, %Vds        !
! 2013/07/19   3.13    wxWidgets 2.9.5 and duration format HMS option       !
! 2013/07/07   3.13    beta 1 released (961)                                !
! 2013/07/04   3.13    Bug : mp3 number of sample per frame (mpeg type)     !
! 2013/04/17   3.12    3.12 released (build 959)                            !
! 2013/04/14   3.12    beta 3 released (957)                                !
! 2013/04/10   3.12    TestBed: replace current names with sel file names   !
! 2013/04/08   3.12    beta 2 released (954)                                !
! 2013/04/02   3.12    "From" / "To" strings diff size => last "To" ch used !
! 2013/03/28   3.12    Main window layout : new menu & serialised vars      !
! 2013/03/25   3.12    Bug : crash testbed if immediate recompute set (msw) !
! 2013/03/19   3.12    beta 1 released (build 947)                          !
! 2013/03/18   3.12    Bug : rename => copy/delete & del ko => remove copy  !
! 2013/03/03   3.11    3.11 released (build 945)                            !
! 2013/02/26   3.11    beta 2 build 944 released (pb clean_string/iswcntrl) !
! 2013/02/25   3.11    beta 1 build 943 released                            !
! 2013/02/24   3.11    Bug : text file format recognition (%T)              !
! 2013/02/12   3.11    Bug : crash if right click on N+1 column header      !
! 2013/02/04   3.11    Bug : qtf audio/video variable storage               !
!                      "Help" menu opt position in tag visu (= file list)   !
!                      Different sizes of siren main icons png              !
! 2013/01/09   3.10    3.10 released (build 938)                            !
! 2013/01/03   3.10    beta 1 build 937 released                            !
! 2012/12/30   3.10    Bug : flv data extraction crash (test NULL)          !
! 2012/12/07   3.10    Help about variables added to different places       !
! 2012/12/03   3.10    Bug : flac data extraction (jump after vorbis cmt)   !
! 2012/11/22   3.10    New modifier : group renaming                        !
! 2012/09/14   3.01    3.01 released (build 920)                            !
! 2012/09/08   3.01    beta 1 build 917 released                            !
! 2012/09/05   3.01    Bug : time add to date problem (%D{"%Y%m%d",24h})    !
!                      wxWidgets 2.9.4 and small modifications              !
! 2012/06/10   3.00    3.00 released (build 914)                            !
! 2012/05/20   3.00    rc 1 build 909 released                              !
! 2012/05/17   3.00    rc 1 build 906 released                              !
! 2012/05/09   3.00    rc 1 build 902 released                              !
! 2012/05/07   3.00    rc 1 build 900 released                              !
! 2012/05/03   3.00    Modifications for GPL license                        !
! 2012/04/30   3.00    beta 2 build 893 released                            !
! 2012/04/23   3.00    beta 2 build 888 released                            !
! 2012/04/11   3.00    beta 2 build 881 released                            !
! 2012/03/27   3.00    beta 1 build 866 released                            !
! 2012/03/13   3.00    beta 1 build 855 released                            !
! 2012/03/06   3.00    alpha 2 build 847 released                           !
! 2012/02/27   3.00    alpha 2 build 837 released                           !
! 2012/02/12   3.00    alpha 2 build 825 released                           !
! 2012/01/23   3.00    alpha 2 build 811 released                           !
! 2012/01/14   3.00    alpha 2 build 805 released                           !
! 2011/12/16   3.00    alpha 1 build 784 released                           !
! 2011/11/29   3.00    alpha 1 build 772 released                           !
! 2011/11/21   3.00    alpha 1 build 764 released                           !
! 2011/11/14   3.00    alpha 1 build 759 released                           !
! 2011/11/06   3.00    alpha 1 build 754 released                           !
! 2011/11/01   3.00    alpha 1 build 751 released                           !
! 2011/10/31   3.00    alpha 1 build 750 released                           !
! 2011/10/16   3.00    alpha 1 build 742 released                           !
! 2011/10/06   3.00    Help written                                         !
! 2010/11/23   3.00    French translation done                              !
! 2008/01/23   3.00    First version that can compute full grammar          !
!                                                                           !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#ifndef SIREN_H
#define SIREN_H
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#include <wx/gdicmn.h>
/*-------------------------------------------------------------------------*/



/*--( Layout )-------------------------------------------------------------*/
enum e_layout
{  LAYOUT_VISU_OFF, LAYOUT_VISU_LEFT, LAYOUT_VISU_RIGHT, LAYOUT_NB
} ;

/*-------------------------------------------------------------------------*/
enum e_id_control
{
   ID_DUMMY_FIRST = wxID_HIGHEST + 1,

   ID_CB_FIL,
   ID_NB,

   IDM_CBC_LIST,
   IDM_CBC_LIST_NAME,

   IDM_FIND,
   IDM_FIND_FIRST,
   IDM_FIND_NEXT,
   IDM_FIND_PREV,
   IDM_FIND_LAST,
   IDM_FIND_SEL_FIRST,
   IDM_FIND_SEL_NEXT,
   IDM_FIND_SEL_PREV,
   IDM_FIND_SEL_LAST,

   IDM_HIL_FIL,
   IDM_HIL_SEL,

   IDM_TOOLBAR_GRP,
   IDM_THREE_TOOLBARS,
   IDM_VISU_OFF,
   IDM_VISU_LEFT,
   IDM_VISU_RIGHT,
   IDM_SHOW_STATUSBAR,
   IDM_THUMBNAIL,

   IDM_EDIT_FILENAME,

   IDM_COL_OFF,
   IDM_COL_ON_GRP_OFF,
   IDM_COL_GRP_OFF,
   IDM_COL_GRP_ON,
   IDM_COL_DEF_WIDTH,
   IDM_COL_AUTOSIZE,
   IDM_COL_DATA_CBC,
   IDM_COL_CUSTOMIZE,

   IDM_FAV_ADD,
   IDM_FAV_ORGANIZE,
   IDM_TOOL_ADD,
   IDM_TOOL_ORGANIZE,

   IDM_FIRST_CONTACT,
   IDM_MAKE_DONATION,
   IDM_TESTBED,

   IDM_CHECKVERSION_MANUAL,
   IDM_GET_NEW_VERSION,

   IDM_INS_VAR,
   IDM_INS_VAL,
   IDM_COPY_VAL_CLIPBOARD,
   IDM_HELP_VAR,
   IDM_FILE_OPEN,
   IDM_FILE_DELETE,
   IDM_FILE_CONTENT_EXTRACTION,

   IDM_DT_REFRESH,
   IDM_DT_INS_PATH,

   IDM_EXPLORE_DIR,
#ifdef __WXMSW__
   IDM_SHELL_CONTEXTUAL_MENU,
#endif // __WXMSW__

   ID_ACT_RENAME,
   ID_ACT_COMPUTE,
   ID_ACT_COPY,
   ID_ACT_UNDO,
   ID_ACT_REDO,

   ID_SEL_ALL,
   ID_UNSEL_ALL,
   ID_SEL_INV,
   ID_SEL_UNSEL_HIL,
   ID_SEL_HIL,
   ID_UNSEL_HIL,
   ID_SEL_FIL,
   ID_UNSEL_FIL,

   ID_GRP_BASE,
   ID_GRP_AUDIO,
   ID_GRP_ID3V1,
   ID_GRP_AUDTAG,
   ID_GRP_VIDEO,
   ID_GRP_VIDTAG,
   ID_GRP_IMG,
   ID_GRP_EXIF,
   ID_GRP_IPTC,
   ID_GRP_DOC,

   ID_CB_EXP,
   ID_CB_DIR,
   ID_TB_ACO_DIR,
   ID_BT_ACO_DIR,

   ID_BT_COMPLETION,
   ID_BT_WIZARD,

   ID_TB_DIR_BACK,
   ID_TB_DIR_FORWARD,
   ID_TB_DIR_CHOOSE,
   ID_TB_DIR_UP,
   ID_TB_DIR_REFRESH,
   ID_TB_DIR_RECURSE,
   ID_TB_DIR_STOP_LOADING

} ;

/*--( Statusbar elements )-------------------------------------------------*/
enum e_status_bar_parts
{  SB_TEXT, SB_OPER, SB_SEL_DURATION, SB_SEL_SIZE, SB_SEL_NB, SB_NB
} ;

/*--( Operation type on file )---------------------------------------------*/
enum e_otfile
{  OFILE_RENAME, OFILE_COPY, OFILE_NB
} ;

/*--( Sort types )---------------------------------------------------------*/
enum e_sort
{  SORT_STRING, SORT_INTEGER, SORT_DOUBLE, SORT_DATETIME, SORT_NB
} ;

/*--( Column groups )------------------------------------------------------*/
enum e_grp
{  GRP_NONE  , GRP_BASE, GRP_AUDIO, GRP_ID3V1, GRP_AUDTAG, GRP_VIDEO,
   GRP_VIDTAG, GRP_IMG , GRP_EXIF , GRP_IPTC , GRP_DOC   , GRP_NB
} ;

/*-------------------------------------------------------------------------*/
enum e_col
{
   COL_NONE_CHECKBOX,
   COL_NONE_ICON,
   COL_NONE_NAME,
   COL_NONE_NEW_NAME,
   COL_NONE_SEL_NUM,
   COL_BASE_DOS_NAME,
   COL_BASE_TYPE,
   COL_BASE_TYPE_DET,
   COL_BASE_SIZE,
   COL_BASE_CRE_DATE,
   COL_BASE_ACC_DATE,
   COL_BASE_MOD_DATE,
   COL_BASE_ATTR,

   COL_AUDIO_BITRATE,
   COL_AUDIO_SAMPRATE,
   COL_AUDIO_CHANNEL,
   COL_AUDIO_DURATION,
   COL_AUDIO_INFO,

   COL_ID3V1_TITLE,
   COL_ID3V1_ARTIST,
   COL_ID3V1_ALBUM,
   COL_ID3V1_YEAR,
   COL_ID3V1_COMMENT,
   COL_ID3V1_TRACK_NUM,
   COL_ID3V1_GENRE,

   COL_AUDTAG_TITLE,
   COL_AUDTAG_ARTIST,
   COL_AUDTAG_ALBUM,
   COL_AUDTAG_YEAR,
   COL_AUDTAG_COMMENT,
   COL_AUDTAG_TRACK_NUM,
   COL_AUDTAG_TRACK_NB,
   COL_AUDTAG_TRACK,
   COL_AUDTAG_DISK,
   COL_AUDTAG_GENRE,
   COL_AUDTAG_COMPOS,
   COL_AUDTAG_ORG_ART,
   COL_AUDTAG_COPYRIGHT,
   COL_AUDTAG_URL,
   COL_AUDTAG_ENCOD_BY,
   COL_AUDTAG_IMG_FORMAT,

   COL_VIDEO_X,
   COL_VIDEO_Y,
   COL_VIDEO_SAMPRATE,
   COL_VIDEO_CHANNEL,
   COL_VIDEO_DURATION,
   COL_VIDEO_FPS,
   COL_VIDEO_INFO,

   COL_VIDTAG_TITLE,
   COL_VIDTAG_SUBJECT,
   COL_VIDTAG_ARTIST,
   COL_VIDTAG_COMMENT,
   COL_VIDTAG_KEYWORDS,
   COL_VIDTAG_ENGINEER,
   COL_VIDTAG_TECHNICIAN,
   COL_VIDTAG_GENRE,
   COL_VIDTAG_CRE_DATE,
   COL_VIDTAG_SOURCE,
   COL_VIDTAG_COPYRIGHT,
   COL_VIDTAG_SOFTWARE,
   COL_VIDTAG_IMG_FORMAT,
   COL_VIDTAG_DV_DATE,
   COL_VIDTAG_DV_TIMECODE,

   COL_IMG_X,
   COL_IMG_Y,
   COL_IMG_BPP,
   COL_IMG_INFO,

   COL_EXIF_IMAGEDESCRIPTION,
   COL_EXIF_MAKE,
   COL_EXIF_MODEL,
   COL_EXIF_ORIENTATION,
   COL_EXIF_XRESOLUTION,
   COL_EXIF_YRESOLUTION,
   COL_EXIF_RESOLUTIONUNIT,
   COL_EXIF_SOFTWARE,
   COL_EXIF_ARTIST,
   COL_EXIF_DATETIME,
   COL_EXIF_SUBSECTIME,
   COL_EXIF_WHITEPOINT,
   COL_EXIF_PRIMARYCHROMATICITIES,
   COL_EXIF_YCBCRCOEFFICIENTS,
   COL_EXIF_YCBCRPOSITIONING,
   COL_EXIF_REFERENCEBLACKWHITE,
   COL_EXIF_COPYRIGHT,
   COL_EXIF_EXIFOFFSET,
   COL_EXIF_GPSOFFSET,
   COL_EXIF_THUMBNAIL_OFFSET,
   COL_EXIF_THUMBNAIL_SIZE,
   COL_EXIF_EXPOSURETIME,
   COL_EXIF_FNUMBER,
   COL_EXIF_EXPOSUREPROGRAM,
   COL_EXIF_SPECTRALSENSITIVITY,
   COL_EXIF_ISOSPEEDRATINGS,
   COL_EXIF_EXIFVERSION,
   COL_EXIF_DATETIMEORIGINAL,
   COL_EXIF_SUBSECTIMEORIGINAL,
   COL_EXIF_DATETIMEDIGITIZED,
   COL_EXIF_SUBSECTIMEDIGITIZED,
   COL_EXIF_COMPONENTCONFIGURATION,
   COL_EXIF_COMPRESSEDBITSPERPIXEL,
   COL_EXIF_SHUTTERSPEEDVALUE,
   COL_EXIF_APERTUREVALUE,
   COL_EXIF_BRIGHTNESSVALUE,
   COL_EXIF_EXPOSUREBIASVALUE,
   COL_EXIF_MAXAPERTUREVALUE,
   COL_EXIF_SUBJECTDISTANCE,
   COL_EXIF_METERINGMODE,
   COL_EXIF_LIGHTSOURCE,
   COL_EXIF_FLASH,
   COL_EXIF_FOCALLENGTH,
   COL_EXIF_FLASHENERGY,
   COL_EXIF_USERCOMMENT,
   COL_EXIF_FLASHPIXVERSION,
   COL_EXIF_COLORSPACE,
   COL_EXIF_EXIFIMAGEWIDTH,
   COL_EXIF_EXIFIMAGEHEIGHT,
   COL_EXIF_RELATEDSOUNDFILE,
   COL_EXIF_FOCALPLANEXRESOLUTION,
   COL_EXIF_FOCALPLANEYRESOLUTION,
   COL_EXIF_FOCALPLANERESOLUTIONUNIT,
   COL_EXIF_EXPOSUREINDEX,
   COL_EXIF_SENSINGMETHOD,
   COL_EXIF_FILESOURCE,
   COL_EXIF_SCENETYPE,
   COL_EXIF_CUSTOMRENDERED,
   COL_EXIF_EXPOSUREMODE,
   COL_EXIF_WHITEBALANCE,
   COL_EXIF_DIGITALZOOMRATIO,
   COL_EXIF_FOCALLENGTHIN35MMFILM,
   COL_EXIF_SCENECAPTURETYPE,
   COL_EXIF_GAINCONTROL,
   COL_EXIF_CONTRAST,
   COL_EXIF_SATURATION,
   COL_EXIF_SHARPNESS,
   COL_EXIF_SUBJECTDISTANCERANGE,
   COL_EXIF_IMAGEUNIQUEID,
   COL_EXIF_GPSVERSIONID,
   COL_EXIF_GPSLATITUDEREF,
   COL_EXIF_GPSLATITUDE,
   COL_EXIF_GPSLONGITUDEREF,
   COL_EXIF_GPSLONGITUDE,
   COL_EXIF_GPSALTITUDEREF,
   COL_EXIF_GPSALTITUDE,
   COL_EXIF_GPSTIMESTAMP,
   COL_EXIF_GPSSATELLITES,
   COL_EXIF_GPSSTATUS,
   COL_EXIF_GPSMEASUREMODE,
   COL_EXIF_GPSDOP,
   COL_EXIF_GPSSPEEDREF,
   COL_EXIF_GPSSPEED,
   COL_EXIF_GPSTRACKREF,
   COL_EXIF_GPSTRACK,
   COL_EXIF_GPSIMGDIRECTIONREF,
   COL_EXIF_GPSIMGDIRECTION,
   COL_EXIF_GPSMAPDATUM,
   COL_EXIF_GPSDESTLATITUDEREF,
   COL_EXIF_GPSDESTLATITUDE,
   COL_EXIF_GPSDESTLONGITUDEREF,
   COL_EXIF_GPSDESTLONGITUDE,
   COL_EXIF_GPSDESTBEARINGREF,
   COL_EXIF_GPSDESTBEARING,
   COL_EXIF_GPSDESTDISTANCEREF,
   COL_EXIF_GPSDESTDISTANCE,

   COL_IPTC_BYLINE,
   COL_IPTC_BYLINE_TITLE,
   COL_IPTC_COPYRIGHT,
   COL_IPTC_CREDIT,
   COL_IPTC_SOURCE,
   COL_IPTC_CAPTION_WRITER,
   COL_IPTC_CAPTION,
   COL_IPTC_HEADLINE,
   COL_IPTC_SPECIAL_INSTR,
   COL_IPTC_OBJECT_NAME,
   COL_IPTC_DATETIME_CREATED,
   COL_IPTC_DATETIME_RELEASED,
   COL_IPTC_CITY,
   COL_IPTC_SUBLOCATION,
   COL_IPTC_STATE,
   COL_IPTC_COUNTRY_CODE,
   COL_IPTC_COUNTRY,
   COL_IPTC_ORIGINAL_TRSF,
   COL_IPTC_CATEGORY,
   COL_IPTC_SUPPL_CATEGORIES,
   COL_IPTC_EDIT_STATUS,
   COL_IPTC_JOBID,
   COL_IPTC_PROGRAM,
   COL_IPTC_PROGRAM_VERSION,
   COL_IPTC_PRIORITY,
   COL_IPTC_OBJECT_CYCLE,
   COL_IPTC_KEYWORDS,

   COL_DOC_TITLE,
   COL_DOC_SUBJECT,
   COL_DOC_VERSION,
   COL_DOC_AUTHOR,
   COL_DOC_DESTINATION,
   COL_DOC_COMMENT,
   COL_DOC_INFO,
   COL_DOC_ID,
   COL_DOC_KEYWORDS,
   COL_DOC_APPLICATION,
   COL_DOC_COMPANY,
   COL_DOC_COPYRIGHT,
   COL_DOC_TRADEMARKS,
   COL_DOC_URL,
   COL_DOC_CRE_DATE,
   COL_DOC_MOD_DATE,
   COL_DOC_FILECOUNT,
   COL_DOC_PAGECOUNT,
   COL_DOC_LINECOUNT,
   COL_DOC_WORDCOUNT,
   COL_DOC_CHARCOUNT,

   COL_NB
} ;

/*--------------------------------------------------------------------------+
! Menu ID used by the "dynamic" menus: history, favourites and tools        !
+--------------------------------------------------------------------------*/
enum e_menu_id_set
{  HIS_MENU_ID_START  = 10000,
   FAV_MENU_ID_START  = 11000,
   TOOL_MENU_ID_START = 12000
} ;

/*--------------------------------------------------------------------------+
! Number of menu IDs reserved for the "dynamic" menus                       !
+--------------------------------------------------------------------------*/
const int g_co_i_reserve_menu_id = 200 ;

/*--------------------------------------------------------------------------+
! Rotation of the image applied for its visualization                       !
! The "_HM" suffix stands for "Horizontal Mirror"                           !
+--------------------------------------------------------------------------*/
enum e_iv_rotation
{  IV_ROTATION_0     ,
   IV_ROTATION_0_HM  ,
   IV_ROTATION_90    ,
   IV_ROTATION_90_HM ,
   IV_ROTATION_180   ,
   IV_ROTATION_180_HM,
   IV_ROTATION_270   ,
   IV_ROTATION_270_HM,
   IV_ROTATION_NB
} ;

/*-------------------------------------------------------------------------*/
enum e_fsw_watch_id
{
   FSW_WID_REN_DIFF_PATH = 1234
} ;


/*-------------------------------------------------------------------------*/
enum e_send_end_event
{  SEEVT_DONT_SEND_END_EVENT,
   SEEVT_DO_SEND_END_EVENT
} ;

/*--( Version of the configuration file associated to this Siren release )-*/
const int g_co_i_config_version     = 13 ;

/*-------------------------------------------------------------------------*/
const int g_co_i_string_sz_max      = 256 ;
const int g_co_i_min_num_pad        =   1 ;
const int g_co_i_max_num_pad        =  20 ;
const int g_co_i_undef_max_name_len =   0 ;
const int g_co_i_min_name_len       =   1 ;
const int g_co_i_min_rand_len       =   1 ;
const int g_co_i_max_rand_len       = g_co_i_string_sz_max ;

/*-------------------------------------------------------------------------*/
const wxSize g_co_size_tool( 16, 16 ) ;

/*--( Global "display" information. Can be used as function parameter )----*/
void g_disp_info( const wxString &s ) ;

bool g_is_edit_info_event( wxKeyEvent &event ) ;
class wxTextCtrl ;
void g_disp_edit_info( const wxTextCtrl *win_text ) ;

void g_disp_info_yield( const wxString &s ) ;
/*-------------------------------------------------------------------------*/
void g_trace( const wxString &s_format, ... ) ;
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#endif // SIREN_H
/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                            End of file siren.h                            !
+==========================================================================*/
