/*====================================+=====================================+
! File CPanPrefs.h                    ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+---------------------------------------------------------------------------+
!                                                                           !
! This class is only present to define some objects used via wxFormBuilder  !
! - mainly a parent for the preference dialog panels in order to add them   !
!   some virtual functions.                                                 !
! - some other objects like CCheckListCtrl                                  !
!                                                                           !
! The other panels type are not defined here but in CDlgPrefs.h because     !
! of compilation order and inclusion.                                       !
!                                                                           !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#ifndef CPANPREFS_H
#define CPANPREFS_H
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#include <wx/panel.h>
/*-------------------------------------------------------------------------*/
#include "CColumn.h"
#include "common/CListCtrlBase.h"
#include "common/CChoice.h"
/*-------------------------------------------------------------------------*/



/*--------------------------------------------------------------------------+
! For the columns panel:                                                    !
! GRP_NONE won't appear in the combo                                        !
! the check box, the icon and current name won't appear in the list         !
+--------------------------------------------------------------------------*/
static const int st_co_i_col_min_disp_group = GRP_BASE ;
static const int st_co_i_col_min_disp       = COL_NONE_NEW_NAME ;
static const int st_co_i_col_nb_disp        = COL_NB - st_co_i_col_min_disp ;
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
class CCheckListCtrl : public CListCtrlBase
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CCheckListCtrl( wxWindow *parent, wxWindowID id,
                      const wxPoint &pos = wxDefaultPosition,
                      const wxSize & size = wxDefaultSize,
                      long style = wxLC_REPORT,
                      const wxValidator &validator = wxDefaultValidator,
                      const wxString &name = wxListCtrlNameStr
                    ) ;
      virtual ~CCheckListCtrl()
      {  ; }

   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CColumn m_tb_col[ st_co_i_col_nb_disp ] ;

   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      virtual wxListItemAttr *OnGetItemAttr( long item ) const ;
      virtual int OnGetItemImage( long l_item ) const ;
      virtual wxString OnGetItemText( long l_item, long l_column ) const ;
      virtual void OnMouseLeftDown( wxMouseEvent &event ) ;
      virtual void OnKeyDown( wxKeyEvent &event ) ;

      /*-------------------------------------------------------------------*/
      void sel_all( bool boo_on ) ;
      void sel_hil( bool boo_on ) ;
      void set_order_def() ;
      void set_sel_def() ;
      void set_width_def() ;
      void hil_group( int i_grp, bool boo_on ) ;
      void move_hil( bool boo_up ) ;

   /*----------------------------------------------------------------------*/
   private :
      /*-------------------------------------------------------------------*/
      DECLARE_EVENT_TABLE()
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
class CPanPrefs : public wxPanel
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CPanPrefs( wxWindow *parent, wxWindowID id = wxID_ANY,
                 const wxPoint &pos = wxDefaultPosition,
                 const wxSize &size = wxDefaultSize,
                 long style = wxTAB_TRAVERSAL
               )
         : wxPanel( parent, id, pos, size, style )
      {  ; }
      virtual ~CPanPrefs() ;
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      wxWindow *check_mandatory( wxTextCtrl *p_win ) ;
      /*-------------------------------------------------------------------*/
      virtual void init_default() = 0 ;
      virtual wxWindow *validate_changes() = 0 ;
      virtual void apply_changes( wxUint32 &ui_poa ) = 0 ;
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#endif // CPANPREFS_H
/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                         End of file CPanPrefs.h                           !
+==========================================================================*/
