/*====================================+=====================================+
! File CDlgPrefs.h                    ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#ifndef CDLGPREFS_H
#define CDLGPREFS_H
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#include <wx/propdlg.h>
#include <wx/notebook.h>
#ifdef __WXMSW__
#include "common/msw/CShortcut.h"
#endif // __WXMSW__
#include "sr_prefs.h"
/*-------------------------------------------------------------------------*/



/*--------------------------------------------------------------------------+
! Possible operations to do after a validation (apply/ok )                  !
! They can be ORed. PPA stands for Post Preferences Action                  !
+--------------------------------------------------------------------------*/
enum e_post_prefs_actions { SR_PPA_NOTHING    = 0,
                            SR_PPA_REFRESH_FL = 1 << 1,
                            SR_PPA_DISP_IMG   = 1 << 2,
                            SR_PPA_COMPUTE    = 1 << 3,
                            SR_PPA_SORT       = 1 << 4,
                            SR_PPA_COLUMN     = 1 << 5,
                            SR_PPA_RELOAD     = 1 << 6,
                            SR_PPA_REFRESH_DT = 1 << 7
                          } ;

/*-------------------------------------------------------------------------*/
class CDlgPrefs : public wxPropertySheetDialog
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CDlgPrefs( wxWindow *parent ) ;
      virtual ~CDlgPrefs() ;

   /*----------------------------------------------------------------------*/
   private :
      /*--------------------------------------------------------------------+
      ! I find useful to be "automatically" positioned on the last          !
      ! visited page. It's handy to change/rechange a parameter             !
      +--------------------------------------------------------------------*/
      static size_t st_sz_last_visited_page ;
      /*--( Useful to open the preferences directly )----------------------*/
      size_t m_sz_col_page_num ;
      /*--------------------------------------------------------------------+
      ! Pointer to the reset page values button.                            !
      ! Useful to enable/disable the functionality                          !
      +--------------------------------------------------------------------*/
      wxWindow *m_bt_reset ;
      /*-------------------------------------------------------------------*/
#ifdef __WXMSW__
      /*--------------------------------------------------------------------+
      ! Shortcut page ref to disable the reset of its content               !
      +--------------------------------------------------------------------*/
      size_t m_sz_scut_page_num ;
      /*-------------------------------------------------------------------*/
#endif // __WXMSW__

   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      virtual void OnBtOk( wxCommandEvent & WXUNUSED( event ) ) ;
      virtual void OnBtApply( wxCommandEvent & WXUNUSED( event ) ) ;
      virtual void OnBtResetPageDefaults( wxCommandEvent & WXUNUSED( event));
      /*-------------------------------------------------------------------*/
#ifdef __WXMSW__
      /*--( To disable the reset button for Shortcut page )----------------*/
      virtual void OnPageChanged( wxBookCtrlEvent &event ) ;
#endif // __WXMSW__
      /*-------------------------------------------------------------------*/
      size_t get_nb_page() const
      {  return( GetBookCtrl()->GetPageCount() ) ; }
      /*-------------------------------------------------------------------*/
      CPanPrefs *get_page( size_t sz_num )
      {  return( static_cast<CPanPrefs *>( GetBookCtrl()->GetPage( sz_num ) )
               ) ;
      }
      /*-------------------------------------------------------------------*/
      size_t get_current_page() const
      {  return( GetBookCtrl()->GetSelection() ) ; }
      void set_current_page( size_t sz_num )
      {  GetBookCtrl()->SetSelection( sz_num ) ; }
      /*-------------------------------------------------------------------*/
      void init()             ;
      bool validate_changes() ;
      void apply_changes()    ;
      int  get_modal()        ;
      int  get_modal_col()    ;

   /*----------------------------------------------------------------------*/
   private :
      /*-------------------------------------------------------------------*/
      DECLARE_EVENT_TABLE()
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
class CPanPrefsGen : public CPanPrefsGenBase
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CPanPrefsGen( wxWindow *parent ) ;
      virtual ~CPanPrefsGen() ;
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      void init_cho_lang() ;
      /*-------------------------------------------------------------------*/
      virtual void init_default() ;
      virtual wxWindow *validate_changes() ;
      virtual void apply_changes( wxUint32 &dw_poa ) ;
      /*-------------------------------------------------------------------*/
      virtual void OnChkExtract( wxCommandEvent & WXUNUSED( event ) ) ;
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
class CPanPrefsDisp : public CPanPrefsDispBase
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CPanPrefsDisp( wxWindow *parent ) ;
      virtual ~CPanPrefsDisp() ;
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      virtual void OnFmtDateFlKeyDown( wxKeyEvent &event ) ;
      /*-------------------------------------------------------------------*/
      virtual void init_default() ;
      virtual wxWindow *validate_changes() ;
      virtual void apply_changes( wxUint32 &dw_poa ) ;
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
class CPanPrefsCol : public CPanPrefsColBase
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CPanPrefsCol( wxWindow *parent ) ;
      virtual ~CPanPrefsCol() ;
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      virtual void init_default() ;
      virtual wxWindow *validate_changes() ;
      virtual void apply_changes( wxUint32 &dw_poa ) ;
      /*-------------------------------------------------------------------*/
      virtual void OnBtUp( wxCommandEvent & WXUNUSED( event ) )       ;
      virtual void OnBtDown( wxCommandEvent & WXUNUSED( event ) )     ;
      virtual void OnBtAll( wxCommandEvent & WXUNUSED( event ) )      ;
      virtual void OnBtNone( wxCommandEvent & WXUNUSED( event ) )     ;
      virtual void OnBtSelect( wxCommandEvent & WXUNUSED( event ) )   ;
      virtual void OnBtUnselect( wxCommandEvent & WXUNUSED( event ) ) ;
      virtual void OnCbHilGrp( wxCommandEvent & WXUNUSED( event ) )   ;
      virtual void OnBtDefOrder( wxCommandEvent & WXUNUSED( event ) ) ;
      virtual void OnBtDefSel( wxCommandEvent & WXUNUSED( event ) )   ;
      virtual void OnBtDefWidth( wxCommandEvent & WXUNUSED( event ) ) ;

   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
class CPanPrefsCbc : public CPanPrefsCbcBase
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CPanPrefsCbc( wxWindow *parent ) ;
      virtual ~CPanPrefsCbc() ;
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      virtual void init_default() ;
      virtual wxWindow *validate_changes() ;
      virtual void apply_changes( wxUint32 &dw_poa ) ;
      /*-------------------------------------------------------------------*/
      virtual void OnRadTab( wxCommandEvent & WXUNUSED( event ) ) ;
      virtual void OnRadChar( wxCommandEvent & WXUNUSED( event ) ) ;
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
#ifdef __WXMSW__
class CPanPrefsScut : public CPanPrefsScutBase
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CPanPrefsScut( wxWindow *parent ) ;
      virtual ~CPanPrefsScut() ;
   /*----------------------------------------------------------------------*/
   private :
      /*--( Checkbox shortcut association )--------------------------------*/
      wxCheckBox *m_tb_scut_chk[ CShortcut::SCUT_NB ] ;
      wxString   m_s_exe_fullpath ;
      wxString   m_s_lnk_basename ;
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      void init_checkboxes() ;
      virtual void init_default() ;
      virtual wxWindow *validate_changes() ;
      virtual void apply_changes( wxUint32 &dw_poa ) ;

   /*----------------------------------------------------------------------*/
} ;
#endif // __WXMSW__

/*-------------------------------------------------------------------------*/
class CPanPrefsComp : public CPanPrefsCompBase
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CPanPrefsComp( wxWindow *parent ) ;
      virtual ~CPanPrefsComp() ;
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      virtual void init_default() ;
      virtual wxWindow *validate_changes() ;
      virtual void apply_changes( wxUint32 &dw_poa ) ;
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
class CPanPrefsChar : public CPanPrefsCharBase
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CPanPrefsChar( wxWindow *parent ) ;
      virtual ~CPanPrefsChar() ;
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      virtual void OnText( wxCommandEvent &event ) ;
      virtual void init_default() ;
      virtual wxWindow *validate_changes() ;
      virtual void apply_changes( wxUint32 &dw_poa ) ;
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
class CPanPrefsCase : public CPanPrefsCaseBase
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CPanPrefsCase( wxWindow *parent ) ;
      virtual ~CPanPrefsCase() ;
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      virtual void init_default() ;
      virtual wxWindow *validate_changes() ;
      virtual void apply_changes( wxUint32 &dw_poa ) ;
      /*-------------------------------------------------------------------*/
      virtual void OnBtAdd( wxCommandEvent & WXUNUSED( event ) ) ;
      virtual void OnBtModify( wxCommandEvent & WXUNUSED( event ) ) ;
      virtual void OnBtDelete( wxCommandEvent & WXUNUSED( event ) ) ;
      virtual void OnListItemActivated( wxListEvent & WXUNUSED( event ) ) ;
      virtual void OnKeyDown( wxKeyEvent &event ) ;

      /*-------------------------------------------------------------------*/
      int edit( long l_item ) ;
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
class CPanPrefsNum : public CPanPrefsNumBase
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CPanPrefsNum( wxWindow *parent ) ;
      virtual ~CPanPrefsNum() ;
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      virtual void init_default() ;
      virtual wxWindow *validate_changes() ;
      virtual void apply_changes( wxUint32 &dw_poa ) ;
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
class CPanPrefsDate : public CPanPrefsDateBase
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CPanPrefsDate( wxWindow *parent ) ;
      virtual ~CPanPrefsDate() ;
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      virtual void init_default() ;
      virtual wxWindow *validate_changes() ;
      virtual void apply_changes( wxUint32 &dw_poa ) ;
      /*-------------------------------------------------------------------*/
      virtual void OnBtHelp( wxCommandEvent & WXUNUSED( event ) ) ;
      virtual void OnBtTest( wxCommandEvent & WXUNUSED( event ) ) ;
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#endif // CDLGPREFS_H
/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                         End of file CDlgPrefs.h                           !
+==========================================================================*/
