/*====================================+=====================================+
! File CDynMenu.h                     ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+---------------------------------------------------------------------------+
!                                                                           !
!                 Base classes for Favourites and Tools                     !
!                                                                           !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#ifndef CDYNMENU_H
#define CDYNMENU_H
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#include "sr_dynmenu.h"
#include "common/CListCtrlBase.h"
/*-------------------------------------------------------------------------*/
class CDynMenu ;
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
class CDlgDynMenuEdit : public CDlgDynMenuEditBase
{
   /*----------------------------------------------------------------------*/
   public :
      /*--------------------------------------------------------------------+
      ! The parent has to be specified because it can be used directly from !
      ! the main menu (Add ...) or via CDlgDynMenu.                         !
      ! Always using the main frame as parent will give it and CDlgDynMenu  !
      ! the same "level" and the user may hide it behind CDlgDynMenu.       !
      +--------------------------------------------------------------------*/
      CDlgDynMenuEdit( wxWindow *parent, CDynMenu *p_dm ) ;
      virtual ~CDlgDynMenuEdit() ;
   /*----------------------------------------------------------------------*/
   public :
      /*--( Parent class )-------------------------------------------------*/
      CDynMenu *m_p_dm ;
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      virtual void OnBtCopyMainExp( wxCommandEvent & WXUNUSED( event ) ) ;
      virtual void OnBtOk( wxCommandEvent & WXUNUSED( event ) ) ;
      /*-------------------------------------------------------------------*/
      int get_modal( wxString &s_name, wxString &s_exp ) ;
      virtual int validate_data() = 0 ;
      /*-------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
class CDlgDynMenu : public CDlgDynMenuBase
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CDlgDynMenu( CDynMenu *p_dm ) ;
      virtual ~CDlgDynMenu() ;
   /*----------------------------------------------------------------------*/
   public :
      /*--( Parent class )-------------------------------------------------*/
      CDynMenu *m_p_dm ;
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      virtual void OnBtUp( wxCommandEvent & WXUNUSED( event ) ) ;
      virtual void OnBtDown( wxCommandEvent & WXUNUSED( event ) ) ;
      virtual void OnBtAdd( wxCommandEvent & WXUNUSED( event ) ) ;
      virtual void OnBtModify( wxCommandEvent & WXUNUSED( event ) ) ;
      virtual void OnBtDelete( wxCommandEvent & WXUNUSED( event ) ) ;
      virtual void OnBtOk( wxCommandEvent & WXUNUSED( event ) ) ;
      virtual void OnListItemActivated( wxListEvent & WXUNUSED( event ) ) ;
      virtual void OnKeyDown( wxKeyEvent &event ) ;

      /*-------------------------------------------------------------------*/
      virtual int get_modal_edit( wxString &s_name, wxString &s_exp ) = 0 ;
      void edit( long l_item ) ;
      int get_modal() ;
      /*-------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
class CDynMenu
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      enum e_cdynmenu_flags
      {  DMF_NONE, DMF_KEY_SHORTCUTS, DMF_NB } ;
      /*-------------------------------------------------------------------*/
      CDynMenu( int i_menu_bar_pos, int i_menu_id_start,
                int i_flags = DMF_NONE
              ) ;
      virtual ~CDynMenu() ;
   /*----------------------------------------------------------------------*/
   public :
      /*--( Associated "config" information )------------------------------*/
      CConfigTabString M_tb_s_name        ;
      CConfigTabString M_tb_s_exp         ;
      /*-------------------------------------------------------------------*/
      CConfigRect      M_rec_dlg          ;
      CConfigRect      M_rec_dlg_edit     ;
      CConfigInt       M_i_list_colw_name ;
      CConfigInt       M_i_list_colw_exp  ;
   /*----------------------------------------------------------------------*/
   protected :
      /*-------------------------------------------------------------------*/
      const int m_co_i_menu_bar_pos  ;
      const int m_co_i_menu_id_start ;
      const int m_co_i_flags         ;

      /*--------------------------------------------------------------------+
      ! Number of "active" elements in the "config" tables.                 !
      ! If some of them have been deleted they are not "active" any more.   !
      +--------------------------------------------------------------------*/
      int m_i_nb_active ;

      /*--------------------------------------------------------------------+
      ! "Current" element. It will be set active in the list after window   !
      ! opening.                                                            !
      +--------------------------------------------------------------------*/
      int m_i_current ;

      /*--------------------------------------------------------------------+
      ! Number of options in the menu when no favourite have been yet added !
      +--------------------------------------------------------------------*/
      int m_i_nb_menu_opt_when_empty ;

   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      int get_nb_active() const { return( m_i_nb_active ) ; }
      /*-------------------------------------------------------------------*/
      void init_var( const wxString &s_main_key ) ;
      void save_var() ;
      virtual void create_default_elmts() = 0 ;
      /*-------------------------------------------------------------------*/
      void var_to_listview( CListCtrlBase *lv ) ;
      void listview_to_var( const CListCtrlBase *lv ) ;
      /*-------------------------------------------------------------------*/
      wxString get_exp( const wxString &s_name ) const ;
      /*-------------------------------------------------------------------*/
      void add( CDlgDynMenuEdit *p_dlg ) ;
      void organize( CDlgDynMenu *p_dlg ) ;
      void update_menu() ;
      void append_to_menu( wxMenu *men_out ) ;
      /*--( Action to do when a menu option is selected )------------------*/
      virtual void menu_item_action( int i_id_menu ) = 0 ;
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#endif // CDYNMENU_H
/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                          End of file CDynMenu.h                           !
+==========================================================================*/
