/*====================================+=====================================+
! File sr_lib.h                       ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#ifndef SR_LIB_H
#define SR_LIB_H
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#ifdef __WXMSW__
#include <wx/wx.h>   // Added because of the needed declaration of FILETIME
#endif // __WXMSW__
#include <vector>
#include <map>
#include <wx/panel.h>
#include <wx/string.h>
#include <wx/filename.h>
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#ifndef SR_TWOCC
#define SR_TWOCC( ch0, ch1 ) \
        ( wxUint16 )( (wxUint16)(wxUint8)(ch0) \
                      | ((wxUint16)(wxUint8)(ch1) << 8 ) )
#endif // SR_TWOCC
/*-------------------------------------------------------------------------*/
#ifndef SR_THREECC
#define SR_THREECC( ch0, ch1, ch2 ) \
        ( wxUint32 ) \
        ( (wxUint32)(wxUint8)(ch0) | ( (wxUint32)(wxUint8)(ch1) << 8 ) | \
        ( (wxUint32)(wxUint8)(ch2) << 16 ) )
#endif // SR_THREECC
/*-------------------------------------------------------------------------*/
#ifndef SR_FOURCC
#define SR_FOURCC( ch0, ch1, ch2, ch3 ) \
        ( wxUint32 ) \
        ( (wxUint32)(wxUint8)(ch0) | ( (wxUint32)(wxUint8)(ch1) << 8 ) | \
        ( (wxUint32)(wxUint8)(ch2)<<16) | ( (wxUint32)(wxUint8)(ch3)<<24) )
#endif // SR_FOURCC

/*-------------------------------------------------------------------------*/
#ifndef SR_SET_0
#define SR_SET_0( s )       memset( &s, '\0', sizeof( s ) )
#endif // SR_SET_0
/*-------------------------------------------------------------------------*/
#ifndef SR_SET_LAST_0
#define SR_SET_LAST_0( t )  ( t[ sizeof( t ) - 1 ] = '\0' )
#endif // SR_SET_LAST_0
/*-------------------------------------------------------------------------*/
#ifndef SR_EOL
#ifdef __WINDOWS__
#define SR_EOL  "\r\n"
#elif defined( __UNIX__ )
#define SR_EOL  "\n"
#else
#error Unknown platform to: determine EOF character sequence
#endif // __WINDOWS__
#endif // SR_EOL



/*-------------------------------------------------------------------------*/
namespace sr
{
/*-------------------------------------------------------------------------*/
typedef wxString::iterator                 wxString_it       ;
typedef wxString::reverse_iterator         wxString_rit      ;
typedef wxString::const_iterator           wxString_cit      ;
typedef wxString::const_reverse_iterator   wxString_crit     ;
/*-------------------------------------------------------------------------*/
typedef std::vector< int >                 t_vec_int         ;
typedef t_vec_int::iterator                t_vec_int_it      ;
typedef t_vec_int::reverse_iterator        t_vec_int_rit     ;
typedef t_vec_int::const_iterator          t_vec_int_cit     ;
typedef t_vec_int::const_reverse_iterator  t_vec_int_crit    ;
/*-------------------------------------------------------------------------*/
typedef std::vector< wxString >            t_vec_str         ;
typedef t_vec_str::iterator                t_vec_str_it      ;
typedef t_vec_str::reverse_iterator        t_vec_str_rit     ;
typedef t_vec_str::const_iterator          t_vec_str_cit     ;
typedef t_vec_str::const_reverse_iterator  t_vec_str_crit    ;
/*-------------------------------------------------------------------------*/
typedef std::map< wxString, wxString >     t_map_str_str     ;
typedef t_map_str_str::const_iterator      t_map_str_str_cit ;
/*-------------------------------------------------------------------------*/
typedef std::map< wxString, int >          t_map_str_int     ;
typedef t_map_str_int::const_iterator      t_map_str_int_cit ;


/*--( For conversion )-----------------------------------------------------*/
union t_dw_fl
{  wxUint32 dw_val ;
   float    f_val  ;
} ;
union t_ddw_do
{  wxUint64 ddw_val ;
   double   do_val  ;
} ;

/*-------------------------------------------------------------------------*/
inline wxInt16 conv_be_sw( wxInt16 sw )
{  return( wxINT16_SWAP_ON_LE( sw ) ) ; }
inline wxUint16 conv_be_uw( wxUint16 uw )
{  return( wxUINT16_SWAP_ON_LE( uw ) ) ; }

inline wxInt16 conv_le_sw( wxInt16 sw )
{  return( wxINT16_SWAP_ON_BE( sw ) ) ; }
inline wxUint16 conv_le_uw( wxUint16 uw )
{  return( wxUINT16_SWAP_ON_BE( uw ) ) ; }

inline wxInt32 conv_be_sdw( wxInt32 sdw )
{  return( wxINT32_SWAP_ON_LE( sdw ) ) ; }
inline wxUint32 conv_be_udw( wxUint32 dw )
{  return( wxUINT32_SWAP_ON_LE( dw ) ) ; }

inline wxInt32 conv_le_sdw( wxInt32 sdw )
{  return( wxINT32_SWAP_ON_BE( sdw ) ) ; }
inline wxUint32 conv_le_udw( wxUint32 udw )
{  return( wxUINT32_SWAP_ON_BE( udw ) ) ; }

inline float conv_be_fl( wxUint32 dw )
{  t_dw_fl uf ;
   uf.dw_val = wxUINT32_SWAP_ON_LE( dw ) ;
   return( uf.f_val ) ;
}
inline float conv_le_fl( wxUint32 dw )
{  t_dw_fl uf ;
   uf.dw_val = wxUINT32_SWAP_ON_BE( dw ) ;
   return( uf.f_val ) ;
}
inline double conv_be_do( wxUint64 ddw )
{  t_ddw_do ud ;
   ud.ddw_val = wxUINT64_SWAP_ON_LE( ddw ) ;
   return( ud.do_val ) ;
}
inline double conv_le_do( wxUint64 ddw )
{  t_ddw_do ud ;
   ud.ddw_val = wxUINT64_SWAP_ON_BE( ddw ) ;
   return( ud.do_val ) ;
}

/*-------------------------------------------------------------------------*/
inline wxUint16 pb_to_ui16( const char *p_b )
{  return( SR_TWOCC( p_b[ 0 ], p_b[ 1 ] ) ) ; }
inline wxUint16 pb_to_ui16( const wxUint8 *p_b )
{  return( SR_TWOCC( p_b[ 0 ], p_b[ 1 ] ) ) ; }
inline wxUint32 pb_to_ui32( const wxUint8 *p_b )
{  return( SR_FOURCC( p_b[ 0 ], p_b[ 1 ], p_b[ 2 ], p_b[ 3 ] ) ) ; }

/*-------------------------------------------------------------------------*/
bool filename_match_filter( const wxString &s_name,
                            const wxString &s_fil
                          ) ;
void set_font_fix( wxWindow *p_win, bool boo_fix ) ;
wxString dir_from_right( const wxFileName &name, int i_num_parent,
                         const wxString &s_absolute_path_to_name
                       ) ;
wxString absolute_path( const wxFileName &name, const wxString &s_path ) ;
wxString size_in_most_appropriate_unit( const wxULongLong &ull_size ) ;
int  round_0( double do_val ) ;
double round_1( double do_val ) ;
double round_01( double do_val ) ;
double round_001( double do_val ) ;
void set_clipboard( const wxString &s ) ;
int init_datetime_wxiso( const wxString &s_date, wxDateTime &dt ) ;
int set_datetime( size_t sz_year, size_t sz_month , size_t sz_day,
                  size_t sz_hour, size_t sz_minute, size_t sz_second,
                  size_t sz_millisec, wxDateTime &dt
                ) ;
int init_date_ymdhms( const wxString &s_date,
                      const char *p_c_format, wxDateTime &dt
                    ) ;
int init_datetime( time_t t, wxDateTime &dt ) ;
#ifdef __WXMSW__
int init_datetime( const FILETIME &ft, wxDateTime &dt ) ;
#endif // __WXMSW__

wxString duration_to_string( int i_nb_sec, const wxUniChar &c_fmt = ' ' ) ;

void access_error_message( const wxString &s_element ) ;
void error_message( const wxString &s_msg ) ;
void info_message( const wxString &s_msg ) ;
bool is_file_attr_hidden( const wxString &s_full_path ) ;
int force_path_existence( wxFileName &name ) ;
bool name_already_used_on_disk( const wxString &s_name ) ;
wxString append_sep_to_path( const wxString &s_name ) ;
int copy_file_timestamp( const wxString &s_from, const wxString &s_to ) ;
int delete_file_dir( const wxString &s_name ) ;

enum e_cft { CFT_DONT_COPY_FILE_TMS, CFT_DO_COPY_FILE_TMS } ;
int copy_file_dir( const wxString &s_from, const wxString &s_to,
                   e_cft copy_tms
                 ) ;
bool is_unc_path( const wxString &s_path ) ;
wxString expand_path( const wxString &s_path ) ;
void attach_win_to_panel( wxWindow *p_win, wxPanel *p_panel ) ;
wxMemoryBuffer memorybuffer_copy( const wxMemoryBuffer &mb ) ;

/*-------------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#endif // SR_LIB_H
/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                           End of file sr_lib.h                            !
+==========================================================================*/
