/*====================================+=====================================+
! File CShortcut.h                    ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#ifdef __WXMSW__
/*-------------------------------------------------------------------------*/
#ifndef CSHORTCUT_H
#define CSHORTCUT_H
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#include <wx/string.h>
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
class CShortcut
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CShortcut()
      {  ; }
      virtual ~CShortcut()
      {  ; }
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      enum e_shortcut
      { SCUT_SENDTO, SCUT_QUICK, SCUT_DESKTOP, SCUT_START, SCUT_PROGRAMS,
        SCUT_NB
      } ;
      /*--( Name used during IO operations )-------------------------------*/
      wxString m_s_name   ;
      /*-------------------------------------------------------------------*/
      wxString m_s_target ;
      wxString m_s_desc   ;
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      const wxString &get_name()   const { return( m_s_name ) ; }
      const wxString &get_target() const { return( m_s_target ) ; }
      const wxString &get_desc()   const { return( m_s_desc ) ; }
      /*-------------------------------------------------------------------*/
      void set_target( const wxString &s_val ){ m_s_target = s_val ; }
      void set_desc( const wxString &s_val ) { m_s_desc = s_val ; }
      /*-------------------------------------------------------------------*/
      int  init_name( e_shortcut scut, const wxString &s_base_name ) ;
      void init_name( const wxString &s_name ) { m_s_name = s_name ; }
      /*-------------------------------------------------------------------*/
      int load() ;
      int create_update() ;
      int remove() ;
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#endif // CSHORTCUT_H
/*-------------------------------------------------------------------------*/
#endif // __WXMSW__
/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                          End of file CShortcut.h                          !
+==========================================================================*/
