/*====================================+=====================================+
! File CSTEllipsize.h                 ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+---------------------------------------------------------------------------+
!                                                                           !
! These classes are used instead of wxStaticText in "sr_wizard.fbp" because !
! of wxSTELLIPSIZE... flags issue.                                          !
! 1) Under wxGTK they "work" correctly only if set during creation of the   !
!    instance                                                               !
! 2) wxFormBuilder doesn't support them "natively" but offers subclassing   !
!                                                                           !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#ifndef CSTELLIPSIZE_H
#define CSTELLIPSIZE_H
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#include <wx/stattext.h>
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
class CStaticTextEllipsizeMiddle : public wxStaticText
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CStaticTextEllipsizeMiddle( wxWindow *parent,
                                  wxWindowID id,
                                  const wxString &label,
                                  const wxPoint &pos = wxDefaultPosition,
                                  const wxSize &size = wxDefaultSize,
                                  long style = 0,
                                  const wxString &name = wxStaticTextNameStr
                                )
                              : wxStaticText( parent, id, label, pos, size,
                                              style | wxST_ELLIPSIZE_MIDDLE,
                                              name
                                            )
      {  ; }
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
class CStaticTextEllipsizeEnd : public wxStaticText
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CStaticTextEllipsizeEnd( wxWindow *parent,
                               wxWindowID id,
                               const wxString &label,
                               const wxPoint &pos = wxDefaultPosition,
                               const wxSize &size = wxDefaultSize,
                               long style = 0,
                               const wxString &name = wxStaticTextNameStr
                             )
                           : wxStaticText( parent, id, label, pos, size,
                                           style | wxST_ELLIPSIZE_END,
                                           name
                                         )
      {  ; }
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#endif // CSTELLIPSIZE_H
/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                       End of file CSTEllipsize.h                          !
+==========================================================================*/
