/*====================================+=====================================+
! File CListCtrlBase.h                ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#ifndef CLISTCTRLBASE_H
#define CLISTCTRLBASE_H
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#include <wx/listctrl.h>
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
class CListCtrlBase : public wxListCtrl
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CListCtrlBase( wxWindow *parent, wxWindowID id,
                     const wxPoint &pos = wxDefaultPosition,
                     const wxSize &size = wxDefaultSize,
                     long style = wxLC_REPORT,
                     const wxValidator &validator = wxDefaultValidator,
                     const wxString &name = wxListCtrlNameStr
                   )
                 : wxListCtrl( parent, id, pos, size, style,
                               validator, name
                             )
      {  ; }

   /*----------------------------------------------------------------------*/
   private :
      /*-------------------------------------------------------------------*/
      enum e_lcb_updown { LCB_UP, LCB_DOWN } ;
      void move_hil( e_lcb_updown lcb_updown ) ;
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      long get_next_hil_item( long l_item ) const
      {  return( GetNextItem( l_item,
                              wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED
                            )
               ) ;
      }
      /*--( -1 means all )-------------------------------------------------*/
      void set_item_hil( long l_item, bool boo_on )
      {  SetItemState( l_item,
                       ( boo_on ? wxLIST_STATE_SELECTED : 0 ),
                       wxLIST_STATE_SELECTED
                     ) ;
      }
      /*-------------------------------------------------------------------*/
      int get_nb_hil() { return( GetSelectedItemCount() ) ; }
      /*-------------------------------------------------------------------*/
      void set_item_state( long l_item, long l_state )
      {  SetItemState( l_item, l_state, l_state ) ; }
      void set_item_focus( long l_item )
      {  set_item_state( l_item, wxLIST_STATE_FOCUSED ) ; }
      long get_item_focus() const
      {  return( GetNextItem( -1, wxLIST_NEXT_ALL, wxLIST_STATE_FOCUSED ) );}
      void set_item_visible( long l_item )
      {  EnsureVisible( l_item ) ; }
      /*-------------------------------------------------------------------*/
      void set_item_text( int i_item, int i_col, const wxString &s_text )
      {  SetItem( i_item, i_col, s_text ) ; }
      /*-------------------------------------------------------------------*/
      wxColour get_alternate_attr() const
      {  return( wxColour( 245, 245, 245 ) ) ; }
      /*-------------------------------------------------------------------*/
      void show_grid( bool boo_on ) ;
      int col_width_for_text( const wxString &s ) const ;
      wxString get_item_text( int i_item, int i_col = 0 ) const ;
      void set_item_active( long l_item ) ;
      void swap_items( int i_item1, int i_item2 ) ;
      /*-------------------------------------------------------------------*/
      void move_hil_up()   { move_hil( LCB_UP ) ; }
      void move_hil_down() { move_hil( LCB_DOWN ) ; }
      /*-------------------------------------------------------------------*/
      void delete_hil() ;
      /*-------------------------------------------------------------------*/
      int get_item_col_at_point( const wxPoint &pt,
                                 long &l_item, long &l_col
                               ) ;

   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#endif // CLISTCTRLBASE_H
/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                       End of file CListCtrlBase.h                         !
+==========================================================================*/
