/*====================================+=====================================+
! File CChoice.h                      ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+---------------------------------------------------------------------------+
!                                                                           !
!        This class has been created to be used in wxFormBuilder            !
!                                                                           !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#ifndef CCHOICE_H
#define CCHOICE_H
/*-------------------------------------------------------------------------*/



/*--( Needed for generated files )-----------------------------------------*/
#include <wx/choice.h>
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
class CChoice : public wxChoice
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CChoice( wxWindow *parent, wxWindowID id, const wxPoint &pos,
               const wxSize &size, const wxArrayString &choices,
               long style = 0,
               const wxValidator &validator = wxDefaultValidator,
               const wxString &name = wxChoiceNameStr
             )
             : wxChoice( parent, id, pos, size,
                         choices, style, validator, name
                       )
      {  ; }

      /*--------------------------------------------------------------------+
      ! As the data are derived from wxClientData they are owned by         !
      ! by the control. So they are deleted when the control is deleted.    !
      +--------------------------------------------------------------------*/
      int append_stringdata( const wxString &item,
                             const wxString &data = wxEmptyString
                           )
      {  return( Append( item, new wxStringClientData( data ) ) ) ; }
      /*-------------------------------------------------------------------*/
      wxString get_stringdata( int i_item = -1 ) const ;
      void append_all_stringdata( const CChoice *p_in ) ;

   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#endif // CCHOICE_H
/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                          End of file CChoice.h                            !
+==========================================================================*/
