/*====================================+=====================================+
! File CArInputStream.h               ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+---------------------------------------------------------------------------+
!                                                                           !
!      Minimalistic implementation of the wxInputStream for AR files        !
!                                                                           !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#ifndef CARSTREAM_H
#define CARSTREAM_H
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#include <wx/archive.h>
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
struct str_ar_file_header
{
   /*----------------------------------------------------------------------*/
   char tb_c_filename[ 16 ] ;
   char tb_c_modif   [ 12 ] ;
   char tb_c_owner_id[  6 ] ;
   char tb_c_group_id[  6 ] ;
   char tb_c_mode    [  8 ] ;
   char tb_c_size    [ 10 ] ;
   char tb_c_magic   [  2 ] ; // Should be \140\012
   /*----------------------------------------------------------------------*/
} ;


/*-------------------------------------------------------------------------*/
class CArEntry : public wxArchiveEntry
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CArEntry( const wxString &name = wxEmptyString,
                const wxDateTime &dt = wxDateTime::Now(),
                wxFileOffset size = wxInvalidOffset
              ) ;
      virtual ~CArEntry() ;
   /*----------------------------------------------------------------------*/
   private :
      /*-------------------------------------------------------------------*/
      wxString     m_s_name    ;
      wxFileOffset m_fo_size   ;
      wxFileOffset m_fo_offset ;
   /*----------------------------------------------------------------------*/
   private :
      /*-------------------------------------------------------------------*/
      void SetOffset( wxFileOffset offset ) { m_fo_offset = offset ; }
      virtual wxArchiveEntry *DoClone() const { return Clone() ; }
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CArEntry( const CArEntry &entry) ;
      CArEntry &operator=( const CArEntry &entry ) ;
      int read_header() ;
      /*-------------------------------------------------------------------*/
      virtual wxString GetName( wxPathFormat WXUNUSED(format)
                                = wxPATH_NATIVE
                              ) const
      {  return( m_s_name ) ; }
      virtual wxString GetInternalName() const
      {  return( m_s_name ) ; }
      static wxString GetInternalName( const wxString &name,
                                       wxPathFormat WXUNUSED( format )
                                                   = wxPATH_NATIVE,
                                       bool * WXUNUSED( pIsDir ) = NULL
                                     )
      {  return( name ) ; }
      /*-------------------------------------------------------------------*/
      virtual wxPathFormat GetInternalFormat() const
      {  return( wxPATH_UNIX ) ; }
      virtual wxFileOffset GetSize() const
      {  return( m_fo_size ) ; }
      virtual wxFileOffset GetOffset() const
      {  return( m_fo_offset ) ; }
      /*-------------------------------------------------------------------*/
      virtual void SetName( const wxString & WXUNUSED( name ),
                            wxPathFormat WXUNUSED( format ) = wxPATH_NATIVE
                          )
      {  ; }
      virtual void SetSize( wxFileOffset WXUNUSED( size ) )
      {  ; }
      virtual wxDateTime GetDateTime() const
      {  return( wxInvalidDateTime ) ; }
      virtual void SetDateTime( const wxDateTime & WXUNUSED( dt ) )
      {  ; }
      virtual bool IsDir() const
      {  return( false ) ; }
      virtual void SetIsDir( bool WXUNUSED( isDir ) = true )
      {  ; }
      virtual bool IsReadOnly() const
      {  return( true ) ; }
      virtual void SetIsReadOnly( bool WXUNUSED( isReadOnly ) = true )
      {  ; }
      /*-------------------------------------------------------------------*/
      CArEntry *Clone() const { return( new CArEntry( *this ) ) ; }
      /*-------------------------------------------------------------------*/
      int read_header( class wxInputStream *p_in ) ;

      /*-------------------------------------------------------------------*/
      friend class CArInputStream ;
      /*-------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
class CArInputStream : public wxArchiveInputStream
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CArInputStream( wxInputStream &stream, wxMBConv &conv = wxConvLocal ) ;
      CArInputStream( wxInputStream *stream, wxMBConv &conv = wxConvLocal ) ;
      virtual ~CArInputStream() ;
   /*----------------------------------------------------------------------*/
   private :
      /*--( Current entry information )------------------------------------*/
      wxFileOffset m_fo_entry_pos    ; // position within the current entry
      wxFileOffset m_fo_entry_offset ; // offset to start of current entry
      wxFileOffset m_fo_entry_size   ; // size of current entry's data
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      virtual bool OpenEntry( CArEntry &entry ) ;
      virtual bool OpenEntry( wxArchiveEntry &entry ) ;
      virtual bool CloseEntry() ;
      CArEntry *GetNextEntry() ;
      /*-------------------------------------------------------------------*/
      virtual wxFileOffset GetLength() const
      {  return( m_fo_entry_size ) ; }
      virtual bool IsSeekable() const
      {  return( m_parent_i_stream->IsSeekable() ) ; }
   /*----------------------------------------------------------------------*/
   protected :
      /*--( These functions are relative to the entry content )------------*/
      virtual wxFileOffset OnSysTell() const
      {  return( m_fo_entry_pos ) ; }
      virtual size_t OnSysRead( void *p_buffer, size_t sz_size ) ;
      virtual wxFileOffset OnSysSeek( wxFileOffset fo_pos, wxSeekMode mode );
   /*----------------------------------------------------------------------*/
   private :
      /*--------------------------------------------------------------------+
      ! Functions with same names are defined in other wxArchiveInputStream !
      ! derived classes (wxTarOutputStream ...)                             !
      +--------------------------------------------------------------------*/
      void Init() ;
      bool IsOpened() const
      {  return( m_fo_entry_pos != wxInvalidOffset ) ; }
      /*-------------------------------------------------------------------*/
      virtual wxArchiveEntry *DoGetNextEntry()
      {  return GetNextEntry() ; }

   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#endif // CARSTREAM_H
/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                      End of file CArInputStream.h                         !
+==========================================================================*/
