/*====================================+=====================================+
! File CWizard.h                      ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#ifndef CWIZARD_H
#define CWIZARD_H
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#include "sr_wizard.h"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
class CWizardPanPredefined : public CWizardPanPredefinedBase
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CWizardPanPredefined( wxWindow *parent ) ;
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      virtual void OnChoice( wxCommandEvent &event ) ;
      void build_expression( wxString &s_exp ) const ;
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
class CWizardPanManual : public CWizardPanManualBase
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CWizardPanManual( wxWindow *parent ) ;
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      virtual void OnChoice( wxCommandEvent & WXUNUSED( event ) ) ;
      virtual void OnText( wxCommandEvent & WXUNUSED( event ) ) ;
      virtual void OnSpin( wxSpinEvent & WXUNUSED( event ) ) ;
      /*-------------------------------------------------------------------*/
      wxString constant_string( const wxTextCtrl *p_text,
                                bool boo_delimited
                              ) const ;
      void build_expression( wxString &s_exp ) const ;
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
class CWizard : public CWizardBase
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CWizard( wxWindow *parent ) ;
      virtual ~CWizard() ;

   /*----------------------------------------------------------------------*/
   private :
      /*--( File number on which the expression is applied )---------------*/
      int m_i_file_example ;
      /*--( Built expression )---------------------------------------------*/
      wxString m_s_exp ;
      /*--( The two different panels used to build the expression )--------*/
      CWizardPanPredefined *m_pan_predefined ;
      CWizardPanManual     *m_pan_manual     ;

   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      virtual void OnNotebookPageChanged( wxNotebookEvent &event ) ;
      virtual void OnBtOk( wxCommandEvent & WXUNUSED( event ) ) ;
      virtual void OnBtApply( wxCommandEvent & WXUNUSED( event ) ) ;
      /*-------------------------------------------------------------------*/
      void init() ;
      /*-------------------------------------------------------------------*/
      void init_example() ;
      void recompute_example() ;
      void recompute() ;
      void validate_expression() const ;
      /*-------------------------------------------------------------------*/
      int get_modal() { return( ShowModal() ) ; }

   /*----------------------------------------------------------------------*/
   private :
      /*-------------------------------------------------------------------*/
      DECLARE_EVENT_TABLE()
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#endif // CWIZARD_H
/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                          End of file CWizard.h                            !
+==========================================================================*/
