/*====================================+=====================================+
! File CTagVisu.h                     ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#ifndef CTAGVISU_H
#define CTAGVISU_H
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#include <wx/treectrl.h>
/*-------------------------------------------------------------------------*/
class CFile ;
/*-------------------------------------------------------------------------*/



/*--( The tree item data will be "deleted" by the wxTreeCtrl )-------------*/
class CTagVisuData : public wxTreeItemData
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CTagVisuData( int i_val ) : wxTreeItemData(), m_i_val( i_val )
      {  ; }
      virtual ~CTagVisuData()
      {  ; }
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      int m_i_val ;
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
class CTagVisu : public wxTreeCtrl
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CTagVisu( wxWindow *parent, wxWindowID id ) ;
      ~CTagVisu() ;

   /*----------------------------------------------------------------------*/
   private :
      /*--( Absolute full path of file which info are currently displayed )*/
      wxString    m_s_file_abs_full_path ;
      /*--( Modification date of the file currently displayed )------------*/
      wxDateTime  m_dt_file_mod ;
      /*--( File size of the file currently displayed )--------------------*/
      wxULongLong m_ull_file_size ;
      /*--------------------------------------------------------------------+
      ! Keep track of "tree expanded" groups. They are stored here because  !
      ! "generally" a file doesn't have data belonging to all groups.       !
      +--------------------------------------------------------------------*/
      bool m_tb_boo_grp_expanded[ GRP_NB ] ;

   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      void OnExpandOrCollapse( wxTreeEvent &event ) ;
      void OnItemMenu( wxTreeEvent &event ) ;
      /*-------------------------------------------------------------------*/
      int  get_var_val_anchor( wxTreeItemId ti_item,
                               wxString &s_var, wxString &s_val,
                               wxString &s_help_anchor
                             ) ;
      int  help() ;
      void visu( const CFile *p_file ) ;

   /*----------------------------------------------------------------------*/
   private :
      /*-------------------------------------------------------------------*/
      DECLARE_EVENT_TABLE()
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#endif // CTAGVISU_H
/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                          End of file CTagVisu.h                           !
+==========================================================================*/
