/*====================================+=====================================+
! File CRunInfoMessage.h              ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+---------------------------------------------------------------------------+
!                                                                           !
!      Inform the user of the currently running task (rename, sort ...)     !
!                                                                           !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#ifndef CRUNINFOMESSAGE_H
#define CRUNINFOMESSAGE_H
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#include <wx/frame.h>
/*-------------------------------------------------------------------------*/



/*--------------------------------------------------------------------------+
! Displays a message in a window during its "life"                          !
! Reimplementation of "wxBusyInfo" because of a Ubuntu issue                !
+--------------------------------------------------------------------------*/
class CInfoFrame : public wxFrame
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CInfoFrame( wxWindow *parent, const wxString s_msg ) ;

   /*----------------------------------------------------------------------*/
} ;

/*--------------------------------------------------------------------------+
! Class used to display information during the running of a process         !
! Before 3.00 only a function was displaying treatment information, no      !
! yielding was done and so no refresh of the main window. Sometimes it      !
! looked weird. This new version adds yielding and "hourglass" cursor after !
! a certain amount of time.                                                 !
+--------------------------------------------------------------------------*/
class CRunInfoMessage
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CRunInfoMessage() ;
      CRunInfoMessage( const wxString &s_msg_0,
                       const wxString &s_msg_N = wxEmptyString
                     ) ;
      ~CRunInfoMessage() ;
   /*----------------------------------------------------------------------*/
   private :
      /*-------------------------------------------------------------------*/
      wxString   m_s_msg_0           ; // Msg displayed when i_val = 0
      wxString   m_s_msg_N           ; // Msg displayed when i_val!= 0
      wxLongLong m_ll_time_last_info ; // Last time msg displayed
      int        m_i_nb_disp         ; // Number of display done
      CInfoFrame *m_p_win_info       ;
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      void set_message( const wxString &s_msg_0, const wxString &s_msg_N )
      {  m_s_msg_0 = s_msg_0 ; m_s_msg_N = s_msg_N ; }
      /*-------------------------------------------------------------------*/
      void display( int i_val = 0 ) ;
      void reset_display() ;
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#endif // CRUNINFOMESSAGE_H
/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                      End of file CRunInfoMessage.h                        !
+==========================================================================*/

