/*====================================+=====================================+
! File CImageVisu.h                   ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#ifndef CIMAGEVISU_H
#define CIMAGEVISU_H
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#include <wx/image.h>
#include "CFile.h"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
class CImageVisu : public wxWindow
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CImageVisu( wxWindow *parent, wxWindowID id ) ;
      ~CImageVisu() ;

   /*----------------------------------------------------------------------*/
   private :
      /*--( Thumbnail displayed ? )----------------------------------------*/
      enum e_iv_thumbnail
      {  IV_THUMBNAIL_NONE, // No thumbnail in the image
         IV_THUMBNAIL_OFF , // Image with thumbnail, full image displayed
         IV_THUMBNAIL_ON  , // Image with thumbnail, thumbnail displayed
         IV_THUMBNAIL_NB
      } ;
      /*--( Absolute full path of file which info are currently displayed )*/
      wxString    m_s_file_abs_full_path ;
      /*--( Modification date of the file currently displayed )------------*/
      wxDateTime  m_dt_file_mod ;
      /*--( File size of the file currently displayed )--------------------*/
      wxULongLong m_ull_file_size ;
      /*-------------------------------------------------------------------*/
      wxImage  m_image ;
      bool     m_boo_imagevisu_possible ;
      /*--( The information to display beside the image )------------------*/
      e_iv_thumbnail m_iv_thumbnail ;
      e_iv_rotation  m_iv_rotation ;
      bool           m_boo_img_hq_manip ;
      bool           m_boo_img_stretch ;

   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      bool get_imagevisu_possible() const
      {  return( m_boo_imagevisu_possible ) ; }
      void set_imagevisu_possible( bool boo_val )
      {  m_boo_imagevisu_possible = boo_val ; }
      /*-------------------------------------------------------------------*/
      void OnEraseBackground( wxEraseEvent &event ) ;
      void OnPaint( wxPaintEvent &event ) ;
      void OnResize( wxSizeEvent &event ) ;
      void reset() ;
      int  rotate_image() ;
      int  visu( const CFile *p_file ) ;
      int  display_image( wxDC &dc ) ;
      int  display_info( wxDC &dc ) const ;

   /*----------------------------------------------------------------------*/
   private :
      /*-------------------------------------------------------------------*/
      DECLARE_EVENT_TABLE()
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#endif // CIMAGEVISU_H
/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                         End of file CImageVisu.h                          !
+==========================================================================*/
