/*====================================+=====================================+
! File CImageFileList.h               ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+---------------------------------------------------------------------------+
!                                                                           !
! This class will handle the image list for a File list:                    !
! files icons and up, down, check ... etc ...                               !
!                                                                           !
! It has been created because :                                             !
! - under MSW, the icons wxWidgets creates are low quality icons            !
! - under GTK, mime associated icons are "missed" (Ubuntu 10.10)            !
!                                                                           !
! Under MSW some files icons are used via a specific map (exe, ico ...).    !
! This map is never cleared because I think that the data volume used is    !
! relatively low and because it would have complicated the code ... ;-)     !
! In order to avoid invalid icon display the modification time and size are !
! also checked to reload it.                                                !
!                                                                           !
! The icons representing the files are "chosen" following the order:        !
! 1) For special files like exe (under MSW), ico, cur ... they are          !
!    extracted from the file itself                                         !
!    Except for the MSW-exe files, there is a size limit for the extraction !
! 2) From the icon associated to the extension:                             !
!         MSW: SHGetFileInfo                                                !
!         GTK: Icon associated to the file's mime/type                      !
!              (doesn't work for Ubuntu)                                    !
! 3) Based on the mime type, some icons I've chosen                         !
!                                                                           !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#ifndef CIMAGEFILELIST_H
#define CIMAGEFILELIST_H
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#include <wx/imaglist.h>
#include "common/sr_lib.h"
#include "CFile.h"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
class CImageFileList : public wxImageList
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CImageFileList() ;
      //~CImageFileList() ;

   /*----------------------------------------------------------------------*/
   private :
      /*--------------------------------------------------------------------+
      ! These icons are the ones specially added by the project             !
      +--------------------------------------------------------------------*/
#ifndef __WXMSW__
      int m_i_ind_asc     ; // Sort ascendant
      int m_i_ind_desc    ; // Sort descendant
#endif // ! __WXMSW__
      int m_i_ind_dir     ; // Directory icon
      int m_i_ind_file    ; // Standard file icon
      int m_i_ind_check   ; // File selected
      int m_i_ind_uncheck ; // File not selected
      /*--( Mime icon index )----------------------------------------------*/
      int m_i_ind_mime_img     ;
      int m_i_ind_mime_audio   ;
      int m_i_ind_mime_video   ;
      int m_i_ind_mime_text    ;
      int m_i_ind_mime_message ;
      int m_i_ind_mime_pdf     ;
      int m_i_ind_mime_zip     ;
      int m_i_ind_mime_epub    ;
      /*-------------------------------------------------------------------*/
      sr::t_map_str_int m_map_ext_ico ;

      /*--------------------------------------------------------------------+
      ! Some files types contain their icons: .exe, .ico ...                !
      ! To be as accurate as possible and identify any file modifications,  !
      ! last file modification time and file size are stored too.           !
      +--------------------------------------------------------------------*/
      struct str_file_ico_info
      {
         /*----------------------------------------------------------------*/
         wxDateTime  m_dt_mod   ;
         wxULongLong m_ull_size ;
         int         m_i_ico    ;
         /*----------------------------------------------------------------*/
      } ;
      /*-------------------------------------------------------------------*/
      typedef std::map< wxString, str_file_ico_info > t_map_file_ico_info ;
      typedef t_map_file_ico_info::const_iterator   t_map_file_ico_info_cit ;
      /*-------------------------------------------------------------------*/
      t_map_file_ico_info m_map_file_ico ;

   /*----------------------------------------------------------------------*/
   private :
      /*-------------------------------------------------------------------*/
      void add_checkboxes() ;
      int get_icon_index_file( const CFile &file, const wxString &s_ext ) ;
      int get_icon_index_ext( const wxString &s_ext ) ;
      int get_icon_index_mime( const wxString &s_ext ) ;
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
#ifndef __WXMSW__
      int get_asc() { return( m_i_ind_asc ) ; }
      int get_desc() { return( m_i_ind_desc ) ; }
#endif // ! __WXMSW__
      /*-------------------------------------------------------------------*/
      int get_dir() { return( m_i_ind_dir ) ; }
      int get_check() { return( m_i_ind_check ) ; }
      int get_uncheck() { return( m_i_ind_uncheck ) ; }
      /*-------------------------------------------------------------------*/
      wxIcon get_dir_icon() { return( GetIcon( m_i_ind_dir ) ) ; }
      wxIcon get_check_icon() { return( GetIcon( m_i_ind_check ) ) ; }
      /*-------------------------------------------------------------------*/
      int icon_index( const CFile &file ) ;

   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#endif // CIMAGEFILELIST_H
/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                         End of file CImageVisu.h                          !
+==========================================================================*/
