/*====================================+=====================================+
! File CFSWatcher.h                   ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#ifndef CFSWATCHER_H
#define CFSWATCHER_H
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#include <wx/fswatcher.h>
#include <wx/timer.h>
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
class CFSWatcher : public wxFileSystemWatcher
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CFSWatcher() : m_timer_to_apply( this ), m_boo_active( false )
      {  ; }

   /*----------------------------------------------------------------------*/
   private :
      /*-------------------------------------------------------------------*/
      class CFSWchange
      {
         /*----------------------------------------------------------------*/
         public :
            /*-------------------------------------------------------------*/
            CFSWchange( int i_type, int i_id,
                        wxString s_name, wxString s_new_name
                      ) : m_i_type( i_type ), m_i_id( i_id ),
                          m_s_name( s_name ), m_s_new_name( s_new_name )
            {  ; }
            /*-------------------------------------------------------------*/
            wxString to_string() const
            {  return( wxString::Format( "Type:%d ID:%d <%s> <%s>",
                                         m_i_type, m_i_id,
                                         m_s_name, m_s_new_name
                                       )
                     ) ;
            }
            /*-------------------------------------------------------------*/
            int      m_i_type         ;
            int      m_i_id           ;
            wxString m_s_name         ;
            wxString m_s_new_name     ;
            wxString m_s_fullpath     ;
            wxString m_s_new_fullpath ;
            /*-------------------------------------------------------------*/
      } ;
      /*-------------------------------------------------------------------*/
      typedef std::vector< CFSWchange >    t_vec_change ;
      typedef t_vec_change::iterator       t_vec_change_it ;
      typedef t_vec_change::const_iterator t_vec_change_cit ;
      /*-------------------------------------------------------------------*/
      t_vec_change m_vec_change ;
      wxTimer      m_timer_to_apply ;
      bool         m_boo_active ;

   /*----------------------------------------------------------------------*/
   private :
      /*-------------------------------------------------------------------*/
      void OnChange( wxFileSystemWatcherEvent &event ) ;
      void OnApplyChanges( wxTimerEvent &event ) ;

   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      wxString to_fullpath( const wxString &s ) const
      {  wxFileName fn( s ) ;
         fn.MakeAbsolute( wxGetApp().M_s_dir.get() ) ;
         return( fn.GetFullPath() ) ;
      }
      bool get_active() const
      {  return( m_boo_active ) ; }
      /*-------------------------------------------------------------------*/
      void start() ;
      void stop() ;
      /*-------------------------------------------------------------------*/

   /*----------------------------------------------------------------------*/
   private :
      /*-------------------------------------------------------------------*/
      DECLARE_EVENT_TABLE()
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#endif // CFSWATCHER_H
/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                         End of file CFSWatcher.h                          !
+==========================================================================*/
