/*====================================+=====================================+
! File CDlgFilter.h                   ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#ifndef CDLGFILTER_H
#define CDLGFILTER_H
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#include "sr_filter.h"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
class CDlgFilter : public CDlgFilterBase
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CDlgFilter( wxWindow *parent,
                  const wxString &s_title,
                  const wxString &s_text_file,
                  const wxString &s_text_dir
                ) ;
      virtual ~CDlgFilter() ;
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      static wxString st_get_match_dialog_text( bool boo_match ) ;
      /*-------------------------------------------------------------------*/
      virtual void OnBtOk( wxCommandEvent &event ) ;
      virtual void OnFilChange( wxCommandEvent &event ) ;
      int get_modal() ;
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
class CDlgFilterSearch : public CDlgFilterSearchBase
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CDlgFilterSearch( wxWindow *parent ) ;
      virtual ~CDlgFilterSearch() ;
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      virtual void OnTextEnter( wxCommandEvent &event ) ;
      virtual void OnFilChange( wxCommandEvent &event ) ;
      /*-------------------------------------------------------------------*/
      virtual void OnBtFindFirst( wxCommandEvent & WXUNUSED( event ) )
      {  EndModal( DLG_IDM_FIND_FIRST ) ; }
      virtual void OnBtFindNext( wxCommandEvent & WXUNUSED( event ) )
      {  EndModal( DLG_IDM_FIND_NEXT ) ; }
      virtual void OnBtFindPrevious( wxCommandEvent & WXUNUSED( event ) )
      {  EndModal( DLG_IDM_FIND_PREV ) ; }
      virtual void OnBtFindLast( wxCommandEvent & WXUNUSED( event ) )
      {  EndModal( DLG_IDM_FIND_LAST ) ; }
      /*-------------------------------------------------------------------*/
      int get_modal() ;
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#endif // CDLGFILTER_H
/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                        End of file CDlgFilter.h                           !
+==========================================================================*/
